/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster;

import java.nio.ByteBuffer;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.ExecutorAllocationClient;
import org.apache.spark.ExecutorAllocationClient$class;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.TaskState$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcCallContext;
import org.apache.spark.rpc.RpcEndpoint$class;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.rpc.ThreadSafeRpcEndpoint;
import org.apache.spark.scheduler.ExecutorKilled$;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.LiveListenerBus;
import org.apache.spark.scheduler.LossReasonPending$;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.scheduler.SchedulerBackend$class;
import org.apache.spark.scheduler.SlaveLost;
import org.apache.spark.scheduler.SparkListenerExecutorAdded;
import org.apache.spark.scheduler.SparkListenerExecutorRemoved;
import org.apache.spark.scheduler.TaskDescription;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.TaskSetManager;
import org.apache.spark.scheduler.WorkerOffer;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages$RegisteredExecutor$;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages$RetrieveSparkProps$;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages$ReviveOffers$;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages$StopDriver$;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages$StopExecutor$;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages$StopExecutors$;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend$;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend$DriverEndpoint$;
import org.apache.spark.scheduler.cluster.ExecutorData;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.util.RpcUtils$;
import org.apache.spark.util.SerializableBuffer;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\r-e!B\u0001\u0003\u0001\u0019a!!H\"pCJ\u001cXm\u0012:bS:,GmU2iK\u0012,H.\u001a:CC\u000e\\WM\u001c3\u000b\u0005\r!\u0011aB2mkN$XM\u001d\u0006\u0003\u000b\u0019\t\u0011b]2iK\u0012,H.\u001a:\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001cR\u0001A\u0007\u0014/m\u0001\"AD\t\u000e\u0003=Q\u0011\u0001E\u0001\u0006g\u000e\fG.Y\u0005\u0003%=\u0011a!\u00118z%\u00164\u0007C\u0001\u000b\u0016\u001b\u00051\u0011B\u0001\f\u0007\u0005a)\u00050Z2vi>\u0014\u0018\t\u001c7pG\u0006$\u0018n\u001c8DY&,g\u000e\u001e\t\u00031ei\u0011\u0001B\u0005\u00035\u0011\u0011\u0001cU2iK\u0012,H.\u001a:CC\u000e\\WM\u001c3\u0011\u0005qyR\"A\u000f\u000b\u0005y1\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005\u0001j\"a\u0002'pO\u001eLgn\u001a\u0005\t\u000b\u0001\u0011\t\u0011)A\u0005G\r\u0001\u0001C\u0001\r%\u0013\t)CAA\tUCN\\7k\u00195fIVdWM]%na2D\u0001b\n\u0001\u0003\u0006\u0004%\t\u0001K\u0001\u0007eB\u001cWI\u001c<\u0016\u0003%\u0002\"AK\u0017\u000e\u0003-R!\u0001\f\u0004\u0002\u0007I\u00048-\u0003\u0002/W\t1!\u000b]2F]ZD\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!K\u0001\beB\u001cWI\u001c<!\u0011\u0015\u0011\u0004\u0001\"\u00014\u0003\u0019a\u0014N\\5u}Q\u0019AGN\u001c\u0011\u0005U\u0002Q\"\u0001\u0002\t\u000b\u0015\t\u0004\u0019A\u0012\t\u000b\u001d\n\u0004\u0019A\u0015\t\u000fe\u0002!\u0019!C\tu\u0005qAo\u001c;bY\u000e{'/Z\"pk:$X#A\u001e\u0011\u0005q*U\"A\u001f\u000b\u0005yz\u0014AB1u_6L7M\u0003\u0002A\u0003\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005\t\u001b\u0015\u0001B;uS2T\u0011\u0001R\u0001\u0005U\u00064\u0018-\u0003\u0002G{\ti\u0011\t^8nS\u000eLe\u000e^3hKJDa\u0001\u0013\u0001!\u0002\u0013Y\u0014a\u0004;pi\u0006d7i\u001c:f\u0007>,h\u000e\u001e\u0011\t\u000f)\u0003!\u0019!C\tu\u0005ABo\u001c;bYJ+w-[:uKJ,G-\u0012=fGV$xN]:\t\r1\u0003\u0001\u0015!\u0003<\u0003e!x\u000e^1m%\u0016<\u0017n\u001d;fe\u0016$W\t_3dkR|'o\u001d\u0011\t\u000f9\u0003!\u0019!C\t\u001f\u0006!1m\u001c8g+\u0005\u0001\u0006C\u0001\u000bR\u0013\t\u0011fAA\u0005Ta\u0006\u00148nQ8oM\"1A\u000b\u0001Q\u0001\nA\u000bQaY8oM\u0002BqA\u0016\u0001C\u0002\u0013%q+A\tnCb\u0014\u0006oY'fgN\fw-Z*ju\u0016,\u0012\u0001\u0017\t\u0003\u001deK!AW\b\u0003\u0007%sG\u000f\u0003\u0004]\u0001\u0001\u0006I\u0001W\u0001\u0013[\u0006D(\u000b]2NKN\u001c\u0018mZ3TSj,\u0007\u0005C\u0004_\u0001\t\u0007I\u0011B0\u0002'}k\u0017N\u001c*fO&\u001cH/\u001a:fIJ\u000bG/[8\u0016\u0003\u0001\u0004\"AD1\n\u0005\t|!A\u0002#pk\ndW\r\u0003\u0004e\u0001\u0001\u0006I\u0001Y\u0001\u0015?6LgNU3hSN$XM]3e%\u0006$\u0018n\u001c\u0011\t\u000f\u0019\u0004!\u0019!C\u0005O\u0006QR.\u0019=SK\u001eL7\u000f^3sK\u0012<\u0016-\u001b;j]\u001e$\u0016.\\3NgV\t\u0001\u000e\u0005\u0002\u000fS&\u0011!n\u0004\u0002\u0005\u0019>tw\r\u0003\u0004m\u0001\u0001\u0006I\u0001[\u0001\u001c[\u0006D(+Z4jgR,'/\u001a3XC&$\u0018N\\4US6,Wj\u001d\u0011\t\u000f9\u0004!\u0019!C\u0005O\u0006Q1M]3bi\u0016$\u0016.\\3\t\rA\u0004\u0001\u0015!\u0003i\u0003-\u0019'/Z1uKRKW.\u001a\u0011\t\u000fI\u0004!\u0019!C\u0005g\u0006yQ\r_3dkR|'\u000fR1uC6\u000b\u0007/F\u0001u!\u0015)(\u0010`A\u0004\u001b\u00051(BA<y\u0003\u001diW\u000f^1cY\u0016T!!_\b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002|m\n9\u0001*Y:i\u001b\u0006\u0004\bcA?\u0002\u00029\u0011aB`\u0005\u0003\u007f>\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u0002\u0003\u000b\u0011aa\u0015;sS:<'BA@\u0010!\r)\u0014\u0011B\u0005\u0004\u0003\u0017\u0011!\u0001D#yK\u000e,Ho\u001c:ECR\f\u0007bBA\b\u0001\u0001\u0006I\u0001^\u0001\u0011Kb,7-\u001e;pe\u0012\u000bG/Y'ba\u0002B\u0001\"a\u0005\u0001\u0001\u0004%IaV\u0001\u0014]Vl\u0007+\u001a8eS:<W\t_3dkR|'o\u001d\u0005\n\u0003/\u0001\u0001\u0019!C\u0005\u00033\tqC\\;n!\u0016tG-\u001b8h\u000bb,7-\u001e;peN|F%Z9\u0015\t\u0005m\u0011\u0011\u0005\t\u0004\u001d\u0005u\u0011bAA\u0010\u001f\t!QK\\5u\u0011%\t\u0019#!\u0006\u0002\u0002\u0003\u0007\u0001,A\u0002yIEBq!a\n\u0001A\u0003&\u0001,\u0001\u000bok6\u0004VM\u001c3j]\u001e,\u00050Z2vi>\u00148\u000f\t\u0015\t\u0003K\tY#!\u0010\u0002@A!\u0011QFA\u001d\u001b\t\tyCC\u0002A\u0003cQA!a\r\u00026\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005\u0005]\u0012!\u00026bm\u0006D\u0018\u0002BA\u001e\u0003_\u0011\u0011bR;be\u0012,GMQ=\u0002\u000bY\fG.^3\"\u0005\u0005\u0005\u0013AI\"pCJ\u001cXm\u0012:bS:,GmU2iK\u0012,H.\u001a:CC\u000e\\WM\u001c3/i\"L7\u000fC\u0005\u0002F\u0001\u0011\r\u0011\"\u0003\u0002H\u0005YA.[:uK:,'OQ;t+\t\tI\u0005E\u0002\u0019\u0003\u0017J1!!\u0014\u0005\u0005=a\u0015N^3MSN$XM\\3s\u0005V\u001c\b\u0002CA)\u0001\u0001\u0006I!!\u0013\u0002\u00191L7\u000f^3oKJ\u0014Uo\u001d\u0011\t\u0013\u0005U\u0003A1A\u0005\n\u0005]\u0013\u0001G3yK\u000e,Ho\u001c:t!\u0016tG-\u001b8h)>\u0014V-\\8wKV\u0011\u0011\u0011\f\t\u0006kjd\u00181\f\t\u0004\u001d\u0005u\u0013bAA0\u001f\t9!i\\8mK\u0006t\u0007\u0002CA2\u0001\u0001\u0006I!!\u0017\u00023\u0015DXmY;u_J\u001c\b+\u001a8eS:<Gk\u001c*f[>4X\r\t\u0015\t\u0003C\nY#!\u0010\u0002@!I\u0011\u0011\u000e\u0001A\u0002\u0013E\u00111N\u0001\u0015Q>\u001cH\u000fV8M_\u000e\fG\u000eV1tW\u000e{WO\u001c;\u0016\u0005\u00055\u0004#B?\u0002pqD\u0016\u0002BA9\u0003\u000b\u00111!T1q\u0011%\t)\b\u0001a\u0001\n#\t9(\u0001\ri_N$Hk\u001c'pG\u0006dG+Y:l\u0007>,h\u000e^0%KF$B!a\u0007\u0002z!Q\u00111EA:\u0003\u0003\u0005\r!!\u001c\t\u0011\u0005u\u0004\u0001)Q\u0005\u0003[\nQ\u0003[8tiR{Gj\\2bYR\u000b7o[\"pk:$\b\u0005\u000b\u0005\u0002|\u0005-\u0012QHA \u0011!\t\u0019\t\u0001a\u0001\n#9\u0016A\u00057pG\u0006d\u0017\u000e^=Bo\u0006\u0014X\rV1tWND\u0011\"a\"\u0001\u0001\u0004%\t\"!#\u0002-1|7-\u00197jif\fu/\u0019:f)\u0006\u001c8n]0%KF$B!a\u0007\u0002\f\"I\u00111EAC\u0003\u0003\u0005\r\u0001\u0017\u0005\b\u0003\u001f\u0003\u0001\u0015)\u0003Y\u0003MawnY1mSRL\u0018i^1sKR\u000b7o[:!Q!\ti)a\u000b\u0002>\u0005}\u0002\u0002CAK\u0001\u0001\u0007I\u0011C,\u00021\r,(O]3oi\u0016CXmY;u_JLEmQ8v]R,'\u000fC\u0005\u0002\u001a\u0002\u0001\r\u0011\"\u0005\u0002\u001c\u0006a2-\u001e:sK:$X\t_3dkR|'/\u00133D_VtG/\u001a:`I\u0015\fH\u0003BA\u000e\u0003;C\u0011\"a\t\u0002\u0018\u0006\u0005\t\u0019\u0001-\t\u000f\u0005\u0005\u0006\u0001)Q\u00051\u0006I2-\u001e:sK:$X\t_3dkR|'/\u00133D_VtG/\u001a:!Q\u0011\ty*!*\u0011\u00079\t9+C\u0002\u0002*>\u0011\u0001B^8mCRLG.\u001a\u0004\u0007\u0003[\u0003\u0001!a,\u0003\u001d\u0011\u0013\u0018N^3s\u000b:$\u0007o\\5oiN1\u00111V\u0007\u00022n\u00012AKAZ\u0013\r\t)l\u000b\u0002\u0016)\"\u0014X-\u00193TC\u001a,'\u000b]2F]\u0012\u0004x.\u001b8u\u0011%9\u00131\u0016BC\u0002\u0013\u0005\u0003\u0006C\u00051\u0003W\u0013\t\u0011)A\u0005S!Y\u0011QXAV\u0005\u0003\u0005\u000b\u0011BA`\u0003=\u0019\b/\u0019:l!J|\u0007/\u001a:uS\u0016\u001c\bCBAa\u0003#\f9N\u0004\u0003\u0002D\u00065g\u0002BAc\u0003\u0017l!!a2\u000b\u0007\u0005%'%\u0001\u0004=e>|GOP\u0005\u0002!%\u0019\u0011qZ\b\u0002\u000fA\f7m[1hK&!\u00111[Ak\u0005\r\u0019V-\u001d\u0006\u0004\u0003\u001f|\u0001#\u0002\b\u0002Zrd\u0018bAAn\u001f\t1A+\u001e9mKJBqAMAV\t\u0003\ty\u000e\u0006\u0004\u0002b\u0006\u0015\u0018q\u001d\t\u0005\u0003G\fY+D\u0001\u0001\u0011\u00199\u0013Q\u001ca\u0001S!A\u0011QXAo\u0001\u0004\ty\f\u0003\u0006\u0002l\u0006-&\u0019!C\t\u0003[\f!$\u001a=fGV$xN]:QK:$\u0017N\\4M_N\u001c(+Z1t_:,\"!a<\u0011\tU\f\t\u0010`\u0005\u0004\u0003g4(a\u0002%bg\"\u001cV\r\u001e\u0005\n\u0003o\fY\u000b)A\u0005\u0003_\f1$\u001a=fGV$xN]:QK:$\u0017N\\4M_N\u001c(+Z1t_:\u0004\u0003BCA~\u0003W\u0013\r\u0011\"\u0003\u0002~\u0006\u00191/\u001a:\u0016\u0005\u0005}\b\u0003\u0002B\u0001\u0005\u000fi!Aa\u0001\u000b\u0007\t\u0015a!\u0001\u0006tKJL\u0017\r\\5{KJLAA!\u0003\u0003\u0004\t\u00112+\u001a:jC2L'0\u001a:J]N$\u0018M\\2f\u0011%\u0011i!a+!\u0002\u0013\ty0\u0001\u0003tKJ\u0004\u0003B\u0003B\t\u0003W\u0013\r\u0011\"\u0005\u0003\u0014\u0005\u0019\u0012\r\u001a3sKN\u001cHk\\#yK\u000e,Ho\u001c:JIV\u0011!Q\u0003\t\u0006kj\u00149\u0002 \t\u0004U\te\u0011b\u0001B\u000eW\tQ!\u000b]2BI\u0012\u0014Xm]:\t\u0013\t}\u00111\u0016Q\u0001\n\tU\u0011\u0001F1eIJ,7o\u001d+p\u000bb,7-\u001e;pe&#\u0007\u0005\u0003\u0006\u0003$\u0005-&\u0019!C\u0005\u0005K\tAB]3wSZ,G\u000b\u001b:fC\u0012,\"Aa\n\u0011\t\t%\"1F\u0007\u0002\u007f%\u0019!QF \u00031M\u001b\u0007.\u001a3vY\u0016$W\t_3dkR|'oU3sm&\u001cW\rC\u0005\u00032\u0005-\u0006\u0015!\u0003\u0003(\u0005i!/\u001a<jm\u0016$\u0006N]3bI\u0002B\u0001B!\u000e\u0002,\u0012\u0005#qG\u0001\b_:\u001cF/\u0019:u)\t\tY\u0002\u0003\u0005\u0003<\u0005-F\u0011\tB\u001f\u0003\u001d\u0011XmY3jm\u0016,\"Aa\u0010\u0011\u000f9\u0011\tE!\u0012\u0002\u001c%\u0019!1I\b\u0003\u001fA\u000b'\u000f^5bY\u001a+hn\u0019;j_:\u00042A\u0004B$\u0013\r\u0011Ie\u0004\u0002\u0004\u0003:L\b\u0002\u0003B'\u0003W#\tEa\u0014\u0002\u001fI,7-Z5wK\u0006sGMU3qYf$BAa\u0010\u0003R!A!1\u000bB&\u0001\u0004\u0011)&A\u0004d_:$X\r\u001f;\u0011\u0007)\u00129&C\u0002\u0003Z-\u0012aB\u00159d\u0007\u0006dGnQ8oi\u0016DH\u000f\u0003\u0005\u0003^\u0005-F\u0011\u0002B\u001c\u0003)i\u0017m[3PM\u001a,'o\u001d\u0005\t\u0005C\nY\u000b\"\u0011\u0003d\u0005qqN\u001c#jg\u000e|gN\\3di\u0016$G\u0003BA\u000e\u0005KB\u0001Ba\u001a\u0003`\u0001\u0007!qC\u0001\u000ee\u0016lw\u000e^3BI\u0012\u0014Xm]:\t\u0011\tu\u00131\u0016C\u0005\u0005W\"B!a\u0007\u0003n!9!q\u000eB5\u0001\u0004a\u0018AC3yK\u000e,Ho\u001c:JI\"A!1OAV\t\u0013\u0011)(A\bfq\u0016\u001cW\u000f^8s\u0013N\fE.\u001b<f)\u0011\tYFa\u001e\t\u000f\t=$\u0011\u000fa\u0001y\"A!1PAV\t\u0013\u0011i(A\u0006mCVt7\r\u001b+bg.\u001cH\u0003BA\u000e\u0005\u007fB\u0001B!!\u0003z\u0001\u0007!1Q\u0001\u0006i\u0006\u001c8n\u001d\t\u0007\u0003\u0003\f\tN!\"\u0011\r\u0005\u0005\u0017\u0011\u001bBD!\rA\"\u0011R\u0005\u0004\u0005\u0017#!a\u0004+bg.$Um]2sSB$\u0018n\u001c8\t\u0011\t=\u00151\u0016C\u0005\u0005#\u000baB]3n_Z,W\t_3dkR|'\u000f\u0006\u0004\u0002\u001c\tM%Q\u0013\u0005\b\u0005_\u0012i\t1\u0001}\u0011!\u00119J!$A\u0002\te\u0015A\u0002:fCN|g\u000eE\u0002\u0019\u00057K1A!(\u0005\u0005I)\u00050Z2vi>\u0014Hj\\:t%\u0016\f7o\u001c8\t\u0011\t\u0005\u00161\u0016C\t\u0005G\u000bq\u0002Z5tC\ndW-\u0012=fGV$xN\u001d\u000b\u0005\u00037\u0012)\u000bC\u0004\u0003p\t}\u0005\u0019\u0001?\t\u0011\t%\u00161\u0016C!\u0005o\taa\u001c8Ti>\u0004\b\"\u0003BW\u0001\u0001\u0007I\u0011\u0001BX\u00039!'/\u001b<fe\u0016sG\r]8j]R,\"A!-\u0011\u0007)\u0012\u0019,C\u0002\u00036.\u0012aB\u00159d\u000b:$\u0007o\\5oiJ+g\rC\u0005\u0003:\u0002\u0001\r\u0011\"\u0001\u0003<\u0006\u0011BM]5wKJ,e\u000e\u001a9pS:$x\fJ3r)\u0011\tYB!0\t\u0015\u0005\r\"qWA\u0001\u0002\u0004\u0011\t\f\u0003\u0005\u0003B\u0002\u0001\u000b\u0015\u0002BY\u0003=!'/\u001b<fe\u0016sG\r]8j]R\u0004\u0003B\u0002Bc\u0001\u0011Eq,\u0001\nnS:\u0014VmZ5ti\u0016\u0014X\r\u001a*bi&|\u0007b\u0002Be\u0001\u0011\u0005#qG\u0001\u0006gR\f'\u000f\u001e\u0005\b\u0005\u001b\u0004A\u0011\u0003Bh\u0003]\u0019'/Z1uK\u0012\u0013\u0018N^3s\u000b:$\u0007o\\5oiJ+g\r\u0006\u0003\u00032\nE\u0007\u0002\u0003Bj\u0005\u0017\u0004\rA!6\u0002\u0015A\u0014x\u000e]3si&,7\u000fE\u0003v\u0005/\f9.C\u0002\u0003ZZ\u00141\"\u0011:sCf\u0014UO\u001a4fe\"9!Q\u001c\u0001\u0005\u0012\t}\u0017\u0001F2sK\u0006$X\r\u0012:jm\u0016\u0014XI\u001c3q_&tG\u000f\u0006\u0003\u0002b\n\u0005\b\u0002\u0003Bj\u00057\u0004\r!a0\t\u000f\t\u0015\b\u0001\"\u0001\u00038\u0005i1\u000f^8q\u000bb,7-\u001e;peNDqA!;\u0001\t\u0003\u00129$\u0001\u0003ti>\u0004\bb\u0002Bw\u0001\u0011E!qG\u0001\u0006e\u0016\u001cX\r\u001e\u0005\b\u0005c\u0004A\u0011\tB\u001c\u00031\u0011XM^5wK>3g-\u001a:t\u0011\u001d\u0011)\u0010\u0001C!\u0005o\f\u0001b[5mYR\u000b7o\u001b\u000b\t\u00037\u0011IP!@\u0003\u0000\"9!1 Bz\u0001\u0004A\u0017A\u0002;bg.LE\rC\u0004\u0003p\tM\b\u0019\u0001?\t\u0011\r\u0005!1\u001fa\u0001\u00037\nq\"\u001b8uKJ\u0014X\u000f\u001d;UQJ,\u0017\r\u001a\u0005\b\u0007\u000b\u0001A\u0011IB\u0004\u0003I!WMZ1vYR\u0004\u0016M]1mY\u0016d\u0017n]7\u0015\u0003aCqAa$\u0001\t\u0003\u0019Y\u0001\u0006\u0004\u0002\u001c\r51q\u0002\u0005\b\u0005_\u001aI\u00011\u0001}\u0011!\u00119j!\u0003A\u0002\te\u0005bBB\n\u0001\u0011\u00051QC\u0001\u001egV4g-[2jK:$(+Z:pkJ\u001cWm\u001d*fO&\u001cH/\u001a:fIR\u0011\u00111\f\u0005\b\u00073\u0001A\u0011IB\u000b\u0003\u001dI7OU3bIfDaa!\b\u0001\t\u00139\u0016\u0001\u00068v[\u0016C\u0018n\u001d;j]\u001e,\u00050Z2vi>\u00148\u000fC\u0004\u0004\"\u0001!\tea\t\u0002\u001d\u001d,G/\u0012=fGV$xN]%egR\u00111Q\u0005\t\u0006\u0003\u0003\f\t\u000e \u0005\b\u0007S\u0001AQIB\u0016\u0003A\u0011X-];fgR,\u00050Z2vi>\u00148\u000f\u0006\u0003\u0002\\\r5\u0002bBB\u0018\u0007O\u0001\r\u0001W\u0001\u0017]Vl\u0017\t\u001a3ji&|g.\u00197Fq\u0016\u001cW\u000f^8sg\"911\u0007\u0001\u0005F\rU\u0012!\u0006:fcV,7\u000f\u001e+pi\u0006dW\t_3dkR|'o\u001d\u000b\t\u00037\u001a9da\u000f\u0004>!91\u0011HB\u0019\u0001\u0004A\u0016\u0001\u00048v[\u0016CXmY;u_J\u001c\bbBAB\u0007c\u0001\r\u0001\u0017\u0005\t\u0003S\u001a\t\u00041\u0001\u0002n!91\u0011\t\u0001\u0005\u0012\r\r\u0013a\u00063p%\u0016\fX/Z:u)>$\u0018\r\\#yK\u000e,Ho\u001c:t)\u0011\tYf!\u0012\t\u000f\r\u001d3q\ba\u00011\u0006q!/Z9vKN$X\r\u001a+pi\u0006d\u0007bBB&\u0001\u0011\u00153QJ\u0001\u000eW&dG.\u0012=fGV$xN]:\u0015\t\u0005m3q\n\u0005\t\u0007#\u001aI\u00051\u0001\u0004&\u0005YQ\r_3dkR|'/\u00133t\u0011\u001d\u0019Y\u0005\u0001C\u0003\u0007+\"\u0002\"a\u0017\u0004X\re3Q\f\u0005\t\u0007#\u001a\u0019\u00061\u0001\u0004&!A11LB*\u0001\u0004\tY&A\u0004sKBd\u0017mY3\t\u0011\r}31\u000ba\u0001\u00037\nQAZ8sG\u0016Dqaa\u0019\u0001\t#\u0019)'A\be_.KG\u000e\\#yK\u000e,Ho\u001c:t)\u0011\tYfa\u001a\t\u0011\rE3\u0011\ra\u0001\u0007K9\u0001ba\u001b\u0003\u0011\u000311QN\u0001\u001e\u0007>\f'o]3He\u0006Lg.\u001a3TG\",G-\u001e7fe\n\u000b7m[3oIB\u0019Qga\u001c\u0007\u000f\u0005\u0011\u0001\u0012\u0001\u0004\u0004rM\u00191qN\u0007\t\u000fI\u001ay\u0007\"\u0001\u0004vQ\u00111Q\u000e\u0005\u000b\u0007s\u001ayG1A\u0005\u0002\rm\u0014!D#O\tB{\u0015J\u0014+`\u001d\u0006kU)\u0006\u0002\u0004~A!1qPBC\u001b\t\u0019\tIC\u0002\u0004\u0004\u000e\u000bA\u0001\\1oO&!\u00111ABA\u0011%\u0019Iia\u001c!\u0002\u0013\u0019i(\u0001\bF\u001d\u0012\u0003v*\u0013(U?:\u000bU*\u0012\u0011")
public class CoarseGrainedSchedulerBackend
implements ExecutorAllocationClient,
SchedulerBackend,
Logging {
    public final TaskSchedulerImpl org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler;
    private final RpcEnv rpcEnv;
    private final AtomicInteger totalCoreCount;
    private final AtomicInteger totalRegisteredExecutors;
    private final SparkConf conf;
    private final int org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$maxRpcMessageSize;
    private final double _minRegisteredRatio;
    private final long org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$maxRegisteredWaitingTimeMs;
    private final long createTime;
    private final HashMap<String, ExecutorData> org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap;
    @GuardedBy(value="CoarseGrainedSchedulerBackend.this")
    private int org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors;
    private final LiveListenerBus org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$listenerBus;
    @GuardedBy(value="CoarseGrainedSchedulerBackend.this")
    private final HashMap<String, Object> org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove;
    @GuardedBy(value="CoarseGrainedSchedulerBackend.this")
    private scala.collection.immutable.Map<String, Object> hostToLocalTaskCount;
    @GuardedBy(value="CoarseGrainedSchedulerBackend.this")
    private int localityAwareTasks;
    private volatile int currentExecutorIdCounter;
    private RpcEndpointRef driverEndpoint;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private final String org$apache$spark$scheduler$SchedulerBackend$$appId;

    public static String ENDPOINT_NAME() {
        return CoarseGrainedSchedulerBackend$.MODULE$.ENDPOINT_NAME();
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    @Override
    public String org$apache$spark$scheduler$SchedulerBackend$$appId() {
        return this.org$apache$spark$scheduler$SchedulerBackend$$appId;
    }

    @Override
    public void org$apache$spark$scheduler$SchedulerBackend$_setter_$org$apache$spark$scheduler$SchedulerBackend$$appId_$eq(String x$1) {
        this.org$apache$spark$scheduler$SchedulerBackend$$appId = x$1;
    }

    @Override
    public String applicationId() {
        return SchedulerBackend$class.applicationId(this);
    }

    @Override
    public Option<String> applicationAttemptId() {
        return SchedulerBackend$class.applicationAttemptId(this);
    }

    @Override
    public Option<scala.collection.immutable.Map<String, String>> getDriverLogUrls() {
        return SchedulerBackend$class.getDriverLogUrls(this);
    }

    @Override
    public boolean killExecutor(String executorId) {
        return ExecutorAllocationClient$class.killExecutor(this, executorId);
    }

    public RpcEnv rpcEnv() {
        return this.rpcEnv;
    }

    public AtomicInteger totalCoreCount() {
        return this.totalCoreCount;
    }

    public AtomicInteger totalRegisteredExecutors() {
        return this.totalRegisteredExecutors;
    }

    public SparkConf conf() {
        return this.conf;
    }

    public int org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$maxRpcMessageSize() {
        return this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$maxRpcMessageSize;
    }

    private double _minRegisteredRatio() {
        return this._minRegisteredRatio;
    }

    public long org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$maxRegisteredWaitingTimeMs() {
        return this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$maxRegisteredWaitingTimeMs;
    }

    private long createTime() {
        return this.createTime;
    }

    public HashMap<String, ExecutorData> org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap() {
        return this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap;
    }

    public int org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors() {
        return this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors;
    }

    public void org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors_$eq(int x$1) {
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors = x$1;
    }

    public LiveListenerBus org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$listenerBus() {
        return this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$listenerBus;
    }

    public HashMap<String, Object> org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove() {
        return this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove;
    }

    public scala.collection.immutable.Map<String, Object> hostToLocalTaskCount() {
        return this.hostToLocalTaskCount;
    }

    public void hostToLocalTaskCount_$eq(scala.collection.immutable.Map<String, Object> x$1) {
        this.hostToLocalTaskCount = x$1;
    }

    public int localityAwareTasks() {
        return this.localityAwareTasks;
    }

    public void localityAwareTasks_$eq(int x$1) {
        this.localityAwareTasks = x$1;
    }

    public int currentExecutorIdCounter() {
        return this.currentExecutorIdCounter;
    }

    public void currentExecutorIdCounter_$eq(int x$1) {
        this.currentExecutorIdCounter = x$1;
    }

    public RpcEndpointRef driverEndpoint() {
        return this.driverEndpoint;
    }

    public void driverEndpoint_$eq(RpcEndpointRef x$1) {
        this.driverEndpoint = x$1;
    }

    public double minRegisteredRatio() {
        return this._minRegisteredRatio();
    }

    @Override
    public void start() {
        ArrayBuffer properties = new ArrayBuffer();
        Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.sc().conf().getAll()).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> check$ifrefutable$2) {
                Tuple2<String, String> tuple2 = check$ifrefutable$2;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, properties){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer properties$1;

            public final Object apply(Tuple2<String, String> x$5) {
                Tuple2<String, String> tuple2 = x$5;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value2 = (String)tuple2._2();
                    BoxedUnit boxedUnit = key.startsWith("spark.") ? this.properties$1.$plus$eq((Object)new Tuple2((Object)key, (Object)value2)) : BoxedUnit.UNIT;
                    return boxedUnit;
                }
                throw new MatchError(tuple2);
            }
            {
                this.properties$1 = properties$1;
            }
        });
        this.driverEndpoint_$eq(this.createDriverEndpointRef((ArrayBuffer<Tuple2<String, String>>)properties));
    }

    public RpcEndpointRef createDriverEndpointRef(ArrayBuffer<Tuple2<String, String>> properties) {
        return this.rpcEnv().setupEndpoint(CoarseGrainedSchedulerBackend$.MODULE$.ENDPOINT_NAME(), this.createDriverEndpoint((Seq<Tuple2<String, String>>)properties));
    }

    public DriverEndpoint createDriverEndpoint(Seq<Tuple2<String, String>> properties) {
        return new DriverEndpoint(this, this.rpcEnv(), properties);
    }

    public void stopExecutors() {
        try {
            if (this.driverEndpoint() != null) {
                this.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Shutting down all executors";
                    }
                });
                this.driverEndpoint().askWithRetry(CoarseGrainedClusterMessages$StopExecutors$.MODULE$, ClassTag$.MODULE$.Boolean());
            }
            return;
        }
        catch (Exception exception2) {
            throw new SparkException("Error asking standalone scheduler to shut down executors", exception2);
        }
    }

    @Override
    public void stop() {
        this.stopExecutors();
        try {
            if (this.driverEndpoint() != null) {
                this.driverEndpoint().askWithRetry(CoarseGrainedClusterMessages$StopDriver$.MODULE$, ClassTag$.MODULE$.Boolean());
            }
            return;
        }
        catch (Exception exception2) {
            throw new SparkException("Error stopping standalone scheduler's driver endpoint", exception2);
        }
    }

    public synchronized void reset() {
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors_$eq(0);
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove().clear();
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().toMap(Predef$.MODULE$.$conforms()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CoarseGrainedSchedulerBackend $outer;

            public final boolean apply(Tuple2<String, ExecutorData> x0$2) {
                Tuple2<String, ExecutorData> tuple2 = x0$2;
                if (tuple2 != null) {
                    String eid = (String)tuple2._1();
                    boolean bl = BoxesRunTime.unboxToBoolean(this.$outer.driverEndpoint().askWithRetry(new CoarseGrainedClusterMessages.RemoveExecutor(eid, new SlaveLost("Stale executor after cluster manager re-registered.")), ClassTag$.MODULE$.Boolean()));
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Override
    public void reviveOffers() {
        this.driverEndpoint().send(CoarseGrainedClusterMessages$ReviveOffers$.MODULE$);
    }

    @Override
    public void killTask(long taskId, String executorId, boolean interruptThread) {
        this.driverEndpoint().send(new CoarseGrainedClusterMessages.KillTask(taskId, executorId, interruptThread));
    }

    @Override
    public int defaultParallelism() {
        return this.conf().getInt("spark.default.parallelism", package$.MODULE$.max(this.totalCoreCount().get(), 2));
    }

    public void removeExecutor(String executorId, ExecutorLossReason reason) {
        try {
            this.driverEndpoint().askWithRetry(new CoarseGrainedClusterMessages.RemoveExecutor(executorId, reason), ClassTag$.MODULE$.Boolean());
            return;
        }
        catch (Exception exception2) {
            throw new SparkException("Error notifying standalone scheduler's driver endpoint", exception2);
        }
    }

    public boolean sufficientResourcesRegistered() {
        return true;
    }

    @Override
    public boolean isReady() {
        if (this.sufficientResourcesRegistered()) {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CoarseGrainedSchedulerBackend $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"SchedulerBackend is ready for scheduling beginning after ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reached minRegisteredResourcesRatio: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.$outer.minRegisteredRatio())}))).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            return true;
        }
        if (System.currentTimeMillis() - this.createTime() >= this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$maxRegisteredWaitingTimeMs()) {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CoarseGrainedSchedulerBackend $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"SchedulerBackend is ready for scheduling beginning after waiting ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"maxRegisteredResourcesWaitingTime: ", "(ms)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$maxRegisteredWaitingTimeMs())}))).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            return true;
        }
        return false;
    }

    private int numExistingExecutors() {
        return this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().size();
    }

    @Override
    public Seq<String> getExecutorIds() {
        return this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().keySet().toSeq();
    }

    @Override
    public final synchronized boolean requestExecutors(int numAdditionalExecutors) {
        if (numAdditionalExecutors < 0) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Attempted to request a negative number of additional executor(s) ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " from the cluster manager. Please specify a positive number!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numAdditionalExecutors)}))).toString());
        }
        this.logInfo((Function0<String>)new Serializable(this, numAdditionalExecutors){
            public static final long serialVersionUID = 0L;
            private final int numAdditionalExecutors$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Requesting ", " additional executor(s) from the cluster manager"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numAdditionalExecutors$1)}));
            }
            {
                this.numAdditionalExecutors$1 = numAdditionalExecutors$1;
            }
        });
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CoarseGrainedSchedulerBackend $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Number of pending executors is now ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors_$eq(this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors() + numAdditionalExecutors);
        int newTotal = this.numExistingExecutors() + this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors() - this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove().size();
        return this.doRequestTotalExecutors(newTotal);
    }

    @Override
    public final synchronized boolean requestTotalExecutors(int numExecutors2, int localityAwareTasks, scala.collection.immutable.Map<String, Object> hostToLocalTaskCount) {
        if (numExecutors2 < 0) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Attempted to request a negative number of executor(s) ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " from the cluster manager. Please specify a positive number!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numExecutors2)}))).toString());
        }
        this.localityAwareTasks_$eq(localityAwareTasks);
        this.hostToLocalTaskCount_$eq(hostToLocalTaskCount);
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors_$eq(package$.MODULE$.max(numExecutors2 - this.numExistingExecutors() + this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove().size(), 0));
        return this.doRequestTotalExecutors(numExecutors2);
    }

    public boolean doRequestTotalExecutors(int requestedTotal) {
        return false;
    }

    @Override
    public final synchronized boolean killExecutors(Seq<String> executorIds) {
        return this.killExecutors(executorIds, false, false);
    }

    public final synchronized boolean killExecutors(Seq<String> executorIds, boolean replace, boolean force) {
        this.logInfo((Function0<String>)new Serializable(this, executorIds){
            public static final long serialVersionUID = 0L;
            private final Seq executorIds$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Requesting to kill executor(s) ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.executorIds$1.mkString(", ")}));
            }
            {
                this.executorIds$1 = executorIds$1;
            }
        });
        Tuple2 tuple2 = executorIds.partition((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CoarseGrainedSchedulerBackend $outer;

            public final boolean apply(String key) {
                return this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().contains((Object)key);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        if (tuple2 != null) {
            Object object;
            Tuple2 tuple22;
            Seq knownExecutors = (Seq)tuple2._1();
            Seq unknownExecutors = (Seq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)knownExecutors, (Object)unknownExecutors);
            Seq knownExecutors2 = (Seq)tuple23._1();
            Seq unknownExecutors2 = (Seq)tuple23._2();
            unknownExecutors2.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CoarseGrainedSchedulerBackend $outer;

                public final void apply(String id) {
                    this.$outer.logWarning((Function0<String>)new Serializable(this, id){
                        public static final long serialVersionUID = 0L;
                        private final String id$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Executor to kill ", " does not exist!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.id$1}));
                        }
                        {
                            this.id$1 = id$1;
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            Seq executorsToKill = (Seq)((TraversableLike)knownExecutors2.filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CoarseGrainedSchedulerBackend $outer;

                public final boolean apply(String id) {
                    return !this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove().contains((Object)id);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            })).filter((Function1)new Serializable(this, force){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CoarseGrainedSchedulerBackend $outer;
                private final boolean force$1;

                public final boolean apply(String id) {
                    return this.force$1 || !this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.isExecutorBusy(id);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.force$1 = force$1;
                }
            });
            executorsToKill.foreach((Function1)new Serializable(this, replace){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CoarseGrainedSchedulerBackend $outer;
                private final boolean replace$1;

                public final void apply(String id) {
                    this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove().update((Object)id, (Object)BoxesRunTime.boxToBoolean((!this.replace$1 ? 1 : 0) != 0));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.replace$1 = replace$1;
                }
            });
            if (replace) {
                this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors_$eq(this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors() + knownExecutors2.size());
                object = BoxedUnit.UNIT;
            } else {
                object = BoxesRunTime.boxToBoolean((boolean)this.doRequestTotalExecutors(this.numExistingExecutors() + this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors() - this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove().size()));
            }
            return !executorsToKill.isEmpty() && this.doKillExecutors((Seq<String>)executorsToKill);
        }
        throw new MatchError((Object)tuple2);
    }

    public boolean doKillExecutors(Seq<String> executorIds) {
        return false;
    }

    public CoarseGrainedSchedulerBackend(TaskSchedulerImpl scheduler, RpcEnv rpcEnv) {
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler = scheduler;
        this.rpcEnv = rpcEnv;
        ExecutorAllocationClient$class.$init$(this);
        SchedulerBackend$class.$init$(this);
        Logging$class.$init$(this);
        this.totalCoreCount = new AtomicInteger(0);
        this.totalRegisteredExecutors = new AtomicInteger(0);
        this.conf = scheduler.sc().conf();
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$maxRpcMessageSize = RpcUtils$.MODULE$.maxMessageSizeBytes(this.conf());
        this._minRegisteredRatio = package$.MODULE$.min(1.0, this.conf().getDouble("spark.scheduler.minRegisteredResourcesRatio", 0.0));
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$maxRegisteredWaitingTimeMs = this.conf().getTimeAsMs("spark.scheduler.maxRegisteredResourcesWaitingTime", "30s");
        this.createTime = System.currentTimeMillis();
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap = new HashMap();
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors = 0;
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$listenerBus = scheduler.sc().listenerBus();
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove = new HashMap();
        this.hostToLocalTaskCount = Predef$.MODULE$.Map().empty();
        this.localityAwareTasks = 0;
        this.currentExecutorIdCounter = 0;
        this.driverEndpoint = null;
    }

    public class DriverEndpoint
    implements ThreadSafeRpcEndpoint,
    Logging {
        private final RpcEnv rpcEnv;
        public final Seq<Tuple2<String, String>> org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$sparkProperties;
        private final HashSet<String> executorsPendingLossReason;
        private final SerializerInstance org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$ser;
        private final HashMap<RpcAddress, String> addressToExecutorId;
        private final ScheduledExecutorService reviveThread;
        public final /* synthetic */ CoarseGrainedSchedulerBackend $outer;
        private transient Logger org$apache$spark$internal$Logging$$log_;

        @Override
        public Logger org$apache$spark$internal$Logging$$log_() {
            return this.org$apache$spark$internal$Logging$$log_;
        }

        @Override
        @TraitSetter
        public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
            this.org$apache$spark$internal$Logging$$log_ = x$1;
        }

        @Override
        public String logName() {
            return Logging$class.logName(this);
        }

        @Override
        public Logger log() {
            return Logging$class.log(this);
        }

        @Override
        public void logInfo(Function0<String> msg) {
            Logging$class.logInfo(this, msg);
        }

        @Override
        public void logDebug(Function0<String> msg) {
            Logging$class.logDebug(this, msg);
        }

        @Override
        public void logTrace(Function0<String> msg) {
            Logging$class.logTrace(this, msg);
        }

        @Override
        public void logWarning(Function0<String> msg) {
            Logging$class.logWarning(this, msg);
        }

        @Override
        public void logError(Function0<String> msg) {
            Logging$class.logError(this, msg);
        }

        @Override
        public void logInfo(Function0<String> msg, Throwable throwable) {
            Logging$class.logInfo(this, msg, throwable);
        }

        @Override
        public void logDebug(Function0<String> msg, Throwable throwable) {
            Logging$class.logDebug(this, msg, throwable);
        }

        @Override
        public void logTrace(Function0<String> msg, Throwable throwable) {
            Logging$class.logTrace(this, msg, throwable);
        }

        @Override
        public void logWarning(Function0<String> msg, Throwable throwable) {
            Logging$class.logWarning(this, msg, throwable);
        }

        @Override
        public void logError(Function0<String> msg, Throwable throwable) {
            Logging$class.logError(this, msg, throwable);
        }

        @Override
        public boolean isTraceEnabled() {
            return Logging$class.isTraceEnabled(this);
        }

        @Override
        public void initializeLogIfNecessary(boolean isInterpreter) {
            Logging$class.initializeLogIfNecessary(this, isInterpreter);
        }

        @Override
        public final RpcEndpointRef self() {
            return RpcEndpoint$class.self(this);
        }

        @Override
        public void onError(Throwable cause) {
            RpcEndpoint$class.onError(this, cause);
        }

        @Override
        public void onConnected(RpcAddress remoteAddress) {
            RpcEndpoint$class.onConnected(this, remoteAddress);
        }

        @Override
        public void onNetworkError(Throwable cause, RpcAddress remoteAddress) {
            RpcEndpoint$class.onNetworkError(this, cause, remoteAddress);
        }

        @Override
        public final void stop() {
            RpcEndpoint$class.stop(this);
        }

        @Override
        public RpcEnv rpcEnv() {
            return this.rpcEnv;
        }

        public HashSet<String> executorsPendingLossReason() {
            return this.executorsPendingLossReason;
        }

        public SerializerInstance org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$ser() {
            return this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$ser;
        }

        public HashMap<RpcAddress, String> addressToExecutorId() {
            return this.addressToExecutorId;
        }

        private ScheduledExecutorService reviveThread() {
            return this.reviveThread;
        }

        @Override
        public void onStart() {
            long reviveIntervalMs = this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().conf().getTimeAsMs("spark.scheduler.revive.interval", "1s");
            this.reviveThread().scheduleAtFixedRate(new Runnable(this){
                private final /* synthetic */ DriverEndpoint $outer;

                public void run() {
                    Utils$.MODULE$.tryLogNonFatalError((Function0<BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ DriverEndpoint$$anon$1 $outer;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            Option$.MODULE$.apply((Object)this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$anon$$$outer().self()).foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final void apply(RpcEndpointRef x$1) {
                                    x$1.send(CoarseGrainedClusterMessages$ReviveOffers$.MODULE$);
                                }
                            });
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }

                public /* synthetic */ DriverEndpoint org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$anon$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, 0L, reviveIntervalMs, TimeUnit.MILLISECONDS);
        }

        @Override
        public PartialFunction<Object, BoxedUnit> receive() {
            return new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DriverEndpoint $outer;

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    void var14_18;
                    A1 A1 = x1;
                    if (A1 instanceof CoarseGrainedClusterMessages.StatusUpdate) {
                        BoxedUnit boxedUnit;
                        CoarseGrainedClusterMessages.StatusUpdate statusUpdate2 = (CoarseGrainedClusterMessages.StatusUpdate)A1;
                        String executorId = statusUpdate2.executorId();
                        long taskId = statusUpdate2.taskId();
                        Enumeration.Value state = statusUpdate2.state();
                        SerializableBuffer data = statusUpdate2.data();
                        this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.statusUpdate(taskId, state, data.value());
                        if (TaskState$.MODULE$.isFinished(state)) {
                            Option option = this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().get((Object)executorId);
                            if (option instanceof Some) {
                                Some some = (Some)option;
                                ExecutorData executorInfo = (ExecutorData)some.x();
                                executorInfo.freeCores_$eq(executorInfo.freeCores() + this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.CPUS_PER_TASK());
                                this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$makeOffers(executorId);
                                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                            } else {
                                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                                this.$outer.logWarning((Function0<String>)new Serializable(this, executorId, taskId, state){
                                    public static final long serialVersionUID = 0L;
                                    private final String executorId$1;
                                    private final long taskId$1;
                                    private final Enumeration.Value state$1;

                                    public final String apply() {
                                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignored task status update (", " state ", ") "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.taskId$1), this.state$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from unknown executor with ID ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.executorId$1}))).toString();
                                    }
                                    {
                                        this.executorId$1 = executorId$1;
                                        this.taskId$1 = taskId$1;
                                        this.state$1 = state$1;
                                    }
                                });
                                BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                            }
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit4 = boxedUnit;
                        return var14_18;
                    } else if (CoarseGrainedClusterMessages$ReviveOffers$.MODULE$.equals(A1)) {
                        this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$makeOffers();
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return var14_18;
                    } else if (A1 instanceof CoarseGrainedClusterMessages.KillTask) {
                        CoarseGrainedClusterMessages.KillTask killTask2 = (CoarseGrainedClusterMessages.KillTask)A1;
                        long taskId = killTask2.taskId();
                        String executorId = killTask2.executor();
                        boolean interruptThread = killTask2.interruptThread();
                        Option option = this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().get((Object)executorId);
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            ExecutorData executorInfo = (ExecutorData)some.x();
                            executorInfo.executorEndpoint().send(new CoarseGrainedClusterMessages.KillTask(taskId, executorId, interruptThread));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                            this.$outer.logWarning((Function0<String>)new Serializable(this, taskId, executorId){
                                public static final long serialVersionUID = 0L;
                                private final long taskId$2;
                                private final String executorId$2;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempted to kill task ", " for unknown executor ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.taskId$2), this.executorId$2}));
                                }
                                {
                                    this.taskId$2 = taskId$2;
                                    this.executorId$2 = executorId$2;
                                }
                            });
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return var14_18;
                    } else {
                        Object object = function1.apply(x1);
                    }
                    return var14_18;
                }

                public final boolean isDefinedAt(Object x1) {
                    Object object = x1;
                    boolean bl = object instanceof CoarseGrainedClusterMessages.StatusUpdate ? true : (CoarseGrainedClusterMessages$ReviveOffers$.MODULE$.equals(object) ? true : object instanceof CoarseGrainedClusterMessages.KillTask);
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
        }

        @Override
        public PartialFunction<Object, BoxedUnit> receiveAndReply(RpcCallContext context) {
            return new Serializable(this, context){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DriverEndpoint $outer;
                private final RpcCallContext context$1;

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public final <A1, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x2;
                    if (A1 instanceof CoarseGrainedClusterMessages.RegisterExecutor) {
                        BoxedUnit boxedUnit;
                        CoarseGrainedClusterMessages.RegisterExecutor registerExecutor = (CoarseGrainedClusterMessages.RegisterExecutor)A1;
                        String executorId = registerExecutor.executorId();
                        RpcEndpointRef executorRef = registerExecutor.executorRef();
                        String hostname = registerExecutor.hostname();
                        int cores = registerExecutor.cores();
                        scala.collection.immutable.Map<String, String> logUrls = registerExecutor.logUrls();
                        if (this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().contains((Object)executorId)) {
                            executorRef.send(new CoarseGrainedClusterMessages.RegisterExecutorFailed(new StringBuilder().append((Object)"Duplicate executor ID: ").append((Object)executorId).toString()));
                            this.context$1.reply(BoxesRunTime.boxToBoolean((boolean)true));
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            RpcAddress executorAddress = executorRef.address() == null ? this.context$1.senderAddress() : executorRef.address();
                            this.$outer.logInfo((Function0<String>)new Serializable(this, executorId, executorRef, executorAddress){
                                public static final long serialVersionUID = 0L;
                                private final String executorId$3;
                                private final RpcEndpointRef executorRef$1;
                                private final RpcAddress executorAddress$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Registered executor ", " (", ") with ID ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.executorRef$1, this.executorAddress$1, this.executorId$3}));
                                }
                                {
                                    this.executorId$3 = executorId$3;
                                    this.executorRef$1 = executorRef$1;
                                    this.executorAddress$1 = executorAddress$1;
                                }
                            });
                            this.$outer.addressToExecutorId().update((Object)executorAddress, (Object)executorId);
                            this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().totalCoreCount().addAndGet(cores);
                            this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().totalRegisteredExecutors().addAndGet(1);
                            ExecutorData data = new ExecutorData(executorRef, executorRef.address(), hostname, cores, cores, logUrls);
                            CoarseGrainedSchedulerBackend coarseGrainedSchedulerBackend = this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer();
                            synchronized (coarseGrainedSchedulerBackend) {
                                BoxedUnit boxedUnit2;
                                this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().put((Object)executorId, (Object)data);
                                if (this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().currentExecutorIdCounter() < new StringOps(Predef$.MODULE$.augmentString(executorId)).toInt()) {
                                    this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().currentExecutorIdCounter_$eq(new StringOps(Predef$.MODULE$.augmentString(executorId)).toInt());
                                }
                                if (this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors() > 0) {
                                    this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors_$eq(this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors() - 1);
                                    this.$outer.logDebug((Function0<String>)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ DriverEndpoint$$anonfun$receiveAndReply$1 $outer;

                                        public final String apply() {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Decremented number of pending executors (", " left)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$anonfun$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors())}));
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                    boxedUnit2 = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit2 = BoxedUnit.UNIT;
                                }
                                // MONITOREXIT @DISABLED, blocks:[0, 1, 10, 12] lbl35 : MonitorExitStatement: MONITOREXIT : coarseGrainedSchedulerBackend
                                executorRef.send(CoarseGrainedClusterMessages$RegisteredExecutor$.MODULE$);
                                this.context$1.reply(BoxesRunTime.boxToBoolean((boolean)true));
                                this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$listenerBus().post(new SparkListenerExecutorAdded(System.currentTimeMillis(), executorId, data));
                                this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$makeOffers();
                                boxedUnit = BoxedUnit.UNIT;
                            }
                        }
                        object = boxedUnit;
                        return (B1)object;
                    }
                    if (CoarseGrainedClusterMessages$StopDriver$.MODULE$.equals(A1)) {
                        this.context$1.reply(BoxesRunTime.boxToBoolean((boolean)true));
                        this.$outer.stop();
                        object = BoxedUnit.UNIT;
                        return (B1)object;
                    }
                    if (CoarseGrainedClusterMessages$StopExecutors$.MODULE$.equals(A1)) {
                        this.$outer.logInfo((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Asking each executor to shut down";
                            }
                        });
                        this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().withFilter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Tuple2<String, ExecutorData> check$ifrefutable$1) {
                                Tuple2<String, ExecutorData> tuple2 = check$ifrefutable$1;
                                boolean bl = tuple2 != null;
                                return bl;
                            }
                        }).foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(Tuple2<String, ExecutorData> x$2) {
                                Tuple2<String, ExecutorData> tuple2 = x$2;
                                if (tuple2 != null) {
                                    ExecutorData executorData = (ExecutorData)tuple2._2();
                                    executorData.executorEndpoint().send(CoarseGrainedClusterMessages$StopExecutor$.MODULE$);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                                throw new MatchError(tuple2);
                            }
                        });
                        this.context$1.reply(BoxesRunTime.boxToBoolean((boolean)true));
                        object = BoxedUnit.UNIT;
                        return (B1)object;
                    }
                    if (A1 instanceof CoarseGrainedClusterMessages.RemoveExecutor) {
                        CoarseGrainedClusterMessages.RemoveExecutor removeExecutor2 = (CoarseGrainedClusterMessages.RemoveExecutor)A1;
                        String executorId = removeExecutor2.executorId();
                        ExecutorLossReason reason = removeExecutor2.reason();
                        this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().get((Object)executorId).foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(ExecutorData x$3) {
                                x$3.executorEndpoint().send(CoarseGrainedClusterMessages$StopExecutor$.MODULE$);
                            }
                        });
                        this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$removeExecutor(executorId, reason);
                        this.context$1.reply(BoxesRunTime.boxToBoolean((boolean)true));
                        object = BoxedUnit.UNIT;
                        return (B1)object;
                    }
                    if (CoarseGrainedClusterMessages$RetrieveSparkProps$.MODULE$.equals(A1)) {
                        this.context$1.reply(this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$sparkProperties);
                        object = BoxedUnit.UNIT;
                        return (B1)object;
                    }
                    object = function1.apply(x2);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Object x2) {
                    Object object = x2;
                    boolean bl = object instanceof CoarseGrainedClusterMessages.RegisterExecutor ? true : (CoarseGrainedClusterMessages$StopDriver$.MODULE$.equals(object) ? true : (CoarseGrainedClusterMessages$StopExecutors$.MODULE$.equals(object) ? true : (object instanceof CoarseGrainedClusterMessages.RemoveExecutor ? true : CoarseGrainedClusterMessages$RetrieveSparkProps$.MODULE$.equals(object))));
                    return bl;
                }

                public /* synthetic */ DriverEndpoint org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.context$1 = context$1;
                }
            };
        }

        public void org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$makeOffers() {
            Map activeExecutors = this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().filterKeys((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DriverEndpoint $outer;

                public final boolean apply(String executorId) {
                    return this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$executorIsAlive(executorId);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            Seq workOffers = ((TraversableOnce)activeExecutors.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final WorkerOffer apply(Tuple2<String, ExecutorData> x0$1) {
                    Tuple2<String, ExecutorData> tuple2 = x0$1;
                    if (tuple2 != null) {
                        String id = (String)tuple2._1();
                        ExecutorData executorData = (ExecutorData)tuple2._2();
                        WorkerOffer workerOffer = new WorkerOffer(id, executorData.executorHost(), executorData.freeCores());
                        return workerOffer;
                    }
                    throw new MatchError(tuple2);
                }
            }, Iterable$.MODULE$.canBuildFrom())).toSeq();
            this.launchTasks(this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.resourceOffers((Seq<WorkerOffer>)workOffers));
        }

        @Override
        public void onDisconnected(RpcAddress remoteAddress) {
            this.addressToExecutorId().get((Object)remoteAddress).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DriverEndpoint $outer;

                public final void apply(String x$4) {
                    this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$removeExecutor(x$4, new SlaveLost("Remote RPC client disassociated. Likely due to containers exceeding thresholds, or network issues. Check driver logs for WARN messages."));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }

        public void org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$makeOffers(String executorId) {
            if (this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$executorIsAlive(executorId)) {
                ExecutorData executorData = (ExecutorData)this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().apply((Object)executorId);
                Seq workOffers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new WorkerOffer[]{new WorkerOffer(executorId, executorData.executorHost(), executorData.freeCores())}));
                this.launchTasks(this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.resourceOffers((Seq<WorkerOffer>)workOffers));
            }
        }

        public synchronized boolean org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$executorIsAlive(String executorId) {
            return !this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove().contains((Object)executorId) && !this.executorsPendingLossReason().contains((Object)executorId);
        }

        private void launchTasks(Seq<Seq<TaskDescription>> tasks) {
            ((IterableLike)tasks.flatten((Function1)Predef$.MODULE$.$conforms())).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DriverEndpoint $outer;

                public final void apply(TaskDescription task) {
                    ByteBuffer serializedTask = this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$ser().serialize(task, ClassTag$.MODULE$.apply(TaskDescription.class));
                    if (serializedTask.limit() >= this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$maxRpcMessageSize()) {
                        this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.taskIdToTaskSetManager().get((Object)BoxesRunTime.boxToLong((long)task.taskId())).foreach((Function1)new Serializable(this, serializedTask, task){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ DriverEndpoint$$anonfun$launchTasks$1 $outer;
                            private final ByteBuffer serializedTask$1;
                            private final TaskDescription task$1;

                            public final void apply(TaskSetManager taskSetMgr) {
                                try {
                                    String msg = "Serialized task %s:%d was %d bytes, which exceeds max allowed: spark.rpc.message.maxSize (%d bytes). Consider increasing spark.rpc.message.maxSize or using broadcast variables for large values.";
                                    msg = new StringOps(Predef$.MODULE$.augmentString(msg)).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.task$1.taskId()), BoxesRunTime.boxToInteger((int)this.task$1.index()), BoxesRunTime.boxToInteger((int)this.serializedTask$1.limit()), BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$anonfun$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$maxRpcMessageSize())}));
                                    taskSetMgr.abort(msg, taskSetMgr.abort$default$2());
                                }
                                catch (Exception exception2) {
                                    this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$anonfun$$$outer().logError((Function0<String>)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "Exception in error callback";
                                        }
                                    }, exception2);
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.serializedTask$1 = serializedTask$1;
                                this.task$1 = task$1;
                            }
                        });
                    } else {
                        ExecutorData executorData = (ExecutorData)this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().apply((Object)task.executorId());
                        executorData.freeCores_$eq(executorData.freeCores() - this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.CPUS_PER_TASK());
                        this.$outer.logInfo((Function0<String>)new Serializable(this, executorData, task){
                            public static final long serialVersionUID = 0L;
                            private final ExecutorData executorData$1;
                            private final TaskDescription task$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Launching task ", " on executor id: ", " hostname: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.task$1.taskId()), this.task$1.executorId()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.executorData$1.executorHost()}))).toString();
                            }
                            {
                                this.executorData$1 = executorData$1;
                                this.task$1 = task$1;
                            }
                        });
                        executorData.executorEndpoint().send(new CoarseGrainedClusterMessages.LaunchTask(new SerializableBuffer(serializedTask)));
                    }
                }

                public /* synthetic */ DriverEndpoint org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$removeExecutor(String executorId, ExecutorLossReason reason) {
            Object object;
            Option option = this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().get((Object)executorId);
            if (!(option instanceof Some)) {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.sc().env().blockManager().master().removeExecutorAsync(executorId);
                this.logInfo((Function0<String>)new Serializable(this, executorId){
                    public static final long serialVersionUID = 0L;
                    private final String executorId$4;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Asked to remove non-existent executor ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.executorId$4}));
                    }
                    {
                        this.executorId$4 = executorId$4;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
            Some some = (Some)option;
            ExecutorData executorInfo = (ExecutorData)some.x();
            CoarseGrainedSchedulerBackend coarseGrainedSchedulerBackend = this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer();
            synchronized (coarseGrainedSchedulerBackend) {
                this.addressToExecutorId().$minus$eq((Object)executorInfo.executorAddress());
                this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().$minus$eq((Object)executorId);
                this.executorsPendingLossReason().$minus$eq((Object)executorId);
                object = this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove().remove((Object)executorId).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return false;
                    }
                });
            }
            boolean killed = BoxesRunTime.unboxToBoolean((Object)object);
            this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().totalCoreCount().addAndGet(-executorInfo.totalCores());
            this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().totalRegisteredExecutors().addAndGet(-1);
            this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.executorLost(executorId, killed ? ExecutorKilled$.MODULE$ : reason);
            this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$listenerBus().post(new SparkListenerExecutorRemoved(System.currentTimeMillis(), executorId, reason.toString()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean disableExecutor(String executorId) {
            Boolean bl;
            CoarseGrainedSchedulerBackend coarseGrainedSchedulerBackend = this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer();
            synchronized (coarseGrainedSchedulerBackend) {
                Boolean bl2;
                if (this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$executorIsAlive(executorId)) {
                    this.executorsPendingLossReason().$plus$eq((Object)executorId);
                    bl2 = BoxesRunTime.boxToBoolean((boolean)true);
                } else {
                    bl2 = BoxesRunTime.boxToBoolean((boolean)this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove().contains((Object)executorId));
                }
                bl = bl2;
            }
            boolean shouldDisable = BoxesRunTime.unboxToBoolean((Object)bl);
            if (shouldDisable) {
                this.logInfo((Function0<String>)new Serializable(this, executorId){
                    public static final long serialVersionUID = 0L;
                    private final String executorId$5;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Disabling executor ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.executorId$5}));
                    }
                    {
                        this.executorId$5 = executorId$5;
                    }
                });
                this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.executorLost(executorId, LossReasonPending$.MODULE$);
            }
            return shouldDisable;
        }

        @Override
        public void onStop() {
            this.reviveThread().shutdownNow();
        }

        public /* synthetic */ CoarseGrainedSchedulerBackend org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer() {
            return this.$outer;
        }

        public DriverEndpoint(CoarseGrainedSchedulerBackend $outer, RpcEnv rpcEnv, Seq<Tuple2<String, String>> sparkProperties) {
            this.rpcEnv = rpcEnv;
            this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$sparkProperties = sparkProperties;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            RpcEndpoint$class.$init$(this);
            Logging$class.$init$(this);
            this.executorsPendingLossReason = new HashSet();
            this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$ser = SparkEnv$.MODULE$.get().closureSerializer().newInstance();
            this.addressToExecutorId = new HashMap();
            this.reviveThread = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("driver-revive-thread");
        }
    }
}

