/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.nio.ByteBuffer;
import java.util.Properties;
import org.apache.spark.Partition;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.executor.TaskMetrics;
import org.apache.spark.rdd.RDD;
import org.apache.spark.scheduler.Task;
import org.apache.spark.scheduler.TaskLocation;
import org.apache.spark.serializer.SerializerInstance;
import scala.Function2;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-b!B\u0001\u0003\u0001\u0011Q!A\u0003*fgVdG\u000fV1tW*\u00111\u0001B\u0001\ng\u000eDW\rZ;mKJT!!\u0002\u0004\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u001dA\u0011AB1qC\u000eDWMC\u0001\n\u0003\ry'oZ\u000b\u0004\u0017A\u00142c\u0001\u0001\r?A\u0019QB\u0004\t\u000e\u0003\tI!a\u0004\u0002\u0003\tQ\u000b7o\u001b\t\u0003#Ia\u0001\u0001B\u0003\u0014\u0001\t\u0007QCA\u0001V\u0007\u0001\t\"A\u0006\u000f\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\u000f9{G\u000f[5oOB\u0011q#H\u0005\u0003=a\u00111!\u00118z!\t\u0001S%D\u0001\"\u0015\t\u00113%\u0001\u0002j_*\tA%\u0001\u0003kCZ\f\u0017B\u0001\u0014\"\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011%A\u0003A!A!\u0002\u0013IC&A\u0004ti\u0006<W-\u00133\u0011\u0005]Q\u0013BA\u0016\u0019\u0005\rIe\u000e^\u0005\u0003Q9A\u0011B\f\u0001\u0003\u0002\u0003\u0006I!K\u0018\u0002\u001dM$\u0018mZ3BiR,W\u000e\u001d;JI&\u0011aF\u0004\u0005\tc\u0001\u0011\t\u0011)A\u0005e\u0005QA/Y:l\u0005&t\u0017M]=\u0011\u0007M2\u0004(D\u00015\u0015\t)D!A\u0005ce>\fGmY1ti&\u0011q\u0007\u000e\u0002\n\u0005J|\u0017\rZ2bgR\u00042aF\u001d<\u0013\tQ\u0004DA\u0003BeJ\f\u0017\u0010\u0005\u0002\u0018y%\u0011Q\b\u0007\u0002\u0005\u0005f$X\r\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003A\u0003%\u0001\u0018M\u001d;ji&|g\u000e\u0005\u0002B\u00056\tA!\u0003\u0002D\t\tI\u0001+\u0019:uSRLwN\u001c\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\r\u0006!An\\2t!\r9uJ\u0015\b\u0003\u00116s!!\u0013'\u000e\u0003)S!a\u0013\u000b\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0012B\u0001(\u0019\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001U)\u0003\u0007M+\u0017O\u0003\u0002O1A\u0011QbU\u0005\u0003)\n\u0011A\u0002V1tW2{7-\u0019;j_:D\u0001B\u0016\u0001\u0003\u0006\u0004%\taV\u0001\t_V$\b/\u001e;JIV\t\u0011\u0006\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003*\u0003%yW\u000f\u001e9vi&#\u0007\u0005\u0003\u0005\\\u0001\t\u0005\t\u0015!\u0003]\u0003=awnY1m!J|\u0007/\u001a:uS\u0016\u001c\bCA/a\u001b\u0005q&BA0$\u0003\u0011)H/\u001b7\n\u0005\u0005t&A\u0003)s_B,'\u000f^5fg\"I1\r\u0001B\u0001B\u0003%AM[\u0001\b[\u0016$(/[2t!\t)\u0007.D\u0001g\u0015\t9G!\u0001\u0005fq\u0016\u001cW\u000f^8s\u0013\tIgMA\u0006UCN\\W*\u001a;sS\u000e\u001c\u0018BA2\u000f\u0011\u0015a\u0007\u0001\"\u0001n\u0003\u0019a\u0014N\\5u}QIaN]:ukZ<\b0\u001f\t\u0005\u001b\u0001y\u0007\u0003\u0005\u0002\u0012a\u0012)\u0011\u000f\u0001b\u0001+\t\tA\u000bC\u0003)W\u0002\u0007\u0011\u0006C\u0003/W\u0002\u0007\u0011\u0006C\u00032W\u0002\u0007!\u0007C\u0003@W\u0002\u0007\u0001\tC\u0003FW\u0002\u0007a\tC\u0003WW\u0002\u0007\u0011\u0006C\u0003\\W\u0002\u0007A\fC\u0003dW\u0002\u0007A\r\u0003\u0004|\u0001\u0001\u0006IAR\u0001\u000eaJ,g-\u001a:sK\u0012dunY:)\u0005il\bCA\f\u007f\u0013\ty\bDA\u0005ue\u0006t7/[3oi\"9\u00111\u0001\u0001\u0005B\u0005\u0015\u0011a\u0002:v]R\u000b7o\u001b\u000b\u0004!\u0005\u001d\u0001\u0002CA\u0005\u0003\u0003\u0001\r!a\u0003\u0002\u000f\r|g\u000e^3yiB\u0019\u0011)!\u0004\n\u0007\u0005=AAA\u0006UCN\\7i\u001c8uKb$\bbBA\n\u0001\u0011\u0005\u0013QC\u0001\u0013aJ,g-\u001a:sK\u0012dunY1uS>t7/F\u0001G\u0011\u001d\tI\u0002\u0001C!\u00037\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003;\u0001B!a\b\u0002&9\u0019q#!\t\n\u0007\u0005\r\u0002$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003O\tIC\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003GA\u0002")
public class ResultTask<T, U>
extends Task<U> {
    private final Broadcast<byte[]> taskBinary;
    private final Partition partition;
    private final int outputId;
    private final transient Seq<TaskLocation> preferredLocs;

    public int outputId() {
        return this.outputId;
    }

    @Override
    public U runTask(TaskContext context) {
        long deserializeStartTime = System.currentTimeMillis();
        SerializerInstance ser = SparkEnv$.MODULE$.get().closureSerializer().newInstance();
        Tuple2 tuple2 = (Tuple2)ser.deserialize(ByteBuffer.wrap(this.taskBinary.value()), Thread.currentThread().getContextClassLoader(), ClassTag$.MODULE$.apply(Tuple2.class));
        if (tuple2 != null) {
            Tuple2 tuple22;
            RDD rdd = (RDD)tuple2._1();
            Function2 func = (Function2)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)rdd, (Object)func);
            RDD rdd2 = (RDD)tuple23._1();
            Function2 func2 = (Function2)tuple23._2();
            this._executorDeserializeTime_$eq(System.currentTimeMillis() - deserializeStartTime);
            return (U)func2.apply((Object)context, rdd2.iterator(this.partition, context));
        }
        throw new MatchError((Object)tuple2);
    }

    @Override
    public Seq<TaskLocation> preferredLocations() {
        return this.preferredLocs;
    }

    public String toString() {
        return new StringBuilder().append((Object)"ResultTask(").append((Object)BoxesRunTime.boxToInteger((int)super.stageId())).append((Object)", ").append((Object)BoxesRunTime.boxToInteger((int)this.partitionId())).append((Object)")").toString();
    }

    public ResultTask(int stageId, int stageAttemptId, Broadcast<byte[]> taskBinary, Partition partition, Seq<TaskLocation> locs, int outputId, Properties localProperties, TaskMetrics metrics) {
        this.taskBinary = taskBinary;
        this.partition = partition;
        this.outputId = outputId;
        super(stageId, stageAttemptId, partition.index(), metrics, localProperties);
        this.preferredLocs = locs == null ? Nil$.MODULE$ : locs.toSet().toSeq();
    }
}

