/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.rpc.netty;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.apache.spark.network.client.RpcResponseCallback;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.RpcEndpointAddress;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnvStoppedException;
import org.apache.spark.rpc.netty.Dispatcher$;
import org.apache.spark.rpc.netty.Inbox;
import org.apache.spark.rpc.netty.InboxMessage;
import org.apache.spark.rpc.netty.LocalNettyRpcCallContext;
import org.apache.spark.rpc.netty.NettyRpcEndpointRef;
import org.apache.spark.rpc.netty.NettyRpcEnv;
import org.apache.spark.rpc.netty.OneWayMessage;
import org.apache.spark.rpc.netty.RemoteNettyRpcCallContext;
import org.apache.spark.rpc.netty.RequestMessage;
import org.apache.spark.rpc.netty.RpcMessage;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.concurrent.Promise;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.TraitSetter;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t}a!B\u0001\u0003\u0001\ta!A\u0003#jgB\fGo\u00195fe*\u00111\u0001B\u0001\u0006]\u0016$H/\u001f\u0006\u0003\u000b\u0019\t1A\u001d9d\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7c\u0001\u0001\u000e'A\u0011a\"E\u0007\u0002\u001f)\t\u0001#A\u0003tG\u0006d\u0017-\u0003\u0002\u0013\u001f\t1\u0011I\\=SK\u001a\u0004\"\u0001F\f\u000e\u0003UQ!A\u0006\u0004\u0002\u0011%tG/\u001a:oC2L!\u0001G\u000b\u0003\u000f1{wmZ5oO\"A!\u0004\u0001B\u0001B\u0003%A$\u0001\u0005oKR$\u00180\u00128w\u0007\u0001\u0001\"!\b\u0010\u000e\u0003\tI!a\b\u0002\u0003\u00179+G\u000f^=Sa\u000e,eN\u001e\u0005\u0006C\u0001!\tAI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\r\"\u0003CA\u000f\u0001\u0011\u0015Q\u0002\u00051\u0001\u001d\r\u00111\u0003\u0001B\u0014\u0003\u0019\u0015sG\r]8j]R$\u0015\r^1\u0014\u0005\u0015j\u0001\u0002C\u0015&\u0005\u000b\u0007I\u0011\u0001\u0016\u0002\t9\fW.Z\u000b\u0002WA\u0011Af\f\b\u0003\u001d5J!AL\b\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0014G\u0001\u0004TiJLgn\u001a\u0006\u0003]=A\u0001bM\u0013\u0003\u0002\u0003\u0006IaK\u0001\u0006]\u0006lW\r\t\u0005\tk\u0015\u0012)\u0019!C\u0001m\u0005AQM\u001c3q_&tG/F\u00018!\tA\u0014(D\u0001\u0005\u0013\tQDAA\u0006Sa\u000e,e\u000e\u001a9pS:$\b\u0002\u0003\u001f&\u0005\u0003\u0005\u000b\u0011B\u001c\u0002\u0013\u0015tG\r]8j]R\u0004\u0003\u0002\u0003 &\u0005\u000b\u0007I\u0011A \u0002\u0007I,g-F\u0001A!\ti\u0012)\u0003\u0002C\u0005\t\u0019b*\u001a;usJ\u00038-\u00128ea>Lg\u000e\u001e*fM\"AA)\nB\u0001B\u0003%\u0001)\u0001\u0003sK\u001a\u0004\u0003\"B\u0011&\t\u00031E\u0003B$J\u0015.\u0003\"\u0001S\u0013\u000e\u0003\u0001AQ!K#A\u0002-BQ!N#A\u0002]BQAP#A\u0002\u0001Cq!T\u0013C\u0002\u0013\u0005a*A\u0003j]\n|\u00070F\u0001P!\ti\u0002+\u0003\u0002R\u0005\t)\u0011J\u001c2pq\"11+\nQ\u0001\n=\u000ba!\u001b8c_b\u0004\u0003bB+\u0001\u0005\u0004%IAV\u0001\nK:$\u0007o\\5oiN,\u0012a\u0016\t\u00051~[s)D\u0001Z\u0015\tQ6,\u0001\u0006d_:\u001cWO\u001d:f]RT!\u0001X/\u0002\tU$\u0018\u000e\u001c\u0006\u0002=\u0006!!.\u0019<b\u0013\t\u0001\u0017LA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCBDaA\u0019\u0001!\u0002\u00139\u0016AC3oIB|\u0017N\u001c;tA!9A\r\u0001b\u0001\n\u0013)\u0017\u0001D3oIB|\u0017N\u001c;SK\u001a\u001cX#\u00014\u0011\ta{vg\u001a\t\u0003q!L!!\u001b\u0003\u0003\u001dI\u00038-\u00128ea>Lg\u000e\u001e*fM\"11\u000e\u0001Q\u0001\n\u0019\fQ\"\u001a8ea>Lg\u000e\u001e*fMN\u0004\u0003bB7\u0001\u0005\u0004%IA\\\u0001\ne\u0016\u001cW-\u001b<feN,\u0012a\u001c\t\u00041B<\u0015BA9Z\u0005Ma\u0015N\\6fI\ncwnY6j]\u001e\fV/Z;f\u0011\u0019\u0019\b\u0001)A\u0005_\u0006Q!/Z2fSZ,'o\u001d\u0011\t\u000fU\u0004\u0001\u0019!C\u0005m\u000691\u000f^8qa\u0016$W#A<\u0011\u00059A\u0018BA=\u0010\u0005\u001d\u0011un\u001c7fC:Dqa\u001f\u0001A\u0002\u0013%A0A\u0006ti>\u0004\b/\u001a3`I\u0015\fHcA?\u0002\u0002A\u0011aB`\u0005\u0003\u007f>\u0011A!\u00168ji\"A\u00111\u0001>\u0002\u0002\u0003\u0007q/A\u0002yIEBq!a\u0002\u0001A\u0003&q/\u0001\u0005ti>\u0004\b/\u001a3!Q!\t)!a\u0003\u0002\u001e\u0005}\u0001\u0003BA\u0007\u00033i!!a\u0004\u000b\u0007i\u000b\tB\u0003\u0003\u0002\u0014\u0005U\u0011AC1o]>$\u0018\r^5p]*\u0011\u0011qC\u0001\u0006U\u00064\u0018\r_\u0005\u0005\u00037\tyAA\u0005Hk\u0006\u0014H-\u001a3Cs\u0006)a/\u00197vK\u0006\u0012\u0011\u0011E\u0001\u0005i\"L7\u000fC\u0004\u0002&\u0001!\t!a\n\u0002'I,w-[:uKJ\u0014\u0006oY#oIB|\u0017N\u001c;\u0015\u000b\u0001\u000bI#a\u000b\t\r%\n\u0019\u00031\u0001,\u0011\u0019)\u00141\u0005a\u0001o!9\u0011q\u0006\u0001\u0005\u0002\u0005E\u0012!E4fiJ\u00038-\u00128ea>Lg\u000e\u001e*fMR\u0019q-a\r\t\rU\ni\u00031\u00018\u0011\u001d\t9\u0004\u0001C\u0001\u0003s\tAC]3n_Z,'\u000b]2F]\u0012\u0004x.\u001b8u%\u00164GcA?\u0002<!1Q'!\u000eA\u0002]Bq!a\u0010\u0001\t\u0013\t\t%A\u000bv]J,w-[:uKJ\u0014\u0006oY#oIB|\u0017N\u001c;\u0015\u0007u\f\u0019\u0005\u0003\u0004*\u0003{\u0001\ra\u000b\u0005\b\u0003\u000f\u0002A\u0011AA%\u0003\u0011\u0019Ho\u001c9\u0015\u0007u\fY\u0005C\u0004\u0002N\u0005\u0015\u0003\u0019A4\u0002\u001dI\u00048-\u00128ea>Lg\u000e\u001e*fM\"9\u0011\u0011\u000b\u0001\u0005\u0002\u0005M\u0013!\u00039pgR$v.\u00117m)\ri\u0018Q\u000b\u0005\t\u0003/\ny\u00051\u0001\u0002Z\u00059Q.Z:tC\u001e,\u0007cA\u000f\u0002\\%\u0019\u0011Q\f\u0002\u0003\u0019%s'm\u001c=NKN\u001c\u0018mZ3\t\u000f\u0005\u0005\u0004\u0001\"\u0001\u0002d\u0005\t\u0002o\\:u%\u0016lw\u000e^3NKN\u001c\u0018mZ3\u0015\u000bu\f)'!\u001c\t\u0011\u0005]\u0013q\fa\u0001\u0003O\u00022!HA5\u0013\r\tYG\u0001\u0002\u000f%\u0016\fX/Z:u\u001b\u0016\u001c8/Y4f\u0011!\ty'a\u0018A\u0002\u0005E\u0014\u0001C2bY2\u0014\u0017mY6\u0011\t\u0005M\u0014QP\u0007\u0003\u0003kRA!a\u001e\u0002z\u000511\r\\5f]RT1!a\u001f\u0007\u0003\u001dqW\r^<pe.LA!a \u0002v\t\u0019\"\u000b]2SKN\u0004xN\\:f\u0007\u0006dGNY1dW\"9\u00111\u0011\u0001\u0005\u0002\u0005\u0015\u0015\u0001\u00059pgRdunY1m\u001b\u0016\u001c8/Y4f)\u0015i\u0018qQAE\u0011!\t9&!!A\u0002\u0005\u001d\u0004\u0002CAF\u0003\u0003\u0003\r!!$\u0002\u0003A\u0004b!a$\u0002\u0014\u0006]UBAAI\u0015\tQv\"\u0003\u0003\u0002\u0016\u0006E%a\u0002)s_6L7/\u001a\t\u0004\u001d\u0005e\u0015bAAN\u001f\t\u0019\u0011I\\=\t\u000f\u0005}\u0005\u0001\"\u0001\u0002\"\u0006\t\u0002o\\:u\u001f:,w+Y=NKN\u001c\u0018mZ3\u0015\u0007u\f\u0019\u000b\u0003\u0005\u0002X\u0005u\u0005\u0019AA4\u0011\u001d\t9\u000b\u0001C\u0005\u0003S\u000b1\u0002]8ti6+7o]1hKR9Q0a+\u00020\u0006E\u0006bBAW\u0003K\u0003\raK\u0001\rK:$\u0007o\\5oi:\u000bW.\u001a\u0005\t\u0003/\n)\u000b1\u0001\u0002Z!A\u00111WAS\u0001\u0004\t),A\tdC2d'-Y2l\u0013\u001a\u001cFo\u001c9qK\u0012\u0004bADA\\\u0003wk\u0018bAA]\u001f\tIa)\u001e8di&|g.\r\t\u0005\u0003{\u000biM\u0004\u0003\u0002@\u0006%g\u0002BAa\u0003\u000fl!!a1\u000b\u0007\u0005\u00157$\u0001\u0004=e>|GOP\u0005\u0002!%\u0019\u00111Z\b\u0002\u000fA\f7m[1hK&!\u0011qZAi\u0005%)\u0005pY3qi&|gNC\u0002\u0002L>Aq!a\u0012\u0001\t\u0003\t)\u000eF\u0001~\u0011\u001d\tI\u000e\u0001C\u0001\u0003+\f\u0001#Y<bSR$VM]7j]\u0006$\u0018n\u001c8\t\u000f\u0005u\u0007\u0001\"\u0001\u0002`\u00061a/\u001a:jMf$2a^Aq\u0011\u0019I\u00131\u001ca\u0001W!I\u0011Q\u001d\u0001C\u0002\u0013%\u0011q]\u0001\u000bi\"\u0014X-\u00193q_>dWCAAu!\rA\u00161^\u0005\u0004\u0003[L&A\u0005+ie\u0016\fG\rU8pY\u0016CXmY;u_JD\u0001\"!=\u0001A\u0003%\u0011\u0011^\u0001\fi\"\u0014X-\u00193q_>d\u0007E\u0002\u0004\u0002v\u0002!\u0011q\u001f\u0002\f\u001b\u0016\u001c8/Y4f\u0019>|\u0007o\u0005\u0004\u0002t\u0006e(Q\u0001\t\u0005\u0003w\u0014\t!\u0004\u0002\u0002~*\u0019\u0011q`/\u0002\t1\fgnZ\u0005\u0005\u0005\u0007\tiP\u0001\u0004PE*,7\r\u001e\t\u0005\u0003w\u00149!\u0003\u0003\u0003\n\u0005u(\u0001\u0003*v]:\f'\r\\3\t\u000f\u0005\n\u0019\u0010\"\u0001\u0003\u000eQ\u0011!q\u0002\t\u0004\u0011\u0006M\b\u0002\u0003B\n\u0003g$\t%!6\u0002\u0007I,h\u000eC\u0005\u0003\u0018\u0001\u0011\r\u0011\"\u0003\u0003\u001a\u0005Q\u0001k\\5t_:\u0004\u0016\u000e\u001c7\u0016\u0003\u001dCqA!\b\u0001A\u0003%q)A\u0006Q_&\u001cxN\u001c)jY2\u0004\u0003")
public class Dispatcher
implements Logging {
    private final NettyRpcEnv nettyEnv;
    private final ConcurrentHashMap<String, EndpointData> endpoints;
    private final ConcurrentHashMap<RpcEndpoint, RpcEndpointRef> endpointRefs;
    private final LinkedBlockingQueue<EndpointData> org$apache$spark$rpc$netty$Dispatcher$$receivers;
    @GuardedBy(value="this")
    private boolean stopped;
    private final ThreadPoolExecutor threadpool;
    private final EndpointData org$apache$spark$rpc$netty$Dispatcher$$PoisonPill;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    private ConcurrentHashMap<String, EndpointData> endpoints() {
        return this.endpoints;
    }

    private ConcurrentHashMap<RpcEndpoint, RpcEndpointRef> endpointRefs() {
        return this.endpointRefs;
    }

    public LinkedBlockingQueue<EndpointData> org$apache$spark$rpc$netty$Dispatcher$$receivers() {
        return this.org$apache$spark$rpc$netty$Dispatcher$$receivers;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    public NettyRpcEndpointRef registerRpcEndpoint(String name, RpcEndpoint endpoint) {
        RpcEndpointAddress addr = new RpcEndpointAddress(this.nettyEnv.address(), name);
        NettyRpcEndpointRef endpointRef = new NettyRpcEndpointRef(this.nettyEnv.conf(), addr, this.nettyEnv);
        Dispatcher dispatcher = this;
        synchronized (dispatcher) {
            block5: {
                if (this.stopped()) {
                    throw new IllegalStateException("RpcEnv has been stopped");
                }
                if (this.endpoints().putIfAbsent(name, new EndpointData(this, name, endpoint, endpointRef)) != null) break block5;
                EndpointData data = this.endpoints().get(name);
                this.endpointRefs().put(data.endpoint(), data.ref());
                BoxesRunTime.boxToBoolean((boolean)this.org$apache$spark$rpc$netty$Dispatcher$$receivers().offer(data));
                return endpointRef;
            }
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"There is already an RpcEndpoint called ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
        }
    }

    public RpcEndpointRef getRpcEndpointRef(RpcEndpoint endpoint) {
        return this.endpointRefs().get(endpoint);
    }

    public void removeRpcEndpointRef(RpcEndpoint endpoint) {
        this.endpointRefs().remove(endpoint);
    }

    public void org$apache$spark$rpc$netty$Dispatcher$$unregisterRpcEndpoint(String name) {
        EndpointData data = this.endpoints().remove(name);
        if (data != null) {
            data.inbox().stop();
            this.org$apache$spark$rpc$netty$Dispatcher$$receivers().offer(data);
        }
    }

    public synchronized void stop(RpcEndpointRef rpcEndpointRef) {
        if (this.stopped()) {
            return;
        }
        this.org$apache$spark$rpc$netty$Dispatcher$$unregisterRpcEndpoint(rpcEndpointRef.name());
    }

    public void postToAll(InboxMessage message) {
        for (String name : this.endpoints().keySet()) {
            this.postMessage(name, message, (Function1<Exception, BoxedUnit>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Dispatcher $outer;
                public final InboxMessage message$1;

                public final void apply(Exception e) {
                    this.$outer.logWarning((Function0<String>)new Serializable(this, e){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$postToAll$1 $outer;
                        private final Exception e$2;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Message ", " dropped. ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.message$1, this.e$2.getMessage()}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.e$2 = e$2;
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.message$1 = message$1;
                }
            });
        }
    }

    public void postRemoteMessage(RequestMessage message, RpcResponseCallback callback) {
        RemoteNettyRpcCallContext rpcCallContext = new RemoteNettyRpcCallContext(this.nettyEnv, callback, message.senderAddress());
        RpcMessage rpcMessage = new RpcMessage(message.senderAddress(), message.content(), rpcCallContext);
        this.postMessage(message.receiver().name(), rpcMessage, (Function1<Exception, BoxedUnit>)new Serializable(this, callback){
            public static final long serialVersionUID = 0L;
            private final RpcResponseCallback callback$1;

            public final void apply(Exception e) {
                this.callback$1.onFailure((Throwable)e);
            }
            {
                this.callback$1 = callback$1;
            }
        });
    }

    public void postLocalMessage(RequestMessage message, Promise<Object> p) {
        LocalNettyRpcCallContext rpcCallContext = new LocalNettyRpcCallContext(message.senderAddress(), p);
        RpcMessage rpcMessage = new RpcMessage(message.senderAddress(), message.content(), rpcCallContext);
        this.postMessage(message.receiver().name(), rpcMessage, (Function1<Exception, BoxedUnit>)new Serializable(this, p){
            public static final long serialVersionUID = 0L;
            private final Promise p$1;

            public final void apply(Exception e) {
                this.p$1.tryFailure((Throwable)e);
            }
            {
                this.p$1 = p$1;
            }
        });
    }

    public void postOneWayMessage(RequestMessage message) {
        this.postMessage(message.receiver().name(), new OneWayMessage(message.senderAddress(), message.content()), (Function1<Exception, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply(Exception e) {
                throw e;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void postMessage(String endpointName, InboxMessage message, Function1<Exception, BoxedUnit> callbackIfStopped) {
        Some some;
        Dispatcher dispatcher = this;
        synchronized (dispatcher) {
            Some some2;
            EndpointData data = this.endpoints().get(endpointName);
            if (this.stopped()) {
                some2 = new Some((Object)new RpcEnvStoppedException());
            } else if (data == null) {
                some2 = new Some((Object)new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{endpointName}))));
            } else {
                data.inbox().post(message);
                this.org$apache$spark$rpc$netty$Dispatcher$$receivers().offer(data);
                some2 = None$.MODULE$;
            }
            some = some2;
        }
        Option error2 = (Option)some;
        error2.foreach(callbackIfStopped);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() {
        Dispatcher dispatcher = this;
        synchronized (dispatcher) {
            if (this.stopped()) {
                return;
            }
            this.stopped_$eq(true);
        }
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(this.endpoints().keySet()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Dispatcher $outer;

            public final void apply(String name) {
                this.$outer.org$apache$spark$rpc$netty$Dispatcher$$unregisterRpcEndpoint(name);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.org$apache$spark$rpc$netty$Dispatcher$$receivers().offer(this.org$apache$spark$rpc$netty$Dispatcher$$PoisonPill());
        this.threadpool().shutdown();
    }

    public void awaitTermination() {
        this.threadpool().awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    public boolean verify(String name) {
        return this.endpoints().containsKey(name);
    }

    private ThreadPoolExecutor threadpool() {
        return this.threadpool;
    }

    public EndpointData org$apache$spark$rpc$netty$Dispatcher$$PoisonPill() {
        return this.org$apache$spark$rpc$netty$Dispatcher$$PoisonPill;
    }

    /*
     * WARNING - void declaration
     */
    public Dispatcher(NettyRpcEnv nettyEnv) {
        void var3_3;
        this.nettyEnv = nettyEnv;
        Logging$class.$init$(this);
        this.endpoints = new ConcurrentHashMap();
        this.endpointRefs = new ConcurrentHashMap();
        this.org$apache$spark$rpc$netty$Dispatcher$$receivers = new LinkedBlockingQueue();
        this.stopped = false;
        int numThreads = nettyEnv.conf().getInt("spark.rpc.netty.dispatcher.numThreads", package$.MODULE$.max(2, Runtime.getRuntime().availableProcessors()));
        ThreadPoolExecutor pool = ThreadUtils$.MODULE$.newDaemonFixedThreadPool(numThreads, "dispatcher-event-loop");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numThreads).foreach$mVc$sp((Function1)new Serializable(this, pool){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Dispatcher $outer;
            private final ThreadPoolExecutor pool$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.pool$1.execute(this.$outer.new MessageLoop());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.pool$1 = pool$1;
            }
        });
        this.threadpool = var3_3;
        this.org$apache$spark$rpc$netty$Dispatcher$$PoisonPill = new EndpointData(this, null, null, null);
    }

    public class MessageLoop
    implements Runnable {
        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (true) {
                    EndpointData data;
                    block7: {
                        try {
                            EndpointData endpointData = data = this.org$apache$spark$rpc$netty$Dispatcher$MessageLoop$$$outer().org$apache$spark$rpc$netty$Dispatcher$$receivers().take();
                            EndpointData endpointData2 = this.org$apache$spark$rpc$netty$Dispatcher$MessageLoop$$$outer().org$apache$spark$rpc$netty$Dispatcher$$PoisonPill();
                            if (endpointData != null ? !endpointData.equals(endpointData2) : endpointData2 != null) break block7;
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = throwable;
                            Option option = NonFatal$.MODULE$.unapply(throwable2);
                            if (option.isEmpty()) {
                                throw throwable;
                            }
                            Throwable e = (Throwable)option.get();
                            this.org$apache$spark$rpc$netty$Dispatcher$MessageLoop$$$outer().logError((Function0<String>)new Serializable(this, e){
                                public static final long serialVersionUID = 0L;
                                private final Throwable e$1;

                                public final String apply() {
                                    return this.e$1.getMessage();
                                }
                                {
                                    this.e$1 = e$1;
                                }
                            }, e);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        this.org$apache$spark$rpc$netty$Dispatcher$MessageLoop$$$outer().org$apache$spark$rpc$netty$Dispatcher$$receivers().offer(this.org$apache$spark$rpc$netty$Dispatcher$MessageLoop$$$outer().org$apache$spark$rpc$netty$Dispatcher$$PoisonPill());
                        return;
                    }
                    data.inbox().process(this.org$apache$spark$rpc$netty$Dispatcher$MessageLoop$$$outer());
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        public /* synthetic */ Dispatcher org$apache$spark$rpc$netty$Dispatcher$MessageLoop$$$outer() {
            return Dispatcher.this;
        }

        public MessageLoop() {
            if (Dispatcher.this == null) {
                throw null;
            }
        }
    }

    public class EndpointData {
        private final String name;
        private final RpcEndpoint endpoint;
        private final NettyRpcEndpointRef ref;
        private final Inbox inbox;
        public final /* synthetic */ Dispatcher $outer;

        public String name() {
            return this.name;
        }

        public RpcEndpoint endpoint() {
            return this.endpoint;
        }

        public NettyRpcEndpointRef ref() {
            return this.ref;
        }

        public Inbox inbox() {
            return this.inbox;
        }

        public /* synthetic */ Dispatcher org$apache$spark$rpc$netty$Dispatcher$EndpointData$$$outer() {
            return this.$outer;
        }

        public EndpointData(Dispatcher $outer, String name, RpcEndpoint endpoint, NettyRpcEndpointRef ref) {
            this.name = name;
            this.endpoint = endpoint;
            this.ref = ref;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.inbox = new Inbox(ref, endpoint);
        }
    }
}

