/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.executor;

import java.nio.ByteBuffer;
import org.apache.mesos.ExecutorDriver;
import org.apache.mesos.Protos;
import org.apache.mesos.protobuf.ByteString;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskState$;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.executor.Executor;
import org.apache.spark.executor.Executor$;
import org.apache.spark.executor.ExecutorBackend;
import org.apache.spark.executor.MesosExecutorBackend$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.apache.spark.scheduler.cluster.mesos.MesosTaskLaunchData;
import org.apache.spark.scheduler.cluster.mesos.MesosTaskLaunchData$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Me!B\u0001\u0003\u0001\u0011Q!\u0001F'fg>\u001cX\t_3dkR|'OQ1dW\u0016tGM\u0003\u0002\u0004\t\u0005AQ\r_3dkR|'O\u0003\u0002\u0006\r\u0005)1\u000f]1sW*\u0011q\u0001C\u0001\u0007CB\f7\r[3\u000b\u0003%\t1a\u001c:h'\u0015\u00011bE\r\u001e!\ta\u0011#D\u0001\u000e\u0015\tqq\"\u0001\u0003mC:<'\"\u0001\t\u0002\t)\fg/Y\u0005\u0003%5\u0011aa\u00142kK\u000e$\bC\u0001\u000b\u0018\u001b\u0005)\"B\u0001\f\u0007\u0003\u0015iWm]8t\u0013\tARC\u0001\u0005Fq\u0016\u001cW\u000f^8s!\tQ2$D\u0001\u0003\u0013\ta\"AA\bFq\u0016\u001cW\u000f^8s\u0005\u0006\u001c7.\u001a8e!\tq\u0012%D\u0001 \u0015\t\u0001C!\u0001\u0005j]R,'O\\1m\u0013\t\u0011sDA\u0004M_\u001e<\u0017N\\4\t\u000b\u0011\u0002A\u0011\u0001\u0014\u0002\rqJg.\u001b;?\u0007\u0001!\u0012a\n\t\u00035\u0001Aqa\u0001\u0001A\u0002\u0013\u0005\u0011&F\u0001+!\tQ2&\u0003\u0002\u0019\u0005!9Q\u0006\u0001a\u0001\n\u0003q\u0013\u0001D3yK\u000e,Ho\u001c:`I\u0015\fHCA\u00186!\t\u00014'D\u00012\u0015\u0005\u0011\u0014!B:dC2\f\u0017B\u0001\u001b2\u0005\u0011)f.\u001b;\t\u000fYb\u0013\u0011!a\u0001U\u0005\u0019\u0001\u0010J\u0019\t\ra\u0002\u0001\u0015)\u0003+\u0003%)\u00070Z2vi>\u0014\b\u0005C\u0004;\u0001\u0001\u0007I\u0011A\u001e\u0002\r\u0011\u0014\u0018N^3s+\u0005a\u0004C\u0001\u000b>\u0013\tqTC\u0001\bFq\u0016\u001cW\u000f^8s\tJLg/\u001a:\t\u000f\u0001\u0003\u0001\u0019!C\u0001\u0003\u0006QAM]5wKJ|F%Z9\u0015\u0005=\u0012\u0005b\u0002\u001c@\u0003\u0003\u0005\r\u0001\u0010\u0005\u0007\t\u0002\u0001\u000b\u0015\u0002\u001f\u0002\u000f\u0011\u0014\u0018N^3sA!)a\t\u0001C!\u000f\u0006a1\u000f^1ukN,\u0006\u000fZ1uKR!q\u0006S'`\u0011\u0015IU\t1\u0001K\u0003\u0019!\u0018m]6JIB\u0011\u0001gS\u0005\u0003\u0019F\u0012A\u0001T8oO\")a*\u0012a\u0001\u001f\u0006)1\u000f^1uKB\u0011\u0001\u000b\u0018\b\u0003#js!AU-\u000f\u0005MCfB\u0001+X\u001b\u0005)&B\u0001,&\u0003\u0019a$o\\8u}%\t\u0011\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u00037\u0012\t\u0011\u0002V1tWN#\u0018\r^3\n\u0005us&!\u0003+bg.\u001cF/\u0019;f\u0015\tYF\u0001C\u0003a\u000b\u0002\u0007\u0011-\u0001\u0003eCR\f\u0007C\u00012f\u001b\u0005\u0019'B\u00013\u0010\u0003\rq\u0017n\\\u0005\u0003M\u000e\u0014!BQ=uK\n+hMZ3s\u0011\u0015A\u0007\u0001\"\u0011j\u0003)\u0011XmZ5ti\u0016\u0014X\r\u001a\u000b\u0006_)\\go\u001f\u0005\u0006u\u001d\u0004\r\u0001\u0010\u0005\u0006Y\u001e\u0004\r!\\\u0001\rKb,7-\u001e;pe&sgm\u001c\t\u0003]Nt!a\\9\u000f\u0005I\u0003\u0018B\u0001\f\u0007\u0013\t\u0011X#\u0001\u0004Qe>$xn]\u0005\u0003iV\u0014A\"\u0012=fGV$xN]%oM>T!A]\u000b\t\u000b]<\u0007\u0019\u0001=\u0002\u001b\u0019\u0014\u0018-\\3x_J\\\u0017J\u001c4p!\tq\u00170\u0003\u0002{k\niaI]1nK^|'o[%oM>DQ\u0001`4A\u0002u\f\u0011b\u001d7bm\u0016LeNZ8\u0011\u00059t\u0018BA@v\u0005%\u0019F.\u0019<f\u0013:4w\u000eC\u0004\u0002\u0004\u0001!\t%!\u0002\u0002\u00151\fWO\\2i)\u0006\u001c8\u000eF\u00030\u0003\u000f\tY\u0001C\u0004\u0002\n\u0005\u0005\u0001\u0019\u0001\u001f\u0002\u0003\u0011D\u0001\"!\u0004\u0002\u0002\u0001\u0007\u0011qB\u0001\ti\u0006\u001c8.\u00138g_B\u0019a.!\u0005\n\u0007\u0005MQO\u0001\u0005UCN\\\u0017J\u001c4p\u0011\u001d\t9\u0002\u0001C!\u00033\tQ!\u001a:s_J$RaLA\u000e\u0003;Aq!!\u0003\u0002\u0016\u0001\u0007A\b\u0003\u0005\u0002 \u0005U\u0001\u0019AA\u0011\u0003\u001diWm]:bO\u0016\u0004B!a\t\u0002*9\u0019\u0001'!\n\n\u0007\u0005\u001d\u0012'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003W\tiC\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003O\t\u0004bBA\u0019\u0001\u0011\u0005\u00131G\u0001\tW&dG\u000eV1tWR)q&!\u000e\u00028!9\u0011\u0011BA\u0018\u0001\u0004a\u0004\u0002CA\u001d\u0003_\u0001\r!a\u000f\u0002\u0003Q\u00042A\\A\u001f\u0013\r\ty$\u001e\u0002\u0007)\u0006\u001c8.\u0013#\t\u000f\u0005\r\u0003\u0001\"\u0011\u0002F\u0005a!/\u001a:fO&\u001cH/\u001a:fIR)q&a\u0012\u0002J!9\u0011\u0011BA!\u0001\u0004a\u0004bBA&\u0003\u0003\u0002\r!`\u0001\u0003aJBq!a\u0014\u0001\t\u0003\n\t&\u0001\u0007eSN\u001cwN\u001c8fGR,G\rF\u00020\u0003'Bq!!\u0003\u0002N\u0001\u0007A\bC\u0004\u0002X\u0001!\t%!\u0017\u0002!\u0019\u0014\u0018-\\3x_J\\W*Z:tC\u001e,G#B\u0018\u0002\\\u0005u\u0003bBA\u0005\u0003+\u0002\r\u0001\u0010\u0005\bA\u0006U\u0003\u0019AA0!\u0015\u0001\u0014\u0011MA3\u0013\r\t\u0019'\r\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004a\u0005\u001d\u0014bAA5c\t!!)\u001f;f\u0011\u001d\ti\u0007\u0001C!\u0003_\n\u0001b\u001d5vi\u0012|wO\u001c\u000b\u0004_\u0005E\u0004bBA\u0005\u0003W\u0002\r\u0001P\u0004\t\u0003k\u0012\u0001\u0012\u0001\u0003\u0002x\u0005!R*Z:pg\u0016CXmY;u_J\u0014\u0015mY6f]\u0012\u00042AGA=\r\u001d\t!\u0001#\u0001\u0005\u0003w\u001aR!!\u001f\u0002~u\u00012\u0001MA@\u0013\r\t\t)\r\u0002\u0007\u0003:L(+\u001a4\t\u000f\u0011\nI\b\"\u0001\u0002\u0006R\u0011\u0011q\u000f\u0005\t\u0003\u0013\u000bI\b\"\u0001\u0002\f\u0006!Q.Y5o)\ry\u0013Q\u0012\u0005\t\u0003\u001f\u000b9\t1\u0001\u0002\u0012\u0006!\u0011M]4t!\u0015\u0001\u0014\u0011MA\u0011\u0001")
public class MesosExecutorBackend
implements org.apache.mesos.Executor,
ExecutorBackend,
Logging {
    private Executor executor;
    private ExecutorDriver driver;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static void main(String[] stringArray) {
        MesosExecutorBackend$.MODULE$.main(stringArray);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    public Executor executor() {
        return this.executor;
    }

    public void executor_$eq(Executor x$1) {
        this.executor = x$1;
    }

    public ExecutorDriver driver() {
        return this.driver;
    }

    public void driver_$eq(ExecutorDriver x$1) {
        this.driver = x$1;
    }

    @Override
    public void statusUpdate(long taskId, Enumeration.Value state, ByteBuffer data) {
        Protos.TaskID mesosTaskId = Protos.TaskID.newBuilder().setValue(((Object)BoxesRunTime.boxToLong((long)taskId)).toString()).build();
        this.driver().sendStatusUpdate(Protos.TaskStatus.newBuilder().setTaskId(mesosTaskId).setState(TaskState$.MODULE$.toMesos(state)).setData(ByteString.copyFrom((ByteBuffer)data)).build());
    }

    public void registered(ExecutorDriver driver, Protos.ExecutorInfo executorInfo, Protos.FrameworkInfo frameworkInfo, Protos.SlaveInfo slaveInfo) {
        int cpusPerTask = BoxesRunTime.unboxToInt((Object)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(executorInfo.getResourcesList()).asScala()).find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Protos.Resource x$1) {
                String string = x$1.getName();
                String string2 = "cpus";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Protos.Resource x$2) {
                return (int)x$2.getScalar().getValue();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 0;
            }
        }));
        String executorId = executorInfo.getExecutorId().getValue();
        this.logInfo((Function0<String>)new Serializable(this, cpusPerTask, executorId){
            public static final long serialVersionUID = 0L;
            private final int cpusPerTask$1;
            private final String executorId$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Registered with Mesos as executor ID ", " with ", " cpus"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.executorId$1, BoxesRunTime.boxToInteger((int)this.cpusPerTask$1)}));
            }
            {
                this.cpusPerTask$1 = cpusPerTask$1;
                this.executorId$1 = executorId$1;
            }
        });
        this.driver_$eq(driver);
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        Tuple2[] properties = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])Utils$.MODULE$.deserialize(executorInfo.getData().toByteArray())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"spark.app.id", (Object)frameworkInfo.getId().getValue())})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        SparkConf conf = new SparkConf(true).setAll((Traversable<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])properties));
        int port = conf.getInt("spark.executor.port", 0);
        SparkEnv env = SparkEnv$.MODULE$.createExecutorEnv(conf, executorId, slaveInfo.getHostname(), port, cpusPerTask, false);
        this.executor_$eq(new Executor(executorId, slaveInfo.getHostname(), env, Executor$.MODULE$.$lessinit$greater$default$4(), Executor$.MODULE$.$lessinit$greater$default$5()));
    }

    public void launchTask(ExecutorDriver d, Protos.TaskInfo taskInfo) {
        long taskId = new StringOps(Predef$.MODULE$.augmentString(taskInfo.getTaskId().getValue())).toLong();
        MesosTaskLaunchData taskData = MesosTaskLaunchData$.MODULE$.fromByteString(taskInfo.getData());
        if (this.executor() == null) {
            this.logError((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Received launchTask but executor was null";
                }
            });
        } else {
            SparkHadoopUtil$.MODULE$.get().runAsSparkUser((Function0<BoxedUnit>)new Serializable(this, taskInfo, taskId, taskData){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ MesosExecutorBackend $outer;
                private final Protos.TaskInfo taskInfo$1;
                private final long taskId$1;
                private final MesosTaskLaunchData taskData$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.executor().launchTask(this.$outer, this.taskId$1, this.taskData$1.attemptNumber(), this.taskInfo$1.getName(), this.taskData$1.serializedTask());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.taskInfo$1 = taskInfo$1;
                    this.taskId$1 = taskId$1;
                    this.taskData$1 = taskData$1;
                }
            });
        }
    }

    public void error(ExecutorDriver d, String message) {
        this.logError((Function0<String>)new Serializable(this, message){
            public static final long serialVersionUID = 0L;
            private final String message$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Error from Mesos: ").append((Object)this.message$1).toString();
            }
            {
                this.message$1 = message$1;
            }
        });
    }

    public void killTask(ExecutorDriver d, Protos.TaskID t) {
        if (this.executor() == null) {
            this.logError((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Received KillTask but executor was null";
                }
            });
        } else {
            this.executor().killTask(new StringOps(Predef$.MODULE$.augmentString(t.getValue())).toLong(), false);
        }
    }

    public void reregistered(ExecutorDriver d, Protos.SlaveInfo p2) {
    }

    public void disconnected(ExecutorDriver d) {
    }

    public void frameworkMessage(ExecutorDriver d, byte[] data) {
    }

    public void shutdown(ExecutorDriver d) {
    }

    public MesosExecutorBackend() {
        Logging$class.$init$(this);
        this.executor = null;
        this.driver = null;
    }
}

