/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidReadTxnList;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponseElement;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.txn.CompactionInfo;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorThread;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cleaner
extends CompactorThread {
    private static final String CLASS_NAME = Cleaner.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger(CLASS_NAME);
    private long cleanerCheckInterval = 0L;
    private Map<Long, Set<Long>> compactId2LockMap = new HashMap<Long, Set<Long>>();
    private Map<Long, CompactionInfo> compactId2CompactInfoMap = new HashMap<Long, CompactionInfo>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.cleanerCheckInterval == 0L) {
            this.cleanerCheckInterval = this.conf.getTimeVar(HiveConf.ConfVars.HIVE_COMPACTOR_CLEANER_RUN_INTERVAL, TimeUnit.MILLISECONDS);
        }
        do {
            long elapsedTime;
            boolean setLooped = !this.looped.get();
            TxnStore.MutexAPI.LockHandle handle = null;
            long startedAt = -1L;
            try {
                handle = this.txnHandler.getMutexAPI().acquireLock(TxnStore.MUTEX_KEY.Cleaner.name());
                startedAt = System.currentTimeMillis();
                List<CompactionInfo> toClean = this.txnHandler.findReadyToClean();
                HashSet<Long> currentToCleanSet = new HashSet<Long>();
                for (CompactionInfo compactionInfo : toClean) {
                    currentToCleanSet.add(compactionInfo.id);
                }
                HashSet<Long> cleanPerformedByOthers = new HashSet<Long>();
                for (long id : this.compactId2CompactInfoMap.keySet()) {
                    if (currentToCleanSet.contains(id)) continue;
                    cleanPerformedByOthers.add(id);
                }
                Iterator iterator = cleanPerformedByOthers.iterator();
                while (iterator.hasNext()) {
                    long id;
                    id = (Long)iterator.next();
                    this.compactId2CompactInfoMap.remove(id);
                    this.compactId2LockMap.remove(id);
                }
                if (toClean.size() > 0 || this.compactId2LockMap.size() > 0) {
                    ShowLocksResponse locksResponse = this.txnHandler.showLocks(new ShowLocksRequest());
                    for (CompactionInfo compactionInfo : toClean) {
                        if (this.compactId2LockMap.containsKey(compactionInfo.id)) continue;
                        this.compactId2LockMap.put(compactionInfo.id, this.findRelatedLocks(compactionInfo, locksResponse));
                        this.compactId2CompactInfoMap.put(compactionInfo.id, compactionInfo);
                    }
                    Set<Long> currentLocks = this.buildCurrentLockSet(locksResponse);
                    ArrayList<Long> arrayList = new ArrayList<Long>();
                    ArrayList<Long> compactionsCleaned = new ArrayList<Long>();
                    try {
                        for (Map.Entry<Long, Set<Long>> queueEntry : this.compactId2LockMap.entrySet()) {
                            boolean sawLock = false;
                            for (Long lockId : queueEntry.getValue()) {
                                if (currentLocks.contains(lockId)) {
                                    sawLock = true;
                                    break;
                                }
                                arrayList.add(lockId);
                            }
                            if (!sawLock) {
                                compactionsCleaned.add(queueEntry.getKey());
                                this.clean(this.compactId2CompactInfoMap.get(queueEntry.getKey()));
                                continue;
                            }
                            for (Long lockId : arrayList) {
                                queueEntry.getValue().remove(lockId);
                            }
                        }
                    }
                    finally {
                        if (compactionsCleaned.size() > 0) {
                            for (Long compactId : compactionsCleaned) {
                                this.compactId2LockMap.remove(compactId);
                                this.compactId2CompactInfoMap.remove(compactId);
                            }
                        }
                    }
                }
            }
            catch (Throwable t) {
                LOG.error("Caught an exception in the main loop of compactor cleaner, " + StringUtils.stringifyException((Throwable)t));
            }
            finally {
                if (handle != null) {
                    handle.releaseLocks();
                }
            }
            if (setLooped) {
                this.looped.set(true);
            }
            if ((elapsedTime = System.currentTimeMillis() - startedAt) >= this.cleanerCheckInterval || this.stop.get()) continue;
            try {
                Thread.sleep(this.cleanerCheckInterval - elapsedTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!this.stop.get());
    }

    private Set<Long> findRelatedLocks(CompactionInfo ci, ShowLocksResponse locksResponse) {
        HashSet<Long> relatedLocks = new HashSet<Long>();
        for (ShowLocksResponseElement lock2 : locksResponse.getLocks()) {
            if (!ci.dbname.equals(lock2.getDbname()) || (ci.tableName != null || lock2.getTablename() != null) && (ci.tableName == null || !ci.tableName.equals(lock2.getTablename())) || (ci.partName != null || lock2.getPartname() != null) && (ci.partName == null || !ci.partName.equals(lock2.getPartname()))) continue;
            relatedLocks.add(lock2.getLockid());
        }
        return relatedLocks;
    }

    private Set<Long> buildCurrentLockSet(ShowLocksResponse locksResponse) {
        HashSet<Long> currentLocks = new HashSet<Long>(locksResponse.getLocks().size());
        for (ShowLocksResponseElement lock2 : locksResponse.getLocks()) {
            currentLocks.add(lock2.getLockid());
        }
        return currentLocks;
    }

    private void clean(CompactionInfo ci) throws MetaException {
        LOG.info("Starting cleaning for " + ci.getFullPartitionName());
        try {
            ValidReadTxnList txnList;
            Table t = this.resolveTable(ci);
            if (t == null) {
                LOG.info("Unable to find table " + ci.getFullTableName() + ", assuming it was dropped");
                this.txnHandler.markCleaned(ci);
                return;
            }
            Partition p = null;
            if (ci.partName != null && (p = this.resolvePartition(ci)) == null) {
                LOG.info("Unable to find partition " + ci.getFullPartitionName() + ", assuming it was dropped");
                this.txnHandler.markCleaned(ci);
                return;
            }
            StorageDescriptor sd = this.resolveStorageDescriptor(t, p);
            final String location = sd.getLocation();
            ValidReadTxnList validReadTxnList = txnList = ci.highestTxnId > 0L ? new ValidReadTxnList(new long[0], ci.highestTxnId) : new ValidReadTxnList();
            if (this.runJobAsSelf(ci.runAs)) {
                this.removeFiles(location, txnList);
            } else {
                LOG.info("Cleaning as user " + ci.runAs + " for " + ci.getFullPartitionName());
                UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)ci.runAs, (UserGroupInformation)UserGroupInformation.getLoginUser());
                ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        Cleaner.this.removeFiles(location, txnList);
                        return null;
                    }
                });
                try {
                    FileSystem.closeAllForUGI((UserGroupInformation)ugi);
                }
                catch (IOException exception) {
                    LOG.error("Could not clean up file-system handles for UGI: " + ugi + " for " + ci.getFullPartitionName(), exception);
                }
            }
            this.txnHandler.markCleaned(ci);
        }
        catch (Exception e) {
            LOG.error("Caught exception when cleaning, unable to complete cleaning of " + ci + " " + StringUtils.stringifyException((Throwable)e));
            this.txnHandler.markFailed(ci);
        }
    }

    private void removeFiles(String location, ValidTxnList txnList) throws IOException {
        AcidUtils.Directory dir = AcidUtils.getAcidState(new Path(location), this.conf, txnList);
        List<FileStatus> obsoleteDirs = dir.getObsolete();
        ArrayList<Path> filesToDelete = new ArrayList<Path>(obsoleteDirs.size());
        for (FileStatus stat : obsoleteDirs) {
            filesToDelete.add(stat.getPath());
        }
        if (filesToDelete.size() < 1) {
            LOG.warn("Hmm, nothing to delete in the cleaner for directory " + location + ", that hardly seems right.");
            return;
        }
        LOG.info("About to remove " + filesToDelete.size() + " obsolete directories from " + location);
        FileSystem fs = ((Path)filesToDelete.get(0)).getFileSystem((Configuration)this.conf);
        for (Path dead : filesToDelete) {
            LOG.debug("Going to delete path " + dead.toString());
            fs.delete(dead, true);
        }
    }
}

