/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ppd;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Stack;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.TypeRule;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeFieldDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.ppd.ExprWalkerInfo;
import org.apache.hadoop.hive.ql.ppd.OpWalkerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExprWalkerProcFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ExprWalkerProcFactory.class.getName());

    public static NodeProcessor getDefaultExprProcessor() {
        return new DefaultExprProcessor();
    }

    public static NodeProcessor getGenericFuncProcessor() {
        return new GenericFuncExprProcessor();
    }

    public static NodeProcessor getColumnProcessor() {
        return new ColumnExprProcessor();
    }

    private static NodeProcessor getFieldProcessor() {
        return new FieldExprProcessor();
    }

    public static ExprWalkerInfo extractPushdownPreds(OpWalkerInfo opContext, Operator<? extends OperatorDesc> op, ExprNodeDesc pred) throws SemanticException {
        ArrayList<ExprNodeDesc> preds = new ArrayList<ExprNodeDesc>();
        preds.add(pred);
        return ExprWalkerProcFactory.extractPushdownPreds(opContext, op, preds);
    }

    public static ExprWalkerInfo extractPushdownPreds(OpWalkerInfo opContext, Operator<? extends OperatorDesc> op, List<ExprNodeDesc> preds) throws SemanticException {
        ExprWalkerInfo exprContext = new ExprWalkerInfo(op);
        LinkedHashMap<Rule, NodeProcessor> exprRules = new LinkedHashMap<Rule, NodeProcessor>();
        exprRules.put(new TypeRule(ExprNodeColumnDesc.class), ExprWalkerProcFactory.getColumnProcessor());
        exprRules.put(new TypeRule(ExprNodeFieldDesc.class), ExprWalkerProcFactory.getFieldProcessor());
        exprRules.put(new TypeRule(ExprNodeGenericFuncDesc.class), ExprWalkerProcFactory.getGenericFuncProcessor());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(ExprWalkerProcFactory.getDefaultExprProcessor(), exprRules, exprContext);
        DefaultGraphWalker egw = new DefaultGraphWalker(disp);
        ArrayList<Node> startNodes = new ArrayList<Node>();
        ArrayList<ExprNodeDesc> clonedPreds = new ArrayList<ExprNodeDesc>();
        for (ExprNodeDesc node : preds) {
            ExprNodeDesc clone = node.clone();
            clonedPreds.add(clone);
            exprContext.getNewToOldExprMap().put(clone, node);
        }
        startNodes.addAll(clonedPreds);
        egw.startWalking(startNodes, null);
        HiveConf conf = opContext.getParseContext().getConf();
        for (ExprNodeDesc pred : clonedPreds) {
            ExprWalkerProcFactory.extractFinalCandidates(pred, exprContext, conf);
        }
        return exprContext;
    }

    private static void extractFinalCandidates(ExprNodeDesc expr, ExprWalkerInfo ctx, HiveConf conf) {
        if (FunctionRegistry.isOpAnd(expr)) {
            assert (ctx.getNewToOldExprMap().containsKey(expr));
            for (int i = 0; i < expr.getChildren().size(); ++i) {
                ctx.getNewToOldExprMap().put(expr.getChildren().get(i), ctx.getNewToOldExprMap().get(expr).getChildren().get(i));
                ExprWalkerProcFactory.extractFinalCandidates(expr.getChildren().get(i), ctx, conf);
            }
            return;
        }
        ExprWalkerInfo.ExprInfo exprInfo = ctx.getExprInfo(expr);
        if (exprInfo != null && exprInfo.isCandidate) {
            ExprWalkerInfo.ExprInfo convertedExprInfo;
            String alias = exprInfo.alias;
            if (alias == null && exprInfo.convertedExpr != null && (convertedExprInfo = ctx.getExprInfo(exprInfo.convertedExpr)) != null) {
                alias = convertedExprInfo.alias;
            }
            ctx.addFinalCandidate(alias, exprInfo.convertedExpr != null ? exprInfo.convertedExpr : expr);
            return;
        }
        if (!FunctionRegistry.isOpAnd(expr) && HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVEPPDREMOVEDUPLICATEFILTERS)) {
            ctx.addNonFinalCandidate(exprInfo != null ? exprInfo.alias : null, expr);
        }
    }

    private ExprWalkerProcFactory() {
    }

    public static class DefaultExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            ExprWalkerInfo ctx = (ExprWalkerInfo)procCtx;
            ExprWalkerInfo.ExprInfo exprInfo = ctx.addOrGetExprInfo((ExprNodeDesc)nd);
            exprInfo.isCandidate = true;
            return true;
        }
    }

    public static class GenericFuncExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            ExprWalkerInfo ctx = (ExprWalkerInfo)procCtx;
            String alias = null;
            ExprNodeGenericFuncDesc expr = (ExprNodeGenericFuncDesc)nd;
            if (!FunctionRegistry.isDeterministic(expr.getGenericUDF())) {
                ExprWalkerInfo.ExprInfo exprInfo = ctx.addOrGetExprInfo(expr);
                exprInfo.isCandidate = false;
                ctx.setDeterministic(false);
                return false;
            }
            boolean isCandidate = true;
            for (int i = 0; i < nd.getChildren().size(); ++i) {
                String chAlias;
                ExprNodeDesc newCh;
                ExprNodeDesc ch = (ExprNodeDesc)nd.getChildren().get(i);
                ExprWalkerInfo.ExprInfo chExprInfo = ctx.getExprInfo(ch);
                ExprNodeDesc exprNodeDesc = newCh = chExprInfo != null ? chExprInfo.convertedExpr : null;
                if (newCh != null) {
                    expr.getChildren().set(i, newCh);
                    ch = newCh;
                    chExprInfo = ctx.getExprInfo(ch);
                }
                if (chExprInfo != null) {
                    chAlias = chExprInfo.alias;
                    isCandidate = isCandidate && chExprInfo.isCandidate;
                } else {
                    chAlias = null;
                    isCandidate = false;
                }
                if (isCandidate && chAlias != null) {
                    if (alias == null) {
                        alias = chAlias;
                    } else if (!chAlias.equalsIgnoreCase(alias)) {
                        isCandidate = false;
                    }
                }
                if (!isCandidate) break;
            }
            ExprWalkerInfo.ExprInfo exprInfo = ctx.addOrGetExprInfo(expr);
            if (alias != null) {
                exprInfo.alias = alias;
            }
            exprInfo.isCandidate = isCandidate;
            return isCandidate;
        }
    }

    public static class FieldExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            boolean isCandidate;
            String chAlias;
            ExprNodeDesc newCh;
            ExprWalkerInfo ctx = (ExprWalkerInfo)procCtx;
            String alias = null;
            ExprNodeFieldDesc expr = (ExprNodeFieldDesc)nd;
            assert (nd.getChildren().size() == 1);
            ExprNodeDesc ch = (ExprNodeDesc)nd.getChildren().get(0);
            ExprWalkerInfo.ExprInfo chExprInfo = ctx.getExprInfo(ch);
            ExprNodeDesc exprNodeDesc = newCh = chExprInfo != null ? chExprInfo.convertedExpr : null;
            if (newCh != null) {
                expr.setDesc(newCh);
                ch = newCh;
                chExprInfo = ctx.getExprInfo(ch);
            }
            if (chExprInfo != null) {
                chAlias = chExprInfo.alias;
                isCandidate = chExprInfo.isCandidate;
            } else {
                chAlias = null;
                isCandidate = false;
            }
            if (isCandidate && chAlias != null) {
                alias = chAlias;
            }
            ExprWalkerInfo.ExprInfo exprInfo = ctx.addOrGetExprInfo(expr);
            if (alias != null) {
                exprInfo.alias = alias;
            }
            exprInfo.isCandidate = isCandidate;
            return isCandidate;
        }
    }

    public static class ColumnExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            ExprWalkerInfo ctx = (ExprWalkerInfo)procCtx;
            ExprNodeColumnDesc colref = (ExprNodeColumnDesc)nd;
            RowSchema toRS = ctx.getOp().getSchema();
            Operator<? extends OperatorDesc> op = ctx.getOp();
            ColumnInfo ci = toRS.getColumnInfo(colref.getColumn());
            String tabAlias = null;
            if (ci != null) {
                tabAlias = ci.getTabAlias();
            }
            ExprWalkerInfo.ExprInfo colExprInfo = null;
            boolean isCandidate = true;
            if (op.getColumnExprMap() != null) {
                GroupByOperator groupBy;
                ExprNodeDesc exp = op.getColumnExprMap().get(colref.getColumn());
                if (op instanceof GroupByOperator && ((GroupByDesc)(groupBy = (GroupByOperator)op).getConf()).isGroupingSetsPresent()) {
                    int groupingSetPlaceholderPos = ((GroupByDesc)groupBy.getConf()).getKeys().size() - 1;
                    if (colref.getColumn().equals(groupBy.getSchema().getColumnNames().get(groupingSetPlaceholderPos))) {
                        exp = null;
                    }
                }
                if (exp == null) {
                    colExprInfo = ctx.addOrGetExprInfo(colref);
                    colExprInfo.isCandidate = false;
                    return false;
                }
                if (exp instanceof ExprNodeGenericFuncDesc) {
                    isCandidate = false;
                }
                if (exp instanceof ExprNodeColumnDesc && ci == null) {
                    ExprNodeColumnDesc column = (ExprNodeColumnDesc)exp;
                    tabAlias = column.getTabAlias();
                }
                colExprInfo = ctx.addOrGetExprInfo(colref);
                colExprInfo.convertedExpr = exp;
                ExprWalkerInfo.ExprInfo expInfo = ctx.addExprInfo(exp);
                expInfo.isCandidate = isCandidate;
                expInfo.alias = tabAlias != null ? tabAlias : colExprInfo.alias;
            } else {
                if (ci == null) {
                    return false;
                }
                colExprInfo = ctx.addOrGetExprInfo(colref);
                if (tabAlias != null) {
                    colExprInfo.alias = tabAlias;
                }
            }
            colExprInfo.isCandidate = isCandidate;
            return isCandidate;
        }
    }
}

