/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql2rel;

import java.math.BigDecimal;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.function.Function2;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCostImpl;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.rel.BiRel;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttleImpl;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Correlate;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.FilterCorrelateRule;
import org.apache.calcite.rel.rules.FilterJoinRule;
import org.apache.calcite.rel.rules.FilterProjectTransposeRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlCountAggFunction;
import org.apache.calcite.sql.fun.SqlSingleValueAggFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.Bug;
import org.apache.calcite.util.Holder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.ReflectUtil;
import org.apache.calcite.util.ReflectiveVisitor;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.calcite.util.trace.CalciteTrace;
import org.apache.hive.com.google.common.base.Preconditions;
import org.apache.hive.com.google.common.base.Supplier;
import org.apache.hive.com.google.common.collect.ImmutableList;
import org.apache.hive.com.google.common.collect.ImmutableMap;
import org.apache.hive.com.google.common.collect.ImmutableSet;
import org.apache.hive.com.google.common.collect.ImmutableSortedMap;
import org.apache.hive.com.google.common.collect.Lists;
import org.apache.hive.com.google.common.collect.Maps;
import org.apache.hive.com.google.common.collect.Multimap;
import org.apache.hive.com.google.common.collect.Multimaps;
import org.apache.hive.com.google.common.collect.Sets;
import org.apache.hive.com.google.common.collect.SortedSetMultimap;
import org.slf4j.Logger;

public class RelDecorrelator
implements ReflectiveVisitor {
    private static final Logger SQL2REL_LOGGER = CalciteTrace.getSqlToRelTracer();
    private final RelBuilder relBuilder;
    private CorelMap cm;
    private final ReflectUtil.MethodDispatcher<Frame> dispatcher = ReflectUtil.createMethodDispatcher(Frame.class, this, "decorrelateRel", RelNode.class, new Class[0]);
    private final RexBuilder rexBuilder;
    private RelNode currentRel;
    private final Context context;
    private final Map<RelNode, Frame> map = new HashMap<RelNode, Frame>();
    private final HashSet<LogicalCorrelate> generatedCorRels = Sets.newHashSet();

    private RelDecorrelator(RelOptCluster cluster, CorelMap cm, Context context) {
        this.cm = cm;
        this.rexBuilder = cluster.getRexBuilder();
        this.context = context;
        this.relBuilder = RelFactories.LOGICAL_BUILDER.create(cluster, null);
    }

    public static RelNode decorrelateQuery(RelNode rootRel) {
        CorelMap corelMap = new CorelMapBuilder().build(rootRel);
        if (!corelMap.hasCorrelation()) {
            return rootRel;
        }
        RelOptCluster cluster = rootRel.getCluster();
        RelDecorrelator decorrelator = new RelDecorrelator(cluster, corelMap, cluster.getPlanner().getContext());
        RelNode newRootRel = decorrelator.removeCorrelationViaRule(rootRel);
        if (SQL2REL_LOGGER.isDebugEnabled()) {
            SQL2REL_LOGGER.debug(RelOptUtil.dumpPlan("Plan after removing Correlator", newRootRel, false, SqlExplainLevel.EXPPLAN_ATTRIBUTES));
        }
        if (!decorrelator.cm.mapCorVarToCorRel.isEmpty()) {
            newRootRel = decorrelator.decorrelate(newRootRel);
        }
        return newRootRel;
    }

    private void setCurrent(RelNode root, LogicalCorrelate corRel) {
        this.currentRel = corRel;
        if (corRel != null) {
            this.cm = new CorelMapBuilder().build(Util.first(root, corRel));
        }
    }

    private RelNode decorrelate(RelNode root) {
        HepProgram program = HepProgram.builder().addRuleInstance(new AdjustProjectForCountAggregateRule(false)).addRuleInstance(new AdjustProjectForCountAggregateRule(true)).addRuleInstance(FilterJoinRule.FILTER_ON_JOIN).addRuleInstance(FilterProjectTransposeRule.INSTANCE).addRuleInstance(FilterCorrelateRule.INSTANCE).build();
        HepPlanner planner = this.createPlanner(program);
        planner.setRoot(root);
        root = planner.findBestExp();
        this.map.clear();
        Frame frame = this.getInvoke(root, null);
        if (frame != null) {
            HepProgram program2 = HepProgram.builder().addRuleInstance(FilterJoinRule.FILTER_ON_JOIN).addRuleInstance(FilterJoinRule.JOIN).build();
            HepPlanner planner2 = this.createPlanner(program2);
            RelNode newRoot = frame.r;
            planner2.setRoot(newRoot);
            return planner2.findBestExp();
        }
        return root;
    }

    private Function2<RelNode, RelNode, Void> createCopyHook() {
        return new Function2<RelNode, RelNode, Void>(){

            @Override
            public Void apply(RelNode oldNode, RelNode newNode) {
                if (RelDecorrelator.this.cm.mapRefRelToCorVar.containsKey(oldNode)) {
                    RelDecorrelator.this.cm.mapRefRelToCorVar.putAll(newNode, RelDecorrelator.this.cm.mapRefRelToCorVar.get(oldNode));
                }
                if (oldNode instanceof LogicalCorrelate && newNode instanceof LogicalCorrelate) {
                    LogicalCorrelate oldCor = (LogicalCorrelate)oldNode;
                    CorrelationId c = oldCor.getCorrelationId();
                    if (RelDecorrelator.this.cm.mapCorVarToCorRel.get(c) == oldNode) {
                        RelDecorrelator.this.cm.mapCorVarToCorRel.put(c, newNode);
                    }
                    if (RelDecorrelator.this.generatedCorRels.contains(oldNode)) {
                        RelDecorrelator.this.generatedCorRels.add((LogicalCorrelate)newNode);
                    }
                }
                return null;
            }
        };
    }

    private HepPlanner createPlanner(HepProgram program) {
        return new HepPlanner(program, this.context, true, this.createCopyHook(), RelOptCostImpl.FACTORY);
    }

    public RelNode removeCorrelationViaRule(RelNode root) {
        HepProgram program = HepProgram.builder().addRuleInstance(new RemoveSingleAggregateRule()).addRuleInstance(new RemoveCorrelationForScalarProjectRule()).addRuleInstance(new RemoveCorrelationForScalarAggregateRule()).build();
        HepPlanner planner = this.createPlanner(program);
        planner.setRoot(root);
        return planner.findBestExp();
    }

    protected RexNode decorrelateExpr(RexNode exp) {
        DecorrelateRexShuttle shuttle = new DecorrelateRexShuttle();
        return exp.accept(shuttle);
    }

    protected RexNode removeCorrelationExpr(RexNode exp, boolean projectPulledAboveLeftCorrelator) {
        RemoveCorrelationRexShuttle shuttle = new RemoveCorrelationRexShuttle(this.rexBuilder, projectPulledAboveLeftCorrelator, null, ImmutableSet.of());
        return exp.accept(shuttle);
    }

    protected RexNode removeCorrelationExpr(RexNode exp, boolean projectPulledAboveLeftCorrelator, RexInputRef nullIndicator) {
        RemoveCorrelationRexShuttle shuttle = new RemoveCorrelationRexShuttle(this.rexBuilder, projectPulledAboveLeftCorrelator, nullIndicator, ImmutableSet.of());
        return exp.accept(shuttle);
    }

    protected RexNode removeCorrelationExpr(RexNode exp, boolean projectPulledAboveLeftCorrelator, Set<Integer> isCount) {
        RemoveCorrelationRexShuttle shuttle = new RemoveCorrelationRexShuttle(this.rexBuilder, projectPulledAboveLeftCorrelator, null, isCount);
        return exp.accept(shuttle);
    }

    public Frame decorrelateRel(RelNode rel) {
        RelNode newRel = rel.copy(rel.getTraitSet(), rel.getInputs());
        if (rel.getInputs().size() > 0) {
            List<RelNode> oldInputs = rel.getInputs();
            ArrayList<RelNode> newInputs = Lists.newArrayList();
            for (int i = 0; i < oldInputs.size(); ++i) {
                Frame frame = this.getInvoke(oldInputs.get(i), rel);
                if (frame == null || !frame.corVarOutputPos.isEmpty()) {
                    return null;
                }
                newInputs.add(frame.r);
                newRel.replaceInput(i, frame.r);
            }
            if (!Util.equalShallow(oldInputs, newInputs)) {
                newRel = rel.copy(rel.getTraitSet(), newInputs);
            }
        }
        return this.register(rel, newRel, RelDecorrelator.identityMap(rel.getRowType().getFieldCount()), ImmutableSortedMap.of());
    }

    public Frame decorrelateRel(Sort rel) {
        assert (!this.cm.mapRefRelToCorVar.containsKey(rel));
        RelNode oldInput = rel.getInput();
        Frame frame = this.getInvoke(oldInput, rel);
        if (frame == null) {
            return null;
        }
        RelNode newInput = frame.r;
        Mappings.TargetMapping mapping = Mappings.target(frame.oldToNewOutputPos, oldInput.getRowType().getFieldCount(), newInput.getRowType().getFieldCount());
        RelCollation oldCollation = rel.getCollation();
        RelCollation newCollation = RexUtil.apply(mapping, oldCollation);
        LogicalSort newSort = LogicalSort.create(newInput, newCollation, rel.offset, rel.fetch);
        return this.register(rel, newSort, frame.oldToNewOutputPos, frame.corVarOutputPos);
    }

    public Frame decorrelateRel(Values rel) {
        return null;
    }

    public Frame decorrelateRel(LogicalAggregate rel) {
        if (rel.getGroupType() != Aggregate.Group.SIMPLE) {
            throw new AssertionError(false);
        }
        assert (!this.cm.mapRefRelToCorVar.containsKey(rel));
        RelNode oldInput = rel.getInput();
        Frame frame = this.getInvoke(oldInput, rel);
        if (frame == null) {
            return null;
        }
        assert (!frame.corVarOutputPos.isEmpty());
        RelNode newInput = frame.r;
        HashMap mapNewInputToProjOutputPos = Maps.newHashMap();
        int oldGroupKeyCount = rel.getGroupSet().cardinality();
        ArrayList<Pair<RexNode, String>> projects = Lists.newArrayList();
        List<RelDataTypeField> newInputOutput = newInput.getRowType().getFieldList();
        int newPos = 0;
        TreeMap<Integer, RexLiteral> omittedConstants = new TreeMap<Integer, RexLiteral>();
        for (int i = 0; i < oldGroupKeyCount; ++i) {
            RexLiteral constant = RelDecorrelator.projectedLiteral(newInput, i);
            if (constant != null) {
                omittedConstants.put(i, constant);
                continue;
            }
            int newInputPos = frame.oldToNewOutputPos.get(i);
            projects.add(RexInputRef.of2(newInputPos, newInputOutput));
            mapNewInputToProjOutputPos.put(newInputPos, newPos);
            ++newPos;
        }
        TreeMap<Correlation, Integer> mapCorVarToOutputPos = new TreeMap<Correlation, Integer>();
        if (!frame.corVarOutputPos.isEmpty()) {
            for (Map.Entry entry : frame.corVarOutputPos.entrySet()) {
                projects.add(RexInputRef.of2((Integer)entry.getValue(), newInputOutput));
                mapCorVarToOutputPos.put((Correlation)entry.getKey(), newPos);
                mapNewInputToProjOutputPos.put(entry.getValue(), newPos);
                ++newPos;
            }
        }
        int newGroupKeyCount = newPos;
        for (int i = 0; i < newInputOutput.size(); ++i) {
            if (mapNewInputToProjOutputPos.containsKey(i)) continue;
            projects.add(RexInputRef.of2(i, newInputOutput));
            mapNewInputToProjOutputPos.put(i, newPos);
            ++newPos;
        }
        assert (newPos == newInputOutput.size());
        RelNode newProject = RelOptUtil.createProject(newInput, projects, false);
        HashMap<Integer, Integer> combinedMap = Maps.newHashMap();
        for (Integer oldInputPos : frame.oldToNewOutputPos.keySet()) {
            combinedMap.put(oldInputPos, (Integer)mapNewInputToProjOutputPos.get(frame.oldToNewOutputPos.get(oldInputPos)));
        }
        this.register(oldInput, newProject, combinedMap, mapCorVarToOutputPos);
        ImmutableBitSet newGroupSet = ImmutableBitSet.range(newGroupKeyCount);
        ArrayList<AggregateCall> newAggCalls = Lists.newArrayList();
        List<AggregateCall> oldAggCalls = rel.getAggCallList();
        int oldInputOutputFieldCount = rel.getGroupSet().cardinality();
        int newInputOutputFieldCount = newGroupSet.cardinality();
        int i = -1;
        for (AggregateCall oldAggCall : oldAggCalls) {
            ++i;
            List<Integer> oldAggArgs = oldAggCall.getArgList();
            ArrayList<Integer> aggArgs = Lists.newArrayList();
            for (int oldPos : oldAggArgs) {
                aggArgs.add((Integer)combinedMap.get(oldPos));
            }
            int filterArg = oldAggCall.filterArg < 0 ? oldAggCall.filterArg : (Integer)combinedMap.get(oldAggCall.filterArg);
            newAggCalls.add(oldAggCall.adaptTo(newProject, aggArgs, filterArg, oldGroupKeyCount, newGroupKeyCount));
            combinedMap.put(oldInputOutputFieldCount + i, newInputOutputFieldCount + i);
        }
        this.relBuilder.push(LogicalAggregate.create(newProject, false, newGroupSet, null, newAggCalls));
        if (!omittedConstants.isEmpty()) {
            ArrayList<RexNode> postProjects = new ArrayList<RexNode>(this.relBuilder.fields());
            for (Map.Entry entry : omittedConstants.descendingMap().entrySet()) {
                postProjects.add((Integer)entry.getKey() + frame.corVarOutputPos.size(), (RexNode)entry.getValue());
            }
            this.relBuilder.project(postProjects);
        }
        return this.register(rel, this.relBuilder.build(), combinedMap, mapCorVarToOutputPos);
    }

    public Frame getInvoke(RelNode r, RelNode parent) {
        Frame frame = this.dispatcher.invoke(r);
        if (frame != null) {
            this.map.put(r, frame);
        }
        this.currentRel = parent;
        return frame;
    }

    private static RexLiteral projectedLiteral(RelNode rel, int i) {
        Project project;
        RexNode node;
        if (rel instanceof Project && (node = (project = (Project)rel).getProjects().get(i)) instanceof RexLiteral) {
            return (RexLiteral)node;
        }
        return null;
    }

    public Frame decorrelateRel(LogicalProject rel) {
        int newPos;
        RelNode oldInput = rel.getInput();
        Frame frame = this.getInvoke(oldInput, rel);
        if (frame == null) {
            return null;
        }
        List<RexNode> oldProjects = rel.getProjects();
        List<RelDataTypeField> relOutput = rel.getRowType().getFieldList();
        ArrayList<Pair<RexNode, String>> projects = Lists.newArrayList();
        if (this.cm.mapRefRelToCorVar.containsKey(rel)) {
            this.decorrelateInputWithValueGenerator(rel);
            frame = this.map.get(oldInput);
        }
        HashMap<Integer, Integer> mapOldToNewOutputPos = Maps.newHashMap();
        for (newPos = 0; newPos < oldProjects.size(); ++newPos) {
            projects.add(newPos, Pair.of(this.decorrelateExpr(oldProjects.get(newPos)), relOutput.get(newPos).getName()));
            mapOldToNewOutputPos.put(newPos, newPos);
        }
        TreeMap<Correlation, Integer> mapCorVarToOutputPos = new TreeMap<Correlation, Integer>();
        for (Map.Entry entry : frame.corVarOutputPos.entrySet()) {
            projects.add(RexInputRef.of2((Integer)entry.getValue(), frame.r.getRowType().getFieldList()));
            mapCorVarToOutputPos.put((Correlation)entry.getKey(), newPos);
            ++newPos;
        }
        RelNode newProject = RelOptUtil.createProject(frame.r, projects, false);
        return this.register(rel, newProject, mapOldToNewOutputPos, mapCorVarToOutputPos);
    }

    private RelNode createValueGenerator(Iterable<Correlation> correlations, int valueGenFieldOffset, SortedMap<Correlation, Integer> mapCorVarToOutputPos) {
        RelNode oldInput;
        HashMap<RelNode, List<Integer>> mapNewInputToOutputPos = new HashMap<RelNode, List<Integer>>();
        HashMap<RelNode, Integer> mapNewInputToNewOffset = new HashMap<RelNode, Integer>();
        for (Correlation corVar : correlations) {
            int newCorVarOffset;
            int oldCorVarOffset = corVar.field;
            RelNode oldInput2 = this.getCorRel(corVar);
            assert (oldInput2 != null);
            Frame frame = this.map.get(oldInput2);
            assert (frame != null);
            RelNode newInput = frame.r;
            List newLocalOutputPosList = !mapNewInputToOutputPos.containsKey(newInput) ? Lists.newArrayList() : (List)mapNewInputToOutputPos.get(newInput);
            if (!newLocalOutputPosList.contains(newCorVarOffset = frame.oldToNewOutputPos.get(oldCorVarOffset).intValue())) {
                newLocalOutputPosList.add(newCorVarOffset);
            }
            mapNewInputToOutputPos.put(newInput, newLocalOutputPosList);
        }
        int offset = 0;
        HashSet<RelNode> joinedInputRelSet = Sets.newHashSet();
        RelNode r = null;
        for (Correlation corVar : correlations) {
            oldInput = this.getCorRel(corVar);
            assert (oldInput != null);
            RelNode newInput = this.map.get((Object)oldInput).r;
            assert (newInput != null);
            if (joinedInputRelSet.contains(newInput)) continue;
            RelNode project = RelOptUtil.createProject(newInput, (List)mapNewInputToOutputPos.get(newInput));
            RelNode distinct = RelOptUtil.createDistinctRel(project);
            RelOptCluster cluster = distinct.getCluster();
            joinedInputRelSet.add(newInput);
            mapNewInputToNewOffset.put(newInput, offset);
            offset += distinct.getRowType().getFieldCount();
            if (r == null) {
                r = distinct;
                continue;
            }
            r = LogicalJoin.create(r, distinct, (RexNode)cluster.getRexBuilder().makeLiteral(true), ImmutableSet.of(), JoinRelType.INNER);
        }
        for (Correlation corVar : correlations) {
            oldInput = this.getCorRel(corVar);
            assert (oldInput != null);
            Frame frame = this.map.get(oldInput);
            RelNode newInput = frame.r;
            assert (newInput != null);
            List newLocalOutputPosList = (List)mapNewInputToOutputPos.get(newInput);
            int newLocalOutputPos = frame.oldToNewOutputPos.get(corVar.field);
            int newOutputPos = newLocalOutputPosList.indexOf(newLocalOutputPos) + (Integer)mapNewInputToNewOffset.get(newInput) + valueGenFieldOffset;
            if (mapCorVarToOutputPos.containsKey(corVar)) assert ((Integer)mapCorVarToOutputPos.get(corVar) == newOutputPos);
            mapCorVarToOutputPos.put(corVar, newOutputPos);
        }
        return r;
    }

    private RelNode getCorRel(Correlation corVar) {
        RelNode r = (RelNode)this.cm.mapCorVarToCorRel.get(corVar.corr);
        return r.getInput(0);
    }

    private void decorrelateInputWithValueGenerator(RelNode rel) {
        assert (rel.getInputs().size() == 1);
        RelNode oldInput = rel.getInput(0);
        Frame frame = this.map.get(oldInput);
        TreeMap<Correlation, Integer> mapCorVarToOutputPos = new TreeMap<Correlation, Integer>((SortedMap<Correlation, Integer>)frame.corVarOutputPos);
        Collection<Correlation> corVarList = this.cm.mapRefRelToCorVar.get(rel);
        int leftInputOutputCount = frame.r.getRowType().getFieldCount();
        RelNode valueGen = this.createValueGenerator(corVarList, leftInputOutputCount, mapCorVarToOutputPos);
        LogicalJoin join = LogicalJoin.create(frame.r, valueGen, (RexNode)this.rexBuilder.makeLiteral(true), ImmutableSet.of(), JoinRelType.INNER);
        this.register(oldInput, join, frame.oldToNewOutputPos, mapCorVarToOutputPos);
    }

    public Frame decorrelateRel(LogicalFilter rel) {
        RelNode oldInput = rel.getInput();
        Frame frame = this.getInvoke(oldInput, rel);
        if (frame == null) {
            return null;
        }
        if (this.cm.mapRefRelToCorVar.containsKey(rel)) {
            this.decorrelateInputWithValueGenerator(rel);
            frame = this.map.get(oldInput);
        }
        RelNode newFilter = RelOptUtil.createFilter(frame.r, this.decorrelateExpr(rel.getCondition()));
        return this.register(rel, newFilter, frame.oldToNewOutputPos, frame.corVarOutputPos);
    }

    public Frame decorrelateRel(LogicalCorrelate rel) {
        RelNode oldLeft = rel.getInput(0);
        RelNode oldRight = rel.getInput(1);
        Frame leftFrame = this.getInvoke(oldLeft, rel);
        Frame rightFrame = this.getInvoke(oldRight, rel);
        if (leftFrame == null || rightFrame == null) {
            return null;
        }
        if (rightFrame.corVarOutputPos.isEmpty()) {
            return null;
        }
        assert (rel.getRequiredColumns().cardinality() <= rightFrame.corVarOutputPos.keySet().size());
        TreeMap<Correlation, Integer> corVarOutputPos = new TreeMap<Correlation, Integer>((SortedMap<Correlation, Integer>)rightFrame.corVarOutputPos);
        ArrayList<RexNode> conditions = new ArrayList<RexNode>();
        List<RelDataTypeField> newLeftOutput = leftFrame.r.getRowType().getFieldList();
        int newLeftFieldCount = newLeftOutput.size();
        List<RelDataTypeField> newRightOutput = rightFrame.r.getRowType().getFieldList();
        for (Map.Entry rightOutputPos : Lists.newArrayList(corVarOutputPos.entrySet())) {
            Correlation corVar = (Correlation)rightOutputPos.getKey();
            if (!corVar.corr.equals(rel.getCorrelationId())) continue;
            int newLeftPos = leftFrame.oldToNewOutputPos.get(corVar.field);
            int newRightPos = (Integer)rightOutputPos.getValue();
            conditions.add(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, RexInputRef.of(newLeftPos, newLeftOutput), new RexInputRef(newLeftFieldCount + newRightPos, newRightOutput.get(newRightPos).getType())));
            corVarOutputPos.remove(corVar);
        }
        for (Correlation corVar : corVarOutputPos.keySet()) {
            int newPos = (Integer)corVarOutputPos.get(corVar) + newLeftFieldCount;
            corVarOutputPos.put(corVar, newPos);
        }
        corVarOutputPos.putAll(leftFrame.corVarOutputPos);
        HashMap<Integer, Integer> mapOldToNewOutputPos = Maps.newHashMap();
        int oldLeftFieldCount = oldLeft.getRowType().getFieldCount();
        int oldRightFieldCount = oldRight.getRowType().getFieldCount();
        assert (rel.getRowType().getFieldCount() == oldLeftFieldCount + oldRightFieldCount);
        mapOldToNewOutputPos.putAll(leftFrame.oldToNewOutputPos);
        for (int i = 0; i < oldRightFieldCount; ++i) {
            mapOldToNewOutputPos.put(i + oldLeftFieldCount, rightFrame.oldToNewOutputPos.get(i) + newLeftFieldCount);
        }
        RexNode condition = RexUtil.composeConjunction(this.rexBuilder, conditions, false);
        LogicalJoin newJoin = LogicalJoin.create(leftFrame.r, rightFrame.r, condition, ImmutableSet.of(), rel.getJoinType().toJoinType());
        return this.register(rel, newJoin, mapOldToNewOutputPos, corVarOutputPos);
    }

    public Frame decorrelateRel(LogicalJoin rel) {
        RelNode oldLeft = rel.getInput(0);
        RelNode oldRight = rel.getInput(1);
        Frame leftFrame = this.getInvoke(oldLeft, rel);
        Frame rightFrame = this.getInvoke(oldRight, rel);
        if (leftFrame == null || rightFrame == null) {
            return null;
        }
        LogicalJoin newJoin = LogicalJoin.create(leftFrame.r, rightFrame.r, this.decorrelateExpr(rel.getCondition()), ImmutableSet.of(), rel.getJoinType());
        HashMap<Integer, Integer> mapOldToNewOutputPos = Maps.newHashMap();
        int oldLeftFieldCount = oldLeft.getRowType().getFieldCount();
        int newLeftFieldCount = leftFrame.r.getRowType().getFieldCount();
        int oldRightFieldCount = oldRight.getRowType().getFieldCount();
        assert (rel.getRowType().getFieldCount() == oldLeftFieldCount + oldRightFieldCount);
        mapOldToNewOutputPos.putAll(leftFrame.oldToNewOutputPos);
        for (int i = 0; i < oldRightFieldCount; ++i) {
            mapOldToNewOutputPos.put(i + oldLeftFieldCount, rightFrame.oldToNewOutputPos.get(i) + newLeftFieldCount);
        }
        TreeMap<Correlation, Integer> mapCorVarToOutputPos = new TreeMap<Correlation, Integer>((SortedMap<Correlation, Integer>)leftFrame.corVarOutputPos);
        for (Map.Entry entry : rightFrame.corVarOutputPos.entrySet()) {
            mapCorVarToOutputPos.put((Correlation)entry.getKey(), (Integer)entry.getValue() + newLeftFieldCount);
        }
        return this.register(rel, newJoin, mapOldToNewOutputPos, mapCorVarToOutputPos);
    }

    private RexInputRef getNewForOldInputRef(RexInputRef oldInputRef) {
        int oldLocalOrdinal;
        assert (this.currentRel != null);
        int oldOrdinal = oldInputRef.getIndex();
        int newOrdinal = 0;
        RelNode oldInput = null;
        for (RelNode oldInput0 : this.currentRel.getInputs()) {
            RelDataType oldInputType = oldInput0.getRowType();
            int n = oldInputType.getFieldCount();
            if (oldOrdinal < n) {
                oldInput = oldInput0;
                break;
            }
            RelNode newInput = this.map.get((Object)oldInput0).r;
            newOrdinal += newInput.getRowType().getFieldCount();
            oldOrdinal -= n;
        }
        assert (oldInput != null);
        Frame frame = this.map.get(oldInput);
        assert (frame != null);
        int newLocalOrdinal = oldLocalOrdinal = oldOrdinal;
        if (!frame.oldToNewOutputPos.isEmpty()) {
            newLocalOrdinal = frame.oldToNewOutputPos.get(oldLocalOrdinal);
        }
        return new RexInputRef(newOrdinal += newLocalOrdinal, frame.r.getRowType().getFieldList().get(newLocalOrdinal).getType());
    }

    private RelNode projectJoinOutputWithNullability(LogicalJoin join, LogicalProject project, int nullIndicatorPos) {
        RelDataTypeFactory typeFactory = join.getCluster().getTypeFactory();
        RelNode left = join.getLeft();
        JoinRelType joinType = join.getJoinType();
        RexInputRef nullIndicator = new RexInputRef(nullIndicatorPos, typeFactory.createTypeWithNullability(join.getRowType().getFieldList().get(nullIndicatorPos).getType(), true));
        ArrayList<Pair<RexNode, String>> newProjExprs = Lists.newArrayList();
        List<RelDataTypeField> leftInputFields = left.getRowType().getFieldList();
        for (int i = 0; i < leftInputFields.size(); ++i) {
            newProjExprs.add(RexInputRef.of2(i, leftInputFields));
        }
        boolean projectPulledAboveLeftCorrelator = joinType.generatesNullsOnRight();
        for (Pair<RexNode, String> pair : project.getNamedProjects()) {
            RexNode newProjExpr = this.removeCorrelationExpr((RexNode)pair.left, projectPulledAboveLeftCorrelator, nullIndicator);
            newProjExprs.add(Pair.of(newProjExpr, pair.right));
        }
        return RelOptUtil.createProject((RelNode)join, newProjExprs, false);
    }

    private RelNode aggregateCorrelatorOutput(Correlate correlate, LogicalProject project, Set<Integer> isCount) {
        RelNode left = correlate.getLeft();
        JoinRelType joinType = correlate.getJoinType().toJoinType();
        ArrayList<Pair<RexNode, String>> newProjects = Lists.newArrayList();
        List<RelDataTypeField> leftInputFields = left.getRowType().getFieldList();
        for (int i = 0; i < leftInputFields.size(); ++i) {
            newProjects.add(RexInputRef.of2(i, leftInputFields));
        }
        boolean projectPulledAboveLeftCorrelator = joinType.generatesNullsOnRight();
        for (Pair<RexNode, String> pair : project.getNamedProjects()) {
            RexNode newProjExpr = this.removeCorrelationExpr((RexNode)pair.left, projectPulledAboveLeftCorrelator, isCount);
            newProjects.add(Pair.of(newProjExpr, pair.right));
        }
        return RelOptUtil.createProject((RelNode)correlate, newProjects, false);
    }

    private boolean checkCorVars(LogicalCorrelate correlate, LogicalProject project, LogicalFilter filter, List<RexFieldAccess> correlatedJoinKeys) {
        if (filter != null) {
            assert (correlatedJoinKeys != null);
            HashSet<Correlation> corVarInFilter = Sets.newHashSet(this.cm.mapRefRelToCorVar.get(filter));
            for (RexFieldAccess correlatedJoinKey : correlatedJoinKeys) {
                corVarInFilter.remove(this.cm.mapFieldAccessToCorVar.get(correlatedJoinKey));
            }
            if (!corVarInFilter.isEmpty()) {
                return false;
            }
            corVarInFilter.addAll(this.cm.mapRefRelToCorVar.get(filter));
            for (Correlation corVar : corVarInFilter) {
                if (this.cm.mapCorVarToCorRel.get(corVar.corr) == correlate) continue;
                return false;
            }
        }
        if (project != null && this.cm.mapRefRelToCorVar.containsKey(project)) {
            for (Correlation corVar : this.cm.mapRefRelToCorVar.get(project)) {
                if (this.cm.mapCorVarToCorRel.get(corVar.corr) == correlate) continue;
                return false;
            }
        }
        return true;
    }

    private void removeCorVarFromTree(LogicalCorrelate correlate) {
        if (this.cm.mapCorVarToCorRel.get(correlate.getCorrelationId()) == correlate) {
            this.cm.mapCorVarToCorRel.remove(correlate.getCorrelationId());
        }
    }

    private RelNode createProjectWithAdditionalExprs(RelNode input, List<Pair<RexNode, String>> additionalExprs) {
        List<RelDataTypeField> fieldList = input.getRowType().getFieldList();
        ArrayList<Pair<RexNode, String>> projects = Lists.newArrayList();
        for (Ord<RelDataTypeField> field : Ord.zip(fieldList)) {
            projects.add(Pair.of(this.rexBuilder.makeInputRef(((RelDataTypeField)field.e).getType(), field.i), ((RelDataTypeField)field.e).getName()));
        }
        projects.addAll(additionalExprs);
        return RelOptUtil.createProject(input, projects, false);
    }

    static Map<Integer, Integer> identityMap(int count) {
        ImmutableMap.Builder<Integer, Integer> builder = ImmutableMap.builder();
        for (int i = 0; i < count; ++i) {
            builder.put(i, i);
        }
        return builder.build();
    }

    Frame register(RelNode rel, RelNode newRel, Map<Integer, Integer> oldToNewOutputPos, SortedMap<Correlation, Integer> corVarToOutputPos) {
        assert (RelDecorrelator.allLessThan(oldToNewOutputPos.keySet(), newRel.getRowType().getFieldCount(), Litmus.THROW));
        Frame frame = new Frame(newRel, corVarToOutputPos, oldToNewOutputPos);
        this.map.put(rel, frame);
        return frame;
    }

    static boolean allLessThan(Collection<Integer> integers, int limit, Litmus ret) {
        for (int value : integers) {
            if (value < limit) continue;
            return ret.fail("out of range; value: {}, limit: {}", value, limit);
        }
        return ret.succeed();
    }

    private static RelNode stripHep(RelNode rel) {
        if (rel instanceof HepRelVertex) {
            HepRelVertex hepRelVertex = (HepRelVertex)rel;
            rel = hepRelVertex.getCurrentRel();
        }
        return rel;
    }

    static class Frame {
        final RelNode r;
        final ImmutableSortedMap<Correlation, Integer> corVarOutputPos;
        final ImmutableMap<Integer, Integer> oldToNewOutputPos;

        Frame(RelNode r, SortedMap<Correlation, Integer> corVarOutputPos, Map<Integer, Integer> oldToNewOutputPos) {
            this.r = Preconditions.checkNotNull(r);
            this.corVarOutputPos = ImmutableSortedMap.copyOf(corVarOutputPos);
            this.oldToNewOutputPos = ImmutableSortedMap.copyOf(oldToNewOutputPos);
        }
    }

    private static class CorelMapBuilder
    extends RelShuttleImpl {
        final SortedMap<CorrelationId, RelNode> mapCorVarToCorRel = new TreeMap<CorrelationId, RelNode>();
        final SortedSetMultimap<RelNode, Correlation> mapRefRelToCorVar = Multimaps.newSortedSetMultimap(Maps.newHashMap(), new Supplier<TreeSet<Correlation>>(){

            @Override
            public TreeSet<Correlation> get() {
                Bug.upgrade("use MultimapBuilder when we're on Guava-16");
                return Sets.newTreeSet();
            }
        });
        final Map<RexFieldAccess, Correlation> mapFieldAccessToCorVar = new HashMap<RexFieldAccess, Correlation>();
        final Holder<Integer> offset = Holder.of(0);
        int corrIdGenerator = 0;
        final Deque<RelNode> stack = new ArrayDeque<RelNode>();

        private CorelMapBuilder() {
        }

        CorelMap build(RelNode rel) {
            RelDecorrelator.stripHep(rel).accept(this);
            return new CorelMap(this.mapRefRelToCorVar, this.mapCorVarToCorRel, this.mapFieldAccessToCorVar);
        }

        @Override
        public RelNode visit(LogicalJoin join) {
            try {
                this.stack.push(join);
                join.getCondition().accept(this.rexVisitor(join));
            }
            finally {
                this.stack.pop();
            }
            return this.visitJoin(join);
        }

        @Override
        protected RelNode visitChild(RelNode parent, int i, RelNode input) {
            return super.visitChild(parent, i, RelDecorrelator.stripHep(input));
        }

        @Override
        public RelNode visit(LogicalCorrelate correlate) {
            this.mapCorVarToCorRel.put(correlate.getCorrelationId(), correlate);
            return this.visitJoin(correlate);
        }

        private RelNode visitJoin(BiRel join) {
            int x = this.offset.get();
            this.visitChild(join, 0, join.getLeft());
            this.offset.set(x + join.getLeft().getRowType().getFieldCount());
            this.visitChild(join, 1, join.getRight());
            this.offset.set(x);
            return join;
        }

        @Override
        public RelNode visit(LogicalFilter filter) {
            try {
                this.stack.push(filter);
                filter.getCondition().accept(this.rexVisitor(filter));
            }
            finally {
                this.stack.pop();
            }
            return super.visit(filter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RelNode visit(LogicalProject project) {
            try {
                this.stack.push(project);
                for (RexNode node : project.getProjects()) {
                    node.accept(this.rexVisitor(project));
                }
            }
            finally {
                this.stack.pop();
            }
            return super.visit(project);
        }

        private RexVisitorImpl<Void> rexVisitor(final RelNode rel) {
            return new RexVisitorImpl<Void>(true){

                @Override
                public Void visitFieldAccess(RexFieldAccess fieldAccess) {
                    RexNode ref = fieldAccess.getReferenceExpr();
                    if (ref instanceof RexCorrelVariable) {
                        RexCorrelVariable var = (RexCorrelVariable)ref;
                        Correlation correlation = new Correlation(var.id, fieldAccess.getField().getIndex(), CorelMapBuilder.this.corrIdGenerator++);
                        CorelMapBuilder.this.mapFieldAccessToCorVar.put(fieldAccess, correlation);
                        CorelMapBuilder.this.mapRefRelToCorVar.put(rel, correlation);
                    }
                    return (Void)super.visitFieldAccess(fieldAccess);
                }

                @Override
                public Void visitSubQuery(RexSubQuery subQuery) {
                    subQuery.rel.accept(CorelMapBuilder.this);
                    return (Void)super.visitSubQuery(subQuery);
                }
            };
        }
    }

    private static class CorelMap {
        private final Multimap<RelNode, Correlation> mapRefRelToCorVar;
        private final SortedMap<CorrelationId, RelNode> mapCorVarToCorRel;
        private final Map<RexFieldAccess, Correlation> mapFieldAccessToCorVar;

        private CorelMap(Multimap<RelNode, Correlation> mapRefRelToCorVar, SortedMap<CorrelationId, RelNode> mapCorVarToCorRel, Map<RexFieldAccess, Correlation> mapFieldAccessToCorVar) {
            this.mapRefRelToCorVar = mapRefRelToCorVar;
            this.mapCorVarToCorRel = mapCorVarToCorRel;
            this.mapFieldAccessToCorVar = ImmutableMap.copyOf(mapFieldAccessToCorVar);
        }

        public String toString() {
            return "mapRefRelToCorVar=" + this.mapRefRelToCorVar + "\nmapCorVarToCorRel=" + this.mapCorVarToCorRel + "\nmapFieldAccessToCorVar=" + this.mapFieldAccessToCorVar + "\n";
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof CorelMap && this.mapRefRelToCorVar.equals(((CorelMap)obj).mapRefRelToCorVar) && this.mapCorVarToCorRel.equals(((CorelMap)obj).mapCorVarToCorRel) && this.mapFieldAccessToCorVar.equals(((CorelMap)obj).mapFieldAccessToCorVar);
        }

        public int hashCode() {
            return Objects.hash(this.mapRefRelToCorVar, this.mapCorVarToCorRel, this.mapFieldAccessToCorVar);
        }

        public static CorelMap of(SortedSetMultimap<RelNode, Correlation> mapRefRelToCorVar, SortedMap<CorrelationId, RelNode> mapCorVarToCorRel, Map<RexFieldAccess, Correlation> mapFieldAccessToCorVar) {
            return new CorelMap(mapRefRelToCorVar, mapCorVarToCorRel, mapFieldAccessToCorVar);
        }

        public boolean hasCorrelation() {
            return !this.mapCorVarToCorRel.isEmpty();
        }
    }

    static class Correlation
    implements Comparable<Correlation> {
        public final int uniqueKey;
        public final CorrelationId corr;
        public final int field;

        Correlation(CorrelationId corr, int field, int uniqueKey) {
            this.corr = corr;
            this.field = field;
            this.uniqueKey = uniqueKey;
        }

        @Override
        public int compareTo(Correlation o) {
            int c = this.corr.compareTo(o.corr);
            if (c != 0) {
                return c;
            }
            c = Integer.compare(this.field, o.field);
            if (c != 0) {
                return c;
            }
            return Integer.compare(this.uniqueKey, o.uniqueKey);
        }
    }

    private final class AdjustProjectForCountAggregateRule
    extends RelOptRule {
        final boolean flavor;

        public AdjustProjectForCountAggregateRule(boolean flavor) {
            super(flavor ? AdjustProjectForCountAggregateRule.operand(LogicalCorrelate.class, AdjustProjectForCountAggregateRule.operand(RelNode.class, AdjustProjectForCountAggregateRule.any()), AdjustProjectForCountAggregateRule.operand(LogicalProject.class, AdjustProjectForCountAggregateRule.operand(LogicalAggregate.class, AdjustProjectForCountAggregateRule.any()), new RelOptRuleOperand[0])) : AdjustProjectForCountAggregateRule.operand(LogicalCorrelate.class, AdjustProjectForCountAggregateRule.operand(RelNode.class, AdjustProjectForCountAggregateRule.any()), AdjustProjectForCountAggregateRule.operand(LogicalAggregate.class, AdjustProjectForCountAggregateRule.any())));
            this.flavor = flavor;
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            LogicalAggregate aggregate;
            LogicalProject aggOutputProject;
            LogicalCorrelate correlate = (LogicalCorrelate)call.rel(0);
            Object left = call.rel(1);
            if (this.flavor) {
                aggOutputProject = (LogicalProject)call.rel(2);
                aggregate = (LogicalAggregate)call.rel(3);
            } else {
                aggregate = (LogicalAggregate)call.rel(2);
                ArrayList<Pair<RexNode, String>> projects = Lists.newArrayList();
                List<RelDataTypeField> fields = aggregate.getRowType().getFieldList();
                for (int i = 0; i < fields.size(); ++i) {
                    projects.add(RexInputRef.of2(projects.size(), fields));
                }
                aggOutputProject = (LogicalProject)RelOptUtil.createProject((RelNode)aggregate, projects, false);
            }
            this.onMatch2(call, correlate, (RelNode)left, aggOutputProject, aggregate);
        }

        private void onMatch2(RelOptRuleCall call, LogicalCorrelate correlate, RelNode leftInput, LogicalProject aggOutputProject, LogicalAggregate aggregate) {
            if (RelDecorrelator.this.generatedCorRels.contains(correlate)) {
                return;
            }
            RelDecorrelator.this.setCurrent(call.getPlanner().getRoot(), correlate);
            List<RexNode> aggOutputProjExprs = aggOutputProject.getProjects();
            if (aggOutputProjExprs.size() != 1) {
                return;
            }
            JoinRelType joinType = correlate.getJoinType().toJoinType();
            RexLiteral joinCond = RelDecorrelator.this.rexBuilder.makeLiteral(true);
            if (joinType != JoinRelType.LEFT || joinCond != RelDecorrelator.this.rexBuilder.makeLiteral(true)) {
                return;
            }
            if (!aggregate.getGroupSet().isEmpty()) {
                return;
            }
            List<AggregateCall> aggCalls = aggregate.getAggCallList();
            HashSet<Integer> isCount = Sets.newHashSet();
            int i = -1;
            for (AggregateCall aggCall : aggCalls) {
                ++i;
                if (!(aggCall.getAggregation() instanceof SqlCountAggFunction)) continue;
                isCount.add(i);
            }
            LogicalCorrelate newCorrelate = LogicalCorrelate.create(leftInput, aggregate, correlate.getCorrelationId(), correlate.getRequiredColumns(), correlate.getJoinType());
            RelDecorrelator.this.generatedCorRels.add(newCorrelate);
            if (RelDecorrelator.this.cm.mapCorVarToCorRel.get(correlate.getCorrelationId()) == correlate) {
                RelDecorrelator.this.cm.mapCorVarToCorRel.put(correlate.getCorrelationId(), newCorrelate);
            }
            RelNode newOutput = RelDecorrelator.this.aggregateCorrelatorOutput(newCorrelate, aggOutputProject, isCount);
            call.transformTo(newOutput);
        }
    }

    private final class RemoveCorrelationForScalarAggregateRule
    extends RelOptRule {
        public RemoveCorrelationForScalarAggregateRule() {
            super(RemoveCorrelationForScalarAggregateRule.operand(LogicalCorrelate.class, RemoveCorrelationForScalarAggregateRule.operand(RelNode.class, RemoveCorrelationForScalarAggregateRule.any()), RemoveCorrelationForScalarAggregateRule.operand(LogicalProject.class, RemoveCorrelationForScalarAggregateRule.operand(LogicalAggregate.class, null, Aggregate.IS_SIMPLE, RemoveCorrelationForScalarAggregateRule.operand(LogicalProject.class, RemoveCorrelationForScalarAggregateRule.operand(RelNode.class, RemoveCorrelationForScalarAggregateRule.any()), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), new RelOptRuleOperand[0])));
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            LogicalCorrelate correlate = (LogicalCorrelate)call.rel(0);
            Object left = call.rel(1);
            LogicalProject aggOutputProject = (LogicalProject)call.rel(2);
            LogicalAggregate aggregate = (LogicalAggregate)call.rel(3);
            LogicalProject aggInputProject = (LogicalProject)call.rel(4);
            Object right = call.rel(5);
            RelOptCluster cluster = correlate.getCluster();
            RelDecorrelator.this.setCurrent(call.getPlanner().getRoot(), correlate);
            List<RexNode> aggOutputProjects = aggOutputProject.getProjects();
            if (aggOutputProjects.size() != 1) {
                return;
            }
            JoinRelType joinType = correlate.getJoinType().toJoinType();
            RexNode joinCond = RelDecorrelator.this.rexBuilder.makeLiteral(true);
            if (joinType != JoinRelType.LEFT || joinCond != RelDecorrelator.this.rexBuilder.makeLiteral(true)) {
                return;
            }
            if (!aggregate.getGroupSet().isEmpty()) {
                return;
            }
            List<RexNode> aggInputProjects = aggInputProject.getProjects();
            List<AggregateCall> aggCalls = aggregate.getAggCallList();
            HashSet<Integer> isCountStar = Sets.newHashSet();
            int k = -1;
            for (AggregateCall aggCall : aggCalls) {
                ++k;
                if (!(aggCall.getAggregation() instanceof SqlCountAggFunction) || aggCall.getArgList().size() != 0) continue;
                isCountStar.add(k);
            }
            if (right instanceof LogicalFilter && RelDecorrelator.this.cm.mapRefRelToCorVar.containsKey(right)) {
                LogicalFilter filter = (LogicalFilter)right;
                right = filter.getInput();
                assert (right instanceof HepRelVertex);
                if (RelOptUtil.getVariablesUsed(right = ((HepRelVertex)right).getCurrentRel()).size() > 0) {
                    return;
                }
                ArrayList<RexNode> rightJoinKeys = Lists.newArrayList();
                ArrayList<RexNode> tmpCorrelatedJoinKeys = Lists.newArrayList();
                RelOptUtil.splitCorrelatedFilterCondition(filter, rightJoinKeys, tmpCorrelatedJoinKeys, true);
                ArrayList<RexFieldAccess> correlatedJoinKeys = Lists.newArrayList();
                ArrayList<RexInputRef> correlatedInputRefJoinKeys = Lists.newArrayList();
                for (RexNode joinKey : tmpCorrelatedJoinKeys) {
                    assert (joinKey instanceof RexFieldAccess);
                    correlatedJoinKeys.add((RexFieldAccess)joinKey);
                    RexNode correlatedInputRef = RelDecorrelator.this.removeCorrelationExpr(joinKey, false);
                    assert (correlatedInputRef instanceof RexInputRef);
                    correlatedInputRefJoinKeys.add((RexInputRef)correlatedInputRef);
                }
                if (correlatedInputRefJoinKeys.isEmpty()) {
                    return;
                }
                RelMetadataQuery mq = RelMetadataQuery.instance();
                if (!RelMdUtil.areColumnsDefinitelyUniqueWhenNullsFiltered(mq, left, correlatedInputRefJoinKeys)) {
                    SQL2REL_LOGGER.debug("{} are not unique keys for {}", (Object)((Object)correlatedJoinKeys).toString(), (Object)left.toString());
                    return;
                }
                if (!RelDecorrelator.this.checkCorVars(correlate, aggInputProject, filter, correlatedJoinKeys)) {
                    return;
                }
                joinCond = RelDecorrelator.this.removeCorrelationExpr(filter.getCondition(), false);
            } else if (RelDecorrelator.this.cm.mapRefRelToCorVar.containsKey(aggInputProject)) {
                if (RelOptUtil.getVariablesUsed(right).size() > 0) {
                    return;
                }
                if (!RelDecorrelator.this.checkCorVars(correlate, aggInputProject, null, null)) {
                    return;
                }
                int nFields = left.getRowType().getFieldCount();
                ImmutableBitSet allCols = ImmutableBitSet.range(nFields);
                RelMetadataQuery mq = RelMetadataQuery.instance();
                if (!RelMdUtil.areColumnsDefinitelyUnique(mq, left, allCols)) {
                    SQL2REL_LOGGER.debug("There are no unique keys for {}", left);
                    return;
                }
            } else {
                return;
            }
            RelDataType leftInputFieldType = left.getRowType();
            int leftInputFieldCount = leftInputFieldType.getFieldCount();
            int joinOutputProjExprCount = leftInputFieldCount + aggInputProjects.size() + 1;
            right = RelDecorrelator.this.createProjectWithAdditionalExprs(right, ImmutableList.of(Pair.of(RelDecorrelator.this.rexBuilder.makeLiteral(true), "nullIndicator")));
            LogicalJoin join = LogicalJoin.create(left, right, joinCond, ImmutableSet.of(), joinType);
            int nullIndicatorPos = join.getRowType().getFieldCount() - 1;
            RexInputRef nullIndicator = new RexInputRef(nullIndicatorPos, cluster.getTypeFactory().createTypeWithNullability(join.getRowType().getFieldList().get(nullIndicatorPos).getType(), true));
            ArrayList<RexNode> joinOutputProjects = Lists.newArrayList();
            for (int i = 0; i < leftInputFieldCount; ++i) {
                joinOutputProjects.add(RelDecorrelator.this.rexBuilder.makeInputRef(leftInputFieldType.getFieldList().get(i).getType(), i));
            }
            for (RexNode aggInputProjExpr : aggInputProjects) {
                joinOutputProjects.add(RelDecorrelator.this.removeCorrelationExpr(aggInputProjExpr, joinType.generatesNullsOnRight(), nullIndicator));
            }
            joinOutputProjects.add(RelDecorrelator.this.rexBuilder.makeInputRef(join, nullIndicatorPos));
            RelNode joinOutputProject = RelOptUtil.createProject((RelNode)join, joinOutputProjects, null);
            nullIndicatorPos = joinOutputProjExprCount - 1;
            int groupCount = leftInputFieldCount;
            ArrayList<AggregateCall> newAggCalls = Lists.newArrayList();
            k = -1;
            for (AggregateCall aggCall : aggCalls) {
                List<Object> argList;
                if (isCountStar.contains(++k)) {
                    argList = Collections.singletonList(nullIndicatorPos);
                } else {
                    argList = Lists.newArrayList();
                    for (int aggArg : aggCall.getArgList()) {
                        argList.add(aggArg + groupCount);
                    }
                }
                int filterArg = aggCall.filterArg < 0 ? aggCall.filterArg : aggCall.filterArg + groupCount;
                newAggCalls.add(aggCall.adaptTo(joinOutputProject, argList, filterArg, aggregate.getGroupCount(), groupCount));
            }
            ImmutableBitSet groupSet = ImmutableBitSet.range(groupCount);
            LogicalAggregate newAggregate = LogicalAggregate.create(joinOutputProject, false, groupSet, null, newAggCalls);
            ArrayList<RexNode> newAggOutputProjectList = Lists.newArrayList();
            for (int i : groupSet) {
                newAggOutputProjectList.add(RelDecorrelator.this.rexBuilder.makeInputRef(newAggregate, i));
            }
            RexNode newAggOutputProjects = RelDecorrelator.this.removeCorrelationExpr(aggOutputProjects.get(0), false);
            newAggOutputProjectList.add(RelDecorrelator.this.rexBuilder.makeCast(cluster.getTypeFactory().createTypeWithNullability(newAggOutputProjects.getType(), true), newAggOutputProjects));
            RelNode newAggOutputProject = RelOptUtil.createProject((RelNode)newAggregate, newAggOutputProjectList, null);
            call.transformTo(newAggOutputProject);
            RelDecorrelator.this.removeCorVarFromTree(correlate);
        }
    }

    private final class RemoveCorrelationForScalarProjectRule
    extends RelOptRule {
        public RemoveCorrelationForScalarProjectRule() {
            super(RemoveCorrelationForScalarProjectRule.operand(LogicalCorrelate.class, RemoveCorrelationForScalarProjectRule.operand(RelNode.class, RemoveCorrelationForScalarProjectRule.any()), RemoveCorrelationForScalarProjectRule.operand(LogicalAggregate.class, RemoveCorrelationForScalarProjectRule.operand(LogicalProject.class, RemoveCorrelationForScalarProjectRule.operand(RelNode.class, RemoveCorrelationForScalarProjectRule.any()), new RelOptRuleOperand[0]), new RelOptRuleOperand[0])));
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            int nullIndicatorPos;
            LogicalCorrelate correlate = (LogicalCorrelate)call.rel(0);
            Object left = call.rel(1);
            LogicalAggregate aggregate = (LogicalAggregate)call.rel(2);
            LogicalProject project = (LogicalProject)call.rel(3);
            Object right = call.rel(4);
            RelOptCluster cluster = correlate.getCluster();
            RelDecorrelator.this.setCurrent(call.getPlanner().getRoot(), correlate);
            JoinRelType joinType = correlate.getJoinType().toJoinType();
            RexNode joinCond = RelDecorrelator.this.rexBuilder.makeLiteral(true);
            if (joinType != JoinRelType.LEFT || joinCond != RelDecorrelator.this.rexBuilder.makeLiteral(true)) {
                return;
            }
            if (!aggregate.getGroupSet().isEmpty() || aggregate.getAggCallList().size() != 1 || !(aggregate.getAggCallList().get(0).getAggregation() instanceof SqlSingleValueAggFunction)) {
                return;
            }
            if (project.getProjects().size() != 1) {
                return;
            }
            if (right instanceof LogicalFilter && RelDecorrelator.this.cm.mapRefRelToCorVar.containsKey(right)) {
                LogicalFilter filter = (LogicalFilter)right;
                right = filter.getInput();
                assert (right instanceof HepRelVertex);
                if (RelOptUtil.getVariablesUsed(right = ((HepRelVertex)right).getCurrentRel()).size() > 0) {
                    return;
                }
                ArrayList<RexNode> tmpRightJoinKeys = Lists.newArrayList();
                ArrayList<RexNode> correlatedJoinKeys = Lists.newArrayList();
                RelOptUtil.splitCorrelatedFilterCondition(filter, tmpRightJoinKeys, correlatedJoinKeys, false);
                ArrayList<RexInputRef> rightJoinKeys = new ArrayList<RexInputRef>();
                for (RexNode key : tmpRightJoinKeys) {
                    assert (key instanceof RexInputRef);
                    rightJoinKeys.add((RexInputRef)key);
                }
                if (rightJoinKeys.isEmpty()) {
                    return;
                }
                RelMetadataQuery mq = RelMetadataQuery.instance();
                if (!RelMdUtil.areColumnsDefinitelyUniqueWhenNullsFiltered(mq, (RelNode)right, rightJoinKeys)) {
                    SQL2REL_LOGGER.debug("{} are not unique keys for {}", (Object)((Object)rightJoinKeys).toString(), (Object)right.toString());
                    return;
                }
                RexUtil.FieldAccessFinder visitor = new RexUtil.FieldAccessFinder();
                RexUtil.apply((RexVisitor<Void>)visitor, correlatedJoinKeys, null);
                List<RexFieldAccess> correlatedKeyList = visitor.getFieldAccessList();
                if (!RelDecorrelator.this.checkCorVars(correlate, project, filter, correlatedKeyList)) {
                    return;
                }
                joinCond = RelDecorrelator.this.removeCorrelationExpr(filter.getCondition(), false);
                nullIndicatorPos = left.getRowType().getFieldCount() + ((RexInputRef)rightJoinKeys.get(0)).getIndex();
            } else if (RelDecorrelator.this.cm.mapRefRelToCorVar.containsKey(project)) {
                if (RelOptUtil.getVariablesUsed(right).size() > 0) {
                    return;
                }
                if (!RelDecorrelator.this.checkCorVars(correlate, project, null, null)) {
                    return;
                }
                right = RelDecorrelator.this.createProjectWithAdditionalExprs(right, ImmutableList.of(Pair.of(RelDecorrelator.this.rexBuilder.makeLiteral(true), "nullIndicator")));
                right = RelOptUtil.createSingleValueAggRel(cluster, right);
                nullIndicatorPos = left.getRowType().getFieldCount() + right.getRowType().getFieldCount() - 1;
            } else {
                return;
            }
            LogicalJoin join = LogicalJoin.create(left, (RelNode)right, joinCond, ImmutableSet.of(), joinType);
            RelNode newProject = RelDecorrelator.this.projectJoinOutputWithNullability(join, project, nullIndicatorPos);
            call.transformTo(newProject);
            RelDecorrelator.this.removeCorVarFromTree(correlate);
        }
    }

    private final class RemoveSingleAggregateRule
    extends RelOptRule {
        public RemoveSingleAggregateRule() {
            super(RemoveSingleAggregateRule.operand(LogicalAggregate.class, RemoveSingleAggregateRule.operand(LogicalProject.class, RemoveSingleAggregateRule.operand(LogicalAggregate.class, RemoveSingleAggregateRule.any()), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]));
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            LogicalAggregate singleAggregate = (LogicalAggregate)call.rel(0);
            LogicalProject project = (LogicalProject)call.rel(1);
            LogicalAggregate aggregate = (LogicalAggregate)call.rel(2);
            if (!singleAggregate.getGroupSet().isEmpty() || singleAggregate.getAggCallList().size() != 1 || !(singleAggregate.getAggCallList().get(0).getAggregation() instanceof SqlSingleValueAggFunction)) {
                return;
            }
            List<RexNode> projExprs = project.getProjects();
            if (projExprs.size() != 1) {
                return;
            }
            if (!aggregate.getGroupSet().isEmpty()) {
                return;
            }
            RelOptCluster cluster = project.getCluster();
            RelNode newProject = RelOptUtil.createProject((RelNode)aggregate, ImmutableList.of(RelDecorrelator.this.rexBuilder.makeCast(cluster.getTypeFactory().createTypeWithNullability(projExprs.get(0).getType(), true), projExprs.get(0))), null);
            call.transformTo(newProject);
        }
    }

    private class RemoveCorrelationRexShuttle
    extends RexShuttle {
        final RexBuilder rexBuilder;
        final RelDataTypeFactory typeFactory;
        final boolean projectPulledAboveLeftCorrelator;
        final RexInputRef nullIndicator;
        final ImmutableSet<Integer> isCount;

        public RemoveCorrelationRexShuttle(RexBuilder rexBuilder, boolean projectPulledAboveLeftCorrelator, RexInputRef nullIndicator, Set<Integer> isCount) {
            this.projectPulledAboveLeftCorrelator = projectPulledAboveLeftCorrelator;
            this.nullIndicator = nullIndicator;
            this.isCount = ImmutableSet.copyOf(isCount);
            this.rexBuilder = rexBuilder;
            this.typeFactory = rexBuilder.getTypeFactory();
        }

        private RexNode createCaseExpression(RexInputRef nullInputRef, RexLiteral lit, RexNode rexNode) {
            RexNode[] caseOperands = new RexNode[]{this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexInputRef(nullInputRef.getIndex(), this.typeFactory.createTypeWithNullability(nullInputRef.getType(), true))), this.rexBuilder.makeCast(this.typeFactory.createTypeWithNullability(rexNode.getType(), true), lit), this.rexBuilder.makeCast(this.typeFactory.createTypeWithNullability(rexNode.getType(), true), rexNode)};
            return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, caseOperands);
        }

        @Override
        public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
            if (RelDecorrelator.this.cm.mapFieldAccessToCorVar.containsKey(fieldAccess)) {
                Correlation corVar = (Correlation)RelDecorrelator.this.cm.mapFieldAccessToCorVar.get(fieldAccess);
                RexNode newRexNode = new RexInputRef(corVar.field, fieldAccess.getType());
                if (this.projectPulledAboveLeftCorrelator && this.nullIndicator != null) {
                    newRexNode = this.createCaseExpression(this.nullIndicator, this.rexBuilder.constantNull(), newRexNode);
                }
                return newRexNode;
            }
            return fieldAccess;
        }

        @Override
        public RexNode visitInputRef(RexInputRef inputRef) {
            if (RelDecorrelator.this.currentRel instanceof LogicalCorrelate) {
                int leftInputFieldCount = ((LogicalCorrelate)RelDecorrelator.this.currentRel).getLeft().getRowType().getFieldCount();
                RelDataType newType = inputRef.getType();
                if (this.projectPulledAboveLeftCorrelator) {
                    newType = this.typeFactory.createTypeWithNullability(newType, true);
                }
                int pos = inputRef.getIndex();
                RexInputRef newInputRef = new RexInputRef(leftInputFieldCount + pos, newType);
                if (this.isCount != null && this.isCount.contains(pos)) {
                    return this.createCaseExpression(newInputRef, this.rexBuilder.makeExactLiteral(BigDecimal.ZERO), newInputRef);
                }
                return newInputRef;
            }
            return inputRef;
        }

        @Override
        public RexNode visitLiteral(RexLiteral literal) {
            if (!RexUtil.isNull(literal) && this.projectPulledAboveLeftCorrelator && this.nullIndicator != null) {
                return this.createCaseExpression(this.nullIndicator, this.rexBuilder.constantNull(), literal);
            }
            return literal;
        }

        @Override
        public RexNode visitCall(RexCall call) {
            RexNode newCall;
            boolean[] update = new boolean[]{false};
            List<RexNode> clonedOperands = this.visitList(call.operands, update);
            if (update[0]) {
                SqlFunction function;
                SqlOperator operator = call.getOperator();
                boolean isSpecialCast = false;
                if (operator instanceof SqlFunction && (function = (SqlFunction)operator).getKind() == SqlKind.CAST && call.operands.size() < 2) {
                    isSpecialCast = true;
                }
                RelDataType newType = !isSpecialCast ? this.rexBuilder.deriveReturnType(operator, clonedOperands) : call.getType();
                newCall = this.rexBuilder.makeCall(newType, operator, clonedOperands);
            } else {
                newCall = call;
            }
            if (this.projectPulledAboveLeftCorrelator && this.nullIndicator != null) {
                return this.createCaseExpression(this.nullIndicator, this.rexBuilder.constantNull(), newCall);
            }
            return newCall;
        }
    }

    private class DecorrelateRexShuttle
    extends RexShuttle {
        private DecorrelateRexShuttle() {
        }

        @Override
        public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
            int newInputOutputOffset = 0;
            for (RelNode input : RelDecorrelator.this.currentRel.getInputs()) {
                Frame frame = (Frame)RelDecorrelator.this.map.get(input);
                if (frame != null) {
                    Integer newInputPos;
                    Correlation corVar = (Correlation)RelDecorrelator.this.cm.mapFieldAccessToCorVar.get(fieldAccess);
                    if (corVar != null && (newInputPos = (Integer)frame.corVarOutputPos.get(corVar)) != null) {
                        return new RexInputRef(newInputPos + newInputOutputOffset, fieldAccess.getType());
                    }
                    newInputOutputOffset += frame.r.getRowType().getFieldCount();
                    continue;
                }
                newInputOutputOffset += input.getRowType().getFieldCount();
            }
            return fieldAccess;
        }

        @Override
        public RexNode visitInputRef(RexInputRef inputRef) {
            return RelDecorrelator.this.getNewForOldInputRef(inputRef);
        }
    }
}

