/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.ReduceExpressionsRule;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.hive.com.google.common.collect.ImmutableList;
import org.apache.hive.com.google.common.collect.ImmutableMap;

public class AggregateProjectPullUpConstantsRule
extends RelOptRule {
    public static final AggregateProjectPullUpConstantsRule INSTANCE = new AggregateProjectPullUpConstantsRule(LogicalAggregate.class, LogicalProject.class, RelFactories.LOGICAL_BUILDER, "AggregateProjectPullUpConstantsRule");
    public static final AggregateProjectPullUpConstantsRule INSTANCE2 = new AggregateProjectPullUpConstantsRule(LogicalAggregate.class, RelNode.class, RelFactories.LOGICAL_BUILDER, "AggregatePullUpConstantsRule");

    public AggregateProjectPullUpConstantsRule(Class<? extends Aggregate> aggregateClass, Class<? extends RelNode> inputClass, RelBuilderFactory relBuilderFactory, String description) {
        super(AggregateProjectPullUpConstantsRule.operand(aggregateClass, null, Aggregate.IS_SIMPLE, AggregateProjectPullUpConstantsRule.operand(inputClass, AggregateProjectPullUpConstantsRule.any()), new RelOptRuleOperand[0]), relBuilderFactory, description);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Aggregate aggregate = (Aggregate)call.rel(0);
        Object input = call.rel(1);
        assert (!aggregate.indicator) : "predicate ensured no grouping sets";
        int groupCount = aggregate.getGroupCount();
        if (groupCount == 1) {
            return;
        }
        RexBuilder rexBuilder = aggregate.getCluster().getRexBuilder();
        RelMetadataQuery mq = RelMetadataQuery.instance();
        RelOptPredicateList predicates = mq.getPulledUpPredicates(aggregate.getInput());
        if (predicates == null) {
            return;
        }
        ImmutableMap<RexNode, RexNode> constants = ReduceExpressionsRule.predicateConstants(RexNode.class, rexBuilder, predicates);
        TreeMap<Integer, RexNode> map = new TreeMap<Integer, RexNode>();
        for (int key : aggregate.getGroupSet()) {
            RexInputRef ref = rexBuilder.makeInputRef(aggregate.getInput(), key);
            if (!constants.containsKey(ref)) continue;
            map.put(key, constants.get(ref));
        }
        if (map.isEmpty()) {
            return;
        }
        if (groupCount == map.size()) {
            map.remove(map.navigableKeySet().first());
        }
        ImmutableBitSet newGroupSet = aggregate.getGroupSet();
        Iterator key = map.keySet().iterator();
        while (key.hasNext()) {
            int key2 = (Integer)key.next();
            newGroupSet = newGroupSet.clear(key2);
        }
        int newGroupCount = newGroupSet.cardinality();
        RelBuilder relBuilder = call.builder();
        relBuilder.push((RelNode)input);
        ArrayList<AggregateCall> newAggCalls = new ArrayList<AggregateCall>();
        for (AggregateCall aggCall : aggregate.getAggCallList()) {
            newAggCalls.add(aggCall.adaptTo((RelNode)input, aggCall.getArgList(), aggCall.filterArg, groupCount, newGroupCount));
        }
        relBuilder.aggregate(relBuilder.groupKey(newGroupSet, false, (ImmutableList<ImmutableBitSet>)null), (List<AggregateCall>)newAggCalls);
        ArrayList<Pair<RexInputRef, String>> projects = new ArrayList<Pair<RexInputRef, String>>();
        int source = 0;
        for (RelDataTypeField field : aggregate.getRowType().getFieldList()) {
            RexNode expr;
            int i = field.getIndex();
            if (i >= groupCount) {
                expr = relBuilder.field(i - map.size());
            } else if (map.containsKey(i)) {
                expr = (RexNode)map.get(i);
            } else {
                expr = relBuilder.field(source);
                ++source;
            }
            projects.add(Pair.of(expr, field.getName()));
        }
        relBuilder.project(Pair.left(projects), Pair.right(projects));
        call.transformTo(relBuilder.build());
    }
}

