/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.jdbc;

import java.util.Map;
import org.apache.calcite.avatica.MetaImpl;
import org.apache.calcite.jdbc.CalciteMetaImpl;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.hive.com.google.common.collect.ImmutableMap;

class MetadataSchema
extends AbstractSchema {
    private static final Map<String, Table> TABLE_MAP = ImmutableMap.of("COLUMNS", new CalciteMetaImpl.MetadataTable<MetaImpl.MetaColumn>(MetaImpl.MetaColumn.class){

        @Override
        public Enumerator<MetaImpl.MetaColumn> enumerator(final CalciteMetaImpl meta) {
            String catalog = meta.getConnection().getCatalog();
            return meta.tables(catalog).selectMany(new Function1<MetaImpl.MetaTable, Enumerable<MetaImpl.MetaColumn>>(){

                @Override
                public Enumerable<MetaImpl.MetaColumn> apply(MetaImpl.MetaTable table) {
                    return meta.columns(table);
                }
            }).enumerator();
        }
    }, "TABLES", new CalciteMetaImpl.MetadataTable<MetaImpl.MetaTable>(MetaImpl.MetaTable.class){

        @Override
        public Enumerator<MetaImpl.MetaTable> enumerator(CalciteMetaImpl meta) {
            String catalog = meta.getConnection().getCatalog();
            return meta.tables(catalog).enumerator();
        }
    });
    public static final Schema INSTANCE = new MetadataSchema();

    private MetadataSchema() {
    }

    @Override
    protected Map<String, Table> getTableMap() {
        return TABLE_MAP;
    }
}

