/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql;

import java.util.Calendar;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.calcite.sql.SqlAbstractDateTimeLiteral;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNode;
import org.apache.hive.druid.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeName;

public class SqlTimeLiteral
extends SqlAbstractDateTimeLiteral {
    SqlTimeLiteral(Calendar t, int precision, boolean hasTimeZone, SqlParserPos pos) {
        this(t, precision, hasTimeZone, "HH:mm:ss", pos);
    }

    SqlTimeLiteral(Calendar t, int precision, boolean hasTimeZone, String format, SqlParserPos pos) {
        super(t, hasTimeZone, SqlTypeName.TIME, precision, format, pos);
        Preconditions.checkArgument(this.precision >= 0 && this.precision <= 3);
    }

    @Override
    public SqlNode clone(SqlParserPos pos) {
        return new SqlTimeLiteral((Calendar)this.value, this.precision, this.hasTimeZone, this.formatString, pos);
    }

    @Override
    public String toString() {
        return "TIME '" + this.toFormattedString() + "'";
    }

    @Override
    public String toFormattedString() {
        String result = this.getTime().toString(this.formatString);
        Calendar cal = this.getCal();
        if (this.precision > 0) {
            String digits = Long.toString(cal.getTimeInMillis());
            result = result + "." + digits.substring(digits.length() - 3, digits.length() - 3 + this.precision);
        } else assert (0 == cal.get(14));
        return result;
    }
}

