/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.adapter.enumerable;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.hive.druid.org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.hive.druid.org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.Expression;
import org.apache.hive.druid.org.apache.calcite.linq4j.tree.Expressions;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptCluster;
import org.apache.hive.druid.org.apache.calcite.plan.RelTraitSet;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.core.TableFunctionScan;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.RelColumnMapping;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rex.RexCall;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.schema.QueryableTable;
import org.apache.hive.druid.org.apache.calcite.schema.impl.TableFunctionImpl;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlUserDefinedTableFunction;
import org.apache.hive.druid.org.apache.calcite.util.BuiltInMethod;

public class EnumerableTableFunctionScan
extends TableFunctionScan
implements EnumerableRel {
    public EnumerableTableFunctionScan(RelOptCluster cluster, RelTraitSet traits, List<RelNode> inputs, Type elementType, RelDataType rowType, RexNode call, Set<RelColumnMapping> columnMappings) {
        super(cluster, traits, inputs, call, elementType, rowType, columnMappings);
    }

    @Override
    public EnumerableTableFunctionScan copy(RelTraitSet traitSet, List<RelNode> inputs, RexNode rexCall, Type elementType, RelDataType rowType, Set<RelColumnMapping> columnMappings) {
        return new EnumerableTableFunctionScan(this.getCluster(), traitSet, inputs, elementType, rowType, rexCall, columnMappings);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        JavaRowFormat format;
        BlockBuilder bb = new BlockBuilder();
        boolean array = false;
        if (this.getElementType() == null) {
            format = JavaRowFormat.ARRAY;
        } else if (this.rowType.getFieldCount() == 1 && this.isQueryable()) {
            format = JavaRowFormat.SCALAR;
        } else if (this.getElementType() instanceof Class && Object[].class.isAssignableFrom((Class)this.getElementType())) {
            array = true;
            format = JavaRowFormat.ARRAY;
        } else {
            format = JavaRowFormat.CUSTOM;
        }
        PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), format, false);
        RexToLixTranslator t = RexToLixTranslator.forAggregation((JavaTypeFactory)this.getCluster().getTypeFactory(), bb, null);
        t = t.setCorrelates(implementor.allCorrelateVariables);
        Expression translated = t.translate(this.getCall());
        if (array && this.rowType.getFieldCount() == 1) {
            translated = Expressions.call(null, BuiltInMethod.SLICE0.method, translated);
        }
        bb.add(Expressions.return_(null, translated));
        return implementor.result(physType, bb.toBlock());
    }

    private boolean isQueryable() {
        if (!(this.getCall() instanceof RexCall)) {
            return false;
        }
        RexCall call = (RexCall)this.getCall();
        if (!(call.getOperator() instanceof SqlUserDefinedTableFunction)) {
            return false;
        }
        SqlUserDefinedTableFunction udtf = (SqlUserDefinedTableFunction)call.getOperator();
        if (!(udtf.getFunction() instanceof TableFunctionImpl)) {
            return false;
        }
        TableFunctionImpl tableFunction = (TableFunctionImpl)udtf.getFunction();
        Method method = tableFunction.method;
        return QueryableTable.class.isAssignableFrom(method.getReturnType());
    }
}

