/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.lookup.cache;

import com.google.inject.Inject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Predicates;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.Collections2;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.com.google.common.net.HostAndPort;
import org.apache.hive.druid.com.google.common.util.concurrent.FutureCallback;
import org.apache.hive.druid.com.google.common.util.concurrent.Futures;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableScheduledFuture;
import org.apache.hive.druid.com.google.common.util.concurrent.ListeningScheduledExecutorService;
import org.apache.hive.druid.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hive.druid.com.metamx.common.IAE;
import org.apache.hive.druid.com.metamx.common.ISE;
import org.apache.hive.druid.com.metamx.common.StreamUtils;
import org.apache.hive.druid.com.metamx.common.StringUtils;
import org.apache.hive.druid.com.metamx.common.lifecycle.LifecycleStart;
import org.apache.hive.druid.com.metamx.common.lifecycle.LifecycleStop;
import org.apache.hive.druid.com.metamx.emitter.EmittingLogger;
import org.apache.hive.druid.com.metamx.http.client.HttpClient;
import org.apache.hive.druid.com.metamx.http.client.Request;
import org.apache.hive.druid.com.metamx.http.client.response.ClientResponse;
import org.apache.hive.druid.com.metamx.http.client.response.HttpResponseHandler;
import org.apache.hive.druid.com.metamx.http.client.response.SequenceInputStreamResponseHandler;
import org.apache.hive.druid.io.druid.audit.AuditInfo;
import org.apache.hive.druid.io.druid.common.config.JacksonConfigManager;
import org.apache.hive.druid.io.druid.concurrent.Execs;
import org.apache.hive.druid.io.druid.guice.annotations.Global;
import org.apache.hive.druid.io.druid.guice.annotations.Smile;
import org.apache.hive.druid.io.druid.query.lookup.LookupModule;
import org.apache.hive.druid.io.druid.server.listener.announcer.ListenerDiscoverer;
import org.apache.hive.druid.io.druid.server.lookup.cache.LookupCoordinatorManagerConfig;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpMethod;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpResponse;

public class LookupCoordinatorManager {
    public static final String LOOKUP_CONFIG_KEY = "lookups";
    public static final String LOOKUP_LISTEN_ANNOUNCE_KEY = "lookups";
    private static final EmittingLogger LOG = new EmittingLogger(LookupCoordinatorManager.class);
    private static final TypeReference<Map<String, Object>> MAP_STRING_OBJ_TYPE = new TypeReference<Map<String, Object>>(){};
    private static final Function<HostAndPort, URL> HOST_TO_URL = new Function<HostAndPort, URL>(){

        @Override
        @Nullable
        public URL apply(HostAndPort input) {
            if (input == null) {
                LOG.warn("null entry in lookups", new Object[0]);
                return null;
            }
            try {
                return LookupCoordinatorManager.getLookupsURL(input);
            }
            catch (MalformedURLException e) {
                LOG.warn(e, "Skipping node. Malformed URL from `%s`", input);
                return null;
            }
        }
    };
    private final ListeningScheduledExecutorService executorService;
    private final ListenerDiscoverer listenerDiscoverer;
    private final HttpClient httpClient;
    private final ObjectMapper smileMapper;
    private final JacksonConfigManager configManager;
    private final LookupCoordinatorManagerConfig lookupCoordinatorManagerConfig;
    private final Object startStopSync = new Object();
    private AtomicReference<Map<String, Map<String, Map<String, Object>>>> lookupMapConfigRef;
    private volatile Map<String, Map<String, Map<String, Object>>> prior_update = ImmutableMap.of();
    private volatile boolean started = false;
    private volatile ListenableScheduledFuture<?> backgroundManagerFuture = null;
    private final CountDownLatch backgroundManagerExitedLatch = new CountDownLatch(1);

    @Inject
    public LookupCoordinatorManager(@Global HttpClient httpClient, ListenerDiscoverer listenerDiscoverer, @Smile ObjectMapper smileMapper, JacksonConfigManager configManager, LookupCoordinatorManagerConfig lookupCoordinatorManagerConfig) {
        this.listenerDiscoverer = listenerDiscoverer;
        this.configManager = configManager;
        this.httpClient = httpClient;
        this.smileMapper = smileMapper;
        this.lookupCoordinatorManagerConfig = lookupCoordinatorManagerConfig;
        this.executorService = MoreExecutors.listeningDecorator(Executors.newScheduledThreadPool(lookupCoordinatorManagerConfig.getThreadPoolSize(), Execs.makeThreadFactory("LookupCoordinatorManager--%s")));
    }

    void deleteOnHost(URL url) throws ExecutionException, InterruptedException, IOException {
        AtomicInteger returnCode = new AtomicInteger(0);
        AtomicReference<Object> reasonString = new AtomicReference<Object>(null);
        LOG.debug("Dropping %s", url);
        try (InputStream result = (InputStream)this.httpClient.go(new Request(HttpMethod.DELETE, url).addHeader("Accept", "application/x-jackson-smile"), this.makeResponseHandler(returnCode, reasonString), this.lookupCoordinatorManagerConfig.getHostDeleteTimeout()).get();){
            if (!LookupCoordinatorManager.httpStatusIsSuccess(returnCode.get()) && !LookupCoordinatorManager.httpStatusIsNotFound(returnCode.get())) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    StreamUtils.copyAndClose(result, baos);
                }
                catch (IOException e2) {
                    LOG.warn(e2, "Error reading response from [%s]", url);
                }
                throw new IOException(String.format("Bad lookup delete request to [%s] : [%d] : [%s]  Response: [%s]", url, returnCode.get(), reasonString.get(), StringUtils.fromUtf8(baos.toByteArray())));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Delete to [%s] : Status: %s reason: [%s]", url, returnCode.get(), reasonString.get());
            }
        }
    }

    void updateAllOnHost(URL url, Map<String, Map<String, Object>> knownLookups) throws IOException, InterruptedException, ExecutionException {
        byte[] bytes;
        AtomicInteger returnCode = new AtomicInteger(0);
        AtomicReference<Object> reasonString = new AtomicReference<Object>(null);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Loading up %d lookups to %s", knownLookups.size(), url);
            }
            bytes = this.smileMapper.writeValueAsBytes(knownLookups);
        }
        catch (JsonProcessingException e) {
            throw Throwables.propagate(e);
        }
        try (InputStream result = (InputStream)this.httpClient.go(new Request(HttpMethod.POST, url).addHeader("Accept", "application/x-jackson-smile").addHeader("Content-Type", "application/x-jackson-smile").setContent(bytes), this.makeResponseHandler(returnCode, reasonString), this.lookupCoordinatorManagerConfig.getHostUpdateTimeout()).get();){
            Map resultMap;
            Object missingValuesObject;
            if (!LookupCoordinatorManager.httpStatusIsSuccess(returnCode.get())) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    StreamUtils.copyAndClose(result, baos);
                }
                catch (IOException e2) {
                    LOG.warn(e2, "Error reading response", new Object[0]);
                }
                throw new IOException(String.format("Bad update request to [%s] : [%d] : [%s]  Response: [%s]", url, returnCode.get(), reasonString.get(), StringUtils.fromUtf8(baos.toByteArray())));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Update on [%s], Status: %s reason: [%s]", url, returnCode.get(), reasonString.get());
            }
            if (null == (missingValuesObject = (resultMap = (Map)this.smileMapper.readValue(result, MAP_STRING_OBJ_TYPE)).get("failedUpdates"))) {
                throw new IAE("Update result did not have field for [%s]", "failedUpdates");
            }
            Map missingValues = (Map)this.smileMapper.convertValue(missingValuesObject, MAP_STRING_OBJ_TYPE);
            if (!missingValues.isEmpty()) {
                throw new IAE("Lookups failed to update: %s", this.smileMapper.writeValueAsString(missingValues.keySet()));
            }
            LOG.debug("Updated all lookups on [%s]", url);
        }
    }

    HttpResponseHandler<InputStream, InputStream> makeResponseHandler(final AtomicInteger returnCode, final AtomicReference<String> reasonString) {
        return new SequenceInputStreamResponseHandler(){

            @Override
            public ClientResponse<InputStream> handleResponse(HttpResponse response) {
                returnCode.set(response.getStatus().getCode());
                reasonString.set(response.getStatus().getReasonPhrase());
                return super.handleResponse(response);
            }
        };
    }

    void deleteAllOnTier(String tier, final Collection<String> dropLookups) throws ExecutionException, InterruptedException, IOException {
        if (dropLookups.isEmpty()) {
            LOG.debug("Nothing to drop", new Object[0]);
            return;
        }
        Collection<URL> urls = this.getAllHostsAnnounceEndpoint(tier);
        ArrayList futures = new ArrayList(urls.size());
        for (final URL url : urls) {
            futures.add(this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    for (String drop : dropLookups) {
                        URL lookupURL;
                        try {
                            lookupURL = new URL(url.getProtocol(), url.getHost(), url.getPort(), String.format("%s/%s", url.getFile(), drop));
                        }
                        catch (MalformedURLException e) {
                            throw new ISE(e, "Error creating url for [%s]/[%s]", url, drop);
                        }
                        try {
                            LookupCoordinatorManager.this.deleteOnHost(lookupURL);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            LOG.warn("Delete [%s] interrupted", lookupURL);
                            throw Throwables.propagate(e);
                        }
                        catch (IOException | ExecutionException e) {
                            LOG.makeAlert(e, "Error deleting [%s]", lookupURL).emit();
                        }
                    }
                }
            }));
        }
        ListenableFuture allFuture = Futures.allAsList(futures);
        try {
            allFuture.get(this.lookupCoordinatorManagerConfig.getUpdateAllTimeout().getMillis(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            allFuture.cancel(true);
            throw new ExecutionException("Timeout in updating hosts! Attempting to cancel", e);
        }
    }

    void updateAllNewOnTier(String tier, Map<String, Map<String, Object>> knownLookups) throws InterruptedException, ExecutionException, IOException {
        Collection<URL> urls = Collections2.transform(this.listenerDiscoverer.getNewNodes(LookupModule.getTierListenerPath(tier)), HOST_TO_URL);
        if (urls.isEmpty() || knownLookups.isEmpty()) {
            LOG.debug("Nothing new to report", new Object[0]);
            return;
        }
        this.updateNodes(urls, knownLookups);
    }

    void updateAllOnTier(String tier, Map<String, Map<String, Object>> knownLookups) throws InterruptedException, ExecutionException, IOException {
        this.updateNodes(this.getAllHostsAnnounceEndpoint(tier), knownLookups);
    }

    void updateNodes(Collection<URL> urls, final Map<String, Map<String, Object>> knownLookups) throws IOException, InterruptedException, ExecutionException {
        if (knownLookups == null) {
            LOG.debug("No config for lookups found", new Object[0]);
            return;
        }
        if (knownLookups.isEmpty()) {
            LOG.debug("No known lookups. Skipping update", new Object[0]);
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updating %d lookups on %d nodes", knownLookups.size(), urls.size());
        }
        ArrayList futures = new ArrayList(urls.size());
        for (final URL url : urls) {
            futures.add(this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        LookupCoordinatorManager.this.updateAllOnHost(url, knownLookups);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        LOG.warn("Update on [%s] interrupted", url);
                        throw Throwables.propagate(e);
                    }
                    catch (IOException | ExecutionException e) {
                        LOG.makeAlert(e, "Error submitting to [%s]", url).emit();
                    }
                }
            }));
        }
        ListenableFuture allFuture = Futures.allAsList(futures);
        try {
            allFuture.get(this.lookupCoordinatorManagerConfig.getUpdateAllTimeout().getMillis(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            LOG.warn("Timeout in updating hosts! Attempting to cancel", new Object[0]);
            allFuture.cancel(true);
        }
    }

    Collection<URL> getAllHostsAnnounceEndpoint(String tier) throws IOException {
        return ImmutableList.copyOf(Collections2.filter(Collections2.transform(this.listenerDiscoverer.getNodes(LookupModule.getTierListenerPath(tier)), HOST_TO_URL), Predicates.notNull()));
    }

    public boolean updateLookup(String tier, String lookupName, Map<String, Object> spec, AuditInfo auditInfo) {
        return this.updateLookups(ImmutableMap.of(tier, ImmutableMap.of(lookupName, spec)), auditInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateLookups(Map<String, Map<String, Map<String, Object>>> updateSpec, AuditInfo auditInfo) {
        Object object = this.startStopSync;
        synchronized (object) {
            Map<String, Map<String, Map<String, Object>>> updatedSpec;
            Map<String, Map<String, Map<String, Object>>> priorSpec = this.getKnownLookups();
            if (priorSpec == null && !updateSpec.isEmpty()) {
                throw new ISE("Not initialized. If this is the first lookup, post an empty map to initialize", new Object[0]);
            }
            if (priorSpec == null) {
                updatedSpec = updateSpec;
            } else {
                updatedSpec = new HashMap<String, Map<String, Map<String, Object>>>(priorSpec);
                for (String tier : updateSpec.keySet()) {
                    Map<String, Map<String, Object>> priorTierSpec = priorSpec.get(tier);
                    Map<String, Map<String, Object>> updateTierSpec = updateSpec.get(tier);
                    if (priorTierSpec == null) {
                        updatedSpec.put(tier, updateTierSpec);
                        continue;
                    }
                    HashMap<String, Map<String, Object>> updatedTierSpec = new HashMap<String, Map<String, Object>>(priorTierSpec);
                    updatedTierSpec.putAll(updateTierSpec);
                    updatedSpec.put(tier, updatedTierSpec);
                }
            }
            return this.configManager.set("lookups", updatedSpec, auditInfo);
        }
    }

    public Map<String, Map<String, Map<String, Object>>> getKnownLookups() {
        if (!this.started) {
            throw new ISE("Not started", new Object[0]);
        }
        return this.lookupMapConfigRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteLookup(String tier, String lookup, AuditInfo auditInfo) {
        Object object = this.startStopSync;
        synchronized (object) {
            Map<String, Map<String, Map<String, Object>>> priorSpec = this.getKnownLookups();
            if (priorSpec == null) {
                LOG.warn("Requested delete lookup [%s]/[%s]. But no lookups exist!", tier, lookup);
                return false;
            }
            HashMap<String, Map<String, Map<String, Object>>> updateSpec = new HashMap<String, Map<String, Map<String, Object>>>(priorSpec);
            Map priorTierSpec = (Map)updateSpec.get(tier);
            if (priorTierSpec == null) {
                LOG.warn("Requested delete of lookup [%s]/[%s] but tier does not exist!", tier, lookup);
                return false;
            }
            if (!priorTierSpec.containsKey(lookup)) {
                LOG.warn("Requested delete of lookup [%s]/[%s] but lookup does not exist!", tier, lookup);
                return false;
            }
            HashMap updateTierSpec = new HashMap(priorTierSpec);
            updateTierSpec.remove(lookup);
            updateSpec.put(tier, updateTierSpec);
            return this.configManager.set("lookups", updateSpec, auditInfo);
        }
    }

    public Collection<String> discoverTiers() {
        try {
            return this.listenerDiscoverer.discoverChildren("lookups");
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }

    @Nullable
    public Map<String, Object> getLookup(String tier, String lookupName) {
        Map<String, Map<String, Map<String, Object>>> prior = this.getKnownLookups();
        if (prior == null) {
            LOG.warn("Requested tier [%s] lookupName [%s]. But no lookups exist!", tier, lookupName);
            return null;
        }
        Map<String, Map<String, Object>> tierLookups = prior.get(tier);
        if (tierLookups == null) {
            LOG.warn("Tier [%s] does not exist", tier);
            return null;
        }
        return tierLookups.get(lookupName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() {
        Object object = this.startStopSync;
        synchronized (object) {
            if (this.started) {
                return;
            }
            if (this.executorService.isShutdown()) {
                throw new ISE("Cannot restart after stop!", new Object[0]);
            }
            this.lookupMapConfigRef = this.configManager.watch("lookups", new TypeReference<Map<String, Map<String, Map<String, Object>>>>(){}, null);
            this.backgroundManagerFuture = this.executorService.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    Map allLookupTiers = (Map)LookupCoordinatorManager.this.lookupMapConfigRef.get();
                    if (Thread.currentThread().isInterrupted()) {
                        LOG.info("Not updating lookups because process was interrupted", new Object[0]);
                        return;
                    }
                    if (!LookupCoordinatorManager.this.started) {
                        LOG.info("Not started. Returning", new Object[0]);
                        return;
                    }
                    if (allLookupTiers == null) {
                        LOG.info("Not updating lookups because no data exists", new Object[0]);
                        return;
                    }
                    for (String tier : allLookupTiers.keySet()) {
                        try {
                            Map allLookups = (Map)allLookupTiers.get(tier);
                            Map oldLookups = (Map)LookupCoordinatorManager.this.prior_update.get(tier);
                            AbstractCollection drops = oldLookups == null ? ImmutableList.of() : Sets.difference(oldLookups.keySet(), allLookups.keySet());
                            if (allLookupTiers == LookupCoordinatorManager.this.prior_update) {
                                LOG.debug("No updates", new Object[0]);
                                LookupCoordinatorManager.this.updateAllNewOnTier(tier, allLookups);
                                continue;
                            }
                            LookupCoordinatorManager.this.updateAllOnTier(tier, allLookups);
                            LookupCoordinatorManager.this.deleteAllOnTier(tier, drops);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw Throwables.propagate(e);
                        }
                        catch (Exception e) {
                            LOG.error(e, "Error updating lookups for tier [%s]. Will try again soon", tier);
                        }
                    }
                    LookupCoordinatorManager.this.prior_update = allLookupTiers;
                }
            }, 0L, this.lookupCoordinatorManagerConfig.getPeriod(), TimeUnit.MILLISECONDS);
            final ListenableScheduledFuture<?> backgroundManagerFuture = this.backgroundManagerFuture;
            Futures.addCallback(backgroundManagerFuture, new FutureCallback<Object>(){

                @Override
                public void onSuccess(@Nullable Object result) {
                    LookupCoordinatorManager.this.backgroundManagerExitedLatch.countDown();
                    LOG.debug("Exited background lookup manager", new Object[0]);
                }

                @Override
                public void onFailure(Throwable t) {
                    LookupCoordinatorManager.this.backgroundManagerExitedLatch.countDown();
                    if (backgroundManagerFuture.isCancelled()) {
                        LOG.info("Background lookup manager exited", new Object[0]);
                        LOG.trace(t, "Background lookup manager exited with throwable", new Object[0]);
                    } else {
                        LOG.makeAlert(t, "Background lookup manager exited with error!", new Object[0]).emit();
                    }
                }
            });
            this.started = true;
            LOG.debug("Started", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        Object object = this.startStopSync;
        synchronized (object) {
            if (!this.started) {
                LOG.warn("Not started, ignoring stop request", new Object[0]);
                return;
            }
            this.started = false;
            this.executorService.shutdownNow();
            ListenableScheduledFuture<?> backgroundManagerFuture = this.backgroundManagerFuture;
            this.backgroundManagerFuture = null;
            if (backgroundManagerFuture != null && !backgroundManagerFuture.cancel(true)) {
                LOG.warn("Background lookup manager thread could not be cancelled", new Object[0]);
            }
            LOG.debug("Stopped", new Object[0]);
        }
    }

    static URL getLookupsURL(HostAndPort druidNode) throws MalformedURLException {
        return new URL("http", druidNode.getHostText(), druidNode.getPortOrDefault(-1), "/druid/listen/v1/lookups");
    }

    private static boolean httpStatusIsSuccess(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }

    private static boolean httpStatusIsNotFound(int statusCode) {
        return statusCode == 404;
    }

    @VisibleForTesting
    boolean backgroundManagerIsRunning() {
        ListenableScheduledFuture<?> backgroundManagerFuture = this.backgroundManagerFuture;
        return backgroundManagerFuture != null && !backgroundManagerFuture.isDone();
    }

    @VisibleForTesting
    boolean waitForBackgroundTermination(long timeout) throws InterruptedException {
        return this.backgroundManagerExitedLatch.await(timeout, TimeUnit.MILLISECONDS);
    }
}

