/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.http;

import com.google.inject.Inject;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.metamx.common.ISE;
import org.apache.hive.druid.io.druid.client.indexing.IndexingService;
import org.apache.hive.druid.io.druid.client.selector.Server;
import org.apache.hive.druid.io.druid.curator.discovery.ServerDiscoverySelector;
import org.eclipse.jetty.proxy.ProxyServlet;

public class OverlordProxyServlet
extends ProxyServlet {
    private final ServerDiscoverySelector selector;

    @Inject
    OverlordProxyServlet(@IndexingService ServerDiscoverySelector selector) {
        this.selector = selector;
    }

    protected URI rewriteURI(HttpServletRequest request) {
        try {
            Server indexer = this.selector.pick();
            if (indexer == null) {
                throw new ISE("Can't find indexingService, did you configure druid.selectors.indexing.serviceName same as druid.service at overlord?", new Object[0]);
            }
            return new URI(request.getScheme(), indexer.getHost(), request.getRequestURI(), request.getQueryString(), null);
        }
        catch (URISyntaxException e) {
            throw Throwables.propagate(e);
        }
    }
}

