/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.loading;

import com.google.inject.Inject;
import java.util.Map;
import org.apache.hive.druid.com.metamx.common.MapUtils;
import org.apache.hive.druid.io.druid.segment.loading.DataSegmentKiller;
import org.apache.hive.druid.io.druid.segment.loading.SegmentLoadingException;
import org.apache.hive.druid.io.druid.timeline.DataSegment;

public class OmniDataSegmentKiller
implements DataSegmentKiller {
    private final Map<String, DataSegmentKiller> killers;

    @Inject
    public OmniDataSegmentKiller(Map<String, DataSegmentKiller> killers) {
        this.killers = killers;
    }

    @Override
    public void kill(DataSegment segment) throws SegmentLoadingException {
        this.getKiller(segment).kill(segment);
    }

    private DataSegmentKiller getKiller(DataSegment segment) throws SegmentLoadingException {
        String type = MapUtils.getString(segment.getLoadSpec(), "type");
        DataSegmentKiller loader = this.killers.get(type);
        if (loader == null) {
            throw new SegmentLoadingException("Unknown loader type[%s].  Known types are %s", type, this.killers.keySet());
        }
        return loader;
    }
}

