/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.io.druid.segment.data.CompressionFactory;
import org.apache.hive.druid.io.druid.segment.data.IndexedLongs;

public class EntireLayoutIndexedLongSupplier
implements Supplier<IndexedLongs> {
    private final int totalSize;
    private final CompressionFactory.LongEncodingReader reader;

    public EntireLayoutIndexedLongSupplier(int totalSize, CompressionFactory.LongEncodingReader reader) {
        this.totalSize = totalSize;
        this.reader = reader;
    }

    @Override
    public IndexedLongs get() {
        return new EntireLayoutIndexedLongs();
    }

    private class EntireLayoutIndexedLongs
    implements IndexedLongs {
        private EntireLayoutIndexedLongs() {
        }

        @Override
        public int size() {
            return EntireLayoutIndexedLongSupplier.this.totalSize;
        }

        @Override
        public long get(int index) {
            return EntireLayoutIndexedLongSupplier.this.reader.read(index);
        }

        @Override
        public void fill(int index, long[] toFill) {
            if (EntireLayoutIndexedLongSupplier.this.totalSize - index < toFill.length) {
                throw new IndexOutOfBoundsException(String.format("Cannot fill array of size[%,d] at index[%,d].  Max size[%,d]", toFill.length, index, EntireLayoutIndexedLongSupplier.this.totalSize));
            }
            for (int i = 0; i < toFill.length; ++i) {
                toFill[i] = this.get(index + i);
            }
        }

        public String toString() {
            return "EntireCompressedIndexedLongs_Anonymous{, totalSize=" + EntireLayoutIndexedLongSupplier.this.totalSize + '}';
        }

        @Override
        public void close() {
        }
    }
}

