/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import org.apache.hive.druid.com.metamx.common.IAE;
import org.apache.hive.druid.io.druid.segment.DimensionHandler;
import org.apache.hive.druid.io.druid.segment.StringDimensionHandler;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.io.druid.segment.column.ValueType;

public final class DimensionHandlerUtil {
    private DimensionHandlerUtil() {
    }

    public static DimensionHandler getHandlerFromCapabilities(String dimensionName, ColumnCapabilities capabilities) {
        StringDimensionHandler handler = null;
        if (capabilities.getType() == ValueType.STRING) {
            if (!capabilities.isDictionaryEncoded() || !capabilities.hasBitmapIndexes()) {
                throw new IAE("String column must have dictionary encoding and bitmap index.", new Object[0]);
            }
            handler = new StringDimensionHandler(dimensionName);
        }
        if (handler == null) {
            throw new IAE("Could not create handler from invalid column type: " + (Object)((Object)capabilities.getType()), new Object[0]);
        }
        return handler;
    }
}

