/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.spec;

import java.util.List;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.io.druid.common.utils.JodaUtils;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QuerySegmentWalker;
import org.apache.hive.druid.io.druid.query.SegmentDescriptor;
import org.apache.hive.druid.io.druid.query.spec.QuerySegmentSpec;
import org.joda.time.Interval;

public class MultipleSpecificSegmentSpec
implements QuerySegmentSpec {
    private final List<SegmentDescriptor> descriptors;
    private volatile List<Interval> intervals = null;

    @JsonCreator
    public MultipleSpecificSegmentSpec(@JsonProperty(value="segments") List<SegmentDescriptor> descriptors) {
        this.descriptors = descriptors;
    }

    @JsonProperty(value="segments")
    public List<SegmentDescriptor> getDescriptors() {
        return this.descriptors;
    }

    @Override
    public List<Interval> getIntervals() {
        if (this.intervals != null) {
            return this.intervals;
        }
        this.intervals = JodaUtils.condenseIntervals(Iterables.transform(this.descriptors, new Function<SegmentDescriptor, Interval>(){

            @Override
            public Interval apply(SegmentDescriptor input) {
                return input.getInterval();
            }
        }));
        return this.intervals;
    }

    @Override
    public <T> QueryRunner<T> lookup(Query<T> query, QuerySegmentWalker walker) {
        return walker.getQueryRunnerForSegments(query, this.descriptors);
    }

    public String toString() {
        return "MultipleSpecificSegmentSpec{descriptors=" + this.descriptors + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultipleSpecificSegmentSpec that = (MultipleSpecificSegmentSpec)o;
        if (this.descriptors != null ? !this.descriptors.equals(that.descriptors) : that.descriptors != null) {
            return false;
        }
        return !(this.intervals != null ? !this.intervals.equals(that.intervals) : that.intervals != null);
    }

    public int hashCode() {
        int result = this.descriptors != null ? this.descriptors.hashCode() : 0;
        result = 31 * result + (this.intervals != null ? this.intervals.hashCode() : 0);
        return result;
    }
}

