/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.lookup;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.metamx.common.ISE;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.io.druid.guice.annotations.Json;
import org.apache.hive.druid.io.druid.query.lookup.LookupBean;

public class LookupSnapshotTaker {
    private static final Logger LOGGER = new Logger(LookupSnapshotTaker.class);
    protected static final String PERSIST_FILE_NAME = "lookupSnapshot.json";
    private final ObjectMapper objectMapper;
    private final File persistDirectory;
    private final File persistFile;

    public LookupSnapshotTaker(@Json ObjectMapper jsonMapper, String persistDirectory) {
        this.objectMapper = jsonMapper;
        Preconditions.checkArgument(!Strings.isNullOrEmpty(persistDirectory), "can not work without specifying persistDirectory");
        this.persistDirectory = new File(persistDirectory);
        if (!this.persistDirectory.exists()) {
            Preconditions.checkArgument(this.persistDirectory.mkdirs(), "Oups was not able to create persist directory");
        }
        if (!this.persistDirectory.isDirectory()) {
            throw new ISE("Can only persist to directories, [%s] wasn't a directory", persistDirectory);
        }
        this.persistFile = new File(persistDirectory, PERSIST_FILE_NAME);
    }

    public synchronized List<LookupBean> pullExistingSnapshot() {
        try {
            if (!this.persistFile.isFile()) {
                LOGGER.warn("could not find any snapshot file under working directory [%s]", this.persistDirectory);
                return Collections.emptyList();
            }
            if (this.persistFile.length() == 0L) {
                LOGGER.warn("found empty file no lookups to load from [%s]", this.persistFile.getAbsolutePath());
                return Collections.emptyList();
            }
            List lookupBeanList = (List)this.objectMapper.readValue(this.persistFile, (TypeReference)new TypeReference<List<LookupBean>>(){});
            return lookupBeanList;
        }
        catch (IOException e) {
            throw new ISE(e, "Exception during reading lookups from [%s]", this.persistFile.getAbsolutePath());
        }
    }

    public synchronized void takeSnapshot(List<LookupBean> lookups) {
        try {
            this.objectMapper.writeValue(this.persistFile, lookups);
        }
        catch (IOException e) {
            throw new ISE(e, "Exception during serialization of lookups using file [%s]", this.persistFile.getAbsolutePath());
        }
    }

    public File getPersistFile() {
        return this.persistFile;
    }
}

