/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.groupby.epinephelinae;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;

public interface Grouper<KeyType extends Comparable<KeyType>>
extends Closeable {
    public boolean aggregate(KeyType var1, int var2);

    public boolean aggregate(KeyType var1);

    public void reset();

    @Override
    public void close();

    public Iterator<Entry<KeyType>> iterator(boolean var1);

    public static interface KeyComparator {
        public int compare(ByteBuffer var1, ByteBuffer var2, int var3, int var4);
    }

    public static interface KeySerde<T> {
        public int keySize();

        public Class<T> keyClazz();

        public ByteBuffer toByteBuffer(T var1);

        public T fromByteBuffer(ByteBuffer var1, int var2);

        public KeyComparator comparator();

        public void reset();
    }

    public static interface KeySerdeFactory<T> {
        public KeySerde<T> factorize();
    }

    public static class Entry<T> {
        final T key;
        final Object[] values;

        @JsonCreator
        public Entry(@JsonProperty(value="k") T key, @JsonProperty(value="v") Object[] values) {
            this.key = key;
            this.values = values;
        }

        @JsonProperty(value="k")
        public T getKey() {
            return this.key;
        }

        @JsonProperty(value="v")
        public Object[] getValues() {
            return this.values;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (!this.key.equals(entry.key)) {
                return false;
            }
            return Arrays.equals(this.values, entry.values);
        }

        public int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + Arrays.hashCode(this.values);
            return result;
        }

        public String toString() {
            return "Entry{key=" + this.key + ", values=" + Arrays.toString(this.values) + '}';
        }
    }
}

