/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.groupby;

import com.google.inject.Inject;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Functions;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.collect.Collections2;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.metamx.common.ISE;
import org.apache.hive.druid.com.metamx.common.guava.Sequence;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceMetricEvent;
import org.apache.hive.druid.io.druid.collections.StupidPool;
import org.apache.hive.druid.io.druid.data.input.MapBasedRow;
import org.apache.hive.druid.io.druid.data.input.Row;
import org.apache.hive.druid.io.druid.granularity.QueryGranularity;
import org.apache.hive.druid.io.druid.guice.annotations.Global;
import org.apache.hive.druid.io.druid.query.BaseQuery;
import org.apache.hive.druid.io.druid.query.CacheStrategy;
import org.apache.hive.druid.io.druid.query.DataSource;
import org.apache.hive.druid.io.druid.query.DruidMetrics;
import org.apache.hive.druid.io.druid.query.IntervalChunkingQueryRunnerDecorator;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryCacheHelper;
import org.apache.hive.druid.io.druid.query.QueryDataSource;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryToolChest;
import org.apache.hive.druid.io.druid.query.SubqueryQueryRunner;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.MetricManipulationFn;
import org.apache.hive.druid.io.druid.query.aggregation.MetricManipulatorFns;
import org.apache.hive.druid.io.druid.query.dimension.DefaultDimensionSpec;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.io.druid.query.filter.DimFilter;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQuery;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQueryConfig;
import org.apache.hive.druid.io.druid.query.groupby.strategy.GroupByStrategySelector;
import org.joda.time.DateTime;

public class GroupByQueryQueryToolChest
extends QueryToolChest<Row, GroupByQuery> {
    private static final byte GROUPBY_QUERY = 20;
    private static final TypeReference<Object> OBJECT_TYPE_REFERENCE = new TypeReference<Object>(){};
    private static final TypeReference<Row> TYPE_REFERENCE = new TypeReference<Row>(){};
    public static final String GROUP_BY_MERGE_KEY = "groupByMerge";
    private final Supplier<GroupByQueryConfig> configSupplier;
    private final GroupByStrategySelector strategySelector;
    private final StupidPool<ByteBuffer> bufferPool;
    private final IntervalChunkingQueryRunnerDecorator intervalChunkingQueryRunnerDecorator;

    @Inject
    public GroupByQueryQueryToolChest(Supplier<GroupByQueryConfig> configSupplier, GroupByStrategySelector strategySelector, @Global StupidPool<ByteBuffer> bufferPool, IntervalChunkingQueryRunnerDecorator intervalChunkingQueryRunnerDecorator) {
        this.configSupplier = configSupplier;
        this.strategySelector = strategySelector;
        this.bufferPool = bufferPool;
        this.intervalChunkingQueryRunnerDecorator = intervalChunkingQueryRunnerDecorator;
    }

    @Override
    public QueryRunner<Row> mergeResults(final QueryRunner<Row> runner) {
        return new QueryRunner<Row>(){

            @Override
            public Sequence<Row> run(Query<Row> query, Map<String, Object> responseContext) {
                if (BaseQuery.getContextBySegment(query, false)) {
                    return runner.run(query, responseContext);
                }
                if (query.getContextBoolean(GroupByQueryQueryToolChest.GROUP_BY_MERGE_KEY, true)) {
                    return GroupByQueryQueryToolChest.this.mergeGroupByResults((GroupByQuery)query, runner, responseContext);
                }
                return runner.run(query, responseContext);
            }
        };
    }

    private Sequence<Row> mergeGroupByResults(GroupByQuery query, QueryRunner<Row> runner, Map<String, Object> context) {
        DataSource dataSource = query.getDataSource();
        if (dataSource instanceof QueryDataSource) {
            GroupByQuery subquery;
            try {
                TreeMap<String, Object> subqueryContext = Maps.newTreeMap();
                if (query.getContext() != null) {
                    for (Map.Entry<String, Object> entry : query.getContext().entrySet()) {
                        if (entry.getValue() == null) continue;
                        subqueryContext.put(entry.getKey(), entry.getValue());
                    }
                }
                if (((QueryDataSource)dataSource).getQuery().getContext() != null) {
                    subqueryContext.putAll(((QueryDataSource)dataSource).getQuery().getContext());
                }
                subquery = (GroupByQuery)((QueryDataSource)dataSource).getQuery().withOverriddenContext(subqueryContext);
            }
            catch (ClassCastException e) {
                throw new UnsupportedOperationException("Subqueries must be of type 'group by'");
            }
            Sequence<Row> subqueryResult = this.mergeGroupByResults((GroupByQuery)subquery.withOverriddenContext(ImmutableMap.of("sortResults", false)), runner, context);
            return this.strategySelector.strategize(query).processSubqueryResult(subquery, query, subqueryResult);
        }
        return this.strategySelector.strategize(query).mergeResults(runner, query, context);
    }

    @Override
    public ServiceMetricEvent.Builder makeMetricBuilder(GroupByQuery query) {
        return DruidMetrics.makePartialQueryTimeMetric(query).setDimension("numDimensions", String.valueOf(query.getDimensions().size())).setDimension("numMetrics", String.valueOf(query.getAggregatorSpecs().size())).setDimension("numComplexMetrics", String.valueOf(DruidMetrics.findNumComplexAggs(query.getAggregatorSpecs())));
    }

    @Override
    public Function<Row, Row> makePreComputeManipulatorFn(final GroupByQuery query, final MetricManipulationFn fn) {
        if (MetricManipulatorFns.identity().equals(fn)) {
            return Functions.identity();
        }
        return new Function<Row, Row>(){

            @Override
            public Row apply(Row input) {
                if (input instanceof MapBasedRow) {
                    MapBasedRow inputRow = (MapBasedRow)input;
                    HashMap<String, Object> values = Maps.newHashMap(inputRow.getEvent());
                    for (AggregatorFactory agg : query.getAggregatorSpecs()) {
                        values.put(agg.getName(), fn.manipulate(agg, inputRow.getEvent().get(agg.getName())));
                    }
                    return new MapBasedRow(inputRow.getTimestamp(), values);
                }
                return input;
            }
        };
    }

    @Override
    public Function<Row, Row> makePostComputeManipulatorFn(GroupByQuery query, MetricManipulationFn fn) {
        final ImmutableSet<String> optimizedDims = ImmutableSet.copyOf(Iterables.transform(GroupByQueryQueryToolChest.extractionsToRewrite(query), new Function<DimensionSpec, String>(){

            @Override
            public String apply(DimensionSpec input) {
                return input.getOutputName();
            }
        }));
        final Function<Row, Row> preCompute = this.makePreComputeManipulatorFn(query, fn);
        if (optimizedDims.isEmpty()) {
            return preCompute;
        }
        final HashMap<String, ExtractionFn> extractionFnMap = new HashMap<String, ExtractionFn>();
        for (DimensionSpec dimensionSpec : query.getDimensions()) {
            String dimension = dimensionSpec.getOutputName();
            if (!optimizedDims.contains(dimension)) continue;
            extractionFnMap.put(dimension, dimensionSpec.getExtractionFn());
        }
        return new Function<Row, Row>(){

            @Override
            @Nullable
            public Row apply(Row input) {
                Row preRow = (Row)preCompute.apply(input);
                if (preRow instanceof MapBasedRow) {
                    MapBasedRow preMapRow = (MapBasedRow)preRow;
                    HashMap<String, Object> event = Maps.newHashMap(preMapRow.getEvent());
                    for (String dim : optimizedDims) {
                        Object eventVal = event.get(dim);
                        event.put(dim, ((ExtractionFn)extractionFnMap.get(dim)).apply(eventVal));
                    }
                    return new MapBasedRow(preMapRow.getTimestamp(), event);
                }
                return preRow;
            }
        };
    }

    @Override
    public TypeReference<Row> getResultTypeReference() {
        return TYPE_REFERENCE;
    }

    @Override
    public QueryRunner<Row> preMergeQueryDecoration(final QueryRunner<Row> runner) {
        return new SubqueryQueryRunner<Row>(this.intervalChunkingQueryRunnerDecorator.decorate(new QueryRunner<Row>(){

            @Override
            public Sequence<Row> run(Query<Row> query, Map<String, Object> responseContext) {
                GroupByQuery groupByQuery = (GroupByQuery)query;
                if (groupByQuery.getDimFilter() != null) {
                    groupByQuery = groupByQuery.withDimFilter(groupByQuery.getDimFilter().optimize());
                }
                GroupByQuery delegateGroupByQuery = groupByQuery;
                ArrayList<DimensionSpec> dimensionSpecs = new ArrayList<DimensionSpec>();
                ImmutableSet<String> optimizedDimensions = ImmutableSet.copyOf(Iterables.transform(GroupByQueryQueryToolChest.extractionsToRewrite(delegateGroupByQuery), new Function<DimensionSpec, String>(){

                    @Override
                    public String apply(DimensionSpec input) {
                        return input.getDimension();
                    }
                }));
                for (DimensionSpec dimensionSpec : delegateGroupByQuery.getDimensions()) {
                    if (optimizedDimensions.contains(dimensionSpec.getDimension())) {
                        dimensionSpecs.add(new DefaultDimensionSpec(dimensionSpec.getDimension(), dimensionSpec.getOutputName()));
                        continue;
                    }
                    dimensionSpecs.add(dimensionSpec);
                }
                return runner.run(delegateGroupByQuery.withDimensionSpecs(dimensionSpecs), responseContext);
            }
        }, this));
    }

    @Override
    public CacheStrategy<Row, Object, GroupByQuery> getCacheStrategy(final GroupByQuery query) {
        return new CacheStrategy<Row, Object, GroupByQuery>(){
            private static final byte CACHE_STRATEGY_VERSION = 1;
            private final List<AggregatorFactory> aggs;
            private final List<DimensionSpec> dims;
            {
                this.aggs = query.getAggregatorSpecs();
                this.dims = query.getDimensions();
            }

            @Override
            public byte[] computeCacheKey(GroupByQuery query2) {
                DimFilter dimFilter = query2.getDimFilter();
                byte[] filterBytes = dimFilter == null ? new byte[]{} : dimFilter.getCacheKey();
                byte[] aggregatorBytes = QueryCacheHelper.computeAggregatorBytes(query2.getAggregatorSpecs());
                byte[] granularityBytes = query2.getGranularity().cacheKey();
                byte[][] dimensionsBytes = new byte[query2.getDimensions().size()][];
                int dimensionsBytesSize = 0;
                int index = 0;
                for (DimensionSpec dimension : query2.getDimensions()) {
                    dimensionsBytes[index] = dimension.getCacheKey();
                    dimensionsBytesSize += dimensionsBytes[index].length;
                    ++index;
                }
                byte[] havingBytes = query2.getHavingSpec() == null ? new byte[]{} : query2.getHavingSpec().getCacheKey();
                byte[] limitBytes = query2.getLimitSpec().getCacheKey();
                ByteBuffer buffer = ByteBuffer.allocate(2 + granularityBytes.length + filterBytes.length + aggregatorBytes.length + dimensionsBytesSize + havingBytes.length + limitBytes.length).put((byte)20).put((byte)1).put(granularityBytes).put(filterBytes).put(aggregatorBytes);
                for (byte[] dimensionsByte : dimensionsBytes) {
                    buffer.put(dimensionsByte);
                }
                return buffer.put(havingBytes).put(limitBytes).array();
            }

            @Override
            public TypeReference<Object> getCacheObjectClazz() {
                return OBJECT_TYPE_REFERENCE;
            }

            @Override
            public Function<Row, Object> prepareForCache() {
                return new Function<Row, Object>(){

                    @Override
                    public Object apply(Row input) {
                        if (input instanceof MapBasedRow) {
                            MapBasedRow row = (MapBasedRow)input;
                            ArrayList<Object> retVal = Lists.newArrayListWithCapacity(1 + dims.size() + aggs.size());
                            retVal.add(row.getTimestamp().getMillis());
                            Map<String, Object> event = row.getEvent();
                            for (DimensionSpec dim : dims) {
                                retVal.add(event.get(dim.getOutputName()));
                            }
                            for (AggregatorFactory agg : aggs) {
                                retVal.add(event.get(agg.getName()));
                            }
                            return retVal;
                        }
                        throw new ISE("Don't know how to cache input rows of type[%s]", input.getClass());
                    }
                };
            }

            @Override
            public Function<Object, Row> pullFromCache() {
                return new Function<Object, Row>(){
                    private final QueryGranularity granularity;
                    {
                        this.granularity = query.getGranularity();
                    }

                    @Override
                    public Row apply(Object input) {
                        Iterator results = ((List)input).iterator();
                        DateTime timestamp = this.granularity.toDateTime(((Number)results.next()).longValue());
                        LinkedHashMap<String, Object> event = Maps.newLinkedHashMap();
                        Iterator dimsIter = dims.iterator();
                        while (dimsIter.hasNext() && results.hasNext()) {
                            DimensionSpec factory = (DimensionSpec)dimsIter.next();
                            event.put(factory.getOutputName(), results.next());
                        }
                        Iterator aggsIter = aggs.iterator();
                        while (aggsIter.hasNext() && results.hasNext()) {
                            AggregatorFactory factory = (AggregatorFactory)aggsIter.next();
                            event.put(factory.getName(), factory.deserialize(results.next()));
                        }
                        if (dimsIter.hasNext() || aggsIter.hasNext() || results.hasNext()) {
                            throw new ISE("Found left over objects while reading from cache!! dimsIter[%s] aggsIter[%s] results[%s]", dimsIter.hasNext(), aggsIter.hasNext(), results.hasNext());
                        }
                        return new MapBasedRow(timestamp, event);
                    }
                };
            }
        };
    }

    public static Collection<DimensionSpec> extractionsToRewrite(GroupByQuery query) {
        return Collections2.filter(query.getDimensions(), new Predicate<DimensionSpec>(){

            @Override
            public boolean apply(DimensionSpec input) {
                return input.getExtractionFn() != null && ExtractionFn.ExtractionType.ONE_TO_ONE.equals((Object)input.getExtractionFn().getExtractionType());
            }
        });
    }
}

