/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation.post;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.com.metamx.common.IAE;
import org.apache.hive.druid.io.druid.query.aggregation.PostAggregator;

public class ArithmeticPostAggregator
implements PostAggregator {
    public static final Comparator DEFAULT_COMPARATOR = new Comparator(){

        public int compare(Object o, Object o1) {
            return ((Double)o).compareTo((Double)o1);
        }
    };
    private final String name;
    private final String fnName;
    private final List<PostAggregator> fields;
    private final Ops op;
    private final Comparator comparator;
    private final String ordering;

    public ArithmeticPostAggregator(String name, String fnName, List<PostAggregator> fields) {
        this(name, fnName, fields, null);
    }

    @JsonCreator
    public ArithmeticPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="fn") String fnName, @JsonProperty(value="fields") List<PostAggregator> fields, @JsonProperty(value="ordering") String ordering) {
        Preconditions.checkArgument(fnName != null, "fn cannot not be null");
        Preconditions.checkArgument(fields != null && fields.size() > 1, "Illegal number of fields[%s], must be > 1");
        this.name = name;
        this.fnName = fnName;
        this.fields = fields;
        this.op = Ops.lookup(fnName);
        if (this.op == null) {
            throw new IAE("Unknown operation[%s], known operations[%s]", fnName, Ops.getFns());
        }
        this.ordering = ordering;
        this.comparator = ordering == null ? DEFAULT_COMPARATOR : Ordering.valueOf(ordering);
    }

    @Override
    public Set<String> getDependentFields() {
        HashSet<String> dependentFields = Sets.newHashSet();
        for (PostAggregator field : this.fields) {
            dependentFields.addAll(field.getDependentFields());
        }
        return dependentFields;
    }

    @Override
    public Comparator getComparator() {
        return this.comparator;
    }

    @Override
    public Object compute(Map<String, Object> values) {
        Iterator<PostAggregator> fieldsIter = this.fields.iterator();
        double retVal = 0.0;
        if (fieldsIter.hasNext()) {
            retVal = ((Number)fieldsIter.next().compute(values)).doubleValue();
            while (fieldsIter.hasNext()) {
                retVal = this.op.compute(retVal, ((Number)fieldsIter.next().compute(values)).doubleValue());
            }
        }
        return retVal;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="fn")
    public String getFnName() {
        return this.fnName;
    }

    @JsonProperty(value="ordering")
    public String getOrdering() {
        return this.ordering;
    }

    @JsonProperty
    public List<PostAggregator> getFields() {
        return this.fields;
    }

    public String toString() {
        return "ArithmeticPostAggregator{name='" + this.name + '\'' + ", fnName='" + this.fnName + '\'' + ", fields=" + this.fields + ", op=" + (Object)((Object)this.op) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArithmeticPostAggregator that = (ArithmeticPostAggregator)o;
        if (!this.comparator.equals(that.comparator)) {
            return false;
        }
        if (!this.fields.equals(that.fields)) {
            return false;
        }
        if (!this.fnName.equals(that.fnName)) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.op != that.op) {
            return false;
        }
        return !(this.ordering != null ? !this.ordering.equals(that.ordering) : that.ordering != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + this.fnName.hashCode();
        result = 31 * result + this.fields.hashCode();
        result = 31 * result + this.op.hashCode();
        result = 31 * result + this.comparator.hashCode();
        result = 31 * result + (this.ordering != null ? this.ordering.hashCode() : 0);
        return result;
    }

    public static enum Ordering implements Comparator<Double>
    {
        numericFirst{

            @Override
            public int compare(Double lhs, Double rhs) {
                if (this.isFinite(lhs) && !this.isFinite(rhs)) {
                    return 1;
                }
                if (!this.isFinite(lhs) && this.isFinite(rhs)) {
                    return -1;
                }
                return Double.compare(lhs, rhs);
            }

            private boolean isFinite(double value) {
                return !Double.isInfinite(value) && !Double.isNaN(value);
            }
        };

    }

    private static enum Ops {
        PLUS("+"){

            @Override
            public double compute(double lhs, double rhs) {
                return lhs + rhs;
            }
        }
        ,
        MINUS("-"){

            @Override
            public double compute(double lhs, double rhs) {
                return lhs - rhs;
            }
        }
        ,
        MULT("*"){

            @Override
            public double compute(double lhs, double rhs) {
                return lhs * rhs;
            }
        }
        ,
        DIV("/"){

            @Override
            public double compute(double lhs, double rhs) {
                return rhs == 0.0 ? 0.0 : lhs / rhs;
            }
        }
        ,
        QUOTIENT("quotient"){

            @Override
            public double compute(double lhs, double rhs) {
                return lhs / rhs;
            }
        };

        private static final Map<String, Ops> lookupMap;
        private final String fn;

        private Ops(String fn) {
            this.fn = fn;
        }

        public String getFn() {
            return this.fn;
        }

        public abstract double compute(double var1, double var3);

        static Ops lookup(String fn) {
            return lookupMap.get(fn);
        }

        static Set<String> getFns() {
            return lookupMap.keySet();
        }

        static {
            lookupMap = Maps.newHashMap();
            for (Ops op : Ops.values()) {
                lookupMap.put(op.getFn(), op);
            }
        }
    }
}

