/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation;

import java.util.List;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.io.druid.segment.ObjectColumnSelector;

public class JavaScriptAggregator
implements Aggregator {
    private final String name;
    private final ObjectColumnSelector[] selectorList;
    private final ScriptAggregator script;
    private volatile double current;

    public JavaScriptAggregator(String name, List<ObjectColumnSelector> selectorList, ScriptAggregator script) {
        this.name = name;
        this.selectorList = Lists.newArrayList(selectorList).toArray(new ObjectColumnSelector[0]);
        this.script = script;
        this.current = script.reset();
    }

    @Override
    public void aggregate() {
        this.current = this.script.aggregate(this.current, this.selectorList);
    }

    @Override
    public void reset() {
        this.current = this.script.reset();
    }

    @Override
    public Object get() {
        return this.current;
    }

    @Override
    public float getFloat() {
        return (float)this.current;
    }

    @Override
    public long getLong() {
        return (long)this.current;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void close() {
        this.script.close();
    }

    static interface ScriptAggregator {
        public double aggregate(double var1, ObjectColumnSelector[] var3);

        public double combine(double var1, double var3);

        public double reset();

        public void close();
    }
}

