/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.metadata;

import com.google.inject.Inject;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.metamx.common.lifecycle.Lifecycle;
import org.apache.hive.druid.io.druid.metadata.MetadataSegmentManager;
import org.apache.hive.druid.io.druid.metadata.MetadataSegmentManagerConfig;
import org.apache.hive.druid.io.druid.metadata.MetadataSegmentManagerProvider;
import org.apache.hive.druid.io.druid.metadata.MetadataStorageTablesConfig;
import org.apache.hive.druid.io.druid.metadata.SQLMetadataConnector;
import org.apache.hive.druid.io.druid.metadata.SQLMetadataSegmentManager;

public class SQLMetadataSegmentManagerProvider
implements MetadataSegmentManagerProvider {
    private final ObjectMapper jsonMapper;
    private final Supplier<MetadataSegmentManagerConfig> config;
    private final Supplier<MetadataStorageTablesConfig> storageConfig;
    private final SQLMetadataConnector connector;
    private final Lifecycle lifecycle;

    @Inject
    public SQLMetadataSegmentManagerProvider(ObjectMapper jsonMapper, Supplier<MetadataSegmentManagerConfig> config, Supplier<MetadataStorageTablesConfig> storageConfig, SQLMetadataConnector connector, Lifecycle lifecycle) {
        this.jsonMapper = jsonMapper;
        this.config = config;
        this.storageConfig = storageConfig;
        this.connector = connector;
        this.lifecycle = lifecycle;
    }

    @Override
    public MetadataSegmentManager get() {
        this.lifecycle.addHandler(new Lifecycle.Handler(){

            @Override
            public void start() throws Exception {
                SQLMetadataSegmentManagerProvider.this.connector.createSegmentTable();
            }

            @Override
            public void stop() {
            }
        });
        return new SQLMetadataSegmentManager(this.jsonMapper, this.config, this.storageConfig, this.connector);
    }
}

