/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.math.expr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.hive.druid.io.druid.math.expr.BinAndExpr;
import org.apache.hive.druid.io.druid.math.expr.BinDivExpr;
import org.apache.hive.druid.io.druid.math.expr.BinEqExpr;
import org.apache.hive.druid.io.druid.math.expr.BinGeqExpr;
import org.apache.hive.druid.io.druid.math.expr.BinGtExpr;
import org.apache.hive.druid.io.druid.math.expr.BinLeqExpr;
import org.apache.hive.druid.io.druid.math.expr.BinLtExpr;
import org.apache.hive.druid.io.druid.math.expr.BinMinusExpr;
import org.apache.hive.druid.io.druid.math.expr.BinModuloExpr;
import org.apache.hive.druid.io.druid.math.expr.BinMulExpr;
import org.apache.hive.druid.io.druid.math.expr.BinNeqExpr;
import org.apache.hive.druid.io.druid.math.expr.BinOrExpr;
import org.apache.hive.druid.io.druid.math.expr.BinPlusExpr;
import org.apache.hive.druid.io.druid.math.expr.BinPowExpr;
import org.apache.hive.druid.io.druid.math.expr.DoubleExpr;
import org.apache.hive.druid.io.druid.math.expr.Expr;
import org.apache.hive.druid.io.druid.math.expr.FunctionExpr;
import org.apache.hive.druid.io.druid.math.expr.IdentifierExpr;
import org.apache.hive.druid.io.druid.math.expr.LongExpr;
import org.apache.hive.druid.io.druid.math.expr.Parser;
import org.apache.hive.druid.io.druid.math.expr.UnaryMinusExpr;
import org.apache.hive.druid.io.druid.math.expr.UnaryNotExpr;
import org.apache.hive.druid.io.druid.math.expr.antlr.ExprBaseListener;
import org.apache.hive.druid.io.druid.math.expr.antlr.ExprParser;

public class ExprListenerImpl
extends ExprBaseListener {
    private final Map<ParseTree, Object> nodes;
    private final ParseTree rootNodeKey;

    ExprListenerImpl(ParseTree rootNodeKey) {
        this.rootNodeKey = rootNodeKey;
        this.nodes = new HashMap<ParseTree, Object>();
    }

    Expr getAST() {
        return (Expr)this.nodes.get(this.rootNodeKey);
    }

    @Override
    public void exitUnaryOpExpr(ExprParser.UnaryOpExprContext ctx) {
        int opCode = ((TerminalNode)ctx.getChild(0)).getSymbol().getType();
        switch (opCode) {
            case 8: {
                this.nodes.put((ParseTree)ctx, new UnaryMinusExpr((Expr)this.nodes.get(ctx.getChild(1))));
                break;
            }
            case 9: {
                this.nodes.put((ParseTree)ctx, new UnaryNotExpr((Expr)this.nodes.get(ctx.getChild(1))));
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized unary operator " + ctx.getChild(0).getText());
            }
        }
    }

    @Override
    public void exitDoubleExpr(ExprParser.DoubleExprContext ctx) {
        this.nodes.put((ParseTree)ctx, new DoubleExpr(Double.parseDouble(ctx.getText())));
    }

    @Override
    public void exitAddSubExpr(ExprParser.AddSubExprContext ctx) {
        int opCode = ((TerminalNode)ctx.getChild(1)).getSymbol().getType();
        switch (opCode) {
            case 14: {
                this.nodes.put((ParseTree)ctx, new BinPlusExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            case 8: {
                this.nodes.put((ParseTree)ctx, new BinMinusExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized binary operator " + ctx.getChild(1).getText());
            }
        }
    }

    @Override
    public void exitLongExpr(ExprParser.LongExprContext ctx) {
        this.nodes.put((ParseTree)ctx, new LongExpr(Long.parseLong(ctx.getText())));
    }

    @Override
    public void exitLogicalAndOrExpr(ExprParser.LogicalAndOrExprContext ctx) {
        int opCode = ((TerminalNode)ctx.getChild(1)).getSymbol().getType();
        switch (opCode) {
            case 21: {
                this.nodes.put((ParseTree)ctx, new BinAndExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            case 22: {
                this.nodes.put((ParseTree)ctx, new BinOrExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized binary operator " + ctx.getChild(1).getText());
            }
        }
    }

    @Override
    public void exitNestedExpr(ExprParser.NestedExprContext ctx) {
        this.nodes.put((ParseTree)ctx, this.nodes.get(ctx.getChild(1)));
    }

    @Override
    public void exitLogicalOpExpr(ExprParser.LogicalOpExprContext ctx) {
        int opCode = ((TerminalNode)ctx.getChild(1)).getSymbol().getType();
        switch (opCode) {
            case 15: {
                this.nodes.put((ParseTree)ctx, new BinLtExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            case 16: {
                this.nodes.put((ParseTree)ctx, new BinLeqExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            case 17: {
                this.nodes.put((ParseTree)ctx, new BinGtExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            case 18: {
                this.nodes.put((ParseTree)ctx, new BinGeqExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            case 19: {
                this.nodes.put((ParseTree)ctx, new BinEqExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            case 20: {
                this.nodes.put((ParseTree)ctx, new BinNeqExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized binary operator " + ctx.getChild(1).getText());
            }
        }
    }

    @Override
    public void exitMulDivModuloExpr(ExprParser.MulDivModuloExprContext ctx) {
        int opCode = ((TerminalNode)ctx.getChild(1)).getSymbol().getType();
        switch (opCode) {
            case 11: {
                this.nodes.put((ParseTree)ctx, new BinMulExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            case 12: {
                this.nodes.put((ParseTree)ctx, new BinDivExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            case 13: {
                this.nodes.put((ParseTree)ctx, new BinModuloExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized binary operator " + ctx.getChild(1).getText());
            }
        }
    }

    @Override
    public void exitPowOpExpr(ExprParser.PowOpExprContext ctx) {
        this.nodes.put((ParseTree)ctx, new BinPowExpr(ctx.getChild(1).getText(), (Expr)this.nodes.get(ctx.getChild(0)), (Expr)this.nodes.get(ctx.getChild(2))));
    }

    @Override
    public void exitFunctionExpr(ExprParser.FunctionExprContext ctx) {
        String fnName = ctx.getChild(0).getText();
        if (!Parser.func.containsKey(fnName)) {
            throw new RuntimeException("function " + fnName + " is not defined.");
        }
        List args = ctx.getChildCount() > 3 ? (List)this.nodes.get(ctx.getChild(2)) : Collections.emptyList();
        this.nodes.put((ParseTree)ctx, new FunctionExpr(fnName, args));
    }

    @Override
    public void exitIdentifierExpr(ExprParser.IdentifierExprContext ctx) {
        this.nodes.put((ParseTree)ctx, new IdentifierExpr(ctx.getText()));
    }

    @Override
    public void exitFunctionArgs(ExprParser.FunctionArgsContext ctx) {
        ArrayList<Expr> args = new ArrayList<Expr>();
        args.add((Expr)this.nodes.get(ctx.getChild(0)));
        if (ctx.getChildCount() > 1) {
            for (int i = 1; i <= ctx.getChildCount() / 2; ++i) {
                args.add((Expr)this.nodes.get(ctx.getChild(2 * i)));
            }
        }
        this.nodes.put((ParseTree)ctx, args);
    }
}

