/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid.serde;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.hadoop.hive.druid.DruidStorageHandlerUtils;
import org.apache.hadoop.hive.druid.serde.DruidQueryRecordReader;
import org.apache.hadoop.hive.druid.serde.DruidWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQuery;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesResultValue;

public class DruidTimeseriesQueryRecordReader
extends DruidQueryRecordReader<TimeseriesQuery, Result<TimeseriesResultValue>> {
    private Result<TimeseriesResultValue> current;

    @Override
    protected TimeseriesQuery createQuery(String content) throws IOException {
        return DruidStorageHandlerUtils.JSON_MAPPER.readValue(content, TimeseriesQuery.class);
    }

    @Override
    protected List<Result<TimeseriesResultValue>> createResultsList(InputStream content) throws IOException {
        return (List)DruidStorageHandlerUtils.SMILE_MAPPER.readValue(content, (TypeReference)new TypeReference<List<Result<TimeseriesResultValue>>>(){});
    }

    @Override
    public boolean nextKeyValue() {
        if (this.results.hasNext()) {
            this.current = (Result)this.results.next();
            return true;
        }
        return false;
    }

    @Override
    public NullWritable getCurrentKey() throws IOException, InterruptedException {
        return NullWritable.get();
    }

    @Override
    public DruidWritable getCurrentValue() throws IOException, InterruptedException {
        DruidWritable value = new DruidWritable();
        value.getValue().put("__time", this.current.getTimestamp().getMillis());
        value.getValue().putAll(this.current.getValue().getBaseObject());
        return value;
    }

    @Override
    public boolean next(NullWritable key, DruidWritable value) {
        if (this.nextKeyValue()) {
            value.getValue().clear();
            value.getValue().put("__time", this.current.getTimestamp().getMillis());
            value.getValue().putAll(this.current.getValue().getBaseObject());
            return true;
        }
        return false;
    }

    @Override
    public float getProgress() throws IOException {
        return this.results.hasNext() ? 0.0f : 1.0f;
    }
}

