/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid.serde;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.druid.DruidStorageHandlerUtils;
import org.apache.hadoop.hive.druid.serde.DruidSerDeUtils;
import org.apache.hadoop.hive.druid.serde.DruidWritable;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeSpec;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.ShortWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.metamx.common.lifecycle.Lifecycle;
import org.apache.hive.druid.com.metamx.http.client.HttpClient;
import org.apache.hive.druid.com.metamx.http.client.HttpClientConfig;
import org.apache.hive.druid.com.metamx.http.client.HttpClientInit;
import org.apache.hive.druid.io.druid.query.Druids;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.PostAggregator;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQuery;
import org.apache.hive.druid.io.druid.query.metadata.metadata.ColumnAnalysis;
import org.apache.hive.druid.io.druid.query.metadata.metadata.SegmentAnalysis;
import org.apache.hive.druid.io.druid.query.metadata.metadata.SegmentMetadataQuery;
import org.apache.hive.druid.io.druid.query.select.SelectQuery;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQuery;
import org.apache.hive.druid.io.druid.query.topn.TopNQuery;
import org.joda.time.Period;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SerDeSpec(schemaProps={"druid.datasource"})
public class DruidSerDe
extends AbstractSerDe {
    protected static final Logger LOG = LoggerFactory.getLogger(DruidSerDe.class);
    private int numConnection;
    private Period readTimeout;
    private String[] columns;
    private PrimitiveTypeInfo[] types;
    private ObjectInspector inspector;

    public void initialize(Configuration configuration, Properties properties) throws SerDeException {
        this.numConnection = HiveConf.getIntVar((Configuration)configuration, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_NUM_HTTP_CONNECTION);
        this.readTimeout = new Period((Object)HiveConf.getVar((Configuration)configuration, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_HTTP_READ_TIMEOUT));
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<PrimitiveTypeInfo> columnTypes = new ArrayList<PrimitiveTypeInfo>();
        ArrayList<Object> inspectors = new ArrayList<Object>();
        String druidQuery = properties.getProperty("druid.query.json");
        if (druidQuery == null) {
            if (!org.apache.commons.lang3.StringUtils.isEmpty(properties.getProperty("columns")) && !org.apache.commons.lang3.StringUtils.isEmpty(properties.getProperty("columns.types"))) {
                columnNames.addAll(Utilities.getColumnNames((Properties)properties));
                if (!columnNames.contains("__time")) {
                    throw new SerDeException("Timestamp column (' __time') not specified in create table; list of columns is : " + properties.getProperty("columns"));
                }
                columnTypes.addAll(Lists.transform(Utilities.getColumnTypes((Properties)properties), new Function<String, PrimitiveTypeInfo>(){

                    @Override
                    public PrimitiveTypeInfo apply(String type) {
                        return TypeInfoFactory.getPrimitiveTypeInfo((String)type);
                    }
                }));
                inspectors.addAll(Lists.transform(columnTypes, new Function<PrimitiveTypeInfo, ObjectInspector>(){

                    @Override
                    public ObjectInspector apply(PrimitiveTypeInfo type) {
                        return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)type);
                    }
                }));
                this.columns = columnNames.toArray(new String[columnNames.size()]);
                this.types = columnTypes.toArray(new PrimitiveTypeInfo[columnTypes.size()]);
                this.inspector = ObjectInspectorFactory.getStandardStructObjectInspector(columnNames, inspectors);
            } else {
                SegmentAnalysis schemaInfo;
                String dataSource = properties.getProperty("druid.datasource");
                if (dataSource == null) {
                    throw new SerDeException("Druid data source not specified; use druid.datasource in table properties");
                }
                Druids.SegmentMetadataQueryBuilder builder = new Druids.SegmentMetadataQueryBuilder();
                builder.dataSource(dataSource);
                builder.merge(true);
                builder.analysisTypes(new SegmentMetadataQuery.AnalysisType[0]);
                SegmentMetadataQuery query = builder.build();
                String address = HiveConf.getVar((Configuration)configuration, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_BROKER_DEFAULT_ADDRESS);
                if (org.apache.commons.lang3.StringUtils.isEmpty(address)) {
                    throw new SerDeException("Druid broker address not specified in configuration");
                }
                try {
                    schemaInfo = this.submitMetadataRequest(address, query);
                }
                catch (IOException e) {
                    throw new SerDeException((Throwable)e);
                }
                for (Map.Entry<String, ColumnAnalysis> columnInfo : schemaInfo.getColumns().entrySet()) {
                    PrimitiveTypeInfo type;
                    if (columnInfo.getKey().equals("__time")) {
                        columnNames.add(columnInfo.getKey());
                        type = TypeInfoFactory.timestampTypeInfo;
                        columnTypes.add(type);
                        inspectors.add(PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)type));
                        continue;
                    }
                    columnNames.add(columnInfo.getKey());
                    type = DruidSerDeUtils.convertDruidToHiveType(columnInfo.getValue().getType());
                    columnTypes.add(type);
                    inspectors.add(PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)type));
                }
                this.columns = columnNames.toArray(new String[columnNames.size()]);
                this.types = columnTypes.toArray(new PrimitiveTypeInfo[columnTypes.size()]);
                this.inspector = ObjectInspectorFactory.getStandardStructObjectInspector(columnNames, inspectors);
            }
        } else {
            try {
                Query query = DruidStorageHandlerUtils.JSON_MAPPER.readValue(druidQuery, Query.class);
                switch (query.getType()) {
                    case "timeseries": {
                        this.inferSchema((TimeseriesQuery)query, columnNames, columnTypes);
                        break;
                    }
                    case "topN": {
                        this.inferSchema((TopNQuery)query, columnNames, columnTypes);
                        break;
                    }
                    case "select": {
                        String address = HiveConf.getVar((Configuration)configuration, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_BROKER_DEFAULT_ADDRESS);
                        if (org.apache.commons.lang3.StringUtils.isEmpty(address)) {
                            throw new SerDeException("Druid broker address not specified in configuration");
                        }
                        this.inferSchema((SelectQuery)query, columnNames, columnTypes, address);
                        break;
                    }
                    case "groupBy": {
                        this.inferSchema((GroupByQuery)query, columnNames, columnTypes);
                        break;
                    }
                    default: {
                        throw new SerDeException("Not supported Druid query");
                    }
                }
            }
            catch (Exception e) {
                throw new SerDeException((Throwable)e);
            }
            this.columns = new String[columnNames.size()];
            this.types = new PrimitiveTypeInfo[columnNames.size()];
            for (int i = 0; i < columnTypes.size(); ++i) {
                this.columns[i] = (String)columnNames.get(i);
                this.types[i] = (PrimitiveTypeInfo)columnTypes.get(i);
                inspectors.add(PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)this.types[i]));
            }
            this.inspector = ObjectInspectorFactory.getStandardStructObjectInspector(columnNames, inspectors);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("DruidSerDe initialized with\n\t columns: " + columnNames + "\n\t types: " + columnTypes);
        }
    }

    protected SegmentAnalysis submitMetadataRequest(String address, SegmentMetadataQuery query) throws SerDeException, IOException {
        List resultsList;
        InputStream response;
        Lifecycle lifecycle = new Lifecycle();
        HttpClient client = HttpClientInit.createClient(HttpClientConfig.builder().withNumConnections(this.numConnection).withReadTimeout(this.readTimeout.toStandardDuration()).build(), lifecycle);
        try {
            lifecycle.start();
            response = DruidStorageHandlerUtils.submitRequest(client, DruidStorageHandlerUtils.createRequest(address, query));
        }
        catch (Exception e) {
            throw new SerDeException(StringUtils.stringifyException((Throwable)e));
        }
        finally {
            lifecycle.stop();
        }
        try {
            resultsList = (List)DruidStorageHandlerUtils.SMILE_MAPPER.readValue(response, (TypeReference)new TypeReference<List<SegmentAnalysis>>(){});
        }
        catch (Exception e) {
            response.close();
            throw new SerDeException(StringUtils.stringifyException((Throwable)e));
        }
        if (resultsList == null || resultsList.isEmpty()) {
            throw new SerDeException("Connected to Druid but could not retrieve datasource information");
        }
        if (resultsList.size() != 1) {
            throw new SerDeException("Information about segments should have been merged");
        }
        return (SegmentAnalysis)resultsList.get(0);
    }

    private void inferSchema(TimeseriesQuery query, List<String> columnNames, List<PrimitiveTypeInfo> columnTypes) {
        columnNames.add("__time");
        columnTypes.add(TypeInfoFactory.timestampTypeInfo);
        for (AggregatorFactory af : query.getAggregatorSpecs()) {
            columnNames.add(af.getName());
            columnTypes.add(DruidSerDeUtils.convertDruidToHiveType(af.getTypeName()));
        }
        for (PostAggregator pa : query.getPostAggregatorSpecs()) {
            columnNames.add(pa.getName());
            columnTypes.add(TypeInfoFactory.floatTypeInfo);
        }
    }

    private void inferSchema(TopNQuery query, List<String> columnNames, List<PrimitiveTypeInfo> columnTypes) {
        columnNames.add("__time");
        columnTypes.add(TypeInfoFactory.timestampTypeInfo);
        columnNames.add(query.getDimensionSpec().getOutputName());
        columnTypes.add(TypeInfoFactory.stringTypeInfo);
        for (AggregatorFactory af : query.getAggregatorSpecs()) {
            columnNames.add(af.getName());
            columnTypes.add(DruidSerDeUtils.convertDruidToHiveType(af.getTypeName()));
        }
        for (PostAggregator pa : query.getPostAggregatorSpecs()) {
            columnNames.add(pa.getName());
            columnTypes.add(TypeInfoFactory.floatTypeInfo);
        }
    }

    private void inferSchema(SelectQuery query, List<String> columnNames, List<PrimitiveTypeInfo> columnTypes, String address) throws SerDeException {
        SegmentAnalysis schemaInfo;
        columnNames.add("__time");
        columnTypes.add(TypeInfoFactory.timestampTypeInfo);
        for (DimensionSpec ds : query.getDimensions()) {
            columnNames.add(ds.getOutputName());
            columnTypes.add(TypeInfoFactory.stringTypeInfo);
        }
        Druids.SegmentMetadataQueryBuilder builder = new Druids.SegmentMetadataQueryBuilder();
        builder.dataSource(query.getDataSource());
        builder.merge(true);
        builder.analysisTypes(new SegmentMetadataQuery.AnalysisType[0]);
        SegmentMetadataQuery metadataQuery = builder.build();
        try {
            schemaInfo = this.submitMetadataRequest(address, metadataQuery);
        }
        catch (IOException e) {
            throw new SerDeException((Throwable)e);
        }
        if (schemaInfo == null) {
            throw new SerDeException("Connected to Druid but could not retrieve datasource information");
        }
        for (String metric : query.getMetrics()) {
            columnNames.add(metric);
            columnTypes.add(DruidSerDeUtils.convertDruidToHiveType(schemaInfo.getColumns().get(metric).getType()));
        }
    }

    private void inferSchema(GroupByQuery query, List<String> columnNames, List<PrimitiveTypeInfo> columnTypes) {
        columnNames.add("__time");
        columnTypes.add(TypeInfoFactory.timestampTypeInfo);
        for (DimensionSpec ds : query.getDimensions()) {
            columnNames.add(ds.getOutputName());
            columnTypes.add(TypeInfoFactory.stringTypeInfo);
        }
        for (AggregatorFactory af : query.getAggregatorSpecs()) {
            columnNames.add(af.getName());
            columnTypes.add(DruidSerDeUtils.convertDruidToHiveType(af.getTypeName()));
        }
        for (PostAggregator pa : query.getPostAggregatorSpecs()) {
            columnNames.add(pa.getName());
            columnTypes.add(TypeInfoFactory.floatTypeInfo);
        }
    }

    public Class<? extends Writable> getSerializedClass() {
        return DruidWritable.class;
    }

    public Writable serialize(Object o, ObjectInspector objectInspector) throws SerDeException {
        if (objectInspector.getCategory() != ObjectInspector.Category.STRUCT) {
            throw new SerDeException(((Object)((Object)this)).getClass().toString() + " can only serialize struct types, but we got: " + objectInspector.getTypeName());
        }
        StructObjectInspector soi = (StructObjectInspector)objectInspector;
        List fields = soi.getAllStructFieldRefs();
        List values = soi.getStructFieldsDataAsList(o);
        HashMap<String, Object> value = new HashMap<String, Object>();
        for (int i = 0; i < this.columns.length; ++i) {
            Object res;
            if (values.get(i) == null) {
                value.put(this.columns[i], null);
                continue;
            }
            switch (this.types[i].getPrimitiveCategory()) {
                case TIMESTAMP: {
                    res = ((TimestampObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).getPrimitiveJavaObject(values.get(i)).getTime();
                    break;
                }
                case BYTE: {
                    res = ((ByteObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).get(values.get(i));
                    break;
                }
                case SHORT: {
                    res = ((ShortObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).get(values.get(i));
                    break;
                }
                case INT: {
                    res = ((IntObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).get(values.get(i));
                    break;
                }
                case LONG: {
                    res = ((LongObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).get(values.get(i));
                    break;
                }
                case FLOAT: {
                    res = Float.valueOf(((FloatObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).get(values.get(i)));
                    break;
                }
                case DOUBLE: {
                    res = ((DoubleObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).get(values.get(i));
                    break;
                }
                case DECIMAL: {
                    res = ((HiveDecimalObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).getPrimitiveJavaObject(values.get(i)).doubleValue();
                    break;
                }
                case STRING: {
                    res = ((StringObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).getPrimitiveJavaObject(values.get(i));
                    break;
                }
                default: {
                    throw new SerDeException("Unknown type: " + this.types[i].getPrimitiveCategory());
                }
            }
            value.put(this.columns[i], res);
        }
        value.put("__time_granularity", ((TimestampObjectInspector)((StructField)fields.get(this.columns.length)).getFieldObjectInspector()).getPrimitiveJavaObject(values.get(this.columns.length)).getTime());
        return new DruidWritable(value);
    }

    public SerDeStats getSerDeStats() {
        return null;
    }

    public Object deserialize(Writable writable) throws SerDeException {
        DruidWritable input = (DruidWritable)writable;
        ArrayList<Object> output = Lists.newArrayListWithExpectedSize(this.columns.length);
        block11: for (int i = 0; i < this.columns.length; ++i) {
            Object value = input.getValue().get(this.columns[i]);
            if (value == null) {
                output.add(null);
                continue;
            }
            switch (this.types[i].getPrimitiveCategory()) {
                case TIMESTAMP: {
                    output.add(new TimestampWritable(new Timestamp((Long)value)));
                    continue block11;
                }
                case BYTE: {
                    output.add(new ByteWritable(((Number)value).byteValue()));
                    continue block11;
                }
                case SHORT: {
                    output.add(new ShortWritable(((Number)value).shortValue()));
                    continue block11;
                }
                case INT: {
                    output.add(new IntWritable(((Number)value).intValue()));
                    continue block11;
                }
                case LONG: {
                    output.add(new LongWritable(((Number)value).longValue()));
                    continue block11;
                }
                case FLOAT: {
                    output.add(new FloatWritable(((Number)value).floatValue()));
                    continue block11;
                }
                case DOUBLE: {
                    output.add(new DoubleWritable(((Number)value).doubleValue()));
                    continue block11;
                }
                case DECIMAL: {
                    output.add(new HiveDecimalWritable(HiveDecimal.create((double)((Number)value).doubleValue())));
                    continue block11;
                }
                case STRING: {
                    output.add(new Text(value.toString()));
                    continue block11;
                }
                default: {
                    throw new SerDeException("Unknown type: " + this.types[i].getPrimitiveCategory());
                }
            }
        }
        return output;
    }

    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.inspector;
    }
}

