/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.druid.DruidStorageHandlerUtils;
import org.apache.hadoop.hive.druid.io.HiveDruidSplit;
import org.apache.hadoop.hive.druid.serde.DruidGroupByQueryRecordReader;
import org.apache.hadoop.hive.druid.serde.DruidQueryRecordReader;
import org.apache.hadoop.hive.druid.serde.DruidSelectQueryRecordReader;
import org.apache.hadoop.hive.druid.serde.DruidTimeseriesQueryRecordReader;
import org.apache.hadoop.hive.druid.serde.DruidTopNQueryRecordReader;
import org.apache.hadoop.hive.druid.serde.DruidWritable;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonParseException;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.metamx.common.lifecycle.Lifecycle;
import org.apache.hive.druid.com.metamx.http.client.HttpClient;
import org.apache.hive.druid.com.metamx.http.client.HttpClientConfig;
import org.apache.hive.druid.com.metamx.http.client.HttpClientInit;
import org.apache.hive.druid.com.metamx.http.client.Request;
import org.apache.hive.druid.io.druid.query.BaseQuery;
import org.apache.hive.druid.io.druid.query.Druids;
import org.apache.hive.druid.io.druid.query.LocatedSegmentDescriptor;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.SegmentDescriptor;
import org.apache.hive.druid.io.druid.query.metadata.metadata.SegmentAnalysis;
import org.apache.hive.druid.io.druid.query.metadata.metadata.SegmentMetadataQuery;
import org.apache.hive.druid.io.druid.query.select.PagingSpec;
import org.apache.hive.druid.io.druid.query.select.SelectQuery;
import org.apache.hive.druid.io.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.hive.druid.io.druid.query.spec.MultipleSpecificSegmentSpec;
import org.apache.hive.druid.io.druid.query.timeboundary.TimeBoundaryQuery;
import org.apache.hive.druid.io.druid.query.timeboundary.TimeBoundaryResultValue;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidDateTimeUtils;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidTable;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpMethod;
import org.joda.time.Chronology;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.chrono.ISOChronology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DruidQueryBasedInputFormat
extends InputFormat<NullWritable, DruidWritable>
implements org.apache.hadoop.mapred.InputFormat<NullWritable, DruidWritable> {
    protected static final Logger LOG = LoggerFactory.getLogger(DruidQueryBasedInputFormat.class);

    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        return this.getInputSplits((Configuration)job);
    }

    public List<org.apache.hadoop.mapreduce.InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        return Arrays.asList(this.getInputSplits(context.getConfiguration()));
    }

    private HiveDruidSplit[] getInputSplits(Configuration conf) throws IOException {
        String druidQueryType;
        String address = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_BROKER_DEFAULT_ADDRESS);
        if (org.apache.commons.lang3.StringUtils.isEmpty(address)) {
            throw new IOException("Druid broker address not specified in configuration");
        }
        String druidQuery = StringEscapeUtils.unescapeJava(conf.get("druid.query.json"));
        if (org.apache.commons.lang3.StringUtils.isEmpty(druidQuery)) {
            String dataSource;
            if (LOG.isWarnEnabled()) {
                LOG.warn("Druid query is empty; creating Select query");
            }
            if ((dataSource = conf.get("druid.datasource")) == null) {
                throw new IOException("Druid data source cannot be empty");
            }
            druidQuery = DruidQueryBasedInputFormat.createSelectStarQuery(dataSource);
            druidQueryType = "select";
        } else {
            druidQueryType = conf.get("druid.query.type");
            if (druidQueryType == null) {
                throw new IOException("Druid query type not recognized");
            }
        }
        Job job = new Job(conf);
        JobContext jobContext = ShimLoader.getHadoopShims().newJobContext(job);
        Path[] paths = FileInputFormat.getInputPaths((JobContext)jobContext);
        switch (druidQueryType) {
            case "timeseries": 
            case "topN": 
            case "groupBy": {
                return new HiveDruidSplit[]{new HiveDruidSplit(DruidQueryBasedInputFormat.deserializeSerialize(druidQuery), paths[0], new String[]{address})};
            }
            case "select": {
                SelectQuery selectQuery = DruidStorageHandlerUtils.JSON_MAPPER.readValue(druidQuery, SelectQuery.class);
                boolean distributed = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_SELECT_DISTRIBUTE);
                if (distributed) {
                    return DruidQueryBasedInputFormat.distributeSelectQuery(conf, address, selectQuery, paths[0]);
                }
                return DruidQueryBasedInputFormat.splitSelectQuery(conf, address, selectQuery, paths[0]);
            }
        }
        throw new IOException("Druid query type not recognized");
    }

    private static String createSelectStarQuery(String dataSource) throws IOException {
        Druids.SelectQueryBuilder builder = new Druids.SelectQueryBuilder();
        builder.dataSource(dataSource);
        builder.intervals(Arrays.asList(DruidTable.DEFAULT_INTERVAL));
        builder.pagingSpec(PagingSpec.newSpec(1));
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("druid.query.fetch", false);
        builder.context(context);
        return DruidStorageHandlerUtils.JSON_MAPPER.writeValueAsString(builder.build());
    }

    private static HiveDruidSplit[] distributeSelectQuery(Configuration conf, String address, SelectQuery query, Path dummyPath) throws IOException {
        List segmentDescriptors;
        InputStream response;
        boolean isFetch = query.getContextBoolean("druid.query.fetch", false);
        if (isFetch) {
            return new HiveDruidSplit[]{new HiveDruidSplit(DruidStorageHandlerUtils.JSON_MAPPER.writeValueAsString(query), dummyPath, new String[]{address})};
        }
        int numConnection = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_NUM_HTTP_CONNECTION);
        Period readTimeout = new Period((Object)HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_HTTP_READ_TIMEOUT));
        Lifecycle lifecycle = new Lifecycle();
        HttpClient client = HttpClientInit.createClient(HttpClientConfig.builder().withNumConnections(numConnection).withReadTimeout(readTimeout.toStandardDuration()).build(), lifecycle);
        try {
            lifecycle.start();
        }
        catch (Exception e) {
            LOG.error("Lifecycle start issue");
            throw new IOException(StringUtils.stringifyException((Throwable)e));
        }
        String intervals = org.apache.commons.lang3.StringUtils.join(query.getIntervals(), ",");
        String request = String.format("http://%s/druid/v2/datasources/%s/candidates?intervals=%s", address, query.getDataSource().getNames().get(0), intervals);
        try {
            response = DruidStorageHandlerUtils.submitRequest(client, new Request(HttpMethod.GET, new URL(request)));
        }
        catch (Exception e) {
            lifecycle.stop();
            throw new IOException(StringUtils.stringifyException((Throwable)e));
        }
        try {
            segmentDescriptors = (List)DruidStorageHandlerUtils.JSON_MAPPER.readValue(response, (TypeReference)new TypeReference<List<LocatedSegmentDescriptor>>(){});
        }
        catch (Exception e) {
            response.close();
            throw new IOException(StringUtils.stringifyException((Throwable)e));
        }
        finally {
            lifecycle.stop();
        }
        int numSplits = segmentDescriptors.size();
        HiveDruidSplit[] splits = new HiveDruidSplit[segmentDescriptors.size()];
        for (int i = 0; i < numSplits; ++i) {
            LocatedSegmentDescriptor locatedSD = (LocatedSegmentDescriptor)segmentDescriptors.get(i);
            String[] hosts = new String[locatedSD.getLocations().size()];
            for (int j = 0; j < locatedSD.getLocations().size(); ++j) {
                hosts[j] = locatedSD.getLocations().get(j).getHost();
            }
            SegmentDescriptor newSD = new SegmentDescriptor(locatedSD.getInterval(), locatedSD.getVersion(), locatedSD.getPartitionNumber());
            SelectQuery partialQuery = query.withQuerySegmentSpec(new MultipleSpecificSegmentSpec(Lists.newArrayList(newSD)));
            splits[i] = new HiveDruidSplit(DruidStorageHandlerUtils.JSON_MAPPER.writeValueAsString(partialQuery), dummyPath, hosts);
        }
        return splits;
    }

    private static HiveDruidSplit[] splitSelectQuery(Configuration conf, String address, SelectQuery query, Path dummyPath) throws IOException {
        List metadataList;
        InputStream response;
        int selectThreshold = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_SELECT_THRESHOLD);
        int numConnection = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_NUM_HTTP_CONNECTION);
        Period readTimeout = new Period((Object)HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_HTTP_READ_TIMEOUT));
        boolean isFetch = query.getContextBoolean("druid.query.fetch", false);
        if (isFetch) {
            return new HiveDruidSplit[]{new HiveDruidSplit(DruidStorageHandlerUtils.JSON_MAPPER.writeValueAsString(query), dummyPath, new String[]{address})};
        }
        Druids.SegmentMetadataQueryBuilder metadataBuilder = new Druids.SegmentMetadataQueryBuilder();
        metadataBuilder.dataSource(query.getDataSource());
        metadataBuilder.intervals(query.getIntervals());
        metadataBuilder.merge(true);
        metadataBuilder.analysisTypes(new SegmentMetadataQuery.AnalysisType[0]);
        SegmentMetadataQuery metadataQuery = metadataBuilder.build();
        Lifecycle lifecycle = new Lifecycle();
        HttpClient client = HttpClientInit.createClient(HttpClientConfig.builder().withNumConnections(numConnection).withReadTimeout(readTimeout.toStandardDuration()).build(), lifecycle);
        try {
            lifecycle.start();
        }
        catch (Exception e) {
            LOG.error("Lifecycle start issue");
            throw new IOException(StringUtils.stringifyException((Throwable)e));
        }
        try {
            response = DruidStorageHandlerUtils.submitRequest(client, DruidStorageHandlerUtils.createRequest(address, metadataQuery));
        }
        catch (Exception e) {
            lifecycle.stop();
            throw new IOException(StringUtils.stringifyException((Throwable)e));
        }
        try {
            metadataList = (List)DruidStorageHandlerUtils.SMILE_MAPPER.readValue(response, (TypeReference)new TypeReference<List<SegmentAnalysis>>(){});
        }
        catch (Exception e) {
            response.close();
            throw new IOException(StringUtils.stringifyException((Throwable)e));
        }
        finally {
            lifecycle.stop();
        }
        if (metadataList == null) {
            throw new IOException("Connected to Druid but could not retrieve datasource information");
        }
        if (metadataList.isEmpty()) {
            return new HiveDruidSplit[]{new HiveDruidSplit(DruidStorageHandlerUtils.JSON_MAPPER.writeValueAsString(query), dummyPath, new String[]{address})};
        }
        if (metadataList.size() != 1) {
            throw new IOException("Information about segments should have been merged");
        }
        long numRows = ((SegmentAnalysis)metadataList.get(0)).getNumRows();
        query = query.withPagingSpec(PagingSpec.newSpec(Integer.MAX_VALUE));
        if (numRows <= (long)selectThreshold) {
            return new HiveDruidSplit[]{new HiveDruidSplit(DruidStorageHandlerUtils.JSON_MAPPER.writeValueAsString(query), dummyPath, new String[]{address})};
        }
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        if (query.getIntervals().size() == 1 && query.getIntervals().get(0).withChronology((Chronology)ISOChronology.getInstanceUTC()).equals((Object)DruidTable.DEFAULT_INTERVAL)) {
            List timeList;
            Druids.TimeBoundaryQueryBuilder timeBuilder = new Druids.TimeBoundaryQueryBuilder();
            timeBuilder.dataSource(query.getDataSource());
            TimeBoundaryQuery timeQuery = timeBuilder.build();
            lifecycle = new Lifecycle();
            client = HttpClientInit.createClient(HttpClientConfig.builder().withNumConnections(numConnection).withReadTimeout(readTimeout.toStandardDuration()).build(), lifecycle);
            try {
                lifecycle.start();
            }
            catch (Exception e) {
                LOG.error("Lifecycle start issue");
                throw new IOException(StringUtils.stringifyException((Throwable)e));
            }
            try {
                response = DruidStorageHandlerUtils.submitRequest(client, DruidStorageHandlerUtils.createRequest(address, timeQuery));
            }
            catch (Exception e) {
                lifecycle.stop();
                throw new IOException(StringUtils.stringifyException((Throwable)e));
            }
            try {
                timeList = (List)DruidStorageHandlerUtils.SMILE_MAPPER.readValue(response, (TypeReference)new TypeReference<List<Result<TimeBoundaryResultValue>>>(){});
            }
            catch (Exception e) {
                response.close();
                throw new IOException(StringUtils.stringifyException((Throwable)e));
            }
            finally {
                lifecycle.stop();
            }
            if (timeList == null || timeList.isEmpty()) {
                throw new IOException("Connected to Druid but could not retrieve time boundary information");
            }
            if (timeList.size() != 1) {
                throw new IOException("We should obtain a single time boundary");
            }
            intervals.add(new Interval(((TimeBoundaryResultValue)((Result)timeList.get(0)).getValue()).getMinTime().getMillis(), ((TimeBoundaryResultValue)((Result)timeList.get(0)).getValue()).getMaxTime().getMillis(), (Chronology)ISOChronology.getInstanceUTC()));
        } else {
            intervals.addAll(query.getIntervals());
        }
        int numSplits = (int)Math.ceil((double)numRows / (double)selectThreshold);
        List<List<Interval>> newIntervals = DruidQueryBasedInputFormat.createSplitsIntervals(intervals, numSplits);
        HiveDruidSplit[] splits = new HiveDruidSplit[numSplits];
        for (int i = 0; i < numSplits; ++i) {
            SelectQuery partialQuery = query.withQuerySegmentSpec(new MultipleIntervalSegmentSpec(newIntervals.get(i)));
            splits[i] = new HiveDruidSplit(DruidStorageHandlerUtils.JSON_MAPPER.writeValueAsString(partialQuery), dummyPath, new String[]{address});
        }
        return splits;
    }

    private static List<List<Interval>> createSplitsIntervals(List<Interval> intervals, int numSplits) {
        long startTime;
        long totalTime = DruidDateTimeUtils.extractTotalTime(intervals);
        long endTime = startTime = intervals.get(0).getStartMillis();
        long currTime = 0L;
        ArrayList<List<Interval>> newIntervals = new ArrayList<List<Interval>>();
        int posIntervals = 0;
        for (int i = 0; i < numSplits; ++i) {
            long rangeSize = Math.round((double)(totalTime * (long)(i + 1)) / (double)numSplits) - Math.round((double)(totalTime * (long)i) / (double)numSplits);
            ArrayList<Interval> currentIntervals = new ArrayList<Interval>();
            while (posIntervals < intervals.size()) {
                Interval interval = intervals.get(posIntervals);
                long expectedRange = rangeSize - currTime;
                if (interval.getEndMillis() - startTime >= expectedRange) {
                    endTime = startTime + expectedRange;
                    currentIntervals.add(new Interval(startTime, endTime, (Chronology)ISOChronology.getInstanceUTC()));
                    startTime = endTime;
                    currTime = 0L;
                    break;
                }
                endTime = interval.getEndMillis();
                currentIntervals.add(new Interval(startTime, endTime, (Chronology)ISOChronology.getInstanceUTC()));
                currTime += endTime - startTime;
                startTime = intervals.get(++posIntervals).getStartMillis();
            }
            newIntervals.add(currentIntervals);
        }
        assert (endTime == intervals.get(intervals.size() - 1).getEndMillis());
        return newIntervals;
    }

    private static String deserializeSerialize(String druidQuery) throws JsonParseException, JsonMappingException, IOException {
        BaseQuery deserializedQuery = DruidStorageHandlerUtils.JSON_MAPPER.readValue(druidQuery, BaseQuery.class);
        return DruidStorageHandlerUtils.JSON_MAPPER.writeValueAsString(deserializedQuery);
    }

    public org.apache.hadoop.mapred.RecordReader<NullWritable, DruidWritable> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        DruidQueryRecordReader reader;
        String druidQueryType = job.get("druid.query.type");
        if (druidQueryType == null) {
            DruidSelectQueryRecordReader reader2 = new DruidSelectQueryRecordReader();
            reader2.initialize((org.apache.hadoop.mapreduce.InputSplit)((HiveDruidSplit)split), (Configuration)job);
            return reader2;
        }
        switch (druidQueryType) {
            case "timeseries": {
                reader = new DruidTimeseriesQueryRecordReader();
                break;
            }
            case "topN": {
                reader = new DruidTopNQueryRecordReader();
                break;
            }
            case "groupBy": {
                reader = new DruidGroupByQueryRecordReader();
                break;
            }
            case "select": {
                reader = new DruidSelectQueryRecordReader();
                break;
            }
            default: {
                throw new IOException("Druid query type not recognized");
            }
        }
        reader.initialize((org.apache.hadoop.mapreduce.InputSplit)((HiveDruidSplit)split), (Configuration)job);
        return reader;
    }

    public RecordReader<NullWritable, DruidWritable> createRecordReader(org.apache.hadoop.mapreduce.InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        DruidQueryRecordReader reader;
        String druidQueryType = context.getConfiguration().get("druid.query.type");
        if (druidQueryType == null) {
            return new DruidSelectQueryRecordReader();
        }
        switch (druidQueryType) {
            case "timeseries": {
                reader = new DruidTimeseriesQueryRecordReader();
                break;
            }
            case "topN": {
                reader = new DruidTopNQueryRecordReader();
                break;
            }
            case "groupBy": {
                reader = new DruidGroupByQueryRecordReader();
                break;
            }
            case "select": {
                reader = new DruidSelectQueryRecordReader();
                break;
            }
            default: {
                throw new IOException("Druid query type not recognized");
            }
        }
        return reader;
    }
}

