/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma3.mat.extendedset.wrappers;

import it.uniroma3.mat.extendedset.intset.IntSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeMap;

public class LongSet
implements Cloneable,
Comparable<LongSet>,
Serializable,
Iterable<Long> {
    private static final long serialVersionUID = -6165350530254304256L;
    private static int SUBSET_SIZE = 1040187423;
    private final IntSet firstIndices;
    private final NavigableMap<Long, IntSet> otherIndices;

    public LongSet(IntSet block) {
        this.firstIndices = block.empty();
        this.otherIndices = new TreeMap<Long, IntSet>();
    }

    public IntSet emptyBlock() {
        return this.firstIndices.empty();
    }

    public boolean retainAll(LongSet other) {
        if (this.isEmpty() || this == other) {
            return false;
        }
        if (other == null || other.isEmpty()) {
            this.clear();
            return true;
        }
        boolean res = this.firstIndices.retainAll(other.firstIndices);
        if (this.otherIndices.isEmpty()) {
            return res;
        }
        if (other.otherIndices.isEmpty()) {
            this.otherIndices.clear();
            return true;
        }
        Iterator itr1 = this.otherIndices.entrySet().iterator();
        Iterator itr2 = other.otherIndices.entrySet().iterator();
        Map.Entry e1 = null;
        Map.Entry e2 = null;
        int c = 0;
        while (true) {
            if (c <= 0) {
                if (itr1.hasNext()) {
                    e1 = itr1.next();
                } else {
                    return res;
                }
            }
            if (c >= 0) {
                if (itr2.hasNext()) {
                    e2 = itr2.next();
                } else {
                    itr1.remove();
                    while (itr1.hasNext()) {
                        itr1.next();
                        itr1.remove();
                    }
                    return true;
                }
            }
            if ((c = ((Long)e1.getKey()).compareTo((Long)e2.getKey())) < 0) {
                itr1.remove();
                res = true;
                continue;
            }
            if (c != 0) continue;
            res |= ((IntSet)e1.getValue()).retainAll((IntSet)e2.getValue());
            if (!((IntSet)e1.getValue()).isEmpty()) continue;
            itr1.remove();
        }
    }

    public LongSet intersection(LongSet other) {
        if (this.isEmpty() || other == null || other.isEmpty()) {
            return this.empty();
        }
        if (this == other) {
            return this.clone();
        }
        LongSet res = new LongSet(this.firstIndices.intersection(other.firstIndices), new TreeMap<Long, IntSet>());
        if (this.otherIndices.isEmpty() || other.otherIndices.isEmpty()) {
            return res;
        }
        Iterator itr1 = this.otherIndices.entrySet().iterator();
        Iterator itr2 = other.otherIndices.entrySet().iterator();
        Map.Entry e1 = null;
        Map.Entry e2 = null;
        int c = 0;
        while (true) {
            IntSet s;
            if (c <= 0) {
                if (itr1.hasNext()) {
                    e1 = itr1.next();
                } else {
                    return res;
                }
            }
            if (c >= 0) {
                if (itr2.hasNext()) {
                    e2 = itr2.next();
                } else {
                    return res;
                }
            }
            if ((c = ((Long)e1.getKey()).compareTo((Long)e2.getKey())) != 0 || (s = ((IntSet)e1.getValue()).intersection((IntSet)e2.getValue())).isEmpty()) continue;
            res.otherIndices.put((Long)e1.getKey(), s);
        }
    }

    public boolean addAll(LongSet other) {
        if (other == null || other.isEmpty() || this == other) {
            return false;
        }
        boolean res = this.firstIndices.addAll(other.firstIndices);
        if (other.otherIndices.isEmpty()) {
            return res;
        }
        if (this.otherIndices.isEmpty()) {
            for (Map.Entry e : other.otherIndices.entrySet()) {
                this.otherIndices.put((Long)e.getKey(), ((IntSet)e.getValue()).clone());
            }
            return true;
        }
        Iterator itr1 = new ArrayList(this.otherIndices.entrySet()).iterator();
        Iterator itr2 = other.otherIndices.entrySet().iterator();
        Map.Entry e1 = null;
        Map.Entry e2 = null;
        int c = 0;
        while (true) {
            if (c >= 0) {
                if (itr2.hasNext()) {
                    e2 = itr2.next();
                } else {
                    return res;
                }
            }
            if (c <= 0) {
                if (itr1.hasNext()) {
                    e1 = itr1.next();
                } else {
                    this.otherIndices.put((Long)e2.getKey(), ((IntSet)e2.getValue()).clone());
                    while (itr2.hasNext()) {
                        e2 = itr2.next();
                        this.otherIndices.put((Long)e2.getKey(), ((IntSet)e2.getValue()).clone());
                    }
                    return true;
                }
            }
            if ((c = ((Long)e1.getKey()).compareTo((Long)e2.getKey())) > 0) {
                this.otherIndices.put((Long)e2.getKey(), ((IntSet)e2.getValue()).clone());
                res = true;
                continue;
            }
            if (c != 0) continue;
            res |= ((IntSet)e1.getValue()).addAll((IntSet)e2.getValue());
        }
    }

    public LongSet union(LongSet other) {
        if (other == null || other.isEmpty() || this == other) {
            return this.clone();
        }
        if (this.isEmpty()) {
            return other.clone();
        }
        LongSet res = new LongSet(this.firstIndices.union(other.firstIndices), new TreeMap<Long, IntSet>());
        if (other.otherIndices.isEmpty()) {
            for (Map.Entry e : this.otherIndices.entrySet()) {
                res.otherIndices.put((Long)e.getKey(), ((IntSet)e.getValue()).clone());
            }
            return res;
        }
        if (this.otherIndices.isEmpty()) {
            for (Map.Entry e : other.otherIndices.entrySet()) {
                res.otherIndices.put((Long)e.getKey(), ((IntSet)e.getValue()).clone());
            }
            return res;
        }
        Iterator itr1 = this.otherIndices.entrySet().iterator();
        Iterator itr2 = other.otherIndices.entrySet().iterator();
        Map.Entry e1 = null;
        Map.Entry e2 = null;
        int c = 0;
        while (true) {
            if (c <= 0) {
                if (itr1.hasNext()) {
                    e1 = itr1.next();
                } else {
                    if (c != 0) {
                        res.otherIndices.put((Long)e2.getKey(), ((IntSet)e2.getValue()).clone());
                    }
                    while (itr2.hasNext()) {
                        e2 = itr2.next();
                        res.otherIndices.put((Long)e2.getKey(), ((IntSet)e2.getValue()).clone());
                    }
                    return res;
                }
            }
            if (c >= 0) {
                if (itr2.hasNext()) {
                    e2 = itr2.next();
                } else {
                    res.otherIndices.put((Long)e1.getKey(), ((IntSet)e1.getValue()).clone());
                    while (itr1.hasNext()) {
                        e1 = itr1.next();
                        res.otherIndices.put((Long)e1.getKey(), ((IntSet)e1.getValue()).clone());
                    }
                    return res;
                }
            }
            if ((c = ((Long)e1.getKey()).compareTo((Long)e2.getKey())) < 0) {
                res.otherIndices.put((Long)e1.getKey(), ((IntSet)e1.getValue()).clone());
                continue;
            }
            if (c > 0) {
                res.otherIndices.put((Long)e2.getKey(), ((IntSet)e2.getValue()).clone());
                continue;
            }
            res.otherIndices.put((Long)e1.getKey(), ((IntSet)e1.getValue()).union((IntSet)e2.getValue()));
        }
    }

    public boolean removeAll(LongSet other) {
        if (this.isEmpty() || other == null || other.isEmpty()) {
            return false;
        }
        if (this == other) {
            this.clear();
            return true;
        }
        boolean res = this.firstIndices.removeAll(other.firstIndices);
        if (this.otherIndices.isEmpty() || other.otherIndices.isEmpty()) {
            return res;
        }
        Iterator itr1 = this.otherIndices.entrySet().iterator();
        Iterator itr2 = other.otherIndices.entrySet().iterator();
        Map.Entry e1 = null;
        Map.Entry e2 = null;
        int c = 0;
        while (true) {
            if (c <= 0) {
                if (itr1.hasNext()) {
                    e1 = itr1.next();
                } else {
                    return res;
                }
            }
            if (c >= 0) {
                if (itr2.hasNext()) {
                    e2 = itr2.next();
                } else {
                    return res;
                }
            }
            if ((c = ((Long)e1.getKey()).compareTo((Long)e2.getKey())) != 0) continue;
            res |= ((IntSet)e1.getValue()).removeAll((IntSet)e2.getValue());
            if (!((IntSet)e1.getValue()).isEmpty()) continue;
            itr1.remove();
        }
    }

    public LongSet difference(LongSet other) {
        if (other == null || other.isEmpty()) {
            return this.clone();
        }
        if (this.isEmpty() || this == other) {
            return this.empty();
        }
        LongSet res = new LongSet(this.firstIndices.difference(other.firstIndices), new TreeMap<Long, IntSet>());
        if (this.otherIndices.isEmpty()) {
            return res;
        }
        if (other.otherIndices.isEmpty()) {
            for (Map.Entry e : this.otherIndices.entrySet()) {
                res.otherIndices.put((Long)e.getKey(), ((IntSet)e.getValue()).clone());
            }
            return res;
        }
        Iterator itr1 = this.otherIndices.entrySet().iterator();
        Iterator itr2 = other.otherIndices.entrySet().iterator();
        Map.Entry e1 = null;
        Map.Entry e2 = null;
        int c = 0;
        while (true) {
            IntSet s;
            if (c <= 0) {
                if (itr1.hasNext()) {
                    e1 = itr1.next();
                } else {
                    return res;
                }
            }
            if (c >= 0) {
                if (itr2.hasNext()) {
                    e2 = itr2.next();
                } else {
                    res.otherIndices.put((Long)e1.getKey(), ((IntSet)e1.getValue()).clone());
                    while (itr1.hasNext()) {
                        e1 = itr1.next();
                        res.otherIndices.put((Long)e1.getKey(), ((IntSet)e1.getValue()).clone());
                    }
                    return res;
                }
            }
            if ((c = ((Long)e1.getKey()).compareTo((Long)e2.getKey())) < 0) {
                res.otherIndices.put((Long)e1.getKey(), ((IntSet)e1.getValue()).clone());
                continue;
            }
            if (c != 0 || (s = ((IntSet)e1.getValue()).difference((IntSet)e2.getValue())).isEmpty()) continue;
            res.otherIndices.put((Long)e1.getKey(), s);
        }
    }

    public LongSet symmetricDifference(LongSet other) {
        if (other == null || other.isEmpty() || this == other) {
            return this.clone();
        }
        if (this.isEmpty()) {
            return other.clone();
        }
        LongSet res = new LongSet(this.firstIndices.symmetricDifference(other.firstIndices), new TreeMap<Long, IntSet>());
        if (other.otherIndices.isEmpty()) {
            for (Map.Entry e : this.otherIndices.entrySet()) {
                res.otherIndices.put((Long)e.getKey(), ((IntSet)e.getValue()).clone());
            }
            return res;
        }
        if (this.otherIndices.isEmpty()) {
            for (Map.Entry e : other.otherIndices.entrySet()) {
                res.otherIndices.put((Long)e.getKey(), ((IntSet)e.getValue()).clone());
            }
            return res;
        }
        Iterator itr1 = this.otherIndices.entrySet().iterator();
        Iterator itr2 = other.otherIndices.entrySet().iterator();
        Map.Entry e1 = null;
        Map.Entry e2 = null;
        int c = 0;
        while (true) {
            if (c <= 0) {
                if (itr1.hasNext()) {
                    e1 = itr1.next();
                } else {
                    if (c != 0) {
                        res.otherIndices.put((Long)e2.getKey(), ((IntSet)e2.getValue()).clone());
                    }
                    while (itr2.hasNext()) {
                        e2 = itr2.next();
                        res.otherIndices.put((Long)e2.getKey(), ((IntSet)e2.getValue()).clone());
                    }
                    return res;
                }
            }
            if (c >= 0) {
                if (itr2.hasNext()) {
                    e2 = itr2.next();
                } else {
                    res.otherIndices.put((Long)e1.getKey(), ((IntSet)e1.getValue()).clone());
                    while (itr1.hasNext()) {
                        e1 = itr1.next();
                        res.otherIndices.put((Long)e1.getKey(), ((IntSet)e1.getValue()).clone());
                    }
                    return res;
                }
            }
            if ((c = ((Long)e1.getKey()).compareTo((Long)e2.getKey())) < 0) {
                res.otherIndices.put((Long)e1.getKey(), ((IntSet)e1.getValue()).clone());
                continue;
            }
            if (c > 0) {
                res.otherIndices.put((Long)e2.getKey(), ((IntSet)e2.getValue()).clone());
                continue;
            }
            res.otherIndices.put((Long)e1.getKey(), ((IntSet)e1.getValue()).symmetricDifference((IntSet)e2.getValue()));
        }
    }

    public LongSet complemented() {
        LongSet cloned = this.clone();
        cloned.complement();
        return cloned;
    }

    public void complement() {
        if (this.otherIndices.isEmpty()) {
            this.firstIndices.complement();
            return;
        }
        Iterator itr = this.otherIndices.descendingMap().entrySet().iterator();
        Map.Entry e = itr.next();
        ((IntSet)e.getValue()).complement();
        if (((IntSet)e.getValue()).isEmpty()) {
            itr.remove();
        }
        TreeMap<Long, IntSet> toAdd = new TreeMap<Long, IntSet>();
        for (long i = (Long)e.getKey() - (long)SUBSET_SIZE; i > 0L; i -= (long)SUBSET_SIZE) {
            while (e != null && (Long)e.getKey() > i) {
                e = itr.hasNext() ? itr.next() : null;
            }
            if (e != null && (Long)e.getKey() == i) {
                if (((IntSet)e.getValue()).add(SUBSET_SIZE - 1)) {
                    ((IntSet)e.getValue()).complement();
                    ((IntSet)e.getValue()).add(SUBSET_SIZE - 1);
                } else {
                    ((IntSet)e.getValue()).complement();
                }
                if (!((IntSet)e.getValue()).isEmpty()) continue;
                itr.remove();
                continue;
            }
            IntSet s = this.firstIndices.empty();
            s.fill(0, SUBSET_SIZE - 1);
            toAdd.put(i, s);
        }
        this.otherIndices.putAll(toAdd);
        if (this.firstIndices.add(SUBSET_SIZE - 1)) {
            this.firstIndices.complement();
            this.firstIndices.add(SUBSET_SIZE - 1);
        } else {
            this.firstIndices.complement();
        }
    }

    public long intersectionSize(LongSet other) {
        if (this.isEmpty() || other == null || other.isEmpty()) {
            return 0L;
        }
        if (this == other) {
            return this.size();
        }
        long res = this.firstIndices.intersectionSize(other.firstIndices);
        if (this.otherIndices.isEmpty() || other.otherIndices.isEmpty()) {
            return res;
        }
        Iterator itr1 = this.otherIndices.entrySet().iterator();
        Iterator itr2 = other.otherIndices.entrySet().iterator();
        Map.Entry e1 = null;
        Map.Entry e2 = null;
        int c = 0;
        while (true) {
            if (c <= 0) {
                if (itr1.hasNext()) {
                    e1 = itr1.next();
                } else {
                    return res;
                }
            }
            if (c >= 0) {
                if (itr2.hasNext()) {
                    e2 = itr2.next();
                } else {
                    return res;
                }
            }
            if ((c = ((Long)e1.getKey()).compareTo((Long)e2.getKey())) != 0) continue;
            res += (long)((IntSet)e1.getValue()).intersectionSize((IntSet)e2.getValue());
        }
    }

    public long unionSize(LongSet other) {
        return other == null ? this.size() : this.size() + other.size() - this.intersectionSize(other);
    }

    public long symmetricDifferenceSize(LongSet other) {
        return other == null ? this.size() : this.size() + other.size() - 2L * this.intersectionSize(other);
    }

    public long differenceSize(LongSet other) {
        return other == null ? this.size() : this.size() - this.intersectionSize(other);
    }

    public long complementSize() {
        if (this.isEmpty()) {
            return 0L;
        }
        return this.last() - this.size() + 1L;
    }

    public LongSet empty() {
        return new LongSet(this.firstIndices.empty(), new TreeMap<Long, IntSet>());
    }

    private LongSet(IntSet firstIndices, NavigableMap<Long, IntSet> otherIndices) {
        this.firstIndices = firstIndices;
        this.otherIndices = otherIndices;
    }

    public LongSet clone() {
        TreeMap<Long, IntSet> otherIndicesClone = new TreeMap<Long, IntSet>();
        for (Map.Entry e : this.otherIndices.entrySet()) {
            otherIndicesClone.put((Long)e.getKey(), ((IntSet)e.getValue()).clone());
        }
        return new LongSet(this.firstIndices.clone(), otherIndicesClone);
    }

    public double bitmapCompressionRatio() {
        throw new RuntimeException("TODO");
    }

    public double collectionCompressionRatio() {
        throw new RuntimeException("TODO");
    }

    public ExtendedLongIterator longIterator() {
        return new ExtendedLongIterator();
    }

    public ExtendedLongIterator descendingLongIterator() {
        return new ReverseLongIterator();
    }

    @Override
    public Iterator<Long> iterator() {
        return new Iterator<Long>(){
            final ExtendedLongIterator itr;
            {
                this.itr = LongSet.this.longIterator();
            }

            @Override
            public boolean hasNext() {
                return this.itr.hasNext();
            }

            @Override
            public Long next() {
                return this.itr.next();
            }

            @Override
            public void remove() {
                this.itr.remove();
            }
        };
    }

    public String debugInfo() {
        StringBuilder s = new StringBuilder();
        s.append("elements: ");
        s.append(this.toString());
        s.append("\nfirstIndices: " + this.firstIndices);
        s.append('\n');
        s.append("otherIndices: " + this.otherIndices.size());
        s.append('\n');
        for (Map.Entry e : this.otherIndices.entrySet()) {
            s.append('\t');
            s.append(e.getKey());
            s.append(", ");
            s.append(e.getValue());
            s.append('\n');
        }
        return s.toString();
    }

    public void fill(long from, long to) {
        if (from > to) {
            throw new IndexOutOfBoundsException("from: " + from + " > to: " + to);
        }
        if (from == to) {
            this.add(from);
            return;
        }
        long firstBlockIndex = from / (long)SUBSET_SIZE * (long)SUBSET_SIZE;
        long lastBlockIndex = to / (long)SUBSET_SIZE * (long)SUBSET_SIZE;
        if (firstBlockIndex == lastBlockIndex) {
            if (firstBlockIndex == 0L) {
                this.firstIndices.fill((int)from, (int)to);
            } else {
                IntSet s = (IntSet)this.otherIndices.get(firstBlockIndex);
                if (s == null) {
                    s = this.firstIndices.empty();
                    this.otherIndices.put(firstBlockIndex, s);
                }
                s.fill((int)(from - firstBlockIndex), (int)(to - firstBlockIndex));
            }
        } else {
            IntSet s;
            if (firstBlockIndex == 0L) {
                this.firstIndices.fill((int)from, SUBSET_SIZE - 1);
            } else {
                s = (IntSet)this.otherIndices.get(firstBlockIndex);
                if (s == null) {
                    s = this.firstIndices.empty();
                    this.otherIndices.put(firstBlockIndex, s);
                }
                s.fill((int)(from - firstBlockIndex), SUBSET_SIZE - 1);
            }
            for (long i = firstBlockIndex + (long)SUBSET_SIZE; i < lastBlockIndex; i += (long)SUBSET_SIZE) {
                IntSet s2 = this.firstIndices.empty();
                s2.fill(0, SUBSET_SIZE - 1);
                this.otherIndices.put(i, s2);
            }
            s = (IntSet)this.otherIndices.get(lastBlockIndex);
            if (s == null) {
                s = this.firstIndices.empty();
                this.otherIndices.put(lastBlockIndex, s);
            }
            s.fill(0, (int)(to - lastBlockIndex));
        }
    }

    public void clear(long from, long to) {
        if (from > to) {
            throw new IndexOutOfBoundsException("from: " + from + " > to: " + to);
        }
        if (from == to) {
            this.remove(from);
            return;
        }
        long firstBlockIndex = from / (long)SUBSET_SIZE * (long)SUBSET_SIZE;
        long lastBlockIndex = to / (long)SUBSET_SIZE * (long)SUBSET_SIZE;
        if (firstBlockIndex == lastBlockIndex) {
            if (firstBlockIndex == 0L) {
                this.firstIndices.clear((int)from, (int)to);
            } else {
                IntSet s = (IntSet)this.otherIndices.get(firstBlockIndex);
                if (s != null) {
                    s.clear((int)(from - firstBlockIndex), (int)(to - firstBlockIndex));
                    if (s.isEmpty()) {
                        this.otherIndices.remove(firstBlockIndex);
                    }
                }
            }
        } else {
            IntSet s;
            if (firstBlockIndex == 0L) {
                this.firstIndices.clear((int)from, SUBSET_SIZE - 1);
            } else {
                s = (IntSet)this.otherIndices.get(firstBlockIndex);
                if (s != null) {
                    s.clear((int)(from - firstBlockIndex), SUBSET_SIZE - 1);
                    if (s.isEmpty()) {
                        this.otherIndices.remove(firstBlockIndex);
                    }
                }
            }
            for (long i = firstBlockIndex + (long)SUBSET_SIZE; i < lastBlockIndex; i += (long)SUBSET_SIZE) {
                this.otherIndices.remove(i);
            }
            s = (IntSet)this.otherIndices.get(lastBlockIndex);
            if (s != null) {
                s.clear(0, (int)(to - lastBlockIndex));
                if (s.isEmpty()) {
                    this.otherIndices.remove(lastBlockIndex);
                }
            }
        }
    }

    public void flip(long e) {
        if (e < (long)SUBSET_SIZE) {
            this.firstIndices.flip((int)e);
            return;
        }
        long block = e / (long)SUBSET_SIZE * (long)SUBSET_SIZE;
        IntSet s = (IntSet)this.otherIndices.get(block);
        if (s == null) {
            s = this.firstIndices.empty();
            this.otherIndices.put(block, s);
        }
        s.flip((int)(e - block));
        if (s.isEmpty()) {
            this.otherIndices.remove(block);
        }
    }

    public long get(long index) {
        if (index < (long)this.firstIndices.size()) {
            return this.firstIndices.get((int)index);
        }
        index -= (long)this.firstIndices.size();
        for (Map.Entry e : this.otherIndices.entrySet()) {
            if (index < (long)((IntSet)e.getValue()).size()) {
                return (Long)e.getKey() + (long)((IntSet)e.getValue()).get((int)index);
            }
            index -= (long)((IntSet)e.getValue()).size();
        }
        throw new IndexOutOfBoundsException(Long.toString(index));
    }

    public long indexOf(long i) {
        if (i < (long)SUBSET_SIZE) {
            return this.firstIndices.indexOf((int)i);
        }
        long prev = this.firstIndices.size();
        for (Map.Entry e : this.otherIndices.entrySet()) {
            if (i < (Long)e.getKey() + (long)SUBSET_SIZE) {
                return prev + (long)((IntSet)e.getValue()).indexOf((int)(i - (Long)e.getKey()));
            }
            prev += (long)((IntSet)e.getValue()).size();
        }
        return -1L;
    }

    public LongSet convert(long ... a) {
        LongSet res = this.empty();
        if (a != null) {
            a = Arrays.copyOf(a, a.length);
            Arrays.sort(a);
            for (long i : a) {
                res.add(i);
            }
        }
        return res;
    }

    public LongSet convert(Collection<Long> a) {
        LongSet res = this.empty();
        if (a != null) {
            Collection<Long> sorted;
            if (a instanceof SortedSet && ((SortedSet)a).comparator() == null) {
                sorted = a;
            } else {
                sorted = new ArrayList<Long>(a);
                Collections.sort((List)sorted);
            }
            for (long i : sorted) {
                res.add(i);
            }
        }
        return res;
    }

    public long first() {
        if (!this.firstIndices.isEmpty()) {
            return this.firstIndices.first();
        }
        if (this.otherIndices.isEmpty()) {
            throw new NoSuchElementException();
        }
        Map.Entry<Long, IntSet> e = this.otherIndices.firstEntry();
        return e.getKey() + (long)e.getValue().first();
    }

    public long last() {
        if (this.otherIndices.isEmpty() && this.firstIndices.isEmpty()) {
            throw new NoSuchElementException();
        }
        if (!this.otherIndices.isEmpty()) {
            Map.Entry<Long, IntSet> e = this.otherIndices.lastEntry();
            return e.getKey() + (long)e.getValue().last();
        }
        return this.firstIndices.last();
    }

    public long size() {
        long res = this.firstIndices.size();
        for (Map.Entry e : this.otherIndices.entrySet()) {
            res += (long)((IntSet)e.getValue()).size();
        }
        return res;
    }

    public boolean isEmpty() {
        return this.firstIndices.isEmpty() && this.otherIndices.isEmpty();
    }

    public int hashCode() {
        return 31 * this.firstIndices.hashCode() + this.otherIndices.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LongSet)) {
            return false;
        }
        LongSet other = (LongSet)obj;
        return this.firstIndices.equals(other.firstIndices) && this.otherIndices.equals(other.otherIndices);
    }

    public boolean contains(long i) {
        if (i < (long)SUBSET_SIZE) {
            return this.firstIndices.contains((int)i);
        }
        long first = i / (long)SUBSET_SIZE * (long)SUBSET_SIZE;
        IntSet s = (IntSet)this.otherIndices.get(first);
        if (s == null) {
            return false;
        }
        return s.contains((int)(i - first));
    }

    public boolean add(long i) {
        if (i < (long)SUBSET_SIZE) {
            return this.firstIndices.add((int)i);
        }
        long first = i / (long)SUBSET_SIZE * (long)SUBSET_SIZE;
        IntSet s = (IntSet)this.otherIndices.get(first);
        if (s == null) {
            s = this.firstIndices.empty();
            this.otherIndices.put(first, s);
        }
        return s.add((int)(i - first));
    }

    public boolean remove(long i) {
        if (i < (long)SUBSET_SIZE) {
            return this.firstIndices.remove((int)i);
        }
        long first = i / (long)SUBSET_SIZE * (long)SUBSET_SIZE;
        IntSet s = (IntSet)this.otherIndices.get(first);
        if (s == null) {
            return false;
        }
        boolean res = s.remove((int)(i - first));
        if (res && s.isEmpty()) {
            this.otherIndices.remove(first);
        }
        return res;
    }

    public boolean containsAll(LongSet other) {
        if (other == null || other.isEmpty() || other == this) {
            return true;
        }
        if (this.isEmpty()) {
            return false;
        }
        if (!this.firstIndices.containsAll(other.firstIndices)) {
            return false;
        }
        if (other.otherIndices.isEmpty()) {
            return true;
        }
        if (this.otherIndices.isEmpty()) {
            return false;
        }
        Iterator itr1 = this.otherIndices.entrySet().iterator();
        Iterator itr2 = other.otherIndices.entrySet().iterator();
        Map.Entry e1 = null;
        Map.Entry e2 = null;
        int c = 0;
        do {
            if (c <= 0) {
                if (itr1.hasNext()) {
                    e1 = itr1.next();
                } else {
                    return c == 0 && !itr2.hasNext();
                }
            }
            if (c >= 0) {
                if (itr2.hasNext()) {
                    e2 = itr2.next();
                } else {
                    return true;
                }
            }
            if ((c = ((Long)e1.getKey()).compareTo((Long)e2.getKey())) <= 0) continue;
            return false;
        } while (c != 0 || ((IntSet)e1.getValue()).containsAll((IntSet)e2.getValue()));
        return false;
    }

    public boolean containsAny(LongSet other) {
        if (other == null || other.isEmpty() || other == this) {
            return true;
        }
        if (this.isEmpty()) {
            return false;
        }
        if (this.firstIndices.containsAny(other.firstIndices) && !other.firstIndices.isEmpty()) {
            return true;
        }
        if (other.otherIndices.isEmpty() || this.otherIndices.isEmpty()) {
            return false;
        }
        Iterator itr1 = this.otherIndices.entrySet().iterator();
        Iterator itr2 = other.otherIndices.entrySet().iterator();
        Map.Entry e1 = null;
        Map.Entry e2 = null;
        int c = 0;
        do {
            if (c <= 0) {
                if (itr1.hasNext()) {
                    e1 = itr1.next();
                } else {
                    return false;
                }
            }
            if (c < 0) continue;
            if (itr2.hasNext()) {
                e2 = itr2.next();
                continue;
            }
            return false;
        } while ((c = ((Long)e1.getKey()).compareTo((Long)e2.getKey())) != 0 || !((IntSet)e1.getValue()).containsAny((IntSet)e2.getValue()));
        return true;
    }

    public boolean containsAtLeast(LongSet other, long minElements) {
        if (minElements < 1L) {
            throw new IllegalArgumentException();
        }
        if (this == other) {
            return this.size() >= minElements;
        }
        if (other == null || other.isEmpty() || this.isEmpty() || this.size() < minElements) {
            return false;
        }
        long res = this.firstIndices.intersectionSize(other.firstIndices);
        if (res >= minElements) {
            return true;
        }
        if (this.otherIndices.isEmpty() || other.otherIndices.isEmpty()) {
            return false;
        }
        Iterator itr1 = this.otherIndices.entrySet().iterator();
        Iterator itr2 = other.otherIndices.entrySet().iterator();
        Map.Entry e1 = null;
        Map.Entry e2 = null;
        int c = 0;
        do {
            if (c <= 0) {
                if (itr1.hasNext()) {
                    e1 = itr1.next();
                } else {
                    return false;
                }
            }
            if (c < 0) continue;
            if (itr2.hasNext()) {
                e2 = itr2.next();
                continue;
            }
            return false;
        } while ((c = ((Long)e1.getKey()).compareTo((Long)e2.getKey())) != 0 || (res += (long)((IntSet)e1.getValue()).intersectionSize((IntSet)e2.getValue())) < minElements);
        return true;
    }

    public void clear() {
        this.firstIndices.clear();
        this.otherIndices.clear();
    }

    public long[] toArray() {
        if (this.isEmpty()) {
            return null;
        }
        return this.toArray(new long[(int)this.size()]);
    }

    public long[] toArray(long[] a) {
        if ((long)a.length < this.size()) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return a;
        }
        ExtendedLongIterator itr = this.longIterator();
        int i = 0;
        while (itr.hasNext()) {
            a[i++] = itr.next();
        }
        return a;
    }

    public String toString() {
        ExtendedLongIterator itr = this.longIterator();
        if (!itr.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            long e = itr.next();
            sb.append(e);
            if (!itr.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(", ");
        }
    }

    @Override
    public int compareTo(LongSet o) {
        throw new RuntimeException("TODO");
    }

    private class ReverseLongIterator
    extends ExtendedLongIterator {
        private ReverseLongIterator() {
            this.otherItrs = LongSet.this.otherIndices.descendingMap().entrySet().iterator();
            this.nextItr();
        }

        @Override
        protected void nextItr() {
            if (this.otherItrs.hasNext()) {
                Map.Entry e = (Map.Entry)this.otherItrs.next();
                this.current = (IntSet)e.getValue();
                this.itr = ((IntSet)e.getValue()).descendingIterator();
                this.first = (Long)e.getKey();
            } else {
                this.itr = LongSet.this.firstIndices.descendingIterator();
                this.current = null;
                this.first = 0L;
            }
        }

        @Override
        public void skipAllBefore(long element) {
            while (element <= this.first) {
                this.nextItr();
            }
            if (element > this.first + (long)SUBSET_SIZE) {
                return;
            }
            this.itr.skipAllBefore((int)(element - this.first));
        }
    }

    public class ExtendedLongIterator {
        protected IntSet.IntIterator itr;
        protected Iterator<Map.Entry<Long, IntSet>> otherItrs;
        protected long first = 0L;
        protected IntSet current = null;

        private ExtendedLongIterator() {
            this.itr = LongSet.this.firstIndices.iterator();
            this.otherItrs = LongSet.this.otherIndices.entrySet().iterator();
            this.first = 0L;
        }

        protected void nextItr() {
            Map.Entry<Long, IntSet> e = this.otherItrs.next();
            this.current = e.getValue();
            this.itr = e.getValue().iterator();
            this.first = e.getKey();
        }

        public boolean hasNext() {
            return this.otherItrs.hasNext() || this.itr.hasNext();
        }

        public long next() {
            if (!this.itr.hasNext()) {
                this.nextItr();
            }
            return this.first + (long)this.itr.next();
        }

        public void remove() {
            this.itr.remove();
            if (this.current != null && this.current.isEmpty()) {
                this.otherItrs.remove();
            }
        }

        public void skipAllBefore(long element) {
            while (element >= this.first + (long)SUBSET_SIZE) {
                if (this.otherItrs.hasNext()) {
                    this.nextItr();
                    continue;
                }
                this.itr.skipAllBefore(SUBSET_SIZE - 1);
                assert (!this.itr.hasNext());
                return;
            }
            if (element < this.first) {
                return;
            }
            this.itr.skipAllBefore((int)(element - this.first));
        }
    }
}

