/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.spark.network.TransportContext;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.TransportServerBootstrap;
import org.apache.spark.network.util.IOMode;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.network.util.NettyUtils;
import org.apache.spark.network.util.TransportConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spark_project.guava.base.Preconditions;
import org.spark_project.guava.collect.Lists;

public class TransportServer
implements Closeable {
    private final Logger logger = LoggerFactory.getLogger(TransportServer.class);
    private final TransportContext context;
    private final TransportConf conf;
    private final RpcHandler appRpcHandler;
    private final List<TransportServerBootstrap> bootstraps;
    private ServerBootstrap bootstrap;
    private ChannelFuture channelFuture;
    private int port = -1;

    public TransportServer(TransportContext context, String hostToBind, int portToBind, RpcHandler appRpcHandler, List<TransportServerBootstrap> bootstraps) {
        this.context = context;
        this.conf = context.getConf();
        this.appRpcHandler = appRpcHandler;
        this.bootstraps = Lists.newArrayList((Iterable)Preconditions.checkNotNull(bootstraps));
        try {
            this.init(hostToBind, portToBind);
        }
        catch (RuntimeException e) {
            JavaUtils.closeQuietly(this);
            throw e;
        }
    }

    public int getPort() {
        if (this.port == -1) {
            throw new IllegalStateException("Server not initialized");
        }
        return this.port;
    }

    private void init(String hostToBind, int portToBind) {
        EventLoopGroup bossGroup;
        IOMode ioMode = IOMode.valueOf(this.conf.ioMode());
        EventLoopGroup workerGroup = bossGroup = NettyUtils.createEventLoop(ioMode, this.conf.serverThreads(), "shuffle-server");
        PooledByteBufAllocator allocator = NettyUtils.createPooledByteBufAllocator(this.conf.preferDirectBufs(), true, this.conf.serverThreads());
        this.bootstrap = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(bossGroup, workerGroup).channel(NettyUtils.getServerChannelClass(ioMode))).option(ChannelOption.ALLOCATOR, (Object)allocator)).childOption(ChannelOption.ALLOCATOR, (Object)allocator);
        if (this.conf.backLog() > 0) {
            this.bootstrap.option(ChannelOption.SO_BACKLOG, (Object)this.conf.backLog());
        }
        if (this.conf.receiveBuf() > 0) {
            this.bootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)this.conf.receiveBuf());
        }
        if (this.conf.sendBuf() > 0) {
            this.bootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)this.conf.sendBuf());
        }
        this.bootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                RpcHandler rpcHandler = TransportServer.this.appRpcHandler;
                for (TransportServerBootstrap bootstrap : TransportServer.this.bootstraps) {
                    rpcHandler = bootstrap.doBootstrap((Channel)ch, rpcHandler);
                }
                TransportServer.this.context.initializePipeline(ch, rpcHandler);
            }
        });
        InetSocketAddress address = hostToBind == null ? new InetSocketAddress(portToBind) : new InetSocketAddress(hostToBind, portToBind);
        this.channelFuture = this.bootstrap.bind((SocketAddress)address);
        this.channelFuture.syncUninterruptibly();
        this.port = ((InetSocketAddress)this.channelFuture.channel().localAddress()).getPort();
        this.logger.debug("Shuffle server started on port :" + this.port);
    }

    @Override
    public void close() {
        if (this.channelFuture != null) {
            this.channelFuture.channel().close().awaitUninterruptibly(10L, TimeUnit.SECONDS);
            this.channelFuture = null;
        }
        if (this.bootstrap != null && this.bootstrap.group() != null) {
            this.bootstrap.group().shutdownGracefully();
        }
        if (this.bootstrap != null && this.bootstrap.childGroup() != null) {
            this.bootstrap.childGroup().shutdownGracefully();
        }
        this.bootstrap = null;
    }
}

