/*
 * Decompiled with CFR 0.152.
 */
package com.ircclouds.irc.api.state;

import com.ircclouds.irc.api.domain.ChannelMode;
import com.ircclouds.irc.api.domain.IRCUserStatus;
import com.ircclouds.irc.api.domain.IRCUserStatusMode;
import com.ircclouds.irc.api.domain.IRCUserStatuses;
import com.ircclouds.irc.api.domain.WritableIRCChannel;
import com.ircclouds.irc.api.domain.WritableIRCTopic;
import com.ircclouds.irc.api.domain.WritableIRCUser;
import com.ircclouds.irc.api.domain.messages.ChanJoinMessage;
import com.ircclouds.irc.api.domain.messages.ChanPartMessage;
import com.ircclouds.irc.api.domain.messages.ChannelKick;
import com.ircclouds.irc.api.domain.messages.ChannelModeMessage;
import com.ircclouds.irc.api.domain.messages.NickMessage;
import com.ircclouds.irc.api.domain.messages.QuitMessage;
import com.ircclouds.irc.api.domain.messages.TopicMessage;
import com.ircclouds.irc.api.domain.messages.interfaces.IUserMessage;
import com.ircclouds.irc.api.listeners.VariousMessageListenerAdapter;
import com.ircclouds.irc.api.state.IRCStateImpl;
import com.ircclouds.irc.api.state.IStateAccessor;
import com.ircclouds.irc.api.utils.StateUtils;
import com.ircclouds.irc.api.utils.SynchronizedUnmodifiableSet;

public abstract class AbstractIRCStateUpdater
extends VariousMessageListenerAdapter
implements IStateAccessor {
    @Override
    public void onChannelJoin(ChanJoinMessage aMsg) {
        if (!this.isForMe(aMsg)) {
            WritableIRCUser _user = aMsg.getSource();
            WritableIRCChannel _chan = this.getIRCStateImpl().getWritableChannelByName(aMsg.getChannelName());
            this.savedOldState(_chan);
            _chan.addUser(_user);
        }
    }

    @Override
    public void onChannelPart(ChanPartMessage aMsg) {
        if (!this.isForMe(aMsg)) {
            WritableIRCChannel _chan = this.getIRCStateImpl().getWritableChannelByName(aMsg.getChannelName());
            this.savedOldState(_chan);
            _chan.removeUser(aMsg.getSource());
        }
    }

    @Override
    public void onNickChange(NickMessage aMsg) {
        WritableIRCUser _old = new WritableIRCUser(aMsg.getSource().getNick());
        WritableIRCUser _new = new WritableIRCUser(aMsg.getNewNick());
        for (WritableIRCChannel _chan : this.getIRCStateImpl().getChannelsMutable()) {
            this.savedOldState(_chan);
            if (!_chan.contains(_old)) continue;
            _chan.addUser(_new, _chan.removeUser(_old));
        }
    }

    @Override
    public void onUserQuit(QuitMessage aMsg) {
        for (WritableIRCChannel _chan : this.getIRCStateImpl().getChannelsMutable()) {
            this.savedOldState(_chan);
            _chan.removeUser(aMsg.getSource());
        }
    }

    @Override
    public void onTopicChange(TopicMessage aMsg) {
        WritableIRCChannel _chan = this.getIRCStateImpl().getWritableChannelByName(aMsg.getChannelName());
        this.savedOldState(_chan);
        WritableIRCTopic _wit = (WritableIRCTopic)_chan.getTopic();
        _wit.setDate(aMsg.getTopic().getDate());
        _wit.setSetBy(aMsg.getTopic().getSetBy());
        _wit.setValue(aMsg.getTopic().getValue());
    }

    @Override
    public void onChannelKick(ChannelKick aMsg) {
        WritableIRCChannel _chan = this.getIRCStateImpl().getWritableChannelByName(aMsg.getChannelName());
        this.savedOldState(_chan);
        _chan.removeUser(new WritableIRCUser(aMsg.getKickedNickname()));
    }

    @Override
    public void onChannelMode(ChannelModeMessage aMsg) {
        SynchronizedUnmodifiableSet _uStatuses;
        IRCUserStatus _us;
        IRCUserStatusMode _usm;
        String _chanName = aMsg.getChannelName();
        WritableIRCChannel _chan = this.getIRCStateImpl().getWritableChannelByName(_chanName);
        this.savedOldState(_chan);
        for (ChannelMode _mode : aMsg.getAddedModes()) {
            if (!(_mode instanceof IRCUserStatusMode)) continue;
            if (aMsg.getRemovedModes().contains(_mode)) {
                aMsg.getRemovedModes().remove(_mode);
                continue;
            }
            _usm = (IRCUserStatusMode)_mode;
            _us = this.getAvailableUserStatuses().getUserStatus(_usm.getChannelModeType());
            if (_us == null) continue;
            _uStatuses = (SynchronizedUnmodifiableSet)_chan.getStatusesForUser(new WritableIRCUser(_usm.getUser()));
            _uStatuses.addElement(_us);
        }
        for (ChannelMode _mode : aMsg.getRemovedModes()) {
            if (!(_mode instanceof IRCUserStatusMode)) continue;
            _usm = (IRCUserStatusMode)_mode;
            _us = this.getAvailableUserStatuses().getUserStatus(_usm.getChannelModeType());
            if (_us == null) continue;
            _uStatuses = (SynchronizedUnmodifiableSet)_chan.getStatusesForUser(new WritableIRCUser(_usm.getUser()));
            _uStatuses.removeElement(_us);
        }
    }

    private IRCStateImpl getIRCStateImpl() {
        return (IRCStateImpl)this.getIRCState();
    }

    private IRCStateImpl getPreviousIRCStateImpl() {
        return (IRCStateImpl)this.getIRCStateImpl().getPrevious();
    }

    private IRCUserStatuses getAvailableUserStatuses() {
        return this.getIRCState().getServerOptions().getUserChanStatuses();
    }

    private boolean isForMe(IUserMessage aMsg) {
        return this.getIRCState().getNickname().equals(aMsg.getSource().getNick());
    }

    @Override
    public void saveChan(WritableIRCChannel aChannel) {
        this.getIRCStateImpl().getChannelsMutable().addElement(aChannel);
    }

    @Override
    public void deleteChan(String aChannelName) {
        this.getIRCStateImpl().getChannelsMutable().removeElement(aChannelName);
    }

    @Override
    public void updateNick(String aNewNick) {
        this.getIRCStateImpl().updateNick(aNewNick);
    }

    @Override
    public void deleteNickFromChan(String aChannel, String aNick) {
        for (WritableIRCChannel _chan : this.getIRCStateImpl().getChannelsMutable()) {
            if (!_chan.getName().equals(aChannel)) continue;
            _chan.getUsers().remove(new WritableIRCUser(aNick));
            break;
        }
    }

    private void savedOldState(WritableIRCChannel aChan) {
        this.getPreviousIRCStateImpl().getChannelsMutable().removeElement(aChan);
        this.getPreviousIRCStateImpl().getChannelsMutable().addElement(StateUtils.cloneChannel(aChan));
    }
}

