/*
 * Decompiled with CFR 0.152.
 */
package com.ircclouds.irc.api.listeners;

import com.ircclouds.irc.api.Callback;
import com.ircclouds.irc.api.IIRCSession;
import com.ircclouds.irc.api.IRCException;
import com.ircclouds.irc.api.IServerParameters;
import com.ircclouds.irc.api.commands.SendRawMessage;
import com.ircclouds.irc.api.domain.IRCServerOptions;
import com.ircclouds.irc.api.domain.messages.ErrorMessage;
import com.ircclouds.irc.api.domain.messages.ServerNumericMessage;
import com.ircclouds.irc.api.state.IIRCState;
import com.ircclouds.irc.api.state.IRCStateImpl;
import java.io.IOException;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;

public class ConnectCmdListener {
    private String nick;
    private IServerParameters params;
    private Properties properties = new Properties();
    private IIRCSession session;
    private Queue<String> altNicks;
    private Callback<IIRCState> callback;

    public ConnectCmdListener(IIRCSession aSession) {
        this.session = aSession;
    }

    public void setCallback(Callback<IIRCState> aCallback, IServerParameters aServerParameters) {
        this.callback = aCallback;
        this.params = aServerParameters;
        this.altNicks = new ArrayBlockingQueue<String>(aServerParameters.getAlternativeNicknames().size(), true, aServerParameters.getAlternativeNicknames());
        this.properties = new Properties();
    }

    public void onServerMessage(ServerNumericMessage aServMsg) {
        if (aServMsg.getNumericCode() == 433) {
            String _altNick = null;
            if (this.altNicks.isEmpty()) {
                throw new RuntimeException("Found no more altnicks!");
            }
            _altNick = this.altNicks.poll();
            try {
                this.session.getCommandServer().execute(new SendRawMessage("NICK " + _altNick + "\r\n"));
            }
            catch (IOException aExc) {
                throw new RuntimeException(aExc);
            }
        } else {
            if (aServMsg.getNumericCode() == 432) {
                throw new RuntimeException("Errorneus nickname");
            }
            if (aServMsg.getNumericCode() == 1) {
                this.nick = this.getNick(aServMsg.getText());
            } else if (aServMsg.getNumericCode().equals(5)) {
                String[] _opts;
                for (String _opt : _opts = aServMsg.getText().split(" ")) {
                    if (!_opt.contains("=")) continue;
                    String[] _kv = _opt.split("=");
                    this.properties.put(_kv[0], _kv[1]);
                }
            } else if (aServMsg.getNumericCode().equals(422) || aServMsg.getNumericCode().equals(376)) {
                this.callback.onSuccess(new IRCStateImpl(this.nick, this.params.getIdent(), this.params.getRealname(), this.params.getAlternativeNicknames(), this.params.getServer(), new IRCServerOptions(this.properties)));
            }
        }
    }

    public void onError(ErrorMessage aMsg) {
        this.callback.onFailure(new IRCException(aMsg.getText()));
    }

    private String getNick(String aText) {
        String[] _cmpnt = aText.split(" ");
        String _nick = _cmpnt[_cmpnt.length - 1];
        if (_nick.contains("!")) {
            _nick = _nick.substring(0, _nick.indexOf("!"));
        }
        return _nick;
    }
}

