/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.format;

import java.util.Map;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.util.format.DefaultFormatter;
import org.apache.hadoop.io.Text;

public class BinaryFormatter
extends DefaultFormatter {
    private static int showLength;

    @Override
    public String next() {
        this.checkState(true);
        return BinaryFormatter.formatEntry(this.getScannerIterator().next(), this.isDoTimestamps());
    }

    public static String formatEntry(Map.Entry<Key, Value> entry, boolean showTimestamps) {
        Value value;
        StringBuilder sb = new StringBuilder();
        Key key = entry.getKey();
        BinaryFormatter.appendText(sb, key.getRow()).append(" ");
        BinaryFormatter.appendText(sb, key.getColumnFamily()).append(":");
        BinaryFormatter.appendText(sb, key.getColumnQualifier()).append(" ");
        sb.append(new ColumnVisibility(key.getColumnVisibility()));
        if (showTimestamps) {
            sb.append(" ").append(entry.getKey().getTimestamp());
        }
        if ((value = entry.getValue()) != null && value.getSize() > 0) {
            sb.append("\t");
            BinaryFormatter.appendValue(sb, value);
        }
        return sb.toString();
    }

    public static StringBuilder appendText(StringBuilder sb, Text t) {
        return BinaryFormatter.appendBytes(sb, t.getBytes(), 0, t.getLength());
    }

    static StringBuilder appendValue(StringBuilder sb, Value value) {
        return BinaryFormatter.appendBytes(sb, value.get(), 0, value.get().length);
    }

    static StringBuilder appendBytes(StringBuilder sb, byte[] ba, int offset, int len) {
        int length = Math.min(len, showLength);
        return DefaultFormatter.appendBytes(sb, ba, offset, length);
    }

    public static void getlength(int length) {
        showLength = length;
    }
}

