/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import com.google.auto.service.AutoService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.accumulo.start.Main;
import org.apache.accumulo.start.spi.KeywordExecutable;

@AutoService(value=KeywordExecutable.class)
public class Version
implements KeywordExecutable {
    String package_ = null;
    int major = 0;
    int minor = 0;
    int release = 0;
    String etcetera = null;

    public Version() {
    }

    public String keyword() {
        return "version";
    }

    public void execute(String[] args) throws Exception {
        Class<?> runTMP = Main.getClassLoader().loadClass("org.apache.accumulo.core.Constants");
        System.out.println(runTMP.getField("VERSION").get(null));
    }

    public Version(String everything) {
        this.parse(everything);
    }

    private void parse(String everything) {
        Pattern pattern = Pattern.compile("(([^-]*)-)?(\\d+)(\\.(\\d+)(\\.(\\d+))?)?(-(.*))?");
        Matcher parser = pattern.matcher(everything);
        if (!parser.matches()) {
            throw new IllegalArgumentException("Unable to parse: " + everything + " as a version");
        }
        if (parser.group(1) != null) {
            this.package_ = parser.group(2);
        }
        this.major = Integer.parseInt(parser.group(3));
        this.minor = 0;
        if (parser.group(5) != null) {
            this.minor = Integer.parseInt(parser.group(5));
        }
        if (parser.group(7) != null) {
            this.release = Integer.parseInt(parser.group(7));
        }
        if (parser.group(9) != null) {
            this.etcetera = parser.group(9);
        }
    }

    public String getPackage() {
        return this.package_;
    }

    public int getMajorVersion() {
        return this.major;
    }

    public int getMinorVersion() {
        return this.minor;
    }

    public int getReleaseVersion() {
        return this.release;
    }

    public String getEtcetera() {
        return this.etcetera;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.package_ != null) {
            result.append(this.package_);
            result.append("-");
        }
        result.append(this.major);
        result.append(".");
        result.append(this.minor);
        result.append(".");
        result.append(this.release);
        if (this.etcetera != null) {
            result.append("-");
            result.append(this.etcetera);
        }
        return result.toString();
    }
}

