/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import java.nio.ByteBuffer;
import org.apache.accumulo.core.util.ByteBufferUtil;
import org.apache.hadoop.io.WritableUtils;

public class UnsynchronizedBuffer {
    public static int nextArraySize(int i) {
        if (i < 0) {
            throw new IllegalArgumentException();
        }
        if (i > 0x40000000) {
            return Integer.MAX_VALUE;
        }
        if (i == 0) {
            return 1;
        }
        int ret = i;
        --ret;
        ret |= ret >> 1;
        ret |= ret >> 2;
        ret |= ret >> 4;
        ret |= ret >> 8;
        ret |= ret >> 16;
        return ++ret;
    }

    public static class Reader {
        int offset;
        byte[] data;

        public Reader(byte[] b) {
            this.data = b;
        }

        public Reader(ByteBuffer buffer) {
            if (buffer.hasArray() && buffer.array().length == buffer.arrayOffset() + buffer.limit()) {
                this.offset = buffer.arrayOffset() + buffer.position();
                this.data = buffer.array();
            } else {
                this.offset = 0;
                this.data = ByteBufferUtil.toBytes(buffer);
            }
        }

        public int readInt() {
            return (this.data[this.offset++] << 24) + ((this.data[this.offset++] & 0xFF) << 16) + ((this.data[this.offset++] & 0xFF) << 8) + ((this.data[this.offset++] & 0xFF) << 0);
        }

        public long readLong() {
            return ((long)this.data[this.offset++] << 56) + ((long)(this.data[this.offset++] & 0xFF) << 48) + ((long)(this.data[this.offset++] & 0xFF) << 40) + ((long)(this.data[this.offset++] & 0xFF) << 32) + ((long)(this.data[this.offset++] & 0xFF) << 24) + (long)((this.data[this.offset++] & 0xFF) << 16) + (long)((this.data[this.offset++] & 0xFF) << 8) + (long)((this.data[this.offset++] & 0xFF) << 0);
        }

        public void readBytes(byte[] b) {
            System.arraycopy(this.data, this.offset, b, 0, b.length);
            this.offset += b.length;
        }

        public boolean readBoolean() {
            return this.data[this.offset++] == 1;
        }

        public int readVInt() {
            return (int)this.readVLong();
        }

        public long readVLong() {
            byte firstByte;
            int len;
            if ((len = WritableUtils.decodeVIntSize((byte)(firstByte = this.data[this.offset++]))) == 1) {
                return firstByte;
            }
            long i = 0L;
            for (int idx = 0; idx < len - 1; ++idx) {
                byte b = this.data[this.offset++];
                i <<= 8;
                i |= (long)(b & 0xFF);
            }
            return WritableUtils.isNegativeVInt((byte)firstByte) ? i ^ 0xFFFFFFFFFFFFFFFFL : i;
        }
    }

    public static class Writer {
        int offset = 0;
        byte[] data;

        public Writer() {
            this.data = new byte[64];
        }

        public Writer(int initialCapacity) {
            this.data = new byte[initialCapacity];
        }

        private void reserve(int l) {
            if (this.offset + l > this.data.length) {
                int newSize = UnsynchronizedBuffer.nextArraySize(this.offset + l);
                byte[] newData = new byte[newSize];
                System.arraycopy(this.data, 0, newData, 0, this.offset);
                this.data = newData;
            }
        }

        public void add(byte[] bytes, int off, int length) {
            this.reserve(length);
            System.arraycopy(bytes, off, this.data, this.offset, length);
            this.offset += length;
        }

        public void add(boolean b) {
            this.reserve(1);
            this.data[this.offset++] = b ? (byte)1 : 0;
        }

        public byte[] toArray() {
            byte[] ret = new byte[this.offset];
            System.arraycopy(this.data, 0, ret, 0, this.offset);
            return ret;
        }

        public ByteBuffer toByteBuffer() {
            return ByteBuffer.wrap(this.data, 0, this.offset);
        }

        public void writeVInt(int i) {
            this.writeVLong(i);
        }

        public void writeVLong(long i) {
            this.reserve(9);
            if (i >= -112L && i <= 127L) {
                this.data[this.offset++] = (byte)i;
                return;
            }
            int len = -112;
            if (i < 0L) {
                i ^= 0xFFFFFFFFFFFFFFFFL;
                len = -120;
            }
            long tmp = i;
            while (tmp != 0L) {
                tmp >>= 8;
                --len;
            }
            this.data[this.offset++] = (byte)len;
            for (int idx = len = len < -120 ? -(len + 120) : -(len + 112); idx != 0; --idx) {
                int shiftbits = (idx - 1) * 8;
                long mask = 255L << shiftbits;
                this.data[this.offset++] = (byte)((i & mask) >> shiftbits);
            }
        }
    }
}

