/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.data.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.data.thrift.TKey;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class TKeyValue
implements TBase<TKeyValue, _Fields>,
Serializable,
Cloneable,
Comparable<TKeyValue> {
    private static final TStruct STRUCT_DESC = new TStruct("TKeyValue");
    private static final TField KEY_FIELD_DESC = new TField("key", 12, 1);
    private static final TField VALUE_FIELD_DESC = new TField("value", 11, 2);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public TKey key;
    public ByteBuffer value;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TKeyValue() {
    }

    public TKeyValue(TKey key, ByteBuffer value) {
        this();
        this.key = key;
        this.value = value;
    }

    public TKeyValue(TKeyValue other) {
        if (other.isSetKey()) {
            this.key = new TKey(other.key);
        }
        if (other.isSetValue()) {
            this.value = TBaseHelper.copyBinary((ByteBuffer)other.value);
        }
    }

    public TKeyValue deepCopy() {
        return new TKeyValue(this);
    }

    public void clear() {
        this.key = null;
        this.value = null;
    }

    public TKey getKey() {
        return this.key;
    }

    public TKeyValue setKey(TKey key) {
        this.key = key;
        return this;
    }

    public void unsetKey() {
        this.key = null;
    }

    public boolean isSetKey() {
        return this.key != null;
    }

    public void setKeyIsSet(boolean value) {
        if (!value) {
            this.key = null;
        }
    }

    public byte[] getValue() {
        this.setValue(TBaseHelper.rightSize((ByteBuffer)this.value));
        return this.value == null ? null : this.value.array();
    }

    public ByteBuffer bufferForValue() {
        return this.value;
    }

    public TKeyValue setValue(byte[] value) {
        this.setValue(value == null ? (ByteBuffer)null : ByteBuffer.wrap(value));
        return this;
    }

    public TKeyValue setValue(ByteBuffer value) {
        this.value = value;
        return this;
    }

    public void unsetValue() {
        this.value = null;
    }

    public boolean isSetValue() {
        return this.value != null;
    }

    public void setValueIsSet(boolean value) {
        if (!value) {
            this.value = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case KEY: {
                if (value == null) {
                    this.unsetKey();
                    break;
                }
                this.setKey((TKey)value);
                break;
            }
            case VALUE: {
                if (value == null) {
                    this.unsetValue();
                    break;
                }
                this.setValue((ByteBuffer)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case KEY: {
                return this.getKey();
            }
            case VALUE: {
                return this.getValue();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case KEY: {
                return this.isSetKey();
            }
            case VALUE: {
                return this.isSetValue();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof TKeyValue) {
            return this.equals((TKeyValue)that);
        }
        return false;
    }

    public boolean equals(TKeyValue that) {
        if (that == null) {
            return false;
        }
        boolean this_present_key = this.isSetKey();
        boolean that_present_key = that.isSetKey();
        if (this_present_key || that_present_key) {
            if (!this_present_key || !that_present_key) {
                return false;
            }
            if (!this.key.equals(that.key)) {
                return false;
            }
        }
        boolean this_present_value = this.isSetValue();
        boolean that_present_value = that.isSetValue();
        if (this_present_value || that_present_value) {
            if (!this_present_value || !that_present_value) {
                return false;
            }
            if (!this.value.equals(that.value)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return 0;
    }

    @Override
    public int compareTo(TKeyValue other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetKey()).compareTo(other.isSetKey());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetKey() && (lastComparison = TBaseHelper.compareTo((Comparable)this.key, (Comparable)other.key)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetValue()).compareTo(other.isSetValue());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetValue() && (lastComparison = TBaseHelper.compareTo((Comparable)this.value, (Comparable)other.value)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TKeyValue(");
        boolean first = true;
        sb.append("key:");
        if (this.key == null) {
            sb.append("null");
        } else {
            sb.append(this.key);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("value:");
        if (this.value == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString((ByteBuffer)this.value, (StringBuilder)sb);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.key != null) {
            this.key.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new TKeyValueStandardSchemeFactory());
        schemes.put(TupleScheme.class, new TKeyValueTupleSchemeFactory());
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.KEY, new FieldMetaData("key", 3, (FieldValueMetaData)new StructMetaData(12, TKey.class)));
        tmpMap.put(_Fields.VALUE, new FieldMetaData("value", 3, new FieldValueMetaData(11, true)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TKeyValue.class, metaDataMap);
    }

    private static class TKeyValueTupleScheme
    extends TupleScheme<TKeyValue> {
        private TKeyValueTupleScheme() {
        }

        public void write(TProtocol prot, TKeyValue struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetKey()) {
                optionals.set(0);
            }
            if (struct.isSetValue()) {
                optionals.set(1);
            }
            oprot.writeBitSet(optionals, 2);
            if (struct.isSetKey()) {
                struct.key.write((TProtocol)oprot);
            }
            if (struct.isSetValue()) {
                oprot.writeBinary(struct.value);
            }
        }

        public void read(TProtocol prot, TKeyValue struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(2);
            if (incoming.get(0)) {
                struct.key = new TKey();
                struct.key.read((TProtocol)iprot);
                struct.setKeyIsSet(true);
            }
            if (incoming.get(1)) {
                struct.value = iprot.readBinary();
                struct.setValueIsSet(true);
            }
        }
    }

    private static class TKeyValueTupleSchemeFactory
    implements SchemeFactory {
        private TKeyValueTupleSchemeFactory() {
        }

        public TKeyValueTupleScheme getScheme() {
            return new TKeyValueTupleScheme();
        }
    }

    private static class TKeyValueStandardScheme
    extends StandardScheme<TKeyValue> {
        private TKeyValueStandardScheme() {
        }

        public void read(TProtocol iprot, TKeyValue struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 12) {
                            struct.key = new TKey();
                            struct.key.read(iprot);
                            struct.setKeyIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.value = iprot.readBinary();
                            struct.setValueIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, TKeyValue struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.key != null) {
                oprot.writeFieldBegin(KEY_FIELD_DESC);
                struct.key.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.value != null) {
                oprot.writeFieldBegin(VALUE_FIELD_DESC);
                oprot.writeBinary(struct.value);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TKeyValueStandardSchemeFactory
    implements SchemeFactory {
        private TKeyValueStandardSchemeFactory() {
        }

        public TKeyValueStandardScheme getScheme() {
            return new TKeyValueStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        KEY(1, "key"),
        VALUE(2, "value");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return KEY;
                }
                case 2: {
                    return VALUE;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

