/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mock;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.mock.MockBatchScanner;
import org.apache.accumulo.core.client.mock.MockNamespace;
import org.apache.accumulo.core.client.mock.MockTable;
import org.apache.accumulo.core.client.mock.MockUser;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.NamespacePermission;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.Text;

public class MockAccumulo {
    final Map<String, MockTable> tables = new HashMap<String, MockTable>();
    final Map<String, MockNamespace> namespaces = new HashMap<String, MockNamespace>();
    final Map<String, String> systemProperties = new HashMap<String, String>();
    Map<String, MockUser> users = new HashMap<String, MockUser>();
    final FileSystem fs;
    final AtomicInteger tableIdCounter = new AtomicInteger(0);

    MockAccumulo(FileSystem fs) {
        MockUser root = new MockUser("root", new PasswordToken(new byte[0]), Authorizations.EMPTY);
        root.permissions.add(SystemPermission.SYSTEM);
        this.users.put(root.name, root);
        this.namespaces.put("", new MockNamespace());
        this.namespaces.put("accumulo", new MockNamespace());
        this.createTable("root", "accumulo.root", true, TimeType.LOGICAL);
        this.createTable("root", "accumulo.metadata", true, TimeType.LOGICAL);
        this.createTable("root", "accumulo.replication", true, TimeType.LOGICAL);
        this.fs = fs;
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    void setProperty(String key, String value) {
        this.systemProperties.put(key, value);
    }

    String removeProperty(String key) {
        return this.systemProperties.remove(key);
    }

    public void addMutation(String table, Mutation m) {
        MockTable t = this.tables.get(table);
        t.addMutation(m);
    }

    public BatchScanner createBatchScanner(String tableName, Authorizations authorizations) {
        return new MockBatchScanner(this.tables.get(tableName), authorizations);
    }

    public void createTable(String username, String tableName, boolean useVersions, TimeType timeType) {
        Map<String, String> opts = Collections.emptyMap();
        this.createTable(username, tableName, useVersions, timeType, opts);
    }

    public void createTable(String username, String tableName, boolean useVersions, TimeType timeType, Map<String, String> properties) {
        String namespace = Tables.qualify(tableName).getFirst();
        if (!this.namespaceExists(namespace)) {
            return;
        }
        MockNamespace n = this.namespaces.get(namespace);
        MockTable t = new MockTable(n, useVersions, timeType, Integer.toString(this.tableIdCounter.incrementAndGet()), properties);
        t.userPermissions.put(username, EnumSet.allOf(TablePermission.class));
        t.setNamespaceName(namespace);
        t.setNamespace(n);
        this.tables.put(tableName, t);
    }

    public void createTable(String username, String tableName, TimeType timeType, Map<String, String> properties) {
        String namespace = Tables.qualify(tableName).getFirst();
        HashMap<String, String> props = new HashMap<String, String>(properties);
        if (!this.namespaceExists(namespace)) {
            return;
        }
        MockNamespace n = this.namespaces.get(namespace);
        MockTable t = new MockTable(n, timeType, Integer.toString(this.tableIdCounter.incrementAndGet()), props);
        t.userPermissions.put(username, EnumSet.allOf(TablePermission.class));
        t.setNamespaceName(namespace);
        t.setNamespace(n);
        this.tables.put(tableName, t);
    }

    public void createNamespace(String username, String namespace) {
        if (!this.namespaceExists(namespace)) {
            MockNamespace n = new MockNamespace();
            n.userPermissions.put(username, EnumSet.allOf(NamespacePermission.class));
            this.namespaces.put(namespace, n);
        }
    }

    public void addSplits(String tableName, SortedSet<Text> partitionKeys) {
        this.tables.get(tableName).addSplits(partitionKeys);
    }

    public Collection<Text> getSplits(String tableName) {
        return this.tables.get(tableName).getSplits();
    }

    public void merge(String tableName, Text start, Text end) {
        this.tables.get(tableName).merge(start, end);
    }

    private boolean namespaceExists(String namespace) {
        return this.namespaces.containsKey(namespace);
    }
}

