/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.ConnectorImpl;
import org.apache.accumulo.core.client.impl.Credentials;
import org.apache.accumulo.core.client.impl.InstanceOperationsImpl;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.util.ByteBufferUtil;
import org.apache.accumulo.core.util.OpTimer;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.fate.zookeeper.ZooCacheFactory;
import org.apache.commons.configuration.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class ZooKeeperInstance
implements Instance {
    private static final Logger log = Logger.getLogger(ZooKeeperInstance.class);
    private String instanceId = null;
    private String instanceName = null;
    private final ZooCache zooCache;
    private final String zooKeepers;
    private final int zooKeepersSessionTimeOut;
    private AccumuloConfiguration conf;
    private ClientConfiguration clientConf;

    public ZooKeeperInstance(String instanceName, String zooKeepers) {
        this((Configuration)ClientConfiguration.loadDefault().withInstance(instanceName).withZkHosts(zooKeepers));
    }

    @Deprecated
    public ZooKeeperInstance(String instanceName, String zooKeepers, int sessionTimeout) {
        this((Configuration)ClientConfiguration.loadDefault().withInstance(instanceName).withZkHosts(zooKeepers).withZkTimeout(sessionTimeout));
    }

    @Deprecated
    public ZooKeeperInstance(UUID instanceId, String zooKeepers) {
        this((Configuration)ClientConfiguration.loadDefault().withInstance(instanceId).withZkHosts(zooKeepers));
    }

    @Deprecated
    public ZooKeeperInstance(UUID instanceId, String zooKeepers, int sessionTimeout) {
        this((Configuration)ClientConfiguration.loadDefault().withInstance(instanceId).withZkHosts(zooKeepers).withZkTimeout(sessionTimeout));
    }

    public ZooKeeperInstance(Configuration config) {
        this(config, new ZooCacheFactory());
    }

    ZooKeeperInstance(Configuration config, ZooCacheFactory zcf) {
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"config is null");
        this.clientConf = config instanceof ClientConfiguration ? (ClientConfiguration)config : new ClientConfiguration(config);
        this.instanceId = this.clientConf.get(ClientConfiguration.ClientProperty.INSTANCE_ID);
        this.instanceName = this.clientConf.get(ClientConfiguration.ClientProperty.INSTANCE_NAME);
        if (this.instanceId == null == (this.instanceName == null)) {
            throw new IllegalArgumentException("Expected exactly one of instanceName and instanceId to be set");
        }
        this.zooKeepers = this.clientConf.get(ClientConfiguration.ClientProperty.INSTANCE_ZK_HOST);
        this.zooKeepersSessionTimeOut = (int)AccumuloConfiguration.getTimeInMillis(this.clientConf.get(ClientConfiguration.ClientProperty.INSTANCE_ZK_TIMEOUT));
        this.zooCache = zcf.getZooCache(this.zooKeepers, this.zooKeepersSessionTimeOut);
        if (null != this.instanceName) {
            this.getInstanceID();
        }
    }

    @Override
    public String getInstanceID() {
        if (this.instanceId == null) {
            String instanceNamePath = "/accumulo/instances/" + this.instanceName;
            byte[] iidb = this.zooCache.get(instanceNamePath);
            if (iidb == null) {
                throw new RuntimeException("Instance name " + this.instanceName + " does not exist in zookeeper.  Run \"accumulo org.apache.accumulo.server.util.ListInstances\" to see a list.");
            }
            this.instanceId = new String(iidb, StandardCharsets.UTF_8);
        }
        if (this.zooCache.get("/accumulo/" + this.instanceId) == null) {
            if (this.instanceName == null) {
                throw new RuntimeException("Instance id " + this.instanceId + " does not exist in zookeeper");
            }
            throw new RuntimeException("Instance id " + this.instanceId + " pointed to by the name " + this.instanceName + " does not exist in zookeeper");
        }
        return this.instanceId;
    }

    @Override
    public List<String> getMasterLocations() {
        String masterLocPath = ZooUtil.getRoot(this) + "/masters/lock";
        OpTimer opTimer = new OpTimer(log, Level.TRACE).start("Looking up master location in zoocache.");
        byte[] loc = ZooUtil.getLockData((ZooCache)this.zooCache, (String)masterLocPath);
        opTimer.stop("Found master at " + (loc == null ? null : new String(loc, StandardCharsets.UTF_8)) + " in %DURATION%");
        if (loc == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new String(loc, StandardCharsets.UTF_8));
    }

    @Override
    public String getRootTabletLocation() {
        String zRootLocPath = ZooUtil.getRoot(this) + "/root_tablet/location";
        OpTimer opTimer = new OpTimer(log, Level.TRACE).start("Looking up root tablet location in zookeeper.");
        byte[] loc = this.zooCache.get(zRootLocPath);
        opTimer.stop("Found root tablet at " + (loc == null ? null : new String(loc, StandardCharsets.UTF_8)) + " in %DURATION%");
        if (loc == null) {
            return null;
        }
        return new String(loc, StandardCharsets.UTF_8).split("\\|")[0];
    }

    @Override
    public String getInstanceName() {
        if (this.instanceName == null) {
            this.instanceName = InstanceOperationsImpl.lookupInstanceName(this.zooCache, UUID.fromString(this.getInstanceID()));
        }
        return this.instanceName;
    }

    @Override
    public String getZooKeepers() {
        return this.zooKeepers;
    }

    @Override
    public int getZooKeepersSessionTimeOut() {
        return this.zooKeepersSessionTimeOut;
    }

    @Override
    @Deprecated
    public Connector getConnector(String user, CharSequence pass) throws AccumuloException, AccumuloSecurityException {
        return this.getConnector(user, TextUtil.getBytes(new Text(pass.toString())));
    }

    @Override
    @Deprecated
    public Connector getConnector(String user, ByteBuffer pass) throws AccumuloException, AccumuloSecurityException {
        return this.getConnector(user, ByteBufferUtil.toBytes(pass));
    }

    @Override
    public Connector getConnector(String principal, AuthenticationToken token) throws AccumuloException, AccumuloSecurityException {
        return new ConnectorImpl(new ClientContext((Instance)this, new Credentials(principal, token), this.clientConf));
    }

    @Override
    @Deprecated
    public Connector getConnector(String principal, byte[] pass) throws AccumuloException, AccumuloSecurityException {
        return this.getConnector(principal, new PasswordToken(pass));
    }

    @Override
    @Deprecated
    public AccumuloConfiguration getConfiguration() {
        this.conf = this.conf == null ? DefaultConfiguration.getInstance() : ClientContext.convertClientConfig((Configuration)this.clientConf);
        return this.conf;
    }

    @Override
    @Deprecated
    public void setConfiguration(AccumuloConfiguration conf) {
        this.conf = conf;
    }

    @Deprecated
    public static String lookupInstanceName(ZooCache zooCache, UUID instanceId) {
        return InstanceOperationsImpl.lookupInstanceName(zooCache, instanceId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("ZooKeeperInstance: ").append(this.getInstanceName()).append(" ").append(this.getZooKeepers());
        return sb.toString();
    }
}

