/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaException;
import org.apache.hadoop.hive.metastore.MetaStoreSchemaInfo;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hive.beeline.BeeLine;
import org.apache.hive.beeline.HiveSchemaHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveSchemaTool {
    private String userName = null;
    private String passWord = null;
    private boolean dryRun = false;
    private boolean verbose = false;
    private String dbOpts = null;
    private URI[] validationServers = null;
    private final HiveConf hiveConf;
    private final String dbType;
    private final MetaStoreSchemaInfo metaStoreSchemaInfo;
    private static final Logger LOG = LoggerFactory.getLogger((String)HiveSchemaTool.class.getName());

    public HiveSchemaTool(String dbType) throws HiveMetaException {
        this(System.getenv("HIVE_HOME"), new HiveConf(HiveSchemaTool.class), dbType);
    }

    public HiveSchemaTool(String hiveHome, HiveConf hiveConf, String dbType) throws HiveMetaException {
        if (hiveHome == null || hiveHome.isEmpty()) {
            throw new HiveMetaException("No Hive home directory provided");
        }
        this.hiveConf = hiveConf;
        this.dbType = dbType;
        this.metaStoreSchemaInfo = new MetaStoreSchemaInfo(hiveHome, dbType);
        this.userName = hiveConf.get(HiveConf.ConfVars.METASTORE_CONNECTION_USER_NAME.varname);
        try {
            this.passWord = ShimLoader.getHadoopShims().getPassword((Configuration)hiveConf, HiveConf.ConfVars.METASTOREPWD.varname);
        }
        catch (IOException err) {
            throw new HiveMetaException("Error getting metastore password", (Throwable)err);
        }
    }

    public HiveConf getHiveConf() {
        return this.hiveConf;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassWord(String passWord) {
        this.passWord = passWord;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setDbOpts(String dbOpts) {
        this.dbOpts = dbOpts;
    }

    public void setValidationServers(String servers) {
        if (StringUtils.isNotEmpty((String)servers)) {
            String[] strServers = servers.split(",");
            this.validationServers = new URI[strServers.length];
            for (int i = 0; i < this.validationServers.length; ++i) {
                this.validationServers[i] = new Path(strServers[i]).toUri();
            }
        }
    }

    private static void printAndExit(Options cmdLineOptions) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("schemaTool", cmdLineOptions);
        System.exit(1);
    }

    Connection getConnectionToMetastore(boolean printInfo) throws HiveMetaException {
        return HiveSchemaHelper.getConnectionToMetastore(this.userName, this.passWord, printInfo, this.hiveConf);
    }

    private HiveSchemaHelper.NestedScriptParser getDbCommandParser(String dbType) {
        return HiveSchemaHelper.getDbCommandParser(dbType, this.dbOpts, this.userName, this.passWord, this.hiveConf);
    }

    public void showInfo() throws HiveMetaException {
        Connection metastoreConn = this.getConnectionToMetastore(true);
        String hiveVersion = MetaStoreSchemaInfo.getHiveSchemaVersion();
        String dbVersion = this.getMetaStoreSchemaVersion(metastoreConn);
        System.out.println("Hive distribution version:\t " + hiveVersion);
        System.out.println("Metastore schema version:\t " + dbVersion);
        this.assertCompatibleVersion(hiveVersion, dbVersion);
    }

    private String getMetaStoreSchemaVersion(Connection metastoreConn) throws HiveMetaException {
        return this.getMetaStoreSchemaVersion(metastoreConn, false);
    }

    /*
     * Exception decompiling
     */
    private String getMetaStoreSchemaVersion(Connection metastoreConn, boolean checkDuplicatedVersion) throws HiveMetaException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    boolean validateLocations(Connection conn, URI[] defaultServers) throws HiveMetaException {
        System.out.println("Validating database/table/partition locations");
        boolean rtn = this.checkMetaStoreDBLocation(conn, defaultServers);
        rtn = this.checkMetaStoreTableLocation(conn, defaultServers) && rtn;
        rtn = this.checkMetaStorePartitionLocation(conn, defaultServers) && rtn;
        rtn = this.checkMetaStoreSkewedColumnsLocation(conn, defaultServers) && rtn;
        System.out.println((rtn ? "Succeeded" : "Failed") + " in database/table/partition location validation");
        return rtn;
    }

    private String getNameOrID(ResultSet res, int nameInx, int idInx) throws SQLException {
        String itemName = res.getString(nameInx);
        return itemName == null || itemName.isEmpty() ? "ID: " + res.getString(idInx) : "Name: " + itemName;
    }

    private boolean checkMetaStoreDBLocation(Connection conn, URI[] defaultServers) throws HiveMetaException {
        boolean isValid = true;
        int numOfInvalid = 0;
        String dbLoc = this.getDbCommandParser(this.dbType).needsQuotedIdentifier() ? "select dbt.\"DB_ID\", dbt.\"NAME\", dbt.\"DB_LOCATION_URI\" from \"DBS\" dbt" : "select dbt.DB_ID, dbt.NAME, dbt.DB_LOCATION_URI from DBS dbt";
        try (Statement stmt = conn.createStatement();
             ResultSet res = stmt.executeQuery(dbLoc);){
            while (res.next()) {
                String locValue = res.getString(3);
                String dbName = this.getNameOrID(res, 2, 1);
                if (this.checkLocation("Database " + dbName, locValue, defaultServers)) continue;
                ++numOfInvalid;
            }
        }
        catch (SQLException e) {
            throw new HiveMetaException("Failed to get DB Location Info.", (Throwable)e);
        }
        if (numOfInvalid > 0) {
            isValid = false;
            System.err.println("Total number of invalid DB locations is: " + numOfInvalid);
        }
        return isValid;
    }

    private boolean checkMetaStoreTableLocation(Connection conn, URI[] defaultServers) throws HiveMetaException {
        boolean isValid = true;
        int numOfInvalid = 0;
        String tabIDRange = this.getDbCommandParser(this.dbType).needsQuotedIdentifier() ? "select max(\"TBL_ID\"), min(\"TBL_ID\") from \"TBLS\" " : "select max(TBL_ID), min(TBL_ID) from TBLS";
        String tabLoc = this.getDbCommandParser(this.dbType).needsQuotedIdentifier() ? "select tbl.\"TBL_ID\", tbl.\"TBL_NAME\", sd.\"LOCATION\", dbt.\"DB_ID\", dbt.\"NAME\" from \"TBLS\" tbl inner join \"SDS\" sd on tbl.\"SD_ID\" = sd.\"SD_ID\" and tbl.\"TBL_TYPE\" != '" + TableType.VIRTUAL_VIEW + "' and tbl.\"TBL_ID\" >= ? and tbl.\"TBL_ID\"<= ? inner join \"DBS\" dbt on tbl.\"DB_ID\" = dbt.\"DB_ID\" " : "select tbl.TBL_ID, tbl.TBL_NAME, sd.LOCATION, dbt.DB_ID, dbt.NAME from TBLS tbl join SDS sd on tbl.SD_ID = sd.SD_ID and tbl.TBL_TYPE !='" + TableType.VIRTUAL_VIEW + "' and tbl.TBL_ID >= ? and tbl.TBL_ID <= ?  inner join DBS dbt on tbl.DB_ID = dbt.DB_ID";
        long maxID = 0L;
        long minID = 0L;
        long rtnSize = 2000L;
        try {
            Statement stmt = conn.createStatement();
            ResultSet res = stmt.executeQuery(tabIDRange);
            if (res.next()) {
                maxID = res.getLong(1);
                minID = res.getLong(2);
            }
            res.close();
            stmt.close();
            PreparedStatement pStmt = conn.prepareStatement(tabLoc);
            while (minID <= maxID) {
                pStmt.setLong(1, minID);
                pStmt.setLong(2, minID + rtnSize);
                res = pStmt.executeQuery();
                while (res.next()) {
                    String locValue = res.getString(3);
                    String entity = "Database " + this.getNameOrID(res, 5, 4) + ", Table " + this.getNameOrID(res, 2, 1);
                    if (this.checkLocation(entity, locValue, defaultServers)) continue;
                    ++numOfInvalid;
                }
                res.close();
                minID += rtnSize + 1L;
            }
            pStmt.close();
        }
        catch (SQLException e) {
            throw new HiveMetaException("Failed to get Table Location Info.", (Throwable)e);
        }
        if (numOfInvalid > 0) {
            isValid = false;
            System.err.println("Total number of invalid TABLE locations is: " + numOfInvalid);
        }
        return isValid;
    }

    private boolean checkMetaStorePartitionLocation(Connection conn, URI[] defaultServers) throws HiveMetaException {
        boolean isValid = true;
        int numOfInvalid = 0;
        String partIDRange = this.getDbCommandParser(this.dbType).needsQuotedIdentifier() ? "select max(\"PART_ID\"), min(\"PART_ID\") from \"PARTITIONS\" " : "select max(PART_ID), min(PART_ID) from PARTITIONS";
        String partLoc = this.getDbCommandParser(this.dbType).needsQuotedIdentifier() ? "select pt.\"PART_ID\", pt.\"PART_NAME\", sd.\"LOCATION\", tbl.\"TBL_ID\", tbl.\"TBL_NAME\",dbt.\"DB_ID\", dbt.\"NAME\" from \"PARTITIONS\" pt inner join \"SDS\" sd on pt.\"SD_ID\" = sd.\"SD_ID\" and pt.\"PART_ID\" >= ? and pt.\"PART_ID\"<= ?  inner join \"TBLS\" tbl on pt.\"TBL_ID\" = tbl.\"TBL_ID\" inner join \"DBS\" dbt on tbl.\"DB_ID\" = dbt.\"DB_ID\" " : "select pt.PART_ID, pt.PART_NAME, sd.LOCATION, tbl.TBL_ID, tbl.TBL_NAME, dbt.DB_ID, dbt.NAME from PARTITIONS pt inner join SDS sd on pt.SD_ID = sd.SD_ID and pt.PART_ID >= ? and pt.PART_ID <= ?  inner join TBLS tbl on tbl.TBL_ID = pt.TBL_ID inner join DBS dbt on tbl.DB_ID = dbt.DB_ID ";
        long maxID = 0L;
        long minID = 0L;
        long rtnSize = 2000L;
        try {
            Statement stmt = conn.createStatement();
            ResultSet res = stmt.executeQuery(partIDRange);
            if (res.next()) {
                maxID = res.getLong(1);
                minID = res.getLong(2);
            }
            res.close();
            stmt.close();
            PreparedStatement pStmt = conn.prepareStatement(partLoc);
            while (minID <= maxID) {
                pStmt.setLong(1, minID);
                pStmt.setLong(2, minID + rtnSize);
                res = pStmt.executeQuery();
                while (res.next()) {
                    String locValue = res.getString(3);
                    String entity = "Database " + this.getNameOrID(res, 7, 6) + ", Table " + this.getNameOrID(res, 5, 4) + ", Partition " + this.getNameOrID(res, 2, 1);
                    if (this.checkLocation(entity, locValue, defaultServers)) continue;
                    ++numOfInvalid;
                }
                res.close();
                minID += rtnSize + 1L;
            }
            pStmt.close();
        }
        catch (SQLException e) {
            throw new HiveMetaException("Failed to get Partiton Location Info.", (Throwable)e);
        }
        if (numOfInvalid > 0) {
            isValid = false;
            System.err.println("Total number of invalid PARTITION locations is: " + numOfInvalid);
        }
        return isValid;
    }

    private boolean checkMetaStoreSkewedColumnsLocation(Connection conn, URI[] defaultServers) throws HiveMetaException {
        boolean isValid = true;
        int numOfInvalid = 0;
        String skewedColIDRange = this.getDbCommandParser(this.dbType).needsQuotedIdentifier() ? "select max(\"STRING_LIST_ID_KID\"), min(\"STRING_LIST_ID_KID\") from \"SKEWED_COL_VALUE_LOC_MAP\" " : "select max(STRING_LIST_ID_KID), min(STRING_LIST_ID_KID) from SKEWED_COL_VALUE_LOC_MAP";
        String skewedColLoc = this.getDbCommandParser(this.dbType).needsQuotedIdentifier() ? "select t.\"TBL_NAME\", t.\"TBL_ID\", sk.\"STRING_LIST_ID_KID\", sk.\"LOCATION\" from \"TBLS\" t, \"SDS\" s, \"SKEWED_COL_VALUE_LOC_MAP\" sk where sk.\"SD_ID\" = s.\"SD_ID\" and s.\"SD_ID\" = t.\"SD_ID\" and sk.\"STRING_LIST_ID_KID\" >= ? and sk.\"STRING_LIST_ID_KID\" <= ? " : "select t.TBL_NAME, t.TBL_ID, sk.STRING_LIST_ID_KID, sk.LOCATION from TBLS t, SDS s, SKEWED_COL_VALUE_LOC_MAP sk where sk.SD_ID = s.SD_ID and s.SD_ID = t.SD_ID and sk.STRING_LIST_ID_KID >= ? and sk.STRING_LIST_ID_KID <= ? ";
        long maxID = 0L;
        long minID = 0L;
        long rtnSize = 2000L;
        try {
            Statement stmt = conn.createStatement();
            ResultSet res = stmt.executeQuery(skewedColIDRange);
            if (res.next()) {
                maxID = res.getLong(1);
                minID = res.getLong(2);
            }
            res.close();
            stmt.close();
            PreparedStatement pStmt = conn.prepareStatement(skewedColLoc);
            while (minID <= maxID) {
                pStmt.setLong(1, minID);
                pStmt.setLong(2, minID + rtnSize);
                res = pStmt.executeQuery();
                while (res.next()) {
                    String locValue = res.getString(4);
                    String entity = "Table " + this.getNameOrID(res, 1, 2) + ", String list " + res.getString(3);
                    if (this.checkLocation(entity, locValue, defaultServers)) continue;
                    ++numOfInvalid;
                }
                res.close();
                minID += rtnSize + 1L;
            }
            pStmt.close();
        }
        catch (SQLException e) {
            throw new HiveMetaException("Failed to get skewed columns location info.", (Throwable)e);
        }
        if (numOfInvalid > 0) {
            isValid = false;
            System.err.println("Total number of invalid SKEWED_COL_VALUE_LOC_MAP locations is: " + numOfInvalid);
        }
        return isValid;
    }

    private boolean checkLocation(String entity, String entityLocation, URI[] defaultServers) {
        boolean isValid = true;
        if (entityLocation == null) {
            System.err.println(entity + ", error: empty location");
            isValid = false;
        } else {
            try {
                URI currentUri = new Path(entityLocation).toUri();
                String scheme = currentUri.getScheme();
                if (StringUtils.isEmpty((String)scheme)) {
                    System.err.println(entity + ", location: " + entityLocation + ", error: missing location scheme");
                    isValid = false;
                } else if (ArrayUtils.isNotEmpty((Object[])defaultServers) && currentUri.getAuthority() != null) {
                    String authority = currentUri.getAuthority();
                    boolean matchServer = false;
                    for (URI server : defaultServers) {
                        if (!StringUtils.equalsIgnoreCase((String)server.getScheme(), (String)scheme) || !StringUtils.equalsIgnoreCase((String)server.getAuthority(), (String)authority)) continue;
                        matchServer = true;
                        break;
                    }
                    if (!matchServer) {
                        System.err.println(entity + ", location: " + entityLocation + ", error: mismatched server");
                        isValid = false;
                    }
                }
            }
            catch (Exception pe) {
                System.err.println(entity + ", error: invalid location " + pe.getMessage());
                isValid = false;
            }
        }
        return isValid;
    }

    private void testConnectionToMetastore() throws HiveMetaException {
        Connection conn = this.getConnectionToMetastore(true);
        try {
            conn.close();
        }
        catch (SQLException e) {
            throw new HiveMetaException("Failed to close metastore connection", (Throwable)e);
        }
    }

    public void verifySchemaVersion() throws HiveMetaException {
        if (this.dryRun) {
            return;
        }
        String newSchemaVersion = this.getMetaStoreSchemaVersion(this.getConnectionToMetastore(false));
        this.assertCompatibleVersion(MetaStoreSchemaInfo.getHiveSchemaVersion(), newSchemaVersion);
    }

    private void assertCompatibleVersion(String hiveSchemaVersion, String dbSchemaVersion) throws HiveMetaException {
        if (!MetaStoreSchemaInfo.isVersionCompatible((String)hiveSchemaVersion, (String)dbSchemaVersion)) {
            throw new HiveMetaException("Metastore schema version is not compatible. Hive Version: " + hiveSchemaVersion + ", Database Schema Version: " + dbSchemaVersion);
        }
    }

    public void doUpgrade() throws HiveMetaException {
        String fromVersion = this.getMetaStoreSchemaVersion(this.getConnectionToMetastore(false));
        if (fromVersion == null || fromVersion.isEmpty()) {
            throw new HiveMetaException("Schema version not stored in the metastore. Metastore schema is too old or corrupt. Try specifying the version manually");
        }
        this.doUpgrade(fromVersion);
    }

    public void doUpgrade(String fromSchemaVer) throws HiveMetaException {
        if (MetaStoreSchemaInfo.getHiveSchemaVersion().equals(fromSchemaVer)) {
            System.out.println("No schema upgrade required from version " + fromSchemaVer);
            return;
        }
        List upgradeScripts = this.metaStoreSchemaInfo.getUpgradeScripts(fromSchemaVer);
        this.testConnectionToMetastore();
        System.out.println("Starting upgrade metastore schema from version " + fromSchemaVer + " to " + MetaStoreSchemaInfo.getHiveSchemaVersion());
        String scriptDir = this.metaStoreSchemaInfo.getMetaStoreScriptDir();
        try {
            for (String scriptFile : upgradeScripts) {
                System.out.println("Upgrade script " + scriptFile);
                if (this.dryRun) continue;
                this.runPreUpgrade(scriptDir, scriptFile);
                this.runBeeLine(scriptDir, scriptFile);
                System.out.println("Completed " + scriptFile);
            }
        }
        catch (IOException eIO) {
            throw new HiveMetaException("Upgrade FAILED! Metastore state would be inconsistent !!", (Throwable)eIO);
        }
        this.verifySchemaVersion();
    }

    public void doInit() throws HiveMetaException {
        this.doInit(MetaStoreSchemaInfo.getHiveSchemaVersion());
        this.verifySchemaVersion();
    }

    public void doInit(String toVersion) throws HiveMetaException {
        this.testConnectionToMetastore();
        System.out.println("Starting metastore schema initialization to " + toVersion);
        String initScriptDir = this.metaStoreSchemaInfo.getMetaStoreScriptDir();
        String initScriptFile = this.metaStoreSchemaInfo.generateInitFileName(toVersion);
        try {
            System.out.println("Initialization script " + initScriptFile);
            if (!this.dryRun) {
                this.runBeeLine(initScriptDir, initScriptFile);
                System.out.println("Initialization script completed");
            }
        }
        catch (IOException e) {
            throw new HiveMetaException("Schema initialization FAILED! Metastore state would be inconsistent !!", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doValidate() throws HiveMetaException {
        System.out.println("Starting metastore validation\n");
        Connection conn = this.getConnectionToMetastore(false);
        boolean success = true;
        try {
            if (this.validateSchemaVersions(conn)) {
                System.out.println("[SUCCESS]\n");
            } else {
                success = false;
                System.out.println("[FAIL]\n");
            }
            if (this.validateSequences(conn)) {
                System.out.println("[SUCCESS]\n");
            } else {
                success = false;
                System.out.println("[FAIL]\n");
            }
            if (this.validateSchemaTables(conn)) {
                System.out.println("[SUCCESS]\n");
            } else {
                success = false;
                System.out.println("[FAIL]\n");
            }
            if (this.validateLocations(conn, this.validationServers)) {
                System.out.println("[SUCCESS]\n");
            } else {
                success = false;
                System.out.println("[FAIL]\n");
            }
            if (this.validateColumnNullValues(conn)) {
                System.out.println("[SUCCESS]\n");
            } else {
                success = false;
                System.out.println("[FAIL]\n");
            }
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    throw new HiveMetaException("Failed to close metastore connection", (Throwable)e);
                }
            }
        }
        System.out.print("Done with metastore validation: ");
        if (!success) {
            System.out.println("[FAIL]");
            System.exit(1);
        } else {
            System.out.println("[SUCCESS]");
        }
    }

    boolean validateSequences(Connection conn) throws HiveMetaException {
        ImmutableMap seqNameToTable = new ImmutableMap.Builder().put((Object)"MDatabase", (Object)Pair.of((Object)"DBS", (Object)"DB_ID")).put((Object)"MRole", (Object)Pair.of((Object)"ROLES", (Object)"ROLE_ID")).put((Object)"MGlobalPrivilege", (Object)Pair.of((Object)"GLOBAL_PRIVS", (Object)"USER_GRANT_ID")).put((Object)"MTable", (Object)Pair.of((Object)"TBLS", (Object)"TBL_ID")).put((Object)"MStorageDescriptor", (Object)Pair.of((Object)"SDS", (Object)"SD_ID")).put((Object)"MSerDeInfo", (Object)Pair.of((Object)"SERDES", (Object)"SERDE_ID")).put((Object)"MColumnDescriptor", (Object)Pair.of((Object)"CDS", (Object)"CD_ID")).put((Object)"MTablePrivilege", (Object)Pair.of((Object)"TBL_PRIVS", (Object)"TBL_GRANT_ID")).put((Object)"MTableColumnStatistics", (Object)Pair.of((Object)"TAB_COL_STATS", (Object)"CS_ID")).put((Object)"MPartition", (Object)Pair.of((Object)"PARTITIONS", (Object)"PART_ID")).put((Object)"MPartitionColumnStatistics", (Object)Pair.of((Object)"PART_COL_STATS", (Object)"CS_ID")).put((Object)"MFunction", (Object)Pair.of((Object)"FUNCS", (Object)"FUNC_ID")).put((Object)"MIndex", (Object)Pair.of((Object)"IDXS", (Object)"INDEX_ID")).put((Object)"MStringList", (Object)Pair.of((Object)"SKEWED_STRING_LIST", (Object)"STRING_LIST_ID")).build();
        System.out.println("Validating sequence number for SEQUENCE_TABLE");
        boolean isValid = true;
        try {
            Statement stmt = conn.createStatement();
            for (String seqName : seqNameToTable.keySet()) {
                long maxId;
                String tableName = (String)((Pair)seqNameToTable.get(seqName)).getLeft();
                String tableKey = (String)((Pair)seqNameToTable.get(seqName)).getRight();
                String seqQuery = this.getDbCommandParser(this.dbType).needsQuotedIdentifier() ? "select t.\"NEXT_VAL\" from \"SEQUENCE_TABLE\" t WHERE t.\"SEQUENCE_NAME\"='org.apache.hadoop.hive.metastore.model." + seqName + "'" : "select t.NEXT_VAL from SEQUENCE_TABLE t WHERE t.SEQUENCE_NAME='org.apache.hadoop.hive.metastore.model." + seqName + "'";
                String maxIdQuery = this.getDbCommandParser(this.dbType).needsQuotedIdentifier() ? "select max(\"" + tableKey + "\") from \"" + tableName + "\"" : "select max(" + tableKey + ") from " + tableName;
                ResultSet res = stmt.executeQuery(maxIdQuery);
                if (!res.next() || (maxId = res.getLong(1)) <= 0L) continue;
                ResultSet resSeq = stmt.executeQuery(seqQuery);
                if (!resSeq.next()) {
                    isValid = false;
                    System.err.println("Missing SEQUENCE_NAME " + seqName + " from SEQUENCE_TABLE");
                    continue;
                }
                if (resSeq.getLong(1) >= maxId) continue;
                isValid = false;
                System.err.println("NEXT_VAL for " + seqName + " in SEQUENCE_TABLE < max(" + tableKey + ") in " + tableName);
            }
            System.out.println((isValid ? "Succeeded" : "Failed") + " in sequence number validation for SEQUENCE_TABLE");
            return isValid;
        }
        catch (SQLException e) {
            throw new HiveMetaException("Failed to validate sequence number for SEQUENCE_TABLE", (Throwable)e);
        }
    }

    boolean validateSchemaVersions(Connection conn) throws HiveMetaException {
        System.out.println("Validating schema version");
        try {
            String newSchemaVersion = this.getMetaStoreSchemaVersion(conn, true);
            this.assertCompatibleVersion(MetaStoreSchemaInfo.getHiveSchemaVersion(), newSchemaVersion);
        }
        catch (HiveMetaException hme) {
            if (hme.getMessage().contains("Metastore schema version is not compatible") || hme.getMessage().contains("Multiple versions were found in metastore") || hme.getMessage().contains("Could not find version info in metastore VERSION table")) {
                System.out.println("Failed in schema version validation: " + hme.getMessage());
                return false;
            }
            throw hme;
        }
        System.out.println("Succeeded in schema version validation.");
        return true;
    }

    boolean validateSchemaTables(Connection conn) throws HiveMetaException {
        String version = null;
        ResultSet rs = null;
        DatabaseMetaData metadata = null;
        ArrayList<String> dbTables = new ArrayList<String>();
        ArrayList<String> schemaTables = new ArrayList<String>();
        ArrayList<String> subScripts = new ArrayList<String>();
        Connection hmsConn = this.getConnectionToMetastore(false);
        System.out.println("Validating metastore schema tables");
        try {
            version = this.getMetaStoreSchemaVersion(hmsConn);
        }
        catch (HiveMetaException he) {
            System.err.println("Failed to determine schema version from Hive Metastore DB," + he.getMessage());
            LOG.debug("Failed to determine schema version from Hive Metastore DB," + he.getMessage());
            return false;
        }
        hmsConn = this.getConnectionToMetastore(false);
        LOG.debug("Validating tables in the schema for version " + version);
        try {
            metadata = conn.getMetaData();
            String[] types = new String[]{"TABLE"};
            rs = metadata.getTables(null, null, "%", types);
            String table = null;
            while (rs.next()) {
                table = rs.getString("TABLE_NAME");
                dbTables.add(table.toLowerCase());
                LOG.debug("Found table " + table + " in HMS dbstore");
            }
        }
        catch (SQLException e) {
            throw new HiveMetaException("Failed to retrieve schema tables from Hive Metastore DB," + e.getMessage());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    throw new HiveMetaException("Failed to close resultset", (Throwable)e);
                }
            }
        }
        String baseDir = new File(this.metaStoreSchemaInfo.getMetaStoreScriptDir()).getParent();
        String schemaFile = baseDir + "/" + this.dbType + "/hive-schema-" + version + "." + this.dbType + ".sql";
        try {
            LOG.debug("Parsing schema script " + schemaFile);
            subScripts.addAll(this.findCreateTable(schemaFile, schemaTables));
            while (subScripts.size() > 0) {
                schemaFile = baseDir + "/" + this.dbType + "/" + (String)subScripts.remove(0);
                LOG.debug("Parsing subscript " + schemaFile);
                subScripts.addAll(this.findCreateTable(schemaFile, schemaTables));
            }
        }
        catch (Exception e) {
            System.err.println("Exception in parsing schema file. Cause:" + e.getMessage());
            System.out.println("Schema table validation failed!!!");
            return false;
        }
        LOG.debug("Schema tables:[ " + Arrays.toString(schemaTables.toArray()) + " ]");
        LOG.debug("DB tables:[ " + Arrays.toString(dbTables.toArray()) + " ]");
        int schemaSize = schemaTables.size();
        schemaTables.removeAll(dbTables);
        if (schemaTables.size() > 0) {
            System.out.println("Table(s) [ " + Arrays.toString(schemaTables.toArray()) + " ] are missing from the metastore database schema.");
            System.out.println("Schema table validation failed!!!");
            return false;
        }
        System.out.println("Succeeded in schema table validation.");
        return true;
    }

    private List<String> findCreateTable(String path, List<String> tableList) throws Exception {
        HiveSchemaHelper.NestedScriptParser sp = HiveSchemaHelper.getDbCommandParser(this.dbType);
        Matcher matcher = null;
        Pattern regexp = null;
        ArrayList<String> subs = new ArrayList<String>();
        int groupNo = 0;
        switch (this.dbType) {
            case "oracle": {
                regexp = Pattern.compile("(CREATE TABLE(IF NOT EXISTS)*) (\\S+).*");
                groupNo = 3;
                break;
            }
            case "mysql": {
                regexp = Pattern.compile("(CREATE TABLE) (\\S+).*");
                groupNo = 2;
                break;
            }
            case "mssql": {
                regexp = Pattern.compile("(CREATE TABLE) (\\S+).*");
                groupNo = 2;
                break;
            }
            case "derby": {
                regexp = Pattern.compile("(CREATE TABLE(IF NOT EXISTS)*) (\\S+).*");
                groupNo = 3;
                break;
            }
            case "postgres": {
                regexp = Pattern.compile("(CREATE TABLE(IF NOT EXISTS)*) (\\S+).*");
                groupNo = 3;
                break;
            }
            default: {
                regexp = Pattern.compile("(CREATE TABLE(IF NOT EXISTS)*) (\\S+).*");
                groupNo = 3;
            }
        }
        if (!new File(path).exists()) {
            throw new Exception(path + " does not exist. Potentially incorrect version in the metastore VERSION table");
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(path));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (sp.isNestedScript(line)) {
                    String subScript = null;
                    subScript = sp.getScriptName(line);
                    LOG.debug("Schema subscript " + subScript + " found");
                    subs.add(subScript);
                    continue;
                }
                line = line.replaceAll("\\(", " ");
                line = line.replaceAll("IF NOT EXISTS ", "");
                line = line.replaceAll("`", "");
                line = line.replaceAll("'", "");
                matcher = regexp.matcher(line = line.replaceAll("\"", ""));
                if (!matcher.find()) continue;
                String table = matcher.group(groupNo);
                if (this.dbType.equals("derby")) {
                    table = table.replaceAll("APP.", "");
                }
                tableList.add(table.toLowerCase());
                LOG.debug("Found table " + table + " in the schema");
            }
        }
        catch (IOException ex) {
            throw new Exception(ex.getMessage());
        }
        return subs;
    }

    boolean validateColumnNullValues(Connection conn) throws HiveMetaException {
        System.out.println("Validating columns for incorrect NULL values");
        boolean isValid = true;
        try {
            Statement stmt = conn.createStatement();
            String tblQuery = this.getDbCommandParser(this.dbType).needsQuotedIdentifier() ? "select t.* from \"TBLS\" t WHERE t.\"SD_ID\" IS NULL and (t.\"TBL_TYPE\"='" + TableType.EXTERNAL_TABLE + "' or t.\"TBL_TYPE\"='" + TableType.MANAGED_TABLE + "')" : "select t.* from TBLS t WHERE t.SD_ID IS NULL and (t.TBL_TYPE='" + TableType.EXTERNAL_TABLE + "' or t.TBL_TYPE='" + TableType.MANAGED_TABLE + "')";
            ResultSet res = stmt.executeQuery(tblQuery);
            while (res.next()) {
                long tableId = res.getLong("TBL_ID");
                String tableName = res.getString("TBL_NAME");
                String tableType = res.getString("TBL_TYPE");
                isValid = false;
                System.err.println("SD_ID in TBLS should not be NULL for Table Name=" + tableName + ", Table ID=" + tableId + ", Table Type=" + tableType);
            }
            System.out.println((isValid ? "Succeeded" : "Failed") + " in column validation for incorrect NULL values");
            return isValid;
        }
        catch (SQLException e) {
            throw new HiveMetaException("Failed to validate columns for incorrect NULL values", (Throwable)e);
        }
    }

    private void runPreUpgrade(String scriptDir, String scriptFile) {
        String preUpgradeScript;
        File preUpgradeScriptFile;
        int i = 0;
        while ((preUpgradeScriptFile = new File(scriptDir, preUpgradeScript = MetaStoreSchemaInfo.getPreUpgradeScriptName((int)i, (String)scriptFile))).isFile()) {
            block3: {
                try {
                    this.runBeeLine(scriptDir, preUpgradeScript);
                    System.out.println("Completed " + preUpgradeScript);
                }
                catch (Exception e) {
                    System.err.println("Warning in pre-upgrade script " + preUpgradeScript + ": " + e.getMessage());
                    if (!this.verbose) break block3;
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    private void runBeeLine(String scriptDir, String scriptFile) throws IOException, HiveMetaException {
        HiveSchemaHelper.NestedScriptParser dbCommandParser = this.getDbCommandParser(this.dbType);
        String sqlCommands = dbCommandParser.buildCommand(scriptDir, scriptFile);
        File tmpFile = File.createTempFile("schematool", ".sql");
        tmpFile.deleteOnExit();
        FileWriter fstream = new FileWriter(tmpFile.getPath());
        BufferedWriter out = new BufferedWriter(fstream);
        out.write("!autocommit on" + System.getProperty("line.separator"));
        out.write(sqlCommands);
        out.write("!closeall" + System.getProperty("line.separator"));
        out.close();
        this.runBeeLine(tmpFile.getPath());
    }

    public void runBeeLine(String sqlScriptFile) throws IOException {
        CommandBuilder builder = new CommandBuilder(this.hiveConf, this.userName, this.passWord, sqlScriptFile);
        try (BeeLine beeLine = new BeeLine();){
            if (!this.verbose) {
                beeLine.setOutputStream(new PrintStream((OutputStream)new NullOutputStream()));
                beeLine.getOpts().setSilent(true);
            }
            beeLine.getOpts().setAllowMultiLineCommand(false);
            beeLine.getOpts().setIsolation("TRANSACTION_READ_COMMITTED");
            beeLine.getOpts().setEntireLineAsCommand(true);
            LOG.debug("Going to run command <" + builder.buildToLog() + ">");
            int status = beeLine.begin(builder.buildToRun(), null);
            if (status != 0) {
                throw new IOException("Schema script failed, errorcode " + status);
            }
        }
    }

    private static void initOptions(Options cmdLineOptions) {
        Option help = new Option("help", "print this message");
        Option upgradeOpt = new Option("upgradeSchema", "Schema upgrade");
        OptionBuilder.withArgName((String)"upgradeFrom");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Schema upgrade from a version");
        Option upgradeFromOpt = OptionBuilder.create((String)"upgradeSchemaFrom");
        Option initOpt = new Option("initSchema", "Schema initialization");
        OptionBuilder.withArgName((String)"initTo");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Schema initialization to a version");
        Option initToOpt = OptionBuilder.create((String)"initSchemaTo");
        Option infoOpt = new Option("info", "Show config and schema details");
        Option validateOpt = new Option("validate", "Validate the database");
        OptionGroup optGroup = new OptionGroup();
        optGroup.addOption(upgradeOpt).addOption(initOpt).addOption(help).addOption(upgradeFromOpt).addOption(initToOpt).addOption(infoOpt).addOption(validateOpt);
        optGroup.setRequired(true);
        OptionBuilder.withArgName((String)"user");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"Override config file user name");
        Option userNameOpt = OptionBuilder.create((String)"userName");
        OptionBuilder.withArgName((String)"password");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"Override config file password");
        Option passwdOpt = OptionBuilder.create((String)"passWord");
        OptionBuilder.withArgName((String)"databaseType");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"Metastore database type");
        Option dbTypeOpt = OptionBuilder.create((String)"dbType");
        OptionBuilder.withArgName((String)"databaseOpts");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"Backend DB specific options");
        Option dbOpts = OptionBuilder.create((String)"dbOpts");
        Option dryRunOpt = new Option("dryRun", "list SQL scripts (no execute)");
        Option verboseOpt = new Option("verbose", "only print SQL statements");
        OptionBuilder.withArgName((String)"serverList");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"a comma-separated list of servers used in location validation");
        Option serversOpt = OptionBuilder.create((String)"servers");
        cmdLineOptions.addOption(help);
        cmdLineOptions.addOption(dryRunOpt);
        cmdLineOptions.addOption(userNameOpt);
        cmdLineOptions.addOption(passwdOpt);
        cmdLineOptions.addOption(dbTypeOpt);
        cmdLineOptions.addOption(verboseOpt);
        cmdLineOptions.addOption(dbOpts);
        cmdLineOptions.addOption(serversOpt);
        cmdLineOptions.addOptionGroup(optGroup);
    }

    public static void main(String[] args) {
        GnuParser parser = new GnuParser();
        CommandLine line = null;
        String dbType = null;
        String schemaVer = null;
        Options cmdLineOptions = new Options();
        HiveSchemaTool.initOptions(cmdLineOptions);
        try {
            line = parser.parse(cmdLineOptions, args);
        }
        catch (ParseException e) {
            System.err.println("HiveSchemaTool:Parsing failed.  Reason: " + e.getLocalizedMessage());
            HiveSchemaTool.printAndExit(cmdLineOptions);
        }
        if (line.hasOption("help")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("schemaTool", cmdLineOptions);
            return;
        }
        if (line.hasOption("dbType")) {
            dbType = line.getOptionValue("dbType");
            if (!(dbType.equalsIgnoreCase("derby") || dbType.equalsIgnoreCase("mssql") || dbType.equalsIgnoreCase("mysql") || dbType.equalsIgnoreCase("postgres") || dbType.equalsIgnoreCase("oracle"))) {
                System.err.println("Unsupported dbType " + dbType);
                HiveSchemaTool.printAndExit(cmdLineOptions);
            }
        } else {
            System.err.println("no dbType supplied");
            HiveSchemaTool.printAndExit(cmdLineOptions);
        }
        System.setProperty(HiveConf.ConfVars.METASTORE_SCHEMA_VERIFICATION.varname, "true");
        try {
            HiveSchemaTool schemaTool = new HiveSchemaTool(dbType);
            if (line.hasOption("userName")) {
                schemaTool.setUserName(line.getOptionValue("userName"));
            }
            if (line.hasOption("passWord")) {
                schemaTool.setPassWord(line.getOptionValue("passWord"));
            }
            if (line.hasOption("dryRun")) {
                schemaTool.setDryRun(true);
            }
            if (line.hasOption("verbose")) {
                schemaTool.setVerbose(true);
            }
            if (line.hasOption("dbOpts")) {
                schemaTool.setDbOpts(line.getOptionValue("dbOpts"));
            }
            if (line.hasOption("validate") && line.hasOption("servers")) {
                schemaTool.setValidationServers(line.getOptionValue("servers"));
            }
            if (line.hasOption("info")) {
                schemaTool.showInfo();
            } else if (line.hasOption("upgradeSchema")) {
                schemaTool.doUpgrade();
            } else if (line.hasOption("upgradeSchemaFrom")) {
                schemaVer = line.getOptionValue("upgradeSchemaFrom");
                schemaTool.doUpgrade(schemaVer);
            } else if (line.hasOption("initSchema")) {
                schemaTool.doInit();
            } else if (line.hasOption("initSchemaTo")) {
                schemaVer = line.getOptionValue("initSchemaTo");
                schemaTool.doInit(schemaVer);
            } else if (line.hasOption("validate")) {
                schemaTool.doValidate();
            } else {
                System.err.println("no valid option supplied");
                HiveSchemaTool.printAndExit(cmdLineOptions);
            }
        }
        catch (HiveMetaException e) {
            System.err.println((Object)e);
            if (e.getCause() != null) {
                Throwable t = e.getCause();
                System.err.println("Underlying cause: " + t.getClass().getName() + " : " + t.getMessage());
                if (e.getCause() instanceof SQLException) {
                    System.err.println("SQL Error code: " + ((SQLException)t).getErrorCode());
                }
            }
            if (line.hasOption("verbose")) {
                e.printStackTrace();
            } else {
                System.err.println("Use --verbose for detailed stacktrace.");
            }
            System.err.println("*** schemaTool failed ***");
            System.exit(1);
        }
        System.out.println("schemaTool completed");
    }

    static class CommandBuilder {
        private final HiveConf hiveConf;
        private final String userName;
        private final String password;
        private final String sqlScriptFile;

        CommandBuilder(HiveConf hiveConf, String userName, String password, String sqlScriptFile) {
            this.hiveConf = hiveConf;
            this.userName = userName;
            this.password = password;
            this.sqlScriptFile = sqlScriptFile;
        }

        String[] buildToRun() throws IOException {
            return this.argsWith(this.password);
        }

        String buildToLog() throws IOException {
            this.logScript();
            return StringUtils.join((Object[])this.argsWith("[passwd stripped]"), (String)" ");
        }

        private String[] argsWith(String password) throws IOException {
            return new String[]{"-u", HiveSchemaHelper.getValidConfVar(HiveConf.ConfVars.METASTORECONNECTURLKEY, this.hiveConf), "-d", HiveSchemaHelper.getValidConfVar(HiveConf.ConfVars.METASTORE_CONNECTION_DRIVER, this.hiveConf), "-n", this.userName, "-p", password, "-f", this.sqlScriptFile};
        }

        private void logScript() throws IOException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Going to invoke file that contains:");
                try (BufferedReader reader = new BufferedReader(new FileReader(this.sqlScriptFile));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        LOG.debug("script: " + line);
                    }
                }
            }
        }
    }
}

