/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.queryhistory.repository;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.queryhistory.repository.AbstractRepository;
import org.apache.hadoop.hive.ql.queryhistory.repository.QueryHistoryRepository;
import org.apache.hadoop.hive.ql.queryhistory.schema.Record;
import org.apache.hadoop.hive.ql.queryhistory.schema.Schema;
import org.apache.hadoop.hive.ql.security.authorization.HiveCustomStorageHandlerUtils;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.session.SessionStateUtil;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCommitter;
import org.apache.hadoop.mapred.TaskAttemptContext;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.tez.mapreduce.hadoop.mapred.TaskAttemptContextImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergRepository
extends AbstractRepository
implements QueryHistoryRepository {
    private static final Logger LOG = LoggerFactory.getLogger(IcebergRepository.class);
    private static final String ICEBERG_STORAGE_HANDLER = "org.apache.iceberg.mr.hive.HiveIcebergStorageHandler";
    private static final String ICEBERG_WORKER_THREAD_NAME_FORMAT = "query-history-iceberg-worker-pool-%d";
    private HiveOutputFormat<?, ?> outputFormat;
    private Serializer serializer;
    @VisibleForTesting
    HiveStorageHandler storageHandler;
    @VisibleForTesting
    TableDesc tableDesc;
    private ExecutorService icebergExecutor;

    @Override
    public void init(HiveConf conf, Schema schema) {
        super.init(conf, schema);
        this.icebergExecutor = Executors.newFixedThreadPool(2, new ThreadFactoryBuilder().setDaemon(true).setNameFormat(ICEBERG_WORKER_THREAD_NAME_FORMAT).build());
    }

    @Override
    protected Table createTable(Hive hive, Database db) throws HiveException {
        LOG.info("Creating iceberg Query History table...");
        Table table = this.createTableObject();
        table.setProperty("storage_handler", ICEBERG_STORAGE_HANDLER);
        table.setProperty("table_type", "ICEBERG");
        table.setProperty("write.format.default", "orc");
        table.setProperty("history.expire.max-snapshot-age-ms", Integer.toString(86400000));
        table.setProperty("name", QUERY_HISTORY_DB_TABLE_NAME);
        table.setFields(this.schema.getFields());
        hive.createTable(table, false);
        table = hive.getTable("sys", "query_history");
        table.setProperty("iceberg.mr.table.location", table.getDataLocation().toString());
        return table;
    }

    @Override
    protected void postInitTable(Table table) throws Exception {
        this.tableDesc = Utilities.getTableDesc(table);
        HashMap<String, String> map = new HashMap<String, String>();
        this.storageHandler = table.getStorageHandler();
        this.storageHandler.configureOutputJobProperties(this.tableDesc, map);
        map.forEach((key, value) -> this.conf.set(key, value));
        this.conf.set("name", QUERY_HISTORY_DB_TABLE_NAME);
        HiveCustomStorageHandlerUtils.setWriteOperation((Configuration)this.conf, QUERY_HISTORY_DB_TABLE_NAME, Context.Operation.OTHER);
        this.outputFormat = HiveFileFormatUtils.getHiveOutputFormat((Configuration)this.conf, this.tableDesc);
        this.serializer = this.tableDesc.getDeserializer((Configuration)this.conf);
    }

    @Override
    public void flush(Queue<Record> records) {
        int numRecords = records.size();
        LOG.info("Persisting {} records", (Object)numRecords);
        if (numRecords == 0) {
            return;
        }
        try {
            this.prepareConfForWrite();
            JobConf jobConf = new JobConf((Configuration)this.conf);
            FileSinkOperator.RecordWriter writer = this.outputFormat.getHiveRecordWriter(jobConf, null, null, false, null, null);
            while (!records.isEmpty()) {
                this.writeRecord(writer, records.poll());
            }
            writer.close(false);
            TaskAttemptContextImpl context = new TaskAttemptContextImpl(jobConf, TaskAttemptID.forName((String)this.conf.get("mapred.task.id")), null);
            OutputCommitter committer = this.storageHandler.getOutputCommitter();
            committer.commitTask((TaskAttemptContext)context);
            this.storageHandler.storageHandlerCommit(HiveConf.getProperties((Configuration)this.conf), Context.Operation.OTHER, this.icebergExecutor);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void writeRecord(FileSinkOperator.RecordWriter writer, Record record) throws Exception {
        Writable w = record.serialize(this.serializer);
        writer.write(w);
    }

    private void prepareConfForWrite() {
        GregorianCalendar gc = new GregorianCalendar();
        String queryHistoryId = "queryhistory_" + String.format("%1$4d%2$02d%3$02d%4$02d%5$02d%6$02d", gc.get(1), gc.get(2) + 1, gc.get(5), gc.get(11), gc.get(12), gc.get(13)) + "_" + String.valueOf(UUID.randomUUID());
        this.conf.set(HiveConf.ConfVars.HIVE_QUERY_ID.varname, queryHistoryId);
        SessionState.getSessionConf().set(HiveConf.ConfVars.HIVE_QUERY_ID.varname, queryHistoryId);
        long currentTime = System.currentTimeMillis();
        String jobIdPostFix = String.format("%d_0000", currentTime);
        this.conf.set("mapred.task.id", String.format("attempt_%s_r_000000_0", jobIdPostFix));
        this.conf.set("iceberg.mr.output.tables", this.tableDesc.getTableName());
        QueryState queryState = new QueryState.Builder().withGenerateNewQueryId(false).withHiveConf(this.conf).build();
        SessionState.get().addQueryState(queryHistoryId, queryState);
        String jobId = String.format("job_%s", jobIdPostFix);
        SessionStateUtil.addCommitInfo((Configuration)SessionState.getSessionConf(), this.tableDesc.getTableName(), jobId, 1, (Map<String, String>)Maps.fromProperties((Properties)this.tableDesc.getProperties()));
    }
}

