/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.ImportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.repl.metric.ReplicationMetricCollector;
import org.apache.hadoop.hive.ql.plan.BaseCopyWork;
import org.apache.hadoop.hive.ql.plan.DeferredWorkContext;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Copy", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class CopyWork
implements Serializable,
BaseCopyWork {
    private static final long serialVersionUID = 1L;
    private Path[] fromPath;
    private Path[] toPath;
    private boolean errorOnSrcEmpty;
    private boolean overwrite = true;
    private boolean isReplication;
    private String dumpDirectory;
    private transient ReplicationMetricCollector metricCollector;

    public CopyWork() {
    }

    public CopyWork(Path fromPath, Path toPath, boolean errorOnSrcEmpty) {
        this(new Path[]{fromPath}, new Path[]{toPath});
        this.setErrorOnSrcEmpty(errorOnSrcEmpty);
    }

    public CopyWork(Path fromPath, Path toPath, boolean errorOnSrcEmpty, String dumpDirectory, ReplicationMetricCollector metricCollector, boolean isReplication) {
        this(new Path[]{fromPath}, new Path[]{toPath});
        this.dumpDirectory = dumpDirectory;
        this.metricCollector = metricCollector;
        this.setErrorOnSrcEmpty(errorOnSrcEmpty);
        this.isReplication = isReplication;
    }

    public CopyWork(Path fromPath, Path toPath, boolean errorOnSrcEmpty, boolean overwrite) {
        this(new Path[]{fromPath}, new Path[]{toPath});
        this.setErrorOnSrcEmpty(errorOnSrcEmpty);
        this.setOverwrite(overwrite);
    }

    public CopyWork(Path fromPath, Path toPath, boolean errorOnSrcEmpty, boolean overwrite, String dumpDirectory, ReplicationMetricCollector metricCollector, boolean isReplication) {
        this(new Path[]{fromPath}, new Path[]{toPath});
        this.setErrorOnSrcEmpty(errorOnSrcEmpty);
        this.setOverwrite(overwrite);
        this.dumpDirectory = dumpDirectory;
        this.metricCollector = metricCollector;
        this.isReplication = isReplication;
    }

    public CopyWork(Path[] fromPath, Path[] toPath) {
        if (fromPath.length != toPath.length) {
            throw new RuntimeException("Cannot copy " + fromPath.length + " paths into " + toPath.length + " paths");
        }
        this.fromPath = fromPath;
        this.toPath = toPath;
    }

    @Explain(displayName="source", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public Path getFromPathExplain() {
        return this.fromPath == null || this.fromPath.length > 1 ? null : this.fromPath[0];
    }

    @Explain(displayName="destination", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public Path getToPathExplain() {
        return this.toPath == null || this.toPath.length > 1 ? null : this.toPath[0];
    }

    @Explain(displayName="sources", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public Path[] getFromPathsExplain() {
        return this.fromPath != null && this.fromPath.length > 1 ? this.fromPath : null;
    }

    @Explain(displayName="destinations", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public Path[] getToPathsExplain() {
        return this.toPath != null && this.toPath.length > 1 ? this.toPath : null;
    }

    public Path[] getFromPaths() {
        return this.fromPath;
    }

    public Path[] getToPaths() {
        return this.toPath;
    }

    public ReplicationMetricCollector getMetricCollector() {
        return this.metricCollector;
    }

    public String getDumpDirectory() {
        return this.dumpDirectory;
    }

    public boolean isReplication() {
        return this.isReplication;
    }

    public void setErrorOnSrcEmpty(boolean errorOnSrcEmpty) {
        this.errorOnSrcEmpty = errorOnSrcEmpty;
    }

    public boolean isErrorOnSrcEmpty() {
        return this.errorOnSrcEmpty;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setToPath(Path[] toPath) {
        this.toPath = toPath;
    }

    @Override
    public void initializeFromDeferredContext(DeferredWorkContext deferredContext) throws HiveException {
        if (!deferredContext.isCalculated()) {
            ImportSemanticAnalyzer.setupDeferredContextFromMetadata(deferredContext);
        }
        this.setToPath(new Path[]{deferredContext.destPath});
    }
}

