/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.rewrite;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.rewrite.CopyOnWriteDeleteRewriter;
import org.apache.hadoop.hive.ql.parse.rewrite.DeleteRewriter;
import org.apache.hadoop.hive.ql.parse.rewrite.DeleteStatement;
import org.apache.hadoop.hive.ql.parse.rewrite.Rewriter;
import org.apache.hadoop.hive.ql.parse.rewrite.RewriterFactory;
import org.apache.hadoop.hive.ql.parse.rewrite.sql.SqlGeneratorFactory;

public class DeleteRewriterFactory
implements RewriterFactory<DeleteStatement> {
    protected final HiveConf conf;

    public DeleteRewriterFactory(HiveConf conf) {
        this.conf = conf;
    }

    @Override
    public Rewriter<DeleteStatement> createRewriter(Table table, String targetTableFullName, String subQueryAlias) {
        boolean copyOnWriteMode = false;
        HiveStorageHandler storageHandler = table.getStorageHandler();
        if (storageHandler != null) {
            copyOnWriteMode = storageHandler.shouldOverwrite(table, Context.Operation.DELETE);
        }
        SqlGeneratorFactory sqlGeneratorFactory = new SqlGeneratorFactory(table, targetTableFullName, this.conf, null, "__d__");
        if (copyOnWriteMode) {
            return new CopyOnWriteDeleteRewriter(this.conf, sqlGeneratorFactory);
        }
        return new DeleteRewriter(sqlGeneratorFactory);
    }
}

