/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.keyseries;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.exec.vector.keyseries.VectorKeySeriesSerialized;
import org.apache.hadoop.hive.ql.exec.vector.keyseries.VectorKeySeriesSerializedImpl;
import org.apache.hadoop.hive.serde2.fast.SerializeWrite;

public class VectorKeySeriesBytesSerialized<T extends SerializeWrite>
extends VectorKeySeriesSerializedImpl<T>
implements VectorKeySeriesSerialized {
    private final int columnNum;
    private int outputStartPosition;

    public VectorKeySeriesBytesSerialized(int columnNum, T serializeWrite) {
        super(serializeWrite);
        this.columnNum = columnNum;
    }

    @Override
    public void processBatch(VectorizedRowBatch batch) throws IOException {
        this.currentBatchSize = batch.size;
        Preconditions.checkState((this.currentBatchSize > 0 ? 1 : 0) != 0);
        BytesColumnVector bytesColVector = (BytesColumnVector)batch.cols[this.columnNum];
        byte[][] vectorBytesArrays = bytesColVector.vector;
        int[] vectorStarts = bytesColVector.start;
        int[] vectorLengths = bytesColVector.length;
        this.outputStartPosition = 0;
        this.output.reset();
        if (bytesColVector.isRepeating) {
            this.duplicateCounts[0] = this.currentBatchSize;
            if (bytesColVector.noNulls || !bytesColVector.isNull[0]) {
                this.seriesIsAllNull[0] = false;
                this.serialize(0, vectorBytesArrays[0], vectorStarts[0], vectorLengths[0]);
                this.nonNullKeyCount = 1;
            } else {
                this.seriesIsAllNull[0] = true;
                this.nonNullKeyCount = 0;
            }
            this.seriesCount = 1;
            Preconditions.checkState((this.seriesCount <= this.currentBatchSize ? 1 : 0) != 0);
        } else {
            this.seriesCount = 0;
            this.nonNullKeyCount = 0;
            if (batch.selectedInUse) {
                int[] selected = batch.selected;
                if (bytesColVector.noNulls) {
                    this.duplicateCounts[0] = 1;
                    int index = selected[0];
                    byte[] prevKeyBytes = vectorBytesArrays[index];
                    int prevKeyStart = vectorStarts[index];
                    int prevKeyLength = vectorLengths[index];
                    this.serialize(0, prevKeyBytes, prevKeyStart, prevKeyLength);
                    for (int logical = 1; logical < this.currentBatchSize; ++logical) {
                        index = selected[logical];
                        byte[] currentKeyBytes = vectorBytesArrays[index];
                        int currentKeyStart = vectorStarts[index];
                        int currentKeyLength = vectorLengths[index];
                        if (StringExpr.equal((byte[])prevKeyBytes, (int)prevKeyStart, (int)prevKeyLength, (byte[])currentKeyBytes, (int)currentKeyStart, (int)currentKeyLength)) {
                            int n = this.seriesCount;
                            this.duplicateCounts[n] = this.duplicateCounts[n] + 1;
                            continue;
                        }
                        this.duplicateCounts[++this.seriesCount] = 1;
                        this.serialize(this.seriesCount, currentKeyBytes, currentKeyStart, currentKeyLength);
                        prevKeyBytes = currentKeyBytes;
                        prevKeyStart = currentKeyStart;
                        prevKeyLength = currentKeyLength;
                    }
                    Arrays.fill(this.seriesIsAllNull, 0, ++this.seriesCount, false);
                    this.nonNullKeyCount = this.seriesCount;
                    Preconditions.checkState((this.seriesCount <= this.currentBatchSize ? 1 : 0) != 0);
                } else {
                    boolean prevKeyIsNull;
                    boolean[] isNull = bytesColVector.isNull;
                    byte[] prevKeyBytes = null;
                    int prevKeyStart = 0;
                    int prevKeyLength = 0;
                    this.duplicateCounts[0] = 1;
                    int index = selected[0];
                    if (isNull[index]) {
                        this.seriesIsAllNull[0] = true;
                        prevKeyIsNull = true;
                    } else {
                        this.seriesIsAllNull[0] = false;
                        prevKeyIsNull = false;
                        prevKeyBytes = vectorBytesArrays[index];
                        prevKeyStart = vectorStarts[index];
                        prevKeyLength = vectorLengths[index];
                        this.serialize(0, prevKeyBytes, prevKeyStart, prevKeyLength);
                        this.nonNullKeyCount = 1;
                    }
                    for (int logical = 1; logical < this.currentBatchSize; ++logical) {
                        index = selected[logical];
                        if (isNull[index]) {
                            if (prevKeyIsNull) {
                                int n = this.seriesCount;
                                this.duplicateCounts[n] = this.duplicateCounts[n] + 1;
                                continue;
                            }
                            this.duplicateCounts[++this.seriesCount] = 1;
                            this.seriesIsAllNull[this.seriesCount] = true;
                            prevKeyIsNull = true;
                            continue;
                        }
                        byte[] currentKeyBytes = vectorBytesArrays[index];
                        int currentKeyStart = vectorStarts[index];
                        int currentKeyLength = vectorLengths[index];
                        if (!prevKeyIsNull && StringExpr.equal((byte[])prevKeyBytes, (int)prevKeyStart, (int)prevKeyLength, (byte[])currentKeyBytes, (int)currentKeyStart, (int)currentKeyLength)) {
                            int n = this.seriesCount;
                            this.duplicateCounts[n] = this.duplicateCounts[n] + 1;
                            continue;
                        }
                        this.duplicateCounts[++this.seriesCount] = 1;
                        this.seriesIsAllNull[this.seriesCount] = false;
                        this.serialize(this.nonNullKeyCount++, currentKeyBytes, currentKeyStart, currentKeyLength);
                        prevKeyIsNull = false;
                        prevKeyBytes = currentKeyBytes;
                        prevKeyStart = currentKeyStart;
                        prevKeyLength = currentKeyLength;
                    }
                    ++this.seriesCount;
                    Preconditions.checkState((this.seriesCount <= this.currentBatchSize ? 1 : 0) != 0);
                }
            } else if (bytesColVector.noNulls) {
                this.duplicateCounts[0] = 1;
                byte[] prevKeyBytes = vectorBytesArrays[0];
                int prevKeyStart = vectorStarts[0];
                int prevKeyLength = vectorLengths[0];
                this.serialize(0, prevKeyBytes, prevKeyStart, prevKeyLength);
                for (int index = 1; index < this.currentBatchSize; ++index) {
                    byte[] currentKeyBytes = vectorBytesArrays[index];
                    int currentKeyStart = vectorStarts[index];
                    int currentKeyLength = vectorLengths[index];
                    if (StringExpr.equal((byte[])prevKeyBytes, (int)prevKeyStart, (int)prevKeyLength, (byte[])currentKeyBytes, (int)currentKeyStart, (int)currentKeyLength)) {
                        int n = this.seriesCount;
                        this.duplicateCounts[n] = this.duplicateCounts[n] + 1;
                        continue;
                    }
                    this.duplicateCounts[++this.seriesCount] = 1;
                    this.serialize(this.seriesCount, currentKeyBytes, currentKeyStart, currentKeyLength);
                    prevKeyBytes = currentKeyBytes;
                    prevKeyStart = currentKeyStart;
                    prevKeyLength = currentKeyLength;
                }
                Arrays.fill(this.seriesIsAllNull, 0, ++this.seriesCount, false);
                this.nonNullKeyCount = this.seriesCount;
                Preconditions.checkState((this.seriesCount <= this.currentBatchSize ? 1 : 0) != 0);
            } else {
                boolean prevKeyIsNull;
                boolean[] isNull = bytesColVector.isNull;
                byte[] prevKeyBytes = null;
                int prevKeyStart = 0;
                int prevKeyLength = 0;
                this.duplicateCounts[0] = 1;
                if (isNull[0]) {
                    this.seriesIsAllNull[0] = true;
                    prevKeyIsNull = true;
                } else {
                    this.seriesIsAllNull[0] = false;
                    prevKeyIsNull = false;
                    prevKeyBytes = vectorBytesArrays[0];
                    prevKeyStart = vectorStarts[0];
                    prevKeyLength = vectorLengths[0];
                    this.serialize(0, prevKeyBytes, prevKeyStart, prevKeyLength);
                    this.nonNullKeyCount = 1;
                }
                for (int index = 1; index < this.currentBatchSize; ++index) {
                    if (isNull[index]) {
                        if (prevKeyIsNull) {
                            int n = this.seriesCount;
                            this.duplicateCounts[n] = this.duplicateCounts[n] + 1;
                            continue;
                        }
                        this.duplicateCounts[++this.seriesCount] = 1;
                        this.seriesIsAllNull[this.seriesCount] = true;
                        prevKeyIsNull = true;
                        continue;
                    }
                    byte[] currentKeyBytes = vectorBytesArrays[index];
                    int currentKeyStart = vectorStarts[index];
                    int currentKeyLength = vectorLengths[index];
                    if (!prevKeyIsNull && StringExpr.equal((byte[])prevKeyBytes, (int)prevKeyStart, (int)prevKeyLength, (byte[])currentKeyBytes, (int)currentKeyStart, (int)currentKeyLength)) {
                        int n = this.seriesCount;
                        this.duplicateCounts[n] = this.duplicateCounts[n] + 1;
                        continue;
                    }
                    this.duplicateCounts[++this.seriesCount] = 1;
                    this.seriesIsAllNull[this.seriesCount] = false;
                    this.serialize(this.nonNullKeyCount++, currentKeyBytes, currentKeyStart, currentKeyLength);
                    prevKeyIsNull = false;
                    prevKeyBytes = currentKeyBytes;
                    prevKeyStart = currentKeyStart;
                    prevKeyLength = currentKeyLength;
                }
                ++this.seriesCount;
                Preconditions.checkState((this.seriesCount <= this.currentBatchSize ? 1 : 0) != 0);
            }
        }
        this.computeSerializedHashCodes();
        this.positionToFirst();
        Preconditions.checkState((boolean)this.validate());
    }

    private void serialize(int pos, byte[] bytes, int start, int length) throws IOException {
        this.serializeWrite.setAppend(this.output);
        this.serializeWrite.writeString(bytes, start, length);
        int outputNewPosition = this.output.getLength();
        this.serializedKeyLengths[pos] = outputNewPosition - this.outputStartPosition;
        this.outputStartPosition = outputNewPosition;
    }
}

