/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.AbstractFileMergeOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcFileKeyWrapper;
import org.apache.hadoop.hive.ql.io.orc.OrcFileValueWrapper;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.OrcFileMergeDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.shims.CombineHiveKey;
import org.apache.orc.CompressionKind;
import org.apache.orc.OrcFile;
import org.apache.orc.TypeDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrcFileMergeOperator
extends AbstractFileMergeOperator<OrcFileMergeDesc> {
    public static final Logger LOG = LoggerFactory.getLogger((String)"OrcFileMergeOperator");
    private CompressionKind compression = null;
    private int compressBuffSize = 0;
    private OrcFile.Version fileVersion;
    private OrcFile.WriterVersion writerVersion;
    private TypeDescription fileSchema;
    private int rowIndexStride = 0;
    private Map<Integer, Writer> outWriters = new HashMap<Integer, Writer>();
    private Path prevPath;
    private FSDataInputStream fdis;
    private ObjectInspector obi;

    protected OrcFileMergeOperator() {
    }

    public OrcFileMergeOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        Object[] keyValue = (Object[])row;
        this.processKeyValuePairs(keyValue[0], keyValue[1]);
    }

    private void processKeyValuePairs(Object key, Object value) throws HiveException {
        String filePath;
        block48: {
            int bucketId;
            OrcFileValueWrapper v;
            OrcFileKeyWrapper k;
            boolean exception;
            block45: {
                block46: {
                    block42: {
                        block43: {
                            filePath = "";
                            exception = false;
                            k = key instanceof CombineHiveKey ? (OrcFileKeyWrapper)((CombineHiveKey)key).getKey() : (OrcFileKeyWrapper)key;
                            if (!k.isIncompatFile()) break block42;
                            LOG.warn("Incompatible ORC file merge! Stripe statistics is missing. " + String.valueOf(k.getInputPath()));
                            this.addIncompatibleFile(k.getInputPath());
                            if (!exception) break block43;
                            this.closeOp(true);
                        }
                        if (this.fdis != null) {
                            try {
                                this.fdis.close();
                            }
                            catch (IOException e) {
                                throw new HiveException(String.format("Unable to close file %s", filePath), (Throwable)e);
                            }
                            finally {
                                this.fdis = null;
                            }
                        }
                        return;
                    }
                    filePath = k.getInputPath().toUri().getPath();
                    Utilities.FILE_OP_LOGGER.info("OrcFileMergeOperator processing " + filePath);
                    this.fixTmpPath(k.getInputPath().getParent());
                    v = (OrcFileValueWrapper)value;
                    if (this.prevPath == null) {
                        this.prevPath = k.getInputPath();
                    }
                    if (this.obi == null) {
                        Reader reader = OrcFile.createReader(this.fs, this.prevPath);
                        this.obi = reader.getObjectInspector();
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            throw new HiveException(String.format("Unable to close reader for %s", filePath), (Throwable)e);
                        }
                    }
                    LOG.info("ORC merge file input path: " + String.valueOf(k.getInputPath()));
                    bucketId = 0;
                    if (((OrcFileMergeDesc)this.conf).getIsCompactionTable()) {
                        bucketId = AcidUtils.parseBucketId(new Path(filePath));
                    }
                    if (this.outWriters.get(bucketId) == null) {
                        this.compression = k.getCompression();
                        this.compressBuffSize = k.getCompressBufferSize();
                        this.fileVersion = k.getFileVersion();
                        this.writerVersion = k.getWriterVersion();
                        this.fileSchema = k.getFileSchema();
                        this.rowIndexStride = k.getRowIndexStride();
                        OrcFile.WriterOptions options = OrcFile.writerOptions((Configuration)this.jc).compress(this.compression).version(this.fileVersion).rowIndexStride(this.rowIndexStride).inspector(this.obi);
                        if (this.compression != CompressionKind.NONE) {
                            options.bufferSize(this.compressBuffSize).enforceBufferSize();
                        }
                        Path outPath = this.getOutPath();
                        if (((OrcFileMergeDesc)this.conf).getIsCompactionTable()) {
                            outPath = this.getOutPath(bucketId);
                        }
                        this.outWriters.put(bucketId, OrcFile.createWriter(outPath, options));
                        LOG.info("ORC merge file output path: {}", (Object)outPath);
                    }
                    if (this.checkCompatibility(k)) break block45;
                    this.addIncompatibleFile(k.getInputPath());
                    if (!exception) break block46;
                    this.closeOp(true);
                }
                if (this.fdis != null) {
                    try {
                        this.fdis.close();
                    }
                    catch (IOException e) {
                        throw new HiveException(String.format("Unable to close file %s", filePath), (Throwable)e);
                    }
                    finally {
                        this.fdis = null;
                    }
                }
                return;
            }
            try {
                byte[] buffer = new byte[(int)v.getStripeInformation().getLength()];
                this.fdis = this.fs.open(k.getInputPath());
                this.fdis.readFully(v.getStripeInformation().getOffset(), buffer, 0, (int)v.getStripeInformation().getLength());
                this.outWriters.get(bucketId).appendStripe(buffer, 0, buffer.length, v.getStripeInformation(), v.getStripeStatistics());
                if (LOG.isInfoEnabled()) {
                    LOG.info("Merged stripe from file " + String.valueOf(k.getInputPath()) + " [ offset : " + v.getStripeInformation().getOffset() + " length: " + v.getStripeInformation().getLength() + " row: " + v.getStripeStatistics().getColStats(0).getNumberOfValues() + " ]");
                }
                if (v.isLastStripeInFile()) {
                    for (Map.Entry<String, ByteBuffer> entry : v.getUserMetadata().entrySet()) {
                        this.outWriters.get(bucketId).addUserMetadata(entry.getKey(), entry.getValue());
                    }
                }
                if (!exception) break block48;
            }
            catch (Throwable e) {
                try {
                    exception = true;
                    LOG.error("Closing operator..Exception: " + ExceptionUtils.getStackTrace((Throwable)e));
                    throw new HiveException(e);
                }
                catch (Throwable throwable) {
                    if (exception) {
                        this.closeOp(true);
                    }
                    if (this.fdis != null) {
                        try {
                            this.fdis.close();
                        }
                        catch (IOException e2) {
                            throw new HiveException(String.format("Unable to close file %s", filePath), (Throwable)e2);
                        }
                        finally {
                            this.fdis = null;
                        }
                    }
                    throw throwable;
                }
            }
            this.closeOp(true);
        }
        if (this.fdis != null) {
            try {
                this.fdis.close();
            }
            catch (IOException e) {
                throw new HiveException(String.format("Unable to close file %s", filePath), (Throwable)e);
            }
            finally {
                this.fdis = null;
            }
        }
    }

    private boolean checkCompatibility(OrcFileKeyWrapper k) {
        if (!this.fileSchema.equals((Object)k.getFileSchema())) {
            LOG.warn("Incompatible ORC file merge! Schema mismatch for " + String.valueOf(k.getInputPath()));
            return false;
        }
        if (!k.getCompression().equals((Object)this.compression)) {
            LOG.warn("Incompatible ORC file merge! Compression codec mismatch for " + String.valueOf(k.getInputPath()));
            return false;
        }
        if (k.getCompressBufferSize() != this.compressBuffSize) {
            LOG.warn("Incompatible ORC file merge! Compression buffer size mismatch for " + String.valueOf(k.getInputPath()));
            return false;
        }
        if (!k.getFileVersion().equals((Object)this.fileVersion)) {
            LOG.warn("Incompatible ORC file merge! File version mismatch for " + String.valueOf(k.getInputPath()));
            return false;
        }
        if (!k.getWriterVersion().equals((Object)this.writerVersion)) {
            LOG.warn("Incompatible ORC file merge! Writer version mismatch for " + String.valueOf(k.getInputPath()));
            return false;
        }
        if (k.getRowIndexStride() != this.rowIndexStride) {
            LOG.warn("Incompatible ORC file merge! Row index stride mismatch for " + String.valueOf(k.getInputPath()));
            return false;
        }
        return true;
    }

    @Override
    public OperatorType getType() {
        return OperatorType.ORCFILEMERGE;
    }

    @Override
    public String getName() {
        return OrcFileMergeOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "OFM";
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        try {
            if (this.fdis != null) {
                this.fdis.close();
                this.fdis = null;
            }
            if (this.outWriters != null) {
                for (Map.Entry<Integer, Writer> outWriterEntry : this.outWriters.entrySet()) {
                    Writer outWriter = outWriterEntry.getValue();
                    outWriter.close();
                }
                this.outWriters.clear();
            }
        }
        catch (Exception e) {
            throw new HiveException("Unable to close OrcFileMergeOperator", (Throwable)e);
        }
        super.closeOp(abort);
    }
}

