/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.utils.StringUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class ColumnType {
    public static final String VOID_TYPE_NAME = "void";
    public static final String BOOLEAN_TYPE_NAME = "boolean";
    public static final String TINYINT_TYPE_NAME = "tinyint";
    public static final String SMALLINT_TYPE_NAME = "smallint";
    public static final String INT_TYPE_NAME = "int";
    public static final String BIGINT_TYPE_NAME = "bigint";
    public static final String FLOAT_TYPE_NAME = "float";
    public static final String DOUBLE_TYPE_NAME = "double";
    public static final String STRING_TYPE_NAME = "string";
    public static final String CHAR_TYPE_NAME = "char";
    public static final String VARCHAR_TYPE_NAME = "varchar";
    public static final String DATE_TYPE_NAME = "date";
    public static final String DATETIME_TYPE_NAME = "datetime";
    public static final String TIMESTAMP_TYPE_NAME = "timestamp";
    public static final String DECIMAL_TYPE_NAME = "decimal";
    public static final String BINARY_TYPE_NAME = "binary";
    public static final String INTERVAL_YEAR_MONTH_TYPE_NAME = "interval_year_month";
    public static final String INTERVAL_DAY_TIME_TYPE_NAME = "interval_day_time";
    public static final String TIMESTAMPTZ_TYPE_NAME = "timestamp with time zone";
    public static final String LIST_TYPE_NAME = "array";
    public static final String MAP_TYPE_NAME = "map";
    public static final String STRUCT_TYPE_NAME = "struct";
    public static final String UNION_TYPE_NAME = "uniontype";
    public static final String LIST_COLUMNS = "columns";
    public static final String LIST_COLUMN_TYPES = "columns.types";
    public static final String COLUMN_NAME_DELIMITER = "column.name.delimiter";
    public static final Set<String> PrimitiveTypes = StringUtils.asSet("void", "boolean", "tinyint", "smallint", "int", "bigint", "float", "double", "string", "varchar", "char", "date", "datetime", "timestamp", "interval_year_month", "interval_day_time", "decimal", "binary", "timestamp with time zone");
    public static final Set<String> StringTypes = StringUtils.asSet("string", "varchar", "char");
    public static final Set<String> NumericTypes = StringUtils.asSet("tinyint", "smallint", "int", "bigint", "float", "double", "decimal");
    public static final Set<String> DateTimeTypes = StringUtils.asSet("date", "datetime", "timestamp", "timestamp with time zone");
    public static final Map<String, Integer> NumericCastOrder;
    private static final Set<String> decoratedTypeNames;
    private static final Map<String, String> alternateTypeNames;
    public static final Set<String> CollectionTypes;
    public static final Set<String> IntegralTypes;
    public static final Set<String> AllTypes;
    public static final String SERIALIZATION_FORMAT = "serialization.format";
    public static final String SERIALIZATION_LIB = "serialization.lib";
    public static final String SERIALIZATION_DDL = "serialization.ddl";
    public static final char COLUMN_COMMENTS_DELIMITER = '\u0000';
    private static HashMap<String, String> typeToThriftTypeMap;

    public static String getTypeName(String typeString) {
        if (typeString == null) {
            return null;
        }
        String protoType = typeString.toLowerCase().split("\\W")[0];
        if (decoratedTypeNames.contains(protoType)) {
            return protoType;
        }
        String realType = alternateTypeNames.get(protoType);
        return realType == null ? protoType : realType;
    }

    public static boolean areColTypesCompatible(String from, String to) {
        if (from.equals(to)) {
            return true;
        }
        if (PrimitiveTypes.contains(from) && PrimitiveTypes.contains(to)) {
            if (StringTypes.contains(from) && StringTypes.contains(to)) {
                return true;
            }
            if (NumericTypes.contains(from) && NumericTypes.contains(to)) {
                return NumericCastOrder.get(from) < NumericCastOrder.get(to);
            }
            if (from.equals(VOID_TYPE_NAME)) {
                return true;
            }
            if (DateTimeTypes.contains(from) && StringTypes.contains(to)) {
                return true;
            }
            if (NumericTypes.contains(from) && StringTypes.contains(to)) {
                return true;
            }
        }
        return false;
    }

    public static String typeToThriftType(String type) {
        StringBuilder thriftType = new StringBuilder();
        int last = 0;
        boolean lastAlphaDigit = Character.isLetterOrDigit(type.charAt(last));
        for (int i = 1; i <= type.length(); ++i) {
            if (i != type.length() && Character.isLetterOrDigit(type.charAt(i)) == lastAlphaDigit) continue;
            String token = type.substring(last, i);
            last = i;
            String thriftToken = typeToThriftTypeMap.get(token);
            thriftType.append(thriftToken == null ? token : thriftToken);
            lastAlphaDigit = !lastAlphaDigit;
        }
        return thriftType.toString();
    }

    public static String getListType(String t) {
        return "array<" + t + ">";
    }

    static {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put(TINYINT_TYPE_NAME, 1);
        map.put(SMALLINT_TYPE_NAME, 2);
        map.put(INT_TYPE_NAME, 3);
        map.put(BIGINT_TYPE_NAME, 4);
        map.put(DECIMAL_TYPE_NAME, 5);
        map.put(FLOAT_TYPE_NAME, 6);
        map.put(DOUBLE_TYPE_NAME, 7);
        NumericCastOrder = Collections.unmodifiableMap(map);
        decoratedTypeNames = new HashSet<String>();
        decoratedTypeNames.add(CHAR_TYPE_NAME);
        decoratedTypeNames.add(DECIMAL_TYPE_NAME);
        decoratedTypeNames.add(VARCHAR_TYPE_NAME);
        alternateTypeNames = new HashMap<String, String>();
        alternateTypeNames.put("integer", INT_TYPE_NAME);
        alternateTypeNames.put("numeric", DECIMAL_TYPE_NAME);
        CollectionTypes = StringUtils.asSet(LIST_TYPE_NAME, MAP_TYPE_NAME);
        IntegralTypes = StringUtils.asSet(TINYINT_TYPE_NAME, SMALLINT_TYPE_NAME, INT_TYPE_NAME, BIGINT_TYPE_NAME);
        AllTypes = StringUtils.asSet(VOID_TYPE_NAME, BOOLEAN_TYPE_NAME, TINYINT_TYPE_NAME, SMALLINT_TYPE_NAME, INT_TYPE_NAME, BIGINT_TYPE_NAME, FLOAT_TYPE_NAME, DOUBLE_TYPE_NAME, STRING_TYPE_NAME, CHAR_TYPE_NAME, VARCHAR_TYPE_NAME, DATE_TYPE_NAME, DATETIME_TYPE_NAME, TIMESTAMP_TYPE_NAME, DECIMAL_TYPE_NAME, BINARY_TYPE_NAME, INTERVAL_YEAR_MONTH_TYPE_NAME, INTERVAL_DAY_TIME_TYPE_NAME, TIMESTAMPTZ_TYPE_NAME, LIST_TYPE_NAME, MAP_TYPE_NAME, STRUCT_TYPE_NAME, UNION_TYPE_NAME, LIST_COLUMNS, LIST_COLUMN_TYPES, COLUMN_NAME_DELIMITER);
        typeToThriftTypeMap = new HashMap();
        typeToThriftTypeMap.put(BOOLEAN_TYPE_NAME, "bool");
        typeToThriftTypeMap.put(TINYINT_TYPE_NAME, "byte");
        typeToThriftTypeMap.put(SMALLINT_TYPE_NAME, "i16");
        typeToThriftTypeMap.put(INT_TYPE_NAME, "i32");
        typeToThriftTypeMap.put(BIGINT_TYPE_NAME, "i64");
        typeToThriftTypeMap.put(DOUBLE_TYPE_NAME, DOUBLE_TYPE_NAME);
        typeToThriftTypeMap.put(FLOAT_TYPE_NAME, FLOAT_TYPE_NAME);
        typeToThriftTypeMap.put(LIST_TYPE_NAME, "list");
        typeToThriftTypeMap.put(MAP_TYPE_NAME, MAP_TYPE_NAME);
        typeToThriftTypeMap.put(STRING_TYPE_NAME, STRING_TYPE_NAME);
        typeToThriftTypeMap.put(BINARY_TYPE_NAME, BINARY_TYPE_NAME);
        typeToThriftTypeMap.put(DATE_TYPE_NAME, DATE_TYPE_NAME);
        typeToThriftTypeMap.put(DATETIME_TYPE_NAME, DATETIME_TYPE_NAME);
        typeToThriftTypeMap.put(TIMESTAMP_TYPE_NAME, TIMESTAMP_TYPE_NAME);
        typeToThriftTypeMap.put(DECIMAL_TYPE_NAME, DECIMAL_TYPE_NAME);
        typeToThriftTypeMap.put(INTERVAL_YEAR_MONTH_TYPE_NAME, INTERVAL_YEAR_MONTH_TYPE_NAME);
        typeToThriftTypeMap.put(INTERVAL_DAY_TIME_TYPE_NAME, INTERVAL_DAY_TIME_TYPE_NAME);
    }
}

