/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.mapreduce;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.InternalRecordWrapper;
import org.apache.iceberg.expressions.Evaluator;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.mr.InputFormatConfig;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandler;
import org.apache.iceberg.mr.hive.IcebergAcidUtil;

public abstract class AbstractIcebergRecordReader<T>
extends RecordReader<Void, T> {
    private TaskAttemptContext context;
    protected Configuration conf;
    protected Table table;
    protected Schema expectedSchema;
    private String nameMapping;
    private boolean reuseContainers;
    private boolean caseSensitive;
    private InputFormatConfig.InMemoryDataModel inMemoryDataModel;
    private boolean fetchVirtualColumns;

    public void initialize(InputSplit split, TaskAttemptContext newContext) {
        this.context = newContext;
        this.conf = newContext.getConfiguration();
        this.table = HiveIcebergStorageHandler.table(this.conf, this.conf.get("iceberg.mr.table.identifier"));
        HiveIcebergStorageHandler.checkAndSetIoConfig(this.conf, this.table);
        this.nameMapping = this.table.properties().get("schema.name-mapping.default");
        this.caseSensitive = this.conf.getBoolean("iceberg.mr.case.sensitive", true);
        this.expectedSchema = AbstractIcebergRecordReader.readSchema(this.conf, this.table, this.caseSensitive);
        this.reuseContainers = this.conf.getBoolean("iceberg.mr.reuse.containers", false);
        this.inMemoryDataModel = (InputFormatConfig.InMemoryDataModel)this.conf.getEnum("iceberg.mr.in.memory.data.model", (Enum)InputFormatConfig.InMemoryDataModel.GENERIC);
        this.fetchVirtualColumns = InputFormatConfig.fetchVirtualColumns(this.conf);
    }

    private static Schema readSchema(Configuration conf, Table table, boolean caseSensitive) {
        Schema readSchema = InputFormatConfig.readSchema(conf);
        if (readSchema != null) {
            return readSchema;
        }
        String[] selectedColumns = InputFormatConfig.selectedColumns(conf);
        readSchema = table.schema();
        if (selectedColumns != null) {
            Schema schema = readSchema = caseSensitive ? readSchema.select(selectedColumns) : readSchema.caseInsensitiveSelect(selectedColumns);
        }
        if (InputFormatConfig.fetchVirtualColumns(conf)) {
            return IcebergAcidUtil.createFileReadSchemaWithVirtualColums(readSchema.columns(), table);
        }
        return readSchema;
    }

    CloseableIterable<T> applyResidualFiltering(CloseableIterable<T> iter, Expression residual, Schema readSchema) {
        boolean applyResidual;
        boolean bl = applyResidual = !this.getContext().getConfiguration().getBoolean("skip.residual.filtering", false);
        if (applyResidual && residual != null && residual != Expressions.alwaysTrue()) {
            InternalRecordWrapper wrapper = new InternalRecordWrapper(readSchema.asStruct());
            Evaluator filter = new Evaluator(readSchema.asStruct(), residual, this.caseSensitive);
            return CloseableIterable.filter(iter, record -> filter.eval(wrapper.wrap((StructLike)record)));
        }
        return iter;
    }

    public TaskAttemptContext getContext() {
        return this.context;
    }

    public boolean isReuseContainers() {
        return this.reuseContainers;
    }

    public String getNameMapping() {
        return this.nameMapping;
    }

    public InputFormatConfig.InMemoryDataModel getInMemoryDataModel() {
        return this.inMemoryDataModel;
    }

    public boolean isFetchVirtualColumns() {
        return this.fetchVirtualColumns;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public Void getCurrentKey() {
        return null;
    }

    public float getProgress() {
        return this.getContext().getProgress();
    }
}

