/*
 * Decompiled with CFR 0.152.
 */
package sqlline;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jline.reader.Completer;
import org.jline.reader.impl.completer.ArgumentCompleter;
import sqlline.DatabaseMetaDataHandler;
import sqlline.Dialect;
import sqlline.DialectImpl;
import sqlline.DispatchCallback;
import sqlline.SqlCompleter;
import sqlline.SqlLine;

class DatabaseConnection {
    private final SqlLine sqlLine;
    Connection connection;
    DatabaseMetaData meta;
    private final String driver;
    private final String url;
    private final Properties info;
    private String nickname;
    private Schema schema = null;
    private Completer sqlCompleter = null;
    private Dialect dialect;

    DatabaseConnection(SqlLine sqlLine, String driver, String url, String username, String password, Properties properties) {
        this.sqlLine = sqlLine;
        this.driver = driver;
        this.url = url;
        Properties properties2 = this.info = properties == null ? new Properties() : properties;
        if (username != null) {
            this.info.put("user", username);
        }
        if (password != null) {
            this.info.put("password", password);
        }
    }

    public String toString() {
        return this.getUrl() + "";
    }

    void setCompletions(boolean skipmeta) {
        this.sqlCompleter = new ArgumentCompleter(new Completer[]{new SqlCompleter(this.sqlLine, skipmeta)});
        ((ArgumentCompleter)this.sqlCompleter).setStrict(false);
    }

    private void initSyntaxRule() throws SQLException {
        String identifierQuoteString = this.meta.getIdentifierQuoteString();
        if (identifierQuoteString.length() > 1) {
            this.sqlLine.error("Identifier quote string is '" + identifierQuoteString + "'; quote strings longer than 1 char are not supported");
            identifierQuoteString = null;
        }
        String productName = this.meta.getDatabaseProductName();
        Set<String> keywords = Stream.of(this.meta.getSQLKeywords().split(",")).collect(Collectors.toSet());
        this.dialect = DialectImpl.create(keywords, identifierQuoteString, productName, this.meta.storesLowerCaseIdentifiers(), this.meta.storesUpperCaseIdentifiers(), this.meta.getExtraNameCharacters());
    }

    boolean connect() throws SQLException {
        try {
            if (this.driver != null && this.driver.length() != 0) {
                Class.forName(this.driver);
            }
        }
        catch (ClassNotFoundException cnfe) {
            return this.sqlLine.error(cnfe);
        }
        boolean foundDriver = false;
        Driver theDriver = null;
        try {
            theDriver = DriverManager.getDriver(this.url);
            foundDriver = theDriver != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!foundDriver) {
            this.sqlLine.output(this.sqlLine.loc("autoloading-known-drivers", this.url));
            this.sqlLine.registerKnownDrivers();
            theDriver = DriverManager.getDriver(this.url);
        }
        try {
            this.close();
        }
        catch (Exception e) {
            return this.sqlLine.error(e);
        }
        this.connection = theDriver.connect(this.url, this.info);
        this.meta = (DatabaseMetaData)Proxy.newProxyInstance(DatabaseMetaData.class.getClassLoader(), new Class[]{DatabaseMetaData.class}, (InvocationHandler)new DatabaseMetaDataHandler(this.connection.getMetaData()));
        try {
            this.sqlLine.debug(this.sqlLine.loc("connected", this.meta.getDatabaseProductName(), this.meta.getDatabaseProductVersion()));
        }
        catch (Exception e) {
            this.sqlLine.handleException(e);
        }
        try {
            this.sqlLine.debug(this.sqlLine.loc("driver", this.meta.getDriverName(), this.meta.getDriverVersion()));
        }
        catch (Exception e) {
            this.sqlLine.handleException(e);
        }
        try {
            this.connection.setAutoCommit(this.sqlLine.getOpts().getAutoCommit());
            this.sqlLine.autocommitStatus(this.connection);
        }
        catch (Exception e) {
            this.sqlLine.handleException(e);
        }
        try {
            this.connection.setReadOnly(this.sqlLine.getOpts().getReadOnly());
        }
        catch (Exception e) {
            this.sqlLine.handleException(e);
        }
        try {
            this.sqlLine.getCommands().isolation("isolation: " + this.sqlLine.getOpts().getIsolation(), new DispatchCallback());
            this.initSyntaxRule();
        }
        catch (Exception e) {
            this.sqlLine.handleException(e);
        }
        this.sqlLine.showWarnings();
        return true;
    }

    public Connection getConnection() throws SQLException {
        if (this.connection != null) {
            return this.connection;
        }
        this.connect();
        this.sqlLine.setCompletions();
        return this.connection;
    }

    public void reconnect() throws Exception {
        this.close();
        this.getConnection();
    }

    public void close() {
        try {
            try {
                if (this.connection != null && !this.connection.isClosed()) {
                    this.sqlLine.debug(this.sqlLine.loc("closing", this.connection.getClass().getName()));
                    this.connection.close();
                }
            }
            catch (Exception e) {
                this.sqlLine.handleException(e);
            }
        }
        finally {
            this.connection = null;
            this.meta = null;
            this.schema = null;
        }
    }

    public Collection<String> getTableNames(boolean force) {
        return this.getSchema().getSchema2tables().values().stream().map(Map::keySet).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    Schema getSchema(boolean force) {
        if (this.schema == null || force) {
            this.schema = new Schema();
        }
        return this.schema;
    }

    Schema getSchema() {
        return this.getSchema(false);
    }

    DatabaseMetaData getDatabaseMetaData() {
        return this.meta;
    }

    String getUrl() {
        return this.url;
    }

    String getNickname() {
        return this.nickname;
    }

    void setNickname(String nickname) {
        this.nickname = nickname;
    }

    Completer getSqlCompleter() {
        return this.sqlCompleter;
    }

    Dialect getDialect() {
        return this.dialect;
    }

    String getCurrentSchema() {
        try {
            return this.connection.getSchema();
        }
        catch (Exception e) {
            return null;
        }
    }

    class Schema {
        private Map<String, Map<String, Set<String>>> schema2tables;

        Schema() {
        }

        Map<String, Map<String, Set<String>>> getSchema2tables() {
            if (this.schema2tables != null) {
                return this.schema2tables;
            }
            this.schema2tables = new HashMap<String, Map<String, Set<String>>>();
            try (ResultSet rs = DatabaseConnection.this.getDatabaseMetaData().getTables(DatabaseConnection.this.getConnection().getCatalog(), null, "%", new String[]{"TABLE"});){
                while (rs.next()) {
                    String tableSchema = rs.getString("TABLE_SCHEM");
                    this.schema2tables.computeIfAbsent(tableSchema, k -> new HashMap());
                    this.schema2tables.get(tableSchema).put(rs.getString("TABLE_NAME"), null);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return this.schema2tables;
        }

        Set<String> getColumnNames(String schemaName, String tableName) {
            Map<String, Set<String>> table2Column = this.schema2tables.get(schemaName);
            if (schemaName == null) {
                this.schema2tables.putIfAbsent(null, new HashMap());
                table2Column = this.schema2tables.get(null);
            }
            if (table2Column == null) {
                return Collections.emptySet();
            }
            if (table2Column.get(tableName) != null) {
                return table2Column.get(tableName);
            }
            try (ResultSet rs = DatabaseConnection.this.getDatabaseMetaData().getColumns(DatabaseConnection.this.getConnection().getCatalog(), schemaName, tableName, "%");){
                table2Column.put(tableName, new HashSet());
                while (rs.next()) {
                    String columnName = rs.getString("COLUMN_NAME");
                    table2Column.get(tableName).add(columnName);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            table2Column.putIfAbsent(tableName, Collections.emptySet());
            return table2Column.get(tableName);
        }
    }
}

