/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.util;

import org.apache.calcite.rel.RelFieldCollation;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;

public enum NullOrdering {
    NULLS_FIRST(1, 1102, ObjectInspectorUtils.NullValueOption.MINVALUE, 'a', RelFieldCollation.NullDirection.FIRST),
    NULLS_LAST(0, 1103, ObjectInspectorUtils.NullValueOption.MAXVALUE, 'z', RelFieldCollation.NullDirection.LAST);

    private final int code;
    private final int token;
    private final ObjectInspectorUtils.NullValueOption nullValueOption;
    private final char sign;
    private final RelFieldCollation.NullDirection direction;

    private NullOrdering(int code, int token, ObjectInspectorUtils.NullValueOption nullValueOption, char sign, RelFieldCollation.NullDirection direction) {
        this.code = code;
        this.token = token;
        this.nullValueOption = nullValueOption;
        this.sign = sign;
        this.direction = direction;
    }

    public static NullOrdering fromToken(int token) {
        for (NullOrdering nullOrdering : NullOrdering.values()) {
            if (nullOrdering.token != token) continue;
            return nullOrdering;
        }
        throw new EnumConstantNotPresentException(NullOrdering.class, "No enum constant present with token " + token);
    }

    public static NullOrdering fromCode(int code) {
        for (NullOrdering nullOrdering : NullOrdering.values()) {
            if (nullOrdering.code != code) continue;
            return nullOrdering;
        }
        throw new EnumConstantNotPresentException(NullOrdering.class, "No enum constant present with code " + code);
    }

    public static NullOrdering fromSign(char sign) {
        for (NullOrdering nullOrdering : NullOrdering.values()) {
            if (nullOrdering.sign != sign) continue;
            return nullOrdering;
        }
        throw new EnumConstantNotPresentException(NullOrdering.class, "No enum constant present with sign " + sign);
    }

    public static NullOrdering fromDirection(RelFieldCollation.NullDirection nullDirection) {
        for (NullOrdering nullOrdering : NullOrdering.values()) {
            if (nullOrdering.direction != nullDirection) continue;
            return nullOrdering;
        }
        throw new EnumConstantNotPresentException(NullOrdering.class, "No enum constant present with null direction " + nullDirection);
    }

    public static NullOrdering defaultNullOrder(Configuration hiveConf) {
        return NullOrdering.defaultNullsLast(HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DEFAULT_NULLS_LAST));
    }

    private static NullOrdering defaultNullsLast(boolean defaultNullsLast) {
        return defaultNullsLast ? NULLS_LAST : NULLS_FIRST;
    }

    public static NullOrdering defaultNullOrder(int order, Configuration hiveConf) {
        if (order == 1) {
            return NullOrdering.defaultNullOrder(hiveConf);
        }
        return NullOrdering.defaultNullsLast(!HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DEFAULT_NULLS_LAST));
    }

    public int getCode() {
        return this.code;
    }

    public int getToken() {
        return this.token;
    }

    public ObjectInspectorUtils.NullValueOption getNullValueOption() {
        return this.nullValueOption;
    }

    public char getSign() {
        return this.sign;
    }

    public RelFieldCollation.NullDirection getDirection() {
        return this.direction;
    }
}

