/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HMSHandler;
import org.apache.hadoop.hive.metastore.MetaStoreThread;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.metrics.Metrics;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorThread;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorUtil;
import org.apache.hadoop.hive.ql.txn.compactor.MetadataCache;
import org.apache.thrift.TException;

public abstract class MetaStoreCompactorThread
extends CompactorThread
implements MetaStoreThread {
    protected TxnStore txnHandler;
    protected ScheduledExecutorService cycleUpdaterExecutorService;
    protected MetadataCache metadataCache;

    @Override
    public void init(AtomicBoolean stop) throws Exception {
        super.init(stop);
        this.txnHandler = TxnUtils.getTxnStore((Configuration)this.conf);
        this.metadataCache = new MetadataCache(this.isCacheEnabled());
        MetastoreConf.setBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_USE_CUSTOM_POOL, (boolean)true);
        HMSHandler.getMSForConf((Configuration)this.conf);
    }

    @Override
    Table resolveTable(CompactionInfo ci) throws MetaException {
        return CompactorUtil.resolveTable(this.conf, ci.dbname, ci.tableName);
    }

    @Override
    boolean replIsCompactionDisabledForDatabase(String dbName) throws TException {
        try {
            Database database = HMSHandler.getMSForConf((Configuration)this.conf).getDatabase(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName);
            boolean isReplCompactDisabled = ReplUtils.isFirstIncPending(database.getParameters());
            if (isReplCompactDisabled) {
                LOG.info("Compaction is disabled for database " + dbName);
            }
            return isReplCompactDisabled;
        }
        catch (NoSuchObjectException e) {
            LOG.info("Unable to find database " + dbName);
            return true;
        }
    }

    @Override
    List<Partition> getPartitionsByNames(CompactionInfo ci) throws MetaException {
        return CompactorUtil.getPartitionsByNames(this.conf, ci.dbname, ci.tableName, ci.partName);
    }

    @Override
    protected Partition resolvePartition(CompactionInfo ci) throws MetaException {
        return CompactorUtil.resolvePartition(this.conf, null, ci.dbname, ci.tableName, ci.partName, CompactorUtil.METADATA_FETCH_MODE.LOCAL);
    }

    protected abstract boolean isCacheEnabled();

    protected void startCycleUpdater(long updateInterval, Runnable taskToRun) {
        if (this.cycleUpdaterExecutorService == null && updateInterval > 0L) {
            this.cycleUpdaterExecutorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setPriority(Thread.currentThread().getPriority()).setDaemon(true).setNameFormat("Cycle-Duration-Updater-%d").build());
            this.cycleUpdaterExecutorService.scheduleAtFixedRate(taskToRun, updateInterval, updateInterval, TimeUnit.MILLISECONDS);
        }
    }

    protected void stopCycleUpdater() {
        if (this.cycleUpdaterExecutorService != null) {
            this.cycleUpdaterExecutorService.shutdownNow();
            this.cycleUpdaterExecutorService = null;
        }
    }

    protected static long updateCycleDurationMetric(String metric, long startedAt) {
        if (startedAt >= 0L) {
            long elapsed = System.currentTimeMillis() - startedAt;
            LOG.debug("Updating {} metric to {}", (Object)metric, (Object)elapsed);
            Metrics.getOrCreateGauge((String)metric).set((int)elapsed);
            return elapsed;
        }
        return 0L;
    }
}

