/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.reexec;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Schema;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.IDriver;
import org.apache.hadoop.hive.ql.QueryDisplay;
import org.apache.hadoop.hive.ql.QueryInfo;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.ExplainTask;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.CBOFallbackStrategy;
import org.apache.hadoop.hive.ql.parse.HiveSemanticAnalyzerHook;
import org.apache.hadoop.hive.ql.parse.HiveSemanticAnalyzerHookContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.mapper.PlanMapper;
import org.apache.hadoop.hive.ql.plan.mapper.StatsSource;
import org.apache.hadoop.hive.ql.processors.CommandProcessorException;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.reexec.IReExecutionPlugin;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReExecDriver
implements IDriver {
    private static final Logger LOG = LoggerFactory.getLogger(ReExecDriver.class);
    private static final SessionState.LogHelper CONSOLE = new SessionState.LogHelper(LOG);
    private final Driver coreDriver;
    private final QueryState queryState;
    private final List<IReExecutionPlugin> plugins;
    private boolean explainReOptimization;
    private String currentQuery;
    private int executionIndex;

    public ReExecDriver(QueryState queryState, QueryInfo queryInfo, List<IReExecutionPlugin> plugins) {
        this.queryState = queryState;
        this.coreDriver = new Driver(queryState, queryInfo, null);
        this.plugins = plugins;
        this.coreDriver.getHookRunner().addSemanticAnalyzerHook(new HandleReOptimizationExplain());
        plugins.forEach(p -> p.initialize(this.coreDriver));
    }

    @VisibleForTesting
    public int compile(String command, boolean resetTaskIds) {
        return this.coreDriver.compile(command, resetTaskIds);
    }

    @VisibleForTesting
    public List<IReExecutionPlugin> getPlugins() {
        return this.plugins;
    }

    private boolean firstExecution() {
        return this.executionIndex == 0;
    }

    private void checkHookConfig() throws CommandProcessorException {
        String strategies = this.coreDriver.getConf().getVar(HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_STRATEGIES);
        CBOFallbackStrategy fallbackStrategy = CBOFallbackStrategy.valueOf(this.coreDriver.getConf().getVar(HiveConf.ConfVars.HIVE_CBO_FALLBACK_STRATEGY));
        if (fallbackStrategy.allowsRetry() && (strategies == null || !Arrays.stream(strategies.split(",")).anyMatch("recompile_without_cbo"::equals))) {
            String errorMsg = "Invalid configuration. If fallbackStrategy is set to " + fallbackStrategy.name() + " then " + HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_STRATEGIES.varname + " should contain 'recompile_without_cbo'";
            CONSOLE.printError(errorMsg);
            throw new CommandProcessorException(errorMsg);
        }
    }

    @Override
    public CommandProcessorResponse compileAndRespond(String statement) throws CommandProcessorException {
        this.currentQuery = statement;
        this.checkHookConfig();
        int compileIndex = 0;
        int maxCompilations = 1 + this.coreDriver.getConf().getIntVar(HiveConf.ConfVars.HIVE_QUERY_MAX_RECOMPILATION_COUNT);
        while (true) {
            int currentIndex = ++compileIndex;
            this.plugins.forEach(p -> p.beforeCompile(currentIndex));
            LOG.info("Compile #{} of query", (Object)compileIndex);
            CommandProcessorResponse cpr = null;
            CommandProcessorException cpe = null;
            try {
                cpr = this.coreDriver.compileAndRespond(statement);
            }
            catch (CommandProcessorException e) {
                cpe = e;
            }
            boolean success = cpe == null;
            this.plugins.forEach(p -> p.afterCompile(success));
            if (success) {
                return cpr;
            }
            if (compileIndex >= maxCompilations || !this.plugins.stream().anyMatch(p -> p.shouldReCompile(currentIndex))) {
                throw cpe;
            }
            this.plugins.forEach(IReExecutionPlugin::prepareToReCompile);
        }
    }

    @Override
    public HiveConf getConf() {
        return this.queryState.getConf();
    }

    @Override
    public QueryPlan getPlan() {
        return this.coreDriver.getPlan();
    }

    @Override
    public QueryState getQueryState() {
        return this.queryState;
    }

    @Override
    public QueryDisplay getQueryDisplay() {
        return this.coreDriver.getQueryDisplay();
    }

    @Override
    public void setOperationId(String operationId) {
        this.coreDriver.setOperationId(operationId);
    }

    @Override
    public CommandProcessorResponse run() throws CommandProcessorException {
        CommandProcessorResponse cpr;
        PlanMapper newPlanMapper;
        PlanMapper oldPlanMapper;
        this.executionIndex = 0;
        int maxExecutions = 1 + this.coreDriver.getConf().getIntVar(HiveConf.ConfVars.HIVE_QUERY_MAX_REEXECUTION_COUNT);
        do {
            ++this.executionIndex;
            for (IReExecutionPlugin p2 : this.plugins) {
                p2.beforeExecute(this.executionIndex, this.explainReOptimization);
            }
            this.coreDriver.getContext().setExecutionIndex(this.executionIndex);
            LOG.info("Execution #{} of query", (Object)this.executionIndex);
            cpr = null;
            CommandProcessorException cpe = null;
            try {
                cpr = this.coreDriver.run();
            }
            catch (CommandProcessorException e) {
                cpe = e;
            }
            oldPlanMapper = this.coreDriver.getPlanMapper();
            boolean success = cpr != null;
            this.plugins.forEach(p -> p.afterExecute(oldPlanMapper, success));
            boolean shouldReExecute = this.explainReOptimization && this.executionIndex == 1;
            LOG.info("Re-execution decision is made according to: executionIndex: {}, maxExecutions: {}, shouldReExecute: {}", new Object[]{this.executionIndex, maxExecutions, shouldReExecute |= cpr == null && this.plugins.stream().anyMatch(p -> p.shouldReExecute(this.executionIndex))});
            if (this.executionIndex >= maxExecutions || !shouldReExecute) {
                if (cpr != null) {
                    return cpr;
                }
                throw cpe;
            }
            LOG.info("Preparing to re-execute query");
            this.plugins.forEach(IReExecutionPlugin::prepareToReExecute);
            try {
                this.coreDriver.compileAndRespond(this.currentQuery);
            }
            catch (CommandProcessorException e) {
                LOG.error("Recompilation of the query failed; this is unexpected.");
                throw e;
            }
            newPlanMapper = this.coreDriver.getPlanMapper();
        } while (this.explainReOptimization || this.plugins.stream().anyMatch(p -> p.shouldReExecuteAfterCompile(this.executionIndex, oldPlanMapper, newPlanMapper)));
        LOG.info("re-running the query would probably not yield better results; returning with last error");
        return cpr;
    }

    @Override
    public CommandProcessorResponse run(String command) throws CommandProcessorException {
        this.compileAndRespond(command);
        return this.run();
    }

    @Override
    public boolean getResults(List res) throws IOException {
        return this.coreDriver.getResults(res);
    }

    @Override
    public void setMaxRows(int maxRows) {
        this.coreDriver.setMaxRows(maxRows);
    }

    @Override
    public FetchTask getFetchTask() {
        return this.coreDriver.getFetchTask();
    }

    @Override
    public Schema getSchema() {
        if (this.explainReOptimization) {
            return new Schema(ExplainTask.getResultSchema(), null);
        }
        return this.coreDriver.getSchema();
    }

    @Override
    public boolean isFetchingTable() {
        return this.coreDriver.isFetchingTable();
    }

    @Override
    public void resetFetch() throws IOException {
        this.coreDriver.resetFetch();
    }

    @Override
    public void close() {
        this.coreDriver.close();
    }

    @Override
    public void destroy() {
        this.coreDriver.destroy();
    }

    @Override
    public final Context getContext() {
        return this.coreDriver.getContext();
    }

    @VisibleForTesting
    public void setStatsSource(StatsSource statsSource) {
        this.coreDriver.setStatsSource(statsSource);
    }

    @Override
    public boolean hasResultSet() {
        return this.explainReOptimization || this.coreDriver.hasResultSet();
    }

    private class HandleReOptimizationExplain
    implements HiveSemanticAnalyzerHook {
        private HandleReOptimizationExplain() {
        }

        @Override
        public ASTNode preAnalyze(HiveSemanticAnalyzerHookContext context, ASTNode ast) throws SemanticException {
            if (ast.getType() == 1021) {
                int childCount = ast.getChildCount();
                for (int i = 1; i < childCount; ++i) {
                    if (ast.getChild(i).getType() != 293) continue;
                    ReExecDriver.this.explainReOptimization = true;
                    ast.deleteChild(i);
                    break;
                }
                if (ReExecDriver.this.explainReOptimization && ReExecDriver.this.firstExecution()) {
                    Tree execTree = ast.getChild(0);
                    execTree.setParent(ast.getParent());
                    ast.getParent().setChild(0, execTree);
                    return (ASTNode)execTree;
                }
            }
            return ast;
        }

        @Override
        public void postAnalyze(HiveSemanticAnalyzerHookContext context, List<Task<?>> rootTasks) throws SemanticException {
        }
    }
}

