/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Correlate;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.rules.PruneEmptyRules;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.tools.RelBuilder;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveAggregate;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveAntiJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSemiJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortLimit;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveUnion;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveRuleConfig;

public class HiveRemoveEmptySingleRules
extends PruneEmptyRules {
    public static final RelOptRule PROJECT_INSTANCE = new RemoveEmptySingleRuleConfig().withOperandFor(HiveProject.class, project -> true).withDescription("HivePruneEmptyProject").toRule();
    public static final RelOptRule FILTER_INSTANCE = new RemoveEmptySingleRuleConfig().withOperandFor(HiveFilter.class, singleRel -> true).withDescription("HivePruneEmptyFilter").toRule();
    public static final RelOptRule JOIN_LEFT_INSTANCE = HiveRemoveEmptySingleRules.getJoinLeftInstance(HiveJoin.class);
    public static final RelOptRule SEMI_JOIN_LEFT_INSTANCE = HiveRemoveEmptySingleRules.getJoinLeftInstance(HiveSemiJoin.class);
    public static final RelOptRule JOIN_RIGHT_INSTANCE = HiveRemoveEmptySingleRules.getJoinRightInstance(HiveJoin.class);
    public static final RelOptRule ANTI_JOIN_RIGHT_INSTANCE = HiveRemoveEmptySingleRules.getJoinRightInstance(HiveAntiJoin.class);
    public static final RelOptRule SEMI_JOIN_RIGHT_INSTANCE = HiveRemoveEmptySingleRules.getJoinRightInstance(HiveSemiJoin.class);
    public static final RelOptRule CORRELATE_RIGHT_INSTANCE = new CorrelateRightEmptyRuleConfig().withOperandSupplier(b0 -> b0.operand(Correlate.class).inputs(new RelRule.OperandTransform[]{b1 -> b1.operand(RelNode.class).anyInputs(), b2 -> b2.operand(Values.class).predicate(Values::isEmpty).noInputs()})).withDescription("PruneEmptyCorrelate(right)").toRule();
    public static final RelOptRule CORRELATE_LEFT_INSTANCE = new CorrelateLeftEmptyRuleConfig().withOperandSupplier(b0 -> b0.operand(Correlate.class).inputs(new RelRule.OperandTransform[]{b1 -> b1.operand(Values.class).predicate(Values::isEmpty).noInputs(), b2 -> b2.operand(RelNode.class).anyInputs()})).withDescription("PruneEmptyCorrelate(left)").toRule();
    public static final RelOptRule SORT_INSTANCE = new RemoveEmptySingleRuleConfig().withOperandFor(HiveSortLimit.class, singleRel -> true).withDescription("HivePruneEmptySort").toRule();
    public static final RelOptRule SORT_FETCH_ZERO_INSTANCE = new SortFetchZeroRuleConfig().withOperandSupplier(b -> b.operand(HiveSortLimit.class).anyInputs()).withDescription("HivePruneSortLimit0").toRule();
    public static final RelOptRule AGGREGATE_INSTANCE = new RemoveEmptySingleRuleConfig().withOperandFor(HiveAggregate.class, Aggregate::isNotGrandTotal).withDescription("HivePruneEmptyAggregate").toRule();
    public static final RelOptRule UNION_INSTANCE = new HiveUnionEmptyPruneRuleConfig().withOperandSupplier(b0 -> b0.operand(HiveUnion.class).unorderedInputs(new RelRule.OperandTransform[]{b1 -> b1.operand(Values.class).predicate(Values::isEmpty).noInputs()})).withDescription("HivePruneEmptyUnionBranch").toRule();

    private static <R extends RelNode> RelOptRule getJoinLeftInstance(Class<R> clazz) {
        return new JoinLeftEmptyRuleConfig().withOperandSupplier(b0 -> b0.operand(clazz).inputs(new RelRule.OperandTransform[]{b1 -> b1.operand(Values.class).predicate(Values::isEmpty).noInputs(), b2 -> b2.operand(RelNode.class).anyInputs()})).withDescription("HivePruneEmptyJoin(left)").toRule();
    }

    private static <R extends RelNode> RelOptRule getJoinRightInstance(Class<R> clazz) {
        return new JoinRightEmptyRuleConfig().withOperandSupplier(b0 -> b0.operand(clazz).inputs(new RelRule.OperandTransform[]{b1 -> b1.operand(RelNode.class).anyInputs(), b2 -> b2.operand(Values.class).predicate(Values::isEmpty).noInputs()})).withDescription("HivePruneEmptyJoin(right)").toRule();
    }

    private static RelNode padWithNulls(RelBuilder builder, RelNode input, RelDataType resultType, boolean leftPadding) {
        int padding = resultType.getFieldCount() - input.getRowType().getFieldCount();
        List<RexLiteral> nullLiterals = Collections.nCopies(padding, builder.literal(null));
        builder.push(input);
        if (leftPadding) {
            builder.project(Iterables.concat(nullLiterals, (Iterable)builder.fields()));
        } else {
            builder.project(Iterables.concat((Iterable)builder.fields(), nullLiterals));
        }
        return builder.convert(resultType, true).build();
    }

    private static boolean isEmpty(RelNode node) {
        if (node instanceof Values) {
            return ((Values)node).getTuples().isEmpty();
        }
        if (node instanceof HepRelVertex) {
            return HiveRemoveEmptySingleRules.isEmpty(((HepRelVertex)node).getCurrentRel());
        }
        if (!(node instanceof RelSubset)) {
            return false;
        }
        RelSubset subset = (RelSubset)node;
        for (RelNode rel : subset.getRels()) {
            if (!HiveRemoveEmptySingleRules.isEmpty(rel)) continue;
            return true;
        }
        return false;
    }

    private static final class JoinLeftEmptyRuleConfig
    extends HiveRuleConfig
    implements PruneEmptyRules.PruneEmptyRule.Config {
        private JoinLeftEmptyRuleConfig() {
        }

        public PruneEmptyRules.PruneEmptyRule toRule() {
            return new PruneEmptyRules.PruneEmptyRule(this){

                public void onMatch(RelOptRuleCall call) {
                    Join join = (Join)call.rel(0);
                    RelNode right = call.rel(2);
                    RelBuilder relBuilder = call.builder();
                    if (join.getJoinType().generatesNullsOnLeft()) {
                        call.transformTo(HiveRemoveEmptySingleRules.padWithNulls(relBuilder, right, join.getRowType(), true));
                        return;
                    }
                    call.transformTo(relBuilder.push((RelNode)join).empty().build());
                }
            };
        }
    }

    private static final class JoinRightEmptyRuleConfig
    extends HiveRuleConfig
    implements PruneEmptyRules.JoinRightEmptyRuleConfig {
        private JoinRightEmptyRuleConfig() {
        }

        public PruneEmptyRules.PruneEmptyRule toRule() {
            return new PruneEmptyRules.PruneEmptyRule((PruneEmptyRules.PruneEmptyRule.Config)this){

                public void onMatch(RelOptRuleCall call) {
                    Join join = (Join)call.rel(0);
                    RelNode left = call.rel(1);
                    RelBuilder relBuilder = call.builder();
                    if (join.getJoinType().generatesNullsOnRight()) {
                        call.transformTo(HiveRemoveEmptySingleRules.padWithNulls(relBuilder, left, join.getRowType(), false));
                        return;
                    }
                    if (join.getJoinType() == JoinRelType.ANTI) {
                        call.transformTo(join.getLeft());
                        return;
                    }
                    call.transformTo(relBuilder.push((RelNode)join).empty().build());
                }
            };
        }
    }

    private static final class RemoveEmptySingleRuleConfig
    extends HiveRuleConfig
    implements PruneEmptyRules.RemoveEmptySingleRule.RemoveEmptySingleRuleConfig {
        private RemoveEmptySingleRuleConfig() {
        }
    }

    public static class CorrelateRightEmptyRuleConfig
    extends HiveRuleConfig
    implements PruneEmptyRules.PruneEmptyRule.Config {
        public PruneEmptyRules.PruneEmptyRule toRule() {
            return new PruneEmptyRules.PruneEmptyRule(this){

                public void onMatch(RelOptRuleCall call) {
                    Correlate corr = (Correlate)call.rel(0);
                    RelNode left = call.rel(1);
                    RelBuilder b = call.builder();
                    call.transformTo(switch (corr.getJoinType()) {
                        case JoinRelType.LEFT -> HiveRemoveEmptySingleRules.padWithNulls(b, left, corr.getRowType(), false);
                        case JoinRelType.INNER, JoinRelType.SEMI -> b.push((RelNode)corr).empty().build();
                        case JoinRelType.ANTI -> left;
                        default -> throw new IllegalStateException("Correlate does not support " + corr.getJoinType());
                    });
                }
            };
        }
    }

    public static class CorrelateLeftEmptyRuleConfig
    extends HiveRuleConfig
    implements PruneEmptyRules.PruneEmptyRule.Config {
        public PruneEmptyRules.PruneEmptyRule toRule() {
            return new PruneEmptyRules.PruneEmptyRule(this){

                public void onMatch(RelOptRuleCall call) {
                    Correlate corr = (Correlate)call.rel(0);
                    call.transformTo(call.builder().push((RelNode)corr).empty().build());
                }
            };
        }
    }

    private static final class SortFetchZeroRuleConfig
    extends HiveRuleConfig
    implements PruneEmptyRules.SortFetchZeroRuleConfig {
        private SortFetchZeroRuleConfig() {
        }
    }

    private static final class HiveUnionEmptyPruneRuleConfig
    extends HiveRuleConfig
    implements PruneEmptyRules.PruneEmptyRule.Config {
        private HiveUnionEmptyPruneRuleConfig() {
        }

        public PruneEmptyRules.PruneEmptyRule toRule() {
            return new PruneEmptyRules.PruneEmptyRule(this){

                public void onMatch(RelOptRuleCall call) {
                    Union union = (Union)call.rel(0);
                    List inputs = union.getInputs();
                    assert (inputs != null);
                    RelBuilder builder = call.builder();
                    int nonEmptyInputs = 0;
                    for (RelNode input : inputs) {
                        if (HiveRemoveEmptySingleRules.isEmpty(input)) continue;
                        builder.push(input);
                        ++nonEmptyInputs;
                    }
                    assert (nonEmptyInputs < inputs.size()) : "planner promised us at least one Empty child: " + RelOptUtil.toString((RelNode)union);
                    if (nonEmptyInputs == 0) {
                        builder.push((RelNode)union).empty();
                    } else {
                        builder.union(union.all, nonEmptyInputs);
                        builder.convert(union.getRowType(), true);
                    }
                    call.transformTo(builder.build());
                }
            };
        }
    }
}

